<?php

use EXMAGE\EXMAGEEnv;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! function_exists( 'villatheme_include_folder' ) ) {
	function villatheme_include_folder( $path, $prefix = '', $ext = array( 'php' ) ) {

		/*Include all files in payment folder*/
		if ( ! is_array( $ext ) ) {
			$ext = explode( ',', $ext );
			$ext = array_map( 'trim', $ext );
		}
		$sfiles = scandir( $path );
		foreach ( $sfiles as $sfile ) {
			if ( $sfile != '.' && $sfile != '..' ) {
				if ( is_file( $path . "/" . $sfile ) ) {
					$ext_file  = pathinfo( $path . "/" . $sfile );
					$file_name = $ext_file['filename'];
					if ( $ext_file['extension'] ) {
						if ( in_array( $ext_file['extension'], $ext ) ) {
							if ( $prefix === 'just_require' ) {
								require_once $path . $sfile;
								continue;
							}
							$class = preg_replace( '/\W/i', '_', $prefix . ucfirst( $file_name ) );

							if ( ! class_exists( $class ) ) {
								require_once $path . $sfile;
								if ( class_exists( $class ) ) {
									new $class;
								}
							}
						}
					}
				}
			}
		}
	}
}

if ( ! function_exists( 'villatheme_sanitize_fields' ) ) {
	function villatheme_sanitize_fields( $data ) {
		if ( is_array( $data ) ) {
			return array_map( 'villatheme_sanitize_fields', $data );
		} else {
			return is_scalar( $data ) ? sanitize_text_field( wp_unslash( $data ) ) : $data;
		}
	}
}
if ( ! function_exists( 'villatheme_exmage_sanitize_area' ) ) {
	function villatheme_exmage_sanitize_area( $data ) {
		if ( is_array( $data ) ) {
			return array_map( 'villatheme_exmage_sanitize_area', $data );
		} else {
			return is_scalar( $data ) ? sanitize_textarea_field( wp_unslash( $data ) ) : $data;
		}
	}
}
if ( ! function_exists( 'villatheme_escape_fields' ) ) {
	function villatheme_escape_fields( $data ) {
		if ( is_array( $data ) ) {
			return array_map( 'villatheme_escape_fields', $data );
		} else {
			return is_scalar( $data ) ? esc_attr( $data ) : $data;
		}
	}
}

if ( ! function_exists( 'villatheme_sanitize_kses' ) ) {
	function villatheme_sanitize_kses( $data ) {
		if ( is_array( $data ) ) {
			return array_map( 'villatheme_sanitize_kses', $data );
		} else {
			return is_scalar( $data ) ? wp_kses_post( wp_unslash( $data ) ) : $data;
		}
	}
}
if ( ! function_exists( 'villatheme_json_encode' ) ) {
	function villatheme_json_encode( $value, $options = 256, $depth = 512 ) {
		return wp_json_encode( $value, $options, $depth );
	}
}
if ( ! function_exists( 'villatheme_json_decode' ) ) {
	function villatheme_json_decode( $json, $assoc = true, $depth = 512, $options = 2 ) {
		if ( is_array( $json ) ) {
			return $json;
		}
		if ( function_exists( 'mb_convert_encoding' ) ) {
			$json = mb_convert_encoding( $json, 'UTF-8', 'UTF-8' );
		}

		return json_decode( is_string( $json ) ? $json : '{}', $assoc, $depth, $options );
	}
}
if ( ! function_exists( 'villatheme_is_url' ) ) {
	function villatheme_is_url( $link ) {
		if ( is_numeric( $link ) ) {
			return false;
		}
		if ( esc_url_raw( $link ) === $link ) {
			return true;
		}

		return wc_is_valid_url( $link );
	}
}

if ( ! function_exists( 'exmage_localize_date' ) ) {

	function exmage_localize_date( $date ) {
		$month             = gmdate( 'F', strtotime( $date ) ); //june
		$month_localized   = esc_html( $month );
		$date              = str_replace( $month, $month_localized, $date );
		$weekday           = gmdate( 'l', strtotime( $date ) ); //wednesday
		$weekday_localized = esc_html( $weekday );
		$date              = str_replace( $weekday, $weekday_localized, $date );

		return $date;
	}
}

if ( ! function_exists( 'exmage_get_template_string' ) ) {

	function exmage_get_template_string( $filename, $args = array(), $path = false, $replace = '' ) {
		$path       = $path ? $path : trailingslashit( EXMAGEEnv::get( 'plugin_dir' ) ) . 'templates/';
		$file       = apply_filters( 'exmage_template_file', $path . $filename, $filename );
		$theme_file = trailingslashit( get_stylesheet_directory() )
		              . trailingslashit( basename( EXMAGEEnv::get( 'plugin_dir' ) ) )
		              . 'templates/' . $filename;

		if ( ! file_exists( $file ) ) {
			$path       = trailingslashit( EXMAGEEnv::get( 'plugin_dir' ) ) . $replace;
			$file       = apply_filters( 'exmage_template_file', $path . $filename, $filename );
			$theme_file = trailingslashit( get_stylesheet_directory() )
			              . trailingslashit( basename( EXMAGEEnv::get( 'plugin_dir' ) ) )
			              . 'assets/js/' . $filename;
			if ( ! file_exists( $file ) ) {
				return false;
			}
		}

		if ( file_exists( $theme_file ) ) {
			$file = $theme_file;
		}

		if ( strpos( $file, '.php' ) !== false ) {
			ob_start();
			require $file;
			$contents = ob_get_clean();
		} else {
			$contents = file_get_contents( $file );// phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents
		}

		if ( ! empty( $args ) && is_array( $args ) ) {
			foreach ( $args as $fieldname => $value ) {
				$contents = str_replace( '{' . $fieldname . '}', $value, $contents );
			}
		}

		return $contents;
	}
}

if ( ! function_exists( 'exmage_get_template' ) ) {
	function exmage_get_template( $template_name, $args = array(), $default_path = '' ) {
		if ( ! empty( $args ) && is_array( $args ) ) {
			extract( $args );
		}

		$located = $default_path . $template_name;

		if ( ! file_exists( $located ) ) {
			/* translators: %s: template name */
			wc_doing_it_wrong( __FUNCTION__, sprintf( esc_html__( '%s does not exist.', 'exmage-wordpress-image-links' ), '<code>' . $located . '</code>' ), '2.1' );

			return;
		}

		// Allow 3rd party plugin filter template file from their plugin.
		$located = apply_filters( 'exmage_get_template_locate', $located );


		include( $located );

	}
}
