<?php

namespace EXMAGE\Includes;


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class EXMAGEVIDEO {
	protected static $instance = null;
	protected        $settings;


	private function __construct() {
		$this->settings = EXMAGEDATA::instance();

	}

	public static function instance() {
		// If the single instance hasn't been set, set it now.
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	function is_video( $url ) {
		return self::is_platform_video( $url ) || self::is_custom_video( $url );
	}

	/**
	 *
	 * Check is video platform
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	function is_platform_video( $url ) {
		return self::check_is_youtube_video( $url ) ||
		       self::check_is_vimeo_video( $url ) ||
		       self::check_is_tiktok_video( $url ) ||
		       self::check_is_dailymotion_video( $url ) ||
		       self::check_is_wistia_video( $url ) ||
		       self::check_is_googledriver_video( $url ) ||
		       self::check_is_ted_video( $url ) ||
		       self::check_is_kickstarter_video( $url ) ||
		       self::check_is_videopress_video( $url );
	}

	/**
	 *
	 * Check is video custom
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	function is_custom_video( $url ) {
		$parts = explode( "\\http", $url );
		$url   = $parts[0];

		if ( self::is_platform_video( $url ) ) {
			return false;
		}

		return strpos( $url, '.mp4' ) !== false || strpos( $url, '.mov' ) !== false || strpos( $url, '.webm' ) !== false;
	}

	function get_data_external_video( $url ) {
		$data_video = [
			'metadata'   => '',/*Default param*/
			'src'        => $url,/*Default param*/
			'oembed_src' => '',/*Default param*/
		];
		$result     = "";
		/*Check YouTube*/
		if ( self::check_is_youtube_video( $url ) ) {
			$result        = self::get_oembed_data( $url, 'youtube' );
			$result_decode = json_decode( $result );

			if ( ! empty( $result ) ) {
				$data_video['post_title'] = $result_decode->title ?? '';
				$data_video['guid']             = $url;
				$data_video['post_mime_type']   = 'video/youtube';
				$data_video['poster']           = $result_decode->thumbnail_url ?? '';
				$data_video['oembed_thumb_src'] = $result_decode->thumbnail_url ?? '';
				$data_video['width']            = $result_decode->width;
				$data_video['height']           = $result_decode->height;
			}
			$data_video['oembed_src'] = self::get_youtube_src( $url );
		}
		/*Check vimeo*/
		if ( self::check_is_vimeo_video( $url ) ) {
			$result        = self::get_oembed_data( $url, 'vimeo' );
			$result_decode = json_decode( $result );
			if ( ! empty( $result ) ) {
				$data_video['post_title'] = $result_decode->title ?? '';
				$data_video['guid']             = $url;
				$data_video['post_mime_type']   = 'video/vimeo';
				$data_video['poster']           = $result_decode->thumbnail_url ?? '';
				$data_video['oembed_thumb_src'] = $result_decode->thumbnail_url ?? '';
				$data_video['width']            = $result_decode->width;
				$data_video['height']           = $result_decode->height;
				$data_video['description']      = $result_decode->description;
			}
			$data_video['oembed_src'] = self::get_vimeo_src( $url );
		}
		/*Check TikTok*/
		if ( self::check_is_tiktok_video( $url ) ) {
			$result        = self::get_oembed_data( $url, 'tiktok' );
			$result_decode = json_decode( $result );
			if ( ! empty( $result ) ) {
				$data_video['post_title'] = $result_decode->title ?? '';

				$data_video['guid']             = $url;
				$data_video['post_mime_type']   = 'video/tiktok';
				$data_video['poster']           = $result_decode->thumbnail_url ?? '';
				$data_video['oembed_thumb_src'] = $result_decode->thumbnail_url ?? '';
				$data_video['width']            = $result_decode->thumbnail_width ?? 480;
				$data_video['height']           = $result_decode->thumbnail_height ?? 640;
			}
			$data_video['oembed_src'] = self::get_tiktok_src( $url );
		}
		/*Check DailyMotion*/
		if ( self::check_is_dailymotion_video( $url ) ) {
			$result        = self::get_oembed_data( $url, 'dailymotion' );
			$result_decode = json_decode( $result );
			if ( ! empty( $result ) ) {
				$data_video['post_title'] = $result_decode->title ?? '';

				$data_video['guid']             = $url;
				$data_video['post_mime_type']   = 'video/dailymotion';
				$data_video['poster']           = $result_decode->thumbnail_url ?? '';
				$data_video['oembed_thumb_src'] = $result_decode->thumbnail_url ?? '';
				$data_video['width']            = $result_decode->width;
				$data_video['height']           = $result_decode->height;
				$data_video['description']      = $result_decode->description;
			}
			$data_video['oembed_src'] = self::get_dailymotion_src( $url );
		}
		/*Check Wistia*/
		if ( self::check_is_wistia_video( $url ) ) {
			$result        = self::get_oembed_data( $url, 'wistia' );
			$result_decode = json_decode( $result );
			if ( ! empty( $result ) ) {
				$data_video['post_title'] = $result_decode->title ?? '';

				$data_video['guid']             = $url;
				$data_video['post_mime_type']   = 'video/wistia';
				$data_video['poster']           = $result_decode->thumbnail_url ?? '';
				$data_video['oembed_thumb_src'] = $result_decode->thumbnail_url ?? '';
				$data_video['width']            = $result_decode->width ?? 480;
				$data_video['height']           = $result_decode->height ?? 640;
			}
			$data_video['oembed_src'] = self::get_wistia_src( $url );
		}
		/*Check Google Drive*/
		if ( self::check_is_googledriver_video( $url ) ) {

			$data_video['post_title']     = $result_decode->title ?? '';
			$data_video['guid']           = self::get_googledriver_src( $url );
			$data_video['post_mime_type'] = 'video/googledrive';
			$data_video['poster']         = self::get_googledriver_thumb_src( $url );
			$data_video['width']          = 640;
			$data_video['height']         = 480;

			$data_video['oembed_src']       = self::get_googledriver_src( $url );
			$data_video['oembed_thumb_src'] = self::get_googledriver_thumb_src( $url );
		}
		/*Check Ted*/
		if ( self::check_is_ted_video( $url ) ) {
			$result        = self::get_oembed_data( $url, 'ted' );
			$result_decode = json_decode( $result );
			if ( ! empty( $result ) ) {
				$data_video['post_title'] = $result_decode->title ?? '';

				$data_video['guid']           = $url;
				$data_video['post_mime_type'] = 'video/ted';
				$data_video['poster']         = $result_decode->thumbnail_url ?? '';
				$data_video['width']          = $result_decode->width ?? 480;
				$data_video['height']         = $result_decode->height ?? 640;
			}
			$data_video['oembed_src'] = self::get_ted_src( $url );
		}
		/*Check Kickstarter*/
		if ( self::check_is_kickstarter_video( $url ) ) {

			$data_video['post_title'] = self::get_kickstarter_video_project( $url );

			$data_video['guid']           = $url;
			$data_video['post_mime_type'] = 'video/kickstarter';
			$data_video['poster']         = '';
			$data_video['width']          = 480;
			$data_video['height']         = 640;

			$data_video['oembed_src']       = self::get_kickstarter_src( $url );
			$data_video['oembed_thumb_src'] = '';
		}
		/*Check WordPress TV*/
		if ( self::check_is_videopress_video( $url ) ) {
			$result        = self::get_oembed_data( $url, 'videopress' );
			$result_decode = json_decode( $result );
			if ( ! empty( $result ) ) {
				$data_video['post_title'] = $result_decode->title ?? '';

				$data_video['guid']           = $url;
				$data_video['post_mime_type'] = 'video/videopress';
				$data_video['poster']         = $result_decode->thumbnail_url ?? '';
				$data_video['oembed_thumb_src']         = $result_decode->thumbnail_url ?? '';
				$data_video['width']          = $result_decode->width ?? 480;
				$data_video['height']         = $result_decode->height ?? 640;
			}
			$data_video['oembed_src'] = self::get_videopress_src( $url );
		}
		if ( self::is_custom_video( $url ) ) {

			$data_video['post_title']     = '';
			$data_video['guid']           = $url;
			$data_video['post_mime_type'] = 'video/exmage';
			$data_video['width']          = 640;
			$data_video['height']         = 480;

			$data_video['oembed_src'] = $url;
		}
		$data_video['metadata'] = strval( $result );

		return $data_video;
	}

	/*YouTube*/
	/**
	 *
	 * Check if url is YouTube url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_youtube_video( $url ) {
		return strpos( $url, 'youtu' ) !== false;
	}

	/**
	 * Normalize and cut video id from YouTube url(including all YouTube url format that customer fills in)
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_youtube_video_id( $url ) {

		preg_match( "/^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user|shorts)\/))([^\?&\"'>]+)/", $url, $matches );

		return sizeof( $matches ) > 0 ? $matches[1] : null;
	}

	public function get_youtube_src( $url ) {
		return 'https://www.youtube.com/embed/' . self::get_youtube_video_id( $url );
	}

	/*Vimeo*/
	/**
	 *
	 * Check if url is Vimeo url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_vimeo_video( $url ) {
		return strpos( $url, 'vimeo' ) !== false;
	}

	/**
	 * Normalize and cut video id from Vimeo url(including all Vimeo url format that customer fills in)
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_vimeo_video_id( $url ) {

		preg_match( "/(https?:\/\/)?(www\.)?(player\.)?vimeo\.com\/([a-z]*\/)*([0-9]{6,11}[\/]*[a-z0-9]*)[?]?.*/", $url, $matches );

		return sizeof( $matches ) > 4 ? $matches[5] : null;
	}

	public function get_vimeo_src( $url ) {
		return 'https://player.vimeo.com/video/' . str_replace( '/', '?h=', self::get_vimeo_video_id( $url ) );
	}

	/*TikTok*/
	/**
	 *
	 * Check if url is tiktok url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_tiktok_video( $url ) {
		return strpos( $url, 'tiktok.com' ) !== false;
	}

	/**
	 * Normalize and cut video id from tiktok url(including all tiktok url format that customer fills in)
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_tiktok_video_id( $url ) {
		return explode( '?', explode( '/', $url )[5] )[0];
	}

	public function get_tiktok_src( $url ) {
		return 'https://www.tiktok.com/embed/v2/' . self::get_tiktok_video_id( $url );
	}

	/*DailyMotion*/
	/**
	 *
	 * Check if url is dailymotion url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_dailymotion_video( $url ) {
		return strpos( $url, 'dailymotion.com' ) !== false;
	}

	/**
	 * Normalize and cut video id from dailymotion url(including all dailymotion url format that customer fills in)
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_dailymotion_video_id( $url ) {
		return explode( '?', explode( '/', $url )[4] )[0];
	}

	public function get_dailymotion_src( $url ) {

		return 'https://geo.dailymotion.com/player.html?video=' . self::get_dailymotion_video_id( $url );
	}
	/*X.com or Twitter*/
	/**
	 *
	 * Check if url is twitter url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_twitter_video( $url ) {
		return strpos( $url, 'twitter.com' ) !== false || strpos( $url, 'x.com' ) !== false;
	}

	/**
	 * Normalize and cut video id from twitter url(including all dailymotion url format that customer fills in)
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_twitter_video_id( $url ) {
		return explode( '?', explode( '/', $url )[4] )[0];
	}

	public function get_twitter_src( $url ) {

		return $url;
	}
	/*Wistia*/
	/**
	 *
	 * Check if url is wistia url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_wistia_video( $url ) {
		return strpos( $url, 'wistia.com' ) !== false;
	}

	/**
	 * Normalize and cut video id from wistia url
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_wistia_video_id( $url ) {
		return explode( '?', explode( '/', $url )[4] )[0];
	}

	public function get_wistia_src( $url ) {

		return 'https://fast.wistia.net/embed/iframe/' . self::get_wistia_video_id( $url );
	}
	/*Google Driver*/
	/**
	 *
	 * Check if url is Google driver url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_googledriver_video( $url ) {
		return strpos( $url, 'drive.google.com/file' ) !== false;
	}

	/**
	 * Normalize and cut video id from Google driver url
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_googledriver_video_id( $url ) {
		return explode( '?', explode( '/', $url )[5] )[0];
	}

	public function get_googledriver_src( $url ) {

		return 'https://drive.google.com/file/d/' . self::get_googledriver_video_id( $url ) . '/preview';
	}

	public function get_googledriver_thumb_src( $url, $width = '480' ) {

		return "https://lh3.googleusercontent.com/d/" . self::get_googledriver_video_id( $url ) . "=w{$width}?authuser=0";
	}
	/*Ted*/
	/**
	 *
	 * Check if url is Ted url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_ted_video( $url ) {
		return strpos( $url, 'ted.com' ) !== false;
	}

	/**
	 * Normalize and cut video id from Ted url
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_ted_video_id( $url ) {
		return explode( '?', explode( '/', $url )[4] )[0];
	}

	public function get_ted_src( $url ) {

		return 'https://embed.ted.com/embed/' . self::get_ted_video_id( $url );
	}

	/*Kickstarter*/
	/**
	 *
	 * Check if url is kickstarter url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_kickstarter_video( $url ) {
		return strpos( $url, 'kickstarter.com' ) !== false;
	}

	/**
	 * Normalize and cut video id from kickstarter url (Kickstarter video id will include Author_name/Project_name)
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_kickstarter_video_id( $url ) {
		$explode_url        = explode( '/', $url );
		$author_and_project = $explode_url[4] . '/' . $explode_url[5];

		return explode( '?', $author_and_project )[0];
	}

	/**
	 * Normalize and cut video id from kickstarter url (Kickstarter video id will include Author_name/Project_name)
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_kickstarter_video_project( $url ) {

		return explode( '?', explode( '/', $url )[5] )[0];
	}

	public function get_kickstarter_src( $url ) {

		return 'https://www.kickstarter.com/projects/' . self::get_kickstarter_video_id( $url ) . '/widget/video.html';
	}
	/*VideoPress */
	/**
	 *
	 * Check if url is VideoPress url or not
	 *
	 * @param $url
	 *
	 * @return bool
	 */
	public function check_is_videopress_video( $url ) {
		return strpos( $url, 'videopress.com' ) !== false;
	}

	/**
	 * Normalize and cut video id from VideoPress  url
	 *
	 * @param $url
	 *
	 * @return string|null
	 */
	public function get_videopress_video_id( $url ) {

		return explode( '?', explode( '/', $url )[4] )[0];
	}

	public function get_videopress_src( $url ) {

		return 'https://video.wordpress.com/embed/' . self::get_videopress_video_id( $url );
	}

	public function get_oembed_data( $url, $type ) {

		$oembedUrl = '';
		$result    = "";
		switch ( $type ) {
			case 'youtube':
				$oembedUrl = "https://www.youtube.com/oembed?format=json&url=" . $url;
				break;
			case 'vimeo':
				$oembedUrl = "https://vimeo.com/api/oembed.json?url=" . $url;
				break;
			case 'tiktok':
				$oembedUrl = "https://www.tiktok.com/oembed?url=" . $url;
				break;
			case 'dailymotion':
				$oembedUrl = "https://www.dailymotion.com/api/oembed?url=" . $url;
				break;
			case 'x':
			case 'twitter':
				$oembedUrl = "https://publish.x.com/oembed?url=" . $url;
				break;
			case 'wistia':
				$oembedUrl = "https://fast.wistia.com/oembed?url=" . $url;
				break;
			case 'ted':
				$oembedUrl = "https://www.ted.com/services/v1/oembed.json?url=" . $url;
				break;
			case 'videopress':
				$oembedUrl = "https://public-api.wordpress.com/oembed/?url=" . $url . '&for=' . get_home_url();/*Declare your application or website's identity, for tracking or rate-limiting API purposes.*/
				break;
			default:
				break;
		}

		if ( ! empty( $oembedUrl ) ) {
			$response = wp_remote_get( $oembedUrl );
			if ( is_wp_error( $response ) ) {
				return null;
			}
			$result = wp_remote_retrieve_body( $response );
		}

		return $result;
	}
}