<?php

namespace EXMAGE\Includes;


use EXMAGE\EXMAGEEnv;


defined( 'ABSPATH' ) || exit;

class EXMAGEScript {
	protected static $instance = null;
	protected        $slug     = 'exmage-';
	protected        $settings;
	protected        $video;

	public function __construct() {
		$this->settings = EXMAGEDATA::instance();
		$this->video    = EXMAGEVIDEO::instance();
		add_action( 'admin_enqueue_scripts', [ $this, 'admin_enqueue_scripts' ] );
		add_action( 'init', [ $this, 'exmage_init' ] );

	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function exmage_init() {
		if ( $this->settings->get_param( 'enable' ) ) {
			add_action( 'wp_enqueue_scripts', [ $this, 'frontend_script' ], 99 );

			/*Hooks run both backend and frontend */
			add_filter( 'wp_video_shortcode_override', [ $this, 'exmage_custom_wp_video_shortcode_override' ], 999, 4 );
			add_filter( 'post_thumbnail_html', [ $this, 'exmage_custom_post_thumbnail_html' ], 999, 5 );/*Override post feature image*/
			add_filter( 'has_post_thumbnail', [ $this, 'exmage_has_post_thumbnail' ], 999, 3 );/*If choose exmage feature media, override check*/

		}
	}
	/*
	 * Override preview external video in attachment edit
	 * */
	/**
	 * @param $html
	 * @param $attr
	 * @param $content
	 * @param $instance
	 *
	 * @return mixed|string
	 */
	function exmage_custom_wp_video_shortcode_override( $html, $attr, $content, $instance ) {
		global $post;
		$src_video    = $attr['src'] ?? '';
		$width_video  = $attr['width'] ?? '640';
		$height_video = $attr['height'] ?? '480';
		if ( empty( $post ) ) {
			return $html;
		}
		$_exmage_external_url = get_post_meta( $post->ID, '_exmage_external_url', true );

		if ( ! empty( $post ) && ! empty( $src_video ) && $this->video->is_platform_video( $src_video ) ) {
			/*By default, wp has support to display external videos YouTube and Vimeo */
			$_exmage_external_oembed_src = get_post_meta( $post->ID, '_exmage_external_oembed_src', true );
			if ( ! empty( $_exmage_external_url ) ) {
				if ( ! empty( $_exmage_external_oembed_src ) ) {
					$src_video = $_exmage_external_oembed_src;
				}
				if ( $this->video->check_is_dailymotion_video( $src_video ) ) {
					$html = "<div style='position:relative;padding-bottom:56.25%;height:0;overflow:hidden;'><iframe src='{$src_video}' style='width:100%; height:100%; position:absolute; left:0px; top:0px; overflow:hidden; border:none;' allowfullscreen title='Dailymotion Video Player' allow='web - share'></iframe></div>";
				} else {
					$html = "<iframe src='{$src_video}' width='{$width_video}' height='{$height_video}'></iframe>";
				}
			}

		}

		return $html;
	}

	/*
	 * Override get_post_thumb() to display video Exmage on frontend
	 * */
	/**
	 * @param $html
	 * @param $post_id
	 * @param $post_thumbnail_id
	 * @param $size
	 * @param $attr
	 *
	 * @return mixed|string
	 */
	function exmage_custom_post_thumbnail_html( $html, $post_id, $post_thumbnail_id, $size, $attr ) {

		if ( $this->settings->get_param( 'enable_set_feature_video_for_post' ) ) {
			$attachment_id = get_post_meta( $post_id, '_exmage_feature_media_id', true );
			if ( ! empty( $attachment_id ) ) {
				$mime_type = get_post_mime_type( $attachment_id );
				$src_video = wp_get_attachment_url( $attachment_id );

				if ( strpos( $mime_type, 'video' ) !== false ) {
					$_exmage_external_oembed_src = get_post_meta( $attachment_id, '_exmage_external_oembed_src', true );

					if ( ! empty( $_exmage_external_oembed_src ) ) {
						$src_video = $_exmage_external_oembed_src;
						$html      = "<iframe src='{$src_video}' width='100%' height=''></iframe>";
					} else {
						/*Default video wordpress*/
						$html = '<div class="wp-media-wrapper wp-video"><video controls="controls" class="wp-video-shortcode" preload="metadata"><source type="' . $mime_type . '" src="' . $src_video . '"/></video></div>';

					}
				}

			}
		}

		return $html;
	}


	function exmage_has_post_thumbnail( $has_thumbnail, $post, $thumbnail_id ) {
		/*Reconsider this function later to see if it is necessary.07-07-2025*/
		if ( $this->settings->get_param( 'enable_set_feature_video_for_post' ) ) {
			$post = get_post( $post );
			if ( ! $post ) {
				return false;
			}
			$attachment_id = get_post_meta( $post->ID, '_exmage_feature_media_id', true );
			if ( ! empty( $attachment_id ) ) {
				return (bool) $attachment_id;
			}

		}

		return $has_thumbnail;
	}

	function exmage_custom_mime_for_video_src( $data, $file, $filename, $mimes ) {

		if ( strpos( $file, 'youtube.com/embed/' ) !== false ) {
			$data['ext']  = 'youtube';
			$data['type'] = 'video/youtube';
		}
		if ( strpos( $file, 'tiktok.com/embed/' ) !== false ) {
			$data['ext']  = 'tiktok';
			$data['type'] = 'video/tiktok';
		}
		if ( strpos( $file, 'vimeo.com/video/' ) !== false ) {
			$data['ext']  = 'vimeo';
			$data['type'] = 'video/vimeo';
		}

		return $data;
	}

	function exmage_custom_upload_mimes( $mimes ) {
		$mimes['video']   = 'video/exmage';
		$mimes['youtube'] = 'video/youtube';
		$mimes['vimeo']   = 'video/vimeo';
		$mimes['tiktok']  = 'video/tiktok';

		return $mimes;
	}

	public static function remove_other_script( $pattern = '', $style = false ) {
		if ( ! $pattern ) {
			$pattern = '/^(\/wp-content\/plugins|\/wp-content\/themes)/i';
		}
		if ( $style ) {
			global $wp_styles;
			$styles = $wp_styles->registered;
			foreach ( $styles as $style ) {
				preg_match( $pattern, $style->src, $result1 );
				if ( count( array_filter( $result1 ) ) ) {
					wp_dequeue_style( $style->handle );
				}
			}
		}
		global $wp_scripts;
		$scripts = $wp_scripts->registered;
		if ( is_admin() ) {
			foreach ( $scripts as $k => $script ) {
				if ( in_array( $script->handle, array( 'query-monitor', 'uip-app', 'uip-vue', 'uip-toolbar-app' ) ) ) {
					continue;
				}
				preg_match( '/^\/wp-/i', $script->src, $result );
				if ( count( array_filter( $result ) ) ) {
					preg_match( $pattern, $script->src, $result1 );
					if ( count( array_filter( $result1 ) ) ) {
						wp_dequeue_script( $script->handle );
					}
				} else {
					wp_dequeue_script( $script->handle );
				}
			}
		} else {
			foreach ( $scripts as $k => $script ) {
				preg_match( $pattern, $script->src, $result1 );
				if ( count( array_filter( $result1 ) ) ) {
					wp_dequeue_script( $script->handle );
				}
			}
		}
	}

	public function register_scripts( $type = 'admin' ) {
		$suffix = WP_DEBUG ? '' : '.min';
		switch ( $type ) {
			case 'admin':
				$lib_styles = [
					'button',
					'tab',
					'input',
					'icon',
					'segment',
					'image',
					'modal',
					'dimmer',
					'transition',
					'menu',
					'grid',
					'search',
					'message',
					'loader',
					'label',
					'select2',
					'header',
					'accordion',
					'dropdown',
					'checkbox',
					'form',
					'step',
					'table',
					'chart',
					'dataTables',
					'dataTables.semanticui',

				];
				foreach ( $lib_styles as $style ) {
					wp_register_style( $this->slug . $style, EXMAGEEnv::get( 'libs_url' ) . $style . '.min.css', '', EXMAGEEnv::get( 'version' ) );
				}

				$styles = [ 'settings' ];
				foreach ( $styles as $style ) {
					wp_register_style( $this->slug . $style, EXMAGEEnv::get( 'css_url' ) . $style . $suffix . '.css', '', EXMAGEEnv::get( 'version' ) );
				}

				$lib_scripts = [
					'select2',
					'transition',
					'dimmer',
					'accordion',
					'dropdown',
					'jqColorPicker',
					'jquery.address',
					'tab',
					'modal',
					'chart',
					'dataTables',
					'dataTables.semanticui'
				];
				foreach ( $lib_scripts as $script ) {
					wp_register_script( $this->slug . $script, EXMAGEEnv::get( 'libs_url' ) . $script . '.min.js', [ 'jquery' ], EXMAGEEnv::get( 'version' ), false );
				}

				$scripts = [
					'settings' => [ 'jquery', 'jquery-ui-sortable' ],
				];
				foreach ( $scripts as $script => $depend ) {
					if ( is_string( $depend ) ) {
						$script = $depend;
						$depend = [];
					}
					wp_register_script( $this->slug . $script, EXMAGEEnv::get( 'js_url' ) . $script . $suffix . '.js', $depend, EXMAGEEnv::get( 'version' ), false );
				}
				break;
			default:
				$lib_styles = [
					'exmage-icon',
				];
				foreach ( $lib_styles as $style ) {
					wp_register_style( $this->slug . $style, EXMAGEEnv::get( 'libs_url' ) . $style . '.min.css', '', EXMAGEEnv::get( 'version' ) );
				}

				$styles = [ 'exmage-frontend', ];
				foreach ( $styles as $style ) {
					if ( str_contains( $style, 'EXMAGE' ) ) {
						wp_register_style( $style, EXMAGEEnv::get( 'css_url' ) . $style . $suffix . '.css', '', EXMAGEEnv::get( 'version' ) );
					} else {
						wp_register_style( $this->slug . $style, EXMAGEEnv::get( 'css_url' ) . $style . $suffix . '.css', '', EXMAGEEnv::get( 'version' ) );
					}
				}


				$scripts = [
					'exmage-frontend' => [ 'jquery' ],
				];
				foreach ( $scripts as $script => $depend ) {
					if ( str_contains( $script, 'EXMAGE' ) ) {
						wp_register_script( $script, EXMAGEEnv::get( 'js_url' ) . $script . $suffix . '.js', $depend, EXMAGEEnv::get( 'version' ), false );
					} else {
						wp_register_script( $this->slug . $script, EXMAGEEnv::get( 'js_url' ) . $script . $suffix . '.js', $depend, EXMAGEEnv::get( 'version' ), false );
					}
				}
		}
	}

	public function admin_enqueue_scripts() {
		$screen_id = get_current_screen()->id;
		$pages     = EXMAGEEnv::get_pages();
		if ( ! in_array( $screen_id, $pages ) ) {
			return;
		}
		$this->register_scripts();
		/*Remove all other script*/
		$this->remove_other_script();

		$enqueue_scripts = $enqueue_styles = [];
		$localize_script = $inline_handle = $css = '';
		$s_lang          = $this->settings->get_language_data();
		$bind_lang       = $s_lang['data'] ?? [];
		$def_lang        = $s_lang['def'] ?? '';
		$params          = [
			'ajaxUrl'  => admin_url( 'admin-ajax.php' ),
			'nonce'    => wp_create_nonce( 'exmage_security' ),
			'language' => array_map( 'esc_attr', (array) array_shift( $bind_lang ) ),
			'def_lang' => $def_lang,
			'isRTL'    => is_rtl(),

		];

		switch ( $screen_id ) {
			case $pages['setting_page']:
				wp_enqueue_editor();
				$enqueue_scripts = [
					'settings',
					'select2',
					'transition',
					'dropdown',
					'tab',
					'modal',
					'dimmer',
					'accordion',
					'jqColorPicker',
					'jquery.address'
				];
				$enqueue_styles  = [
					'settings',
					'select2',
					'segment',
					'menu',
					'tab',
					'accordion',
					'table',
					'form',
					'button',
					'icon',
					'checkbox',
					'message',
					'modal',
					'dimmer',
					'transition',
					'dropdown',
					'label',
					'grid',
					'input'
				];
				$localize_script = 'settings';

				break;

			default:
				break;
		}

		foreach ( $enqueue_scripts as $script ) {
			wp_enqueue_script( $this->slug . $script );
		}

		foreach ( $enqueue_styles as $style ) {
			wp_enqueue_style( $this->slug . $style );
		}
		if ( $localize_script ) {
			wp_localize_script( $this->slug . $localize_script, 'exmageParams', $params );
		}
		if ( $inline_handle ) {
			wp_add_inline_style( $this->slug . $inline_handle, $css );
		}
	}

	public function frontend_script() {
		if ( ! $this->settings->get_param( 'enable' ) ) {
			return;
		}

		if ( isset( $_POST['exmage-nonce-settings'] ) && ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['exmage-nonce-settings'] ) ), 'exmage-nonce-settings' ) ) {
			return;
		}
		/*Remove all other script*/


		$suffix = defined( 'WP_DEBUG' ) && WP_DEBUG ? '' : '.min';

		$this->register_scripts( 'frontend' );


		$localize        = [
			'ajaxUrl' => admin_url( 'admin-ajax.php' ),
			'nonce'   => wp_create_nonce( 'exmage_security' ),
			'isRTL'   => is_rtl(),

		];

		$enqueue_styles = [
			'frontend',
		];
		foreach ( $enqueue_styles as $style ) {
			wp_enqueue_style( $this->slug . $style );// phpcs:ignore NonBlockingScripts.BlockingHeadScript, EnqueuedStylesScope
		}


		$css = $this->render_inline_style();
		wp_add_inline_style( 'exmage-frontend', $css );

		wp_localize_script( $this->slug . 'frontend', 'exmageParams', $localize );
	}

	public function render_inline_style() {

		$css = '';
		$css .= $this->settings->get_param( 'custom_css' );
		$css = str_replace( array( "\r", "\n", '\r', '\n' ), ' ', $css );

		return $css;
	}

}
