<?php

namespace EXMAGE\Includes;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class EXMAGEQueryDB {

	protected static $instance = null;

	public $wp_users;
	public $exmage_logs;
	public $exmage_category;
	public $wpdb;

	protected $settings;

	private function __construct() {
		global $wpdb;
		$this->wpdb            = $wpdb;
		$this->exmage_logs     = $wpdb->prefix . "exmage_logs";
		$this->exmage_category = $wpdb->prefix . "exmage_category";
		$this->wp_users        = $wpdb->base_prefix . 'users';
		$this->settings        = EXMAGEDATA::instance();
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function table_exits( $table_name ) {
		global $wpdb;

		return $wpdb->get_results( $wpdb->prepare( "SHOW TABLES LIKE %s;", $table_name ), ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
	}

	public function get_category( $args = array() ) {
		global $wpdb;
		$args = wp_parse_args( $args, array(
			'fields'  => '*',
			'where'   => '1',
			'orderby' => 'data_created',
			'order'   => 'DESC',
		) );
		if ( isset( $args['fields'] ) && is_array( $args['fields'] ) ) {
			$args['fields'] = implode( ', ', $args['fields'] );
		}
		$query = "SELECT * FROM {$this->exmage_category} WHERE %s ORDER BY `order` ASC";

		return $wpdb->get_results( $wpdb->prepare( $query, $args['where'] ), ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
	}

	public function get_category_ids() {
		global $wpdb;

		$query = "SELECT id FROM {$this->exmage_category} WHERE %s";

		$dt_cat   = $wpdb->get_results( $wpdb->prepare( $query, 1 ), ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
		$i_return = [];
		foreach ( $dt_cat as $dt_val ) {
			$i_return[] = $dt_val['id'];
		}

		return $i_return;
	}

	public function get_category_names() {
		global $wpdb;

		$query = "SELECT id, name FROM {$this->exmage_category} WHERE %s";

		$dt_cat   = $wpdb->get_results( $wpdb->prepare( $query, 1 ), ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
		$i_return = [];
		foreach ( $dt_cat as $dt_val ) {
			$i_return[ $dt_val['id'] ] = (array) json_decode( $dt_val['name'] );
		}

		return $i_return;
	}

	public function add_category_data( $fields ) {
		global $wpdb;
		$success = $wpdb->insert( $this->exmage_category, $fields );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		if ( ! $success ) {
			return false;
		}
		$insertId = isset( $wpdb->insert_id ) ? $wpdb->insert_id : 0;

		return $insertId;
	}

	public function update_category_data_by_id( $id, $fields ) {
		global $wpdb;
		$success = $wpdb->update( $this->exmage_category, array(// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			'name'          => $fields['name'],
			'icon'          => $fields['icon'],
			'description'   => $fields['description'],
			'order'         => $fields['order'],
			'date_modified' => $fields['date_modified'],
		), array( 'id' => $id ) );

		return $success;
	}

	public function delete_category_by_id( $c_id ) {
		global $wpdb;

		$query = "DELETE FROM {$this->exmage_category} WHERE `id`=%d;";
		$rs    = $wpdb->prepare( $query, $c_id );// phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
		$data  = $wpdb->query( $rs );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared

		return $data;
	}

	public function table_category_exits() {
		global $wpdb;

		$query = "SHOW TABLES LIKE %s;";

		return $wpdb->get_results( $wpdb->prepare( $query, $this->exmage_category ), ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
	}

	public function table_category_rows() {
		global $wpdb;

		$query = "SELECT COUNT(id) AS count FROM {$this->exmage_category} WHERE %d ;";
		$rs    = $wpdb->get_results( $wpdb->prepare( $query, 1 ), ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared

		return (int) $rs[0]['count'];
	}

	public function get_activity_logs( $args = array() ) {
		global $wpdb;
		$args = wp_parse_args( $args, array(
			'fields'  => '*',
			'where'   => '1',
			'limit'   => 30,
			'offset'  => 0,
			'orderby' => 'data_created',
			'order'   => 'DESC',
		) );
		if ( isset( $args['fields'] ) && is_array( $args['fields'] ) ) {
			$args['fields'] = implode( ', ', $args['fields'] );
		}
		$query = "SELECT * FROM {$this->exmage_logs} WHERE 1 LIMIT %d OFFSET %d ";

		return $wpdb->get_results( $wpdb->prepare( $query, $args['limit'], $args['offset'] ), ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
	}

	public function get_logs_count( $args = array() ) {
		global $wpdb;

		$query      = "SELECT COUNT(*) as logs_count FROM {$this->exmage_logs} WHERE %d";
		$query      = $wpdb->prepare( $query, 1 );// phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
		$query_data = $wpdb->get_results( $query, ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
		if ( is_array( $query_data ) && isset( $query_data[0] ) ) {
			if ( isset( $query_data[0]['logs_count'] ) ) {

				return intval( $query_data[0]['logs_count'] );
			}
		}

		return 0;
	}

	public function get_logs_in_time( $from_time, $to_time ) {
		global $wpdb;
		$query = "SELECT * FROM {$this->exmage_logs} WHERE date_created >= %s AND date_created <= %s";

		$query_data = $wpdb->get_results( $wpdb->prepare( $query, $from_time, $to_time ), ARRAY_A );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared


		return $query_data;
	}

	public function delete_log_by_id( $id ) {
		global $wpdb;
		$query = "DELETE FROM {$this->exmage_logs} WHERE `id`=%d;";
		$rs    = $wpdb->prepare( $query, $id );// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.PreparedSQL.NotPrepared
		$data  = $wpdb->query( $rs );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared

		return $data;
	}
}
