'use strict';
jQuery(document).ready(function ($) {
    // Hide Upload button default
    setTimeout(function () {
        const default_media_button = $('#drag-drop-area');
        const default_inline_media_button = $('.uploader-inline .upload-ui');
        let button_upload = ``;
        default_media_button.hide();
        default_inline_media_button.hide();
        // add input file and Custom upload button
        switch (exmage_admin_params.cdn_type) {
            case 'cloudinary':
                button_upload = `<a href="#" id="cloudinary-upload-btn" class="button button-primary exmage-button">Upload to Cloudinary</a>`;

                break;
            case 'cloudflare':
            case 'aws':
                button_upload = `<div class="exmage-upload-files-container">
                        <div class="exmage-drag-file-area">
                            <h3 class="exmage-dynamic-message"> Drag & drop any file here </h3>
                            <label class="exmage-label"> or <div class="exmage-browse-files"> <input type="file" class="exmage-default-file-input"  id="cf-file" accept="image/*,video/*"/> <span class="exmage-browse-files-text">browse file</span> <span>from device</span> </div> </label>
                        </div>
                        <div class="exmage-cannot-upload-message">
                            <span class="exmage-icon exmage-notice-icon">error</span> Please select a file first <span class="exmage-icon exmage-close_filled-icon exmage-cancel-alert-button">cancel</span> 
                        </div>
                        <div class="exmage-upload-cdn-message"></div>
                        <div class="exmage-file-block">
                            <div class="exmage-file-info"><span class="exmage-icon exmage-file-icon">description</span> <span class="exmage-file-name"> </span> | <span class="exmage-file-size">  </span></div>
                            <span class="exmage-icon exmage-delete_field-icon">delete</span>
                          
                        </div>
                        <button type="button" class="exmage-upload-button exmage-button" id="cf-upload-btn">Upload</button>
                    </div>`;

                break;
            default:
                break;
        }
        button_upload += `<div class="exmage-upload-cdn-message"></div>`;
        default_media_button.parent().addClass('exmage-wrap-upload-cdn').prepend(button_upload);
        default_inline_media_button.parent().addClass('exmage-wrap-upload-cdn').prepend(button_upload);

    }, 1000);

    $(document).on('click', '#cloudinary-upload-btn', function (e) {
        e.preventDefault();
        let t = $(this),
            $message = t.parent().find('.exmage-upload-cdn-message');
        t.addClass('exmage-button-loading');
        cloudinary.openUploadWidget({
            cloudName: exmage_admin_params.cloudinaryCloudName,
            uploadPreset: exmage_admin_params.cloudinaryUploadPreset,
            sources: ['local'],
            clientAllowedFormats: ['image', 'video'],
            maxImageFileSize: exmage_admin_params.wp_max_upload_size,
            multiple: false,
            cropping: false
        }, function (error, result) {
            if (!error && result && result.event === "success") {

                $.ajax({
                    url: exmage_admin_params.ajaxurl,
                    method: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'cloudinary_save_attachment',
                        url: result.info.secure_url
                    },
                    success: function (response) {
                        if (response.success && response.data.attachment) {
                            let data_attachment = response.data.attachment ?? [];

                            if (data_attachment.status === 'success') {
                                $message.html('<span class="exmage-message-success"><span class="exmage-use-url-message-content">' + data_attachment.message + '</span></span>');
                            } else {
                                $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">' + data_attachment.message + '</span></span>');
                            }
                        } else {
                            $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">' + response.data + '</span></span>');
                        }
                        t.removeClass('exmage-button-loading');

                    },
                    error: function (xhr, status, error) {
                        console.error('AJAX error:', error);
                    }
                });
            }
        });
    });

    $('.exmage-check-cdn-connect-settings').on('click', function (e) {
        e.preventDefault();
        let cloudinaryName = $('#EXMAGE-cloudinary-clound-name').val(),
            cloudinaryUploadPreset = $('#EXMAGE-cloudinary-upload-preset').val(),
            cdn_type = $('#EXMAGE-cdn-type').val(),
            btnWrap = $(this),
            btn_td = btnWrap.closest('td'),
            wrap_notice = btn_td.find('.exmage-test-notice');

        if ($(btnWrap).hasClass('loading')) {
            return;
        }
        switch (cdn_type) {
            case 'cloudinary':
                if (!cloudinaryName && !cloudinaryUploadPreset) {
                    $('.exmage-test-notice').html('Please input config Cloudinary');
                    return;
                }

                $.ajax({
                    url: exmage_admin_params.ajaxurl,
                    type: 'post',
                    dataType: 'json',
                    data: {
                        _exmage_ajax_nonce: exmage_admin_params._exmage_ajax_nonce,
                        action: 'exmage_test_upload_cdn',
                        cdn_type: cdn_type,
                        cloudinaryName: cloudinaryName,
                        cloudinaryUploadPreset: cloudinaryUploadPreset,

                    },
                    beforeSend() {
                        $(btnWrap).addClass('loading');
                    },
                    success(res) {
                        console.log(res)
                        if (res) {
                            $(wrap_notice).html(res.data);
                        }

                        $(btnWrap).removeClass('loading');
                    },
                    complete() {
                        $(btnWrap).removeClass('loading');
                    },
                    error(res) {
                    }
                })
                break;
            default:
                break;
        }

    });

    setTimeout(function () {
        // Function to check if the browser supports necessary APIs.
        // This is pure JavaScript logic and does not need to be modified.
        var isAdvancedUpload = (function () {
            var div = document.createElement('div');
            return (('draggable' in div) || ('ondragstart' in div && 'ondrop' in div)) && 'FormData' in window && 'FileReader' in window;
        })();

        // 1. Select all elements using jQuery syntax
        let draggableFileArea = $(".exmage-drag-file-area");
        let browseFileText = $(".exmage-browse-files-text");
        let uploadIcon = $(".exmage-upload-icon");
        let dragDropText = $(".exmage-dynamic-message");
        let fileInput = $(".exmage-default-file-input");
        let cannotUploadMessage = $(".exmage-cannot-upload-message");
        let cancelAlertButton = $(".exmage-cancel-alert-button");
        let uploadedFile = $(".exmage-file-block");
        let fileName = $(".exmage-file-name");
        let fileSize = $(".exmage-file-size");

        let removeFileButton = $(".exmage-delete_field-icon");
        let uploadButton = $(".exmage-upload-button");
        let fileFlag = 0;

        // Utility function to update the UI when a file is selected
        function updateUIWithFile(file) {
            uploadIcon.html('check_circle');
            dragDropText.html('File Dropped Successfully!');
            $(".label").html(`drag & drop or <div class="exmage-browse-files"> <input type="file" class="exmage-default-file-input" style=""/> <span class="exmage-browse-files-text" style="top: 0;"> browse file</span></div>`);
            uploadButton.html('Upload');
            fileName.html(file.name);
            fileSize.html((file.size / 1024).toFixed(1) + " KB");
            uploadedFile.css("display", "flex");
            fileFlag = 0;
        }

        // 2. Use .on() or shorthand functions to bind event handlers
        fileInput.on("click", function () {
            // Clear the input value to allow re-selecting the same file
            $(this).val('');
        });

        fileInput.on("change", function (e) {
            // Use this.files[0] to get the file from the input element
            if (this.files && this.files.length > 0) {
                updateUIWithFile(this.files[0]);
            }
        });

        $(document).on('click', '#cf-upload-btn', function (e) {
            e.preventDefault();
            let t = $(this);
            let file = $('#cf-file')[0].files[0];
            let formData = new FormData();
            let $message = t.parent().find('.exmage-upload-cdn-message');
            $message.html('');
            if (!file) {
                $message.html('<span class="exmage-message-error">Please select a file.</span>');
                return;
            }
            t.addClass('exmage-button-loading');
            t.prop('disabled', true);
            // Allowed MIME types
            let allowedTypes = [
                'image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/svg+xml',
                'video/mp4', 'video/webm', 'video/ogg', 'video/quicktime'
            ];

            // Check file type
            if (!allowedTypes.includes(file.type)) {
                $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">Invalid file type: ' + file.type + '</span></span>');
                return;
            }
            formData.append('action', 'upload_to_s3_or_r2');
            formData.append('file', file);
            formData.append('_exmage_ajax_nonce', exmage_admin_params._exmage_ajax_nonce);
            $.ajax({
                url: exmage_admin_params.ajaxurl,
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function (res) {
                    if (res.success) {
                        if (res.success && res.data.attachment) {
                            let data_attachment = res.data.attachment ?? [];

                            if (data_attachment.status === 'success') {
                                uploadButton.html(`<span class="exmage-icon upload-button-icon"> check_circle </span> Uploaded`);
                                $message.html('<span class="exmage-message-success"><span class="exmage-use-url-message-content">' + data_attachment.message + '</span>, ID: <a target="_blank" href="' + data_attachment.edit_link + '">' + data_attachment.id + '</a></span></span>');
                            } else {
                                $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">' + data_attachment.message + '</span></span>');
                            }
                        }
                        removeFileButton.trigger('click');
                    } else {
                        $message.html('<span class="exmage-message-error"><span class="exmage-use-url-message-content">' + res.data + '</span></span>');
                    }
                    t.removeClass('exmage-button-loading');
                    t.prop('disabled', false);
                }

            });
        });

        cancelAlertButton.on("click", function () {
            // Use jQuery's .hide() to hide the alert
            cannotUploadMessage.hide();
        });

        if (isAdvancedUpload) {
            // 3. Bind multiple events in a clean and efficient way
            draggableFileArea.on("drag dragstart dragend dragover dragenter dragleave drop", function (e) {
                e.preventDefault();
                e.stopPropagation();
            });

            draggableFileArea.on("dragover dragenter", function () {
                $(this).addClass('is-dragover'); // Add class for easier CSS styling
                uploadIcon.html('file_download');
                dragDropText.html('Drop your file here!');
            });

            draggableFileArea.on("dragleave dragend drop", function () {
                $(this).removeClass('is-dragover');
            });

            draggableFileArea.on("drop", function (e) {
                // 4. Get the file from the drop event using jQuery
                let files = e.originalEvent.dataTransfer.files;

                // Assign the file to the input (might not always work due to browser security)
                // but it's important to capture file information
                fileInput[0].files = files;

                if (files && files.length > 0) {
                    updateUIWithFile(files[0]);
                }
            });
        }

        removeFileButton.on("click", function () {
            uploadedFile.hide();
            fileInput.val('');
            uploadIcon.html('file_upload');
            dragDropText.html('Drag & drop any file here');
            $(".label").html(`or <div class="exmage-browse-files"> <input type="file" class="exmage-default-file-input"/> <span class="exmage-browse-files-text">browse file</span> <span>from device</span> </div>`);
            uploadButton.html(`Upload`);
        });
    }, 1500);


});
