<?php

namespace EXMAGE\Admin;

use EXMAGE\Includes\EXMAGEDATA;
use mysql_xdevapi\Exception;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class EXMAGEOpenAi {
	protected static $instance;
	protected        $settings;
	protected        $api_key;
	protected        $ai_model;

	public function __construct() {
		$this->settings = EXMAGEDATA::instance();
		$this->api_key  = $this->settings->get_param( 'ai_openai_api_key' );
		$this->ai_model = $this->settings->get_param( 'ai_model' );
	}

	public static function instance() {
		// If the single instance hasn't been set, set it now.
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
	public static function check_api_key_validity( $api_key ) {
		if ( empty( $api_key ) ) {
			return esc_html__( 'Invalid API key', 'exmage-wordpress-image-links' );
		}

		$body = json_encode( [
			'messages'   => [
				[
					"role"    => "user",
					"content" => "This is a test."
				]
			],
			'max_tokens' => 5,
			'model'      => 'gpt-3.5-turbo',
		] );

		try {
			$response = wp_remote_post('https://api.openai.com/v1/chat/completions', [
				'body'    => $body,
				'headers' => [
					'Content-Type'  => 'application/json',
					'Authorization' => 'Bearer ' . $api_key,
				],
			] );

			if ( is_wp_error( $response ) ) {
				return esc_html__( 'Unexpected error', 'exmage-wordpress-image-links' );
			}
			$response_code = wp_remote_retrieve_response_code( $response );

			if ( $response_code === 200 ) {
				return esc_html__( 'Success', 'exmage-wordpress-image-links' );
			} elseif ( $response_code === 429 ) {
				return esc_html__( 'Your credit balance is too low to access the OpenAI API. Please go to Plans & Billing to upgrade or purchase credits.', 'exmage-wordpress-image-links' );
			} else {
				return esc_html__( 'We encountered a problem registering your OpenAI API key. Please check your API Key.', 'exmage-wordpress-image-links' );
			}

		} catch ( Exception $e ) {
			return esc_html__( 'OpenAI API Error: ', 'exmage-wordpress-image-links' ) . esc_html( $e->getMessage() );
		}
	}

	public function generator( $attachment_id, $type = 'alt_text', $language = '' ) {
		if ( ! $this->api_key && $this->ai_model == 'disabled' ) {
			return '';
		}
		if ( ! $type ) {
			return '';
		}
		if ( empty( $attachment_id ) ) {
			return '';
		}
		$key_render = '';
		switch ( $type ) {
			case 'alt_text':
				$key_render = $this->settings->get_param( 'ai_render_alt_mess' );
				if ( $language ) {
					$key_render = $this->settings->get_param( 'ai_render_alt_mess_' . $language );
				}
				break;
			default:
				break;
		}
		$r_data         = [
			'image_url'      => get_post_meta( $attachment_id, '_exmage_external_url', true ),
			'writing_style'  => $this->settings->get_param( 'ai_command_writing_style' ),
			'writing_tone'   => $this->settings->get_param( 'ai_command_writing_tone' ),
			'min_characters' => $this->settings->get_param( 'ai_command_min_characters' ),
			'max_characters' => $this->settings->get_param( 'ai_command_max_characters' ),
		];
		$key_render     = $this->settings->ai_command_replace_shortcodes( $key_render, $r_data );
		$headers_openai = [
			'Authorization' => 'Bearer ' . $this->api_key,
			'Content-Type'  => 'application/json',
		];
		$data_openai    = [
			'model'    => $this->ai_model,
			"messages" => [
				[
					"role"    => "user",
					"content" => $key_render
				]
			],
			'stop'     => '',
			'n'        => 1,
		];
		$args           = [
			'headers' => $headers_openai,
			'body'    => json_encode( $data_openai ),
			'timeout' => 120
		];
		try {
			$res = wp_remote_post( 'https://api.openai.com/v1/chat/completions', $args );

			$body = wp_remote_retrieve_body( $res );
			if (
				'application/json' === wp_remote_retrieve_header( $res, 'content-type' ) ||
				'application/json; charset=utf-8' === wp_remote_retrieve_header( $res, 'content-type' )
			) {
				$data = json_decode( $body, true );
			} else {
				$data = $body;
			}
			if (
				! empty( $data ) &&
				is_array( $data ) &&
				isset( $data['choices'] ) &&
				is_array( $data['choices'] ) &&
				isset( $data['choices'][0] ) &&
				isset( $data['choices'][0]['message'] ) &&
				is_array( $data['choices'][0]['message'] ) &&
				isset( $data['choices'][0]['message']['content'] ) &&
				! is_array( $data['choices'][0]['message']['content'] )
			) {
				return $data['choices'][0]['message']['content'] ?? '';
			}

			return [ 'code' => 111, 'message' => 'error' ];
		} catch ( \Exception $e ) {
			return [ 'code' => $e->getCode(), 'message' => $e->getMessage() ];
		}

	}


}
