<?php

namespace EXMAGE\Admin;

use EXMAGE\Includes\EXMAGEDATA;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class EXMAGEGemini {
	protected static $instance;
	protected        $settings;
	protected        $api_key;
	protected        $ai_model;

	public function __construct() {
		$this->settings = EXMAGEDATA::instance();
		$this->api_key  = $this->settings->get_param( 'ai_gemini_api_key' );
		$this->ai_model = $this->settings->get_param( 'ai_model' );
	}

	public static function instance() {
		// If the single instance hasn't been set, set it now.
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public static function check_api_key_validity( $api_key ) {
		if ( empty( $api_key ) ) {
			return esc_html__( 'Invalid API key', 'exmage-wordpress-image-links' );
		}

		$headers['Content-Type'] = 'application/json';

		$options = array(
			'headers' => $headers,
			'method'  => 'POST',
			'body'    => json_encode( [
				'contents' => [
					'parts' => [
						'text' => "say hello",
					]
				]
			] ),
		);

		try {

			$response = wp_remote_request(  'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $api_key, $options );

			if ( is_wp_error( $response ) ) {
				return esc_html( $response->get_error_message() );
			}

			$response_code = wp_remote_retrieve_response_code( $response );

			if ( $response_code === 200 ) {
				return esc_html__( 'Success', 'exmage-wordpress-image-links' );
			} elseif ( $response_code === 429 ) {
				return esc_html__( 'Your credit balance is too low to access the GOOGLEAI API. Please go to Plans & Billing to upgrade or purchase credits.', 'exmage-wordpress-image-links' );
			} else {
				return esc_html__( 'We encountered a problem registering your GoogleAI API key. Please check your API Key.', 'exmage-wordpress-image-links' );
			}

		} catch ( Exception $e ) {
			return esc_html__( 'Google API Error: ', 'exmage-wordpress-image-links' ) . esc_html( $e->getMessage() );
		}
	}
	
	public function generator( $attachment_id, $type = 'alt_text', $language = '' ) {
		if ( ! $this->api_key || $this->ai_model == 'disabled' ) {
			return '';
		}
		if ( empty( $attachment_id ) ) {
			return '';
		}
		if ( ! $type ) {
			return '';
		}
		$key_render = '';
		switch ( $type ) {
			case 'alt_text':
				$key_render = $this->settings->get_param( 'ai_render_alt_mess' );
				if ( $language ) {
					$key_render = $this->settings->get_param( 'ai_render_alt_mess_' . $language );
				}
				break;
			default:
				break;
		}
		$r_data     = [
			'image_url'      => get_post_meta( $attachment_id, '_exmage_external_url', true ),
			'writing_style'  => $this->settings->get_param( 'ai_command_writing_style' ),
			'writing_tone'   => $this->settings->get_param( 'ai_command_writing_tone' ),
			'min_characters' => $this->settings->get_param( 'ai_command_min_characters' ),
			'max_characters' => $this->settings->get_param( 'ai_command_max_characters' ),
		];
		$key_render = $this->settings->ai_command_replace_shortcodes( $key_render, $r_data );

		$headers_gemini = [
			'Content-Type' => 'application/json',
		];
		$data_gemini    = [
			"contents" => [
				[
					"parts" => [
						[
							"text" => $key_render
						]
					],
				]
			],
		];
		$args           = [
			'headers' => $headers_gemini,
			'body'    => json_encode( $data_gemini ),
			'timeout' => 120
		];
		try {
			$res = wp_remote_post( 'https://generativelanguage.googleapis.com/v1beta/models/' . $this->ai_model . ':generateContent?key=' . $this->api_key, $args );

			$body             = wp_remote_retrieve_body( $res );
			$body             = json_decode( $body );
			$candidates       = $body->candidates ?? [];
			$candidates_first = $candidates[0] ?? [];
			$content          = $candidates_first->content ?? [];
			$parts            = $content->parts ?? [];
			$parts_first      = $parts[0] ?? [];

			return $parts_first->text ?? '';
		} catch ( \Exception $e ) {
			return [ 'code' => $e->getCode(), 'message' => $e->getMessage() ];
		}

	}


}
