<?php

namespace EXMAGE\Admin;

use EXMAGE\EXMAGEEnv;
use EXMAGE\Includes\EXMAGEDATA;
use EXMAGE\Includes\EXMAGEVIDEO;

class EXMAGEAdmin {
	protected static $instance = null;
	protected        $settings;
	protected        $video;

	public function __construct() {
		$this->settings = EXMAGEDATA::instance();
		$this->video    = EXMAGEVIDEO::instance();

		add_action( 'admin_menu', [ $this, 'admin_menu_page' ] );
		add_filter( 'set-screen-option', [ $this, 'save_screen_options' ], 10, 3 );
		add_action( 'admin_init', [ $this, 'exmage_admin_init' ] );
		add_action( 'admin_init', [ $this, 'save_settings' ] );
		add_action( 'admin_init', array( $this, 'check_update' ) );

		/*Short link to Add new media*/
		add_filter( 'plugin_action_links_exmage-wordpress-image-links/exmage-wordpress-image-links.php', array( $this, 'settings_link' ) );


	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function exmage_admin_init() {
		/*wp.media*/
		if ( $this->settings->get_param( 'enable' ) ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'wp_enqueue_media' ), PHP_INT_MAX, false );
			add_action( 'post-upload-ui', array( $this, 'post_upload_ui' ), 20 );
			add_action( 'print_media_templates', array( $this, 'override_media_template_attachment_detail' ) );
			add_filter( 'wp_prepare_attachment_for_js', array( $this, 'wp_prepare_attachment_for_js' ) );
			/*External URL column in Media library/mode=list*/
			add_filter( 'manage_media_columns', array( $this, 'is_external' ) );
			add_action( 'manage_media_custom_column', array( $this, 'column_callback_media' ) );
			/*Return error when saving external image*/
			add_filter( 'load_image_to_edit_path', array( $this, 'load_image_to_edit_path' ), 10, 3 );
			/*Filter attachment url and image source set*/
			add_filter( 'wp_get_attachment_url', array( $this, 'wp_get_attachment_url' ), 10, 2 );
			add_filter( 'wp_calculate_image_srcset', array( $this, 'wp_calculate_image_srcset' ), 10, 5 );
			/*Ajax add image from URLs*/
			add_action( 'wp_ajax_exmage_handle_url', array( $this, 'handle_url' ) );
			add_action( 'wp_ajax_exmage_preload_video_data', array( $this, 'exmage_preload_video_data' ) );
			/*Ajax store external images to server*/
			add_action( 'wp_ajax_exmage_convert_external_image', array( $this, 'convert_external_image' ) );
			/*Ajax edit external url*/
			add_action( 'wp_ajax_exmage_edit_url', array( $this, 'exmage_edit_url' ) );
			/*Ajax check api key*/
			add_action( 'wp_ajax_exmage_test_api_key', array( $this, 'exmage_test_api_key' ) );
			/*Ajax generator alt text*/
			add_action( 'wp_ajax_exmage_generator_alt_image', array( $this, 'exmage_generator_alt_image' ) );
			/*Jetpack - Photon CDN*/
			add_filter( 'jetpack_photon_skip_image', array( $this, 'jetpack_photon_skip_image' ), 10, 3 );
			/*WPML*/
			add_action( 'wpml_after_duplicate_attachment', array( $this, 'wpml_after_duplicate_attachment' ), 10, 2 );

			add_action( 'woocommerce_product_import_before_process_item', function () {
				remove_action( 'pre_get_posts', [ $this, 'search_exmage_url_when_import_product' ] );
				add_action( 'pre_get_posts', [ $this, 'search_exmage_url_when_import_product' ] );
			} );

			add_action( 'woocommerce_product_import_inserted_product_object', function () {
				remove_action( 'pre_get_posts', [ $this, 'search_exmage_url_when_import_product' ] );
			} );

			/*Filter exmage */
			add_action( 'pre_get_posts', [ $this, 'filter_exmage_in_library_page' ], 999, 1 );

			/*Auto add iframe to editor content if choose media is exmage video*/
			add_filter( 'media_send_to_editor', [ $this, 'exmage_media_send_to_editor' ], 10, 3 );
			add_filter( 'wp_kses_allowed_html', [ $this, 'exmage_kses_allowed_html' ] );

			if ( $this->settings->get_param( 'enable_set_feature_video_for_post' ) ) {

				add_action( 'add_meta_boxes', [ $this, 'exmage_add_meta_box' ] );
				add_action( 'save_post', [ $this, 'save_exmage_feature_video_metabox' ] );
			}

			if ( $this->settings->get_param( 'cdn_type' ) != 'disable' ) {
				add_action( 'wp_ajax_cloudinary_save_attachment', [ $this, 'ajax_cloudinary_save_attachment' ] );
				add_action( 'wp_ajax_exmage_test_upload_cdn', [ $this, 'exmage_test_upload_cdn' ] );

				add_action( 'wp_ajax_upload_to_s3_or_r2', [ $this, 'ajax_upload_to_s3_or_r2' ] );

				add_action( 'delete_attachment', [ $this, 'delete_file_and_cdn_resource' ], 10 );
			}

		}
    }
	public function exmage_add_meta_box() {
		add_meta_box(
			'exmage_feature_video',                 // ID
			esc_html__( 'Exmage Feature Media', 'exmage-wordpress-image-links' ), // Title
			array( $this, 'exmage_feature_video_metabox_callback' ),           // Callback render content
			[ 'post' ],
			'side',
			'low'
		);
	}

	public function exmage_feature_video_metabox_callback( $post ) {
		$attachment_id = get_post_meta( $post->ID, '_exmage_feature_media_id', true );
		?>
        <div class="exmage-wrap-feature-preview">
			<?php
			if ( ! empty( $attachment_id ) ) {
				$mime_type = get_post_mime_type( $attachment_id );
				$src_video = wp_get_attachment_url( $attachment_id );
				$html      = '';
				if ( strpos( $mime_type, 'video' ) !== false ) {
					$_exmage_external_oembed_src = get_post_meta( $attachment_id, '_exmage_external_oembed_src', true );

					if ( ! empty( $_exmage_external_oembed_src ) ) {
						$src_video = $_exmage_external_oembed_src;
						$html      = "<iframe src='{$src_video}' width='100%' height=''></iframe>";
					} else {
						/*Default video wordpress*/
						$html = '<div  class="wp-media-wrapper wp-video"><video controls="controls" class="wp-video-shortcode" preload="metadata"><source type="' . $mime_type . '" src="' . $src_video . '"/></video></div>';

					}
				} elseif ( strpos( $mime_type, 'image' ) !== false ) {
					$html = wp_get_attachment_image( $attachment_id, 'thumbnail' );
				}
				$html .= '<a href="#" id="remove-exmage-thumbnail">' . esc_html__( 'Remove featured media', 'exmage-wordpress-image-links' ) . '</a>';
				echo ( $html );
			}

			?>

        </div>
        <button type="button" class="button button-primary button-large exmage-choose-feature-media"><?php echo esc_html__( 'Choose Media', 'exmage-wordpress-image-links' ); ?></button>
        <input type="hidden" name="exmage_feature_media_id" id="exmage_feature_media_id" value="<?php echo esc_attr( $attachment_id ); ?>"/>
		<?php
	}

	public function save_exmage_feature_video_metabox( $post_id ) {
		if ( isset( $_POST['exmage_feature_media_id'] ) ) {
			update_post_meta( $post_id, '_exmage_feature_media_id', sanitize_text_field( $_POST['exmage_feature_media_id'] ) );
		}
	}

	public function exmage_kses_allowed_html( $tags ) {
		$tags['iframe'] = array(
			'src'             => true,
			'width'           => true,
			'height'          => true,
			'frameborder'     => true,
			'allowfullscreen' => true,
			'allow'           => true,
		);

		return $tags;
	}

	public function exmage_media_send_to_editor( $html, $attachment_id, $attachment ) {
		$mime_type = get_post_mime_type( $attachment_id );

		if ( strpos( $mime_type, 'video' ) !== false ) {
			$src_video            = wp_get_attachment_url( $attachment_id );
			$_exmage_external_url = get_post_meta( $attachment_id, '_exmage_external_url', true );

			if ( $this->video->is_platform_video( $src_video ) ) {
				/*By default, wp has support to display external videos YouTube and Vimeo */
				$_exmage_external_oembed_src = get_post_meta( $attachment_id, '_exmage_external_oembed_src', true );
				if ( ! empty( $_exmage_external_url ) ) {
					if ( ! empty( $_exmage_external_oembed_src ) ) {
						$src_video = $_exmage_external_oembed_src;
					}
					if ( $this->video->check_is_dailymotion_video( $src_video ) ) {
						$html = "<div style='position:relative;padding-bottom:56.25%;height:0;overflow:hidden;'><iframe src='{$src_video}' style='width:100%; height:100%; position:absolute; left:0px; top:0px; overflow:hidden; border:none;' allowfullscreen title='Dailymotion Video Player' allow='web - share'></iframe></div>";
					} else {
						$html = "<iframe src='{$src_video}' width='640' height='480'></iframe>";
					}
				}

			}
		}

		return $html;
	}


	public function admin_menu_page() {
		global $submenu;

		$post_type_menus = [];
		if ( isset( $submenu['exmage-wordpress-image-links'] ) ) {
			$post_type_menus = $submenu['exmage-wordpress-image-links'];
			unset( $submenu['exmage-wordpress-image-links'] );
		}

		add_menu_page(
			esc_html__( 'Exmage', 'exmage-wordpress-image-links' ),
			esc_html__( 'Exmage', 'exmage-wordpress-image-links' ),
			apply_filters( 'exmage_menu_page_capability', 'manage_options' ),
			'exmage-wordpress-image-links',
			[ $this, 'callback_general_setting' ],
			EXMAGEEnv::get( 'img_url' ) . 'exmage-icon.svg',
			10
		);

		$setting_page = add_submenu_page(
			'exmage-wordpress-image-links',
			esc_html__( 'Settings', 'exmage-wordpress-image-links' ),
			esc_html__( 'Settings', 'exmage-wordpress-image-links' ),
			apply_filters( 'exmage_menu_page_capability', 'manage_options' ),
			'exmage-wordpress-image-links',
			[ $this, 'callback_general_setting' ],
			10
		);

		if ( ! empty( $post_type_menus ) ) {
			foreach ( $post_type_menus as $post_type_menu ) {
				$submenu['exmage-wordpress-image-links'][] = $post_type_menu;
			}
		}

		EXMAGEEnv::set_page( 'setting_page', $setting_page );

	}

	public function callback_general_setting() {
		$general_setting = EXMAGESettings::instance();
		$general_setting->render_page();
	}

	public function callback_logs_setting() {
		$logs_setting = EXMAGELogs::instance();
		$logs_setting->render_page();
	}

	public function logs_screen_options() {
		$option = 'per_page';
		$args   = array(
			'label'   => esc_html__( 'Number of activity logs per page', 'exmage-wordpress-image-links' ),
			'default' => 20,
			'option'  => 'exmage_logs_per_page'
		);
		add_screen_option( $option, $args );
	}

	public function save_screen_options( $status, $option, $value ) {

		if ( 'exmage_content_per_page' == $option ) {
			return $value;
		}
		if ( 'exmage_logs_per_page' == $option ) {
			return $value;
		}

		return $status;
	}

	public function check_update() {
		/**
		 * Check update
		 */
		if ( class_exists( 'VillaTheme_Plugin_Check_Update' ) ) {
			$setting_url = admin_url( 'admin.php?page=exmage-wordpress-image-links' );
			$key         = $this->settings->get_params( 'key' );
			new \VillaTheme_Plugin_Check_Update(
				EXMAGEEnv::get( 'version' ),                    // current version
				'https://villatheme.com/wp-json/downloads/v3',  // update path
				EXMAGEEnv::get( 'basename' ),                  // plugin file slug
				'exmage-wordpress-image-links',
				111106, //id product villatheme
				$key,
				$setting_url
			);
			new \VillaTheme_Plugin_Updater( EXMAGEEnv::get( 'basename' ), 'exmage-wordpress-image-links', $setting_url );
		}
	}

	public function save_settings() {
		if ( ! current_user_can( 'manage_options' ) ) {
			if ( ! apply_filters( 'exmage_save_page_capability', false, get_current_user_id() ) ) {
				return;
			}
		}
		$s_nonce         = isset( $_POST['exmage-nonce-settings'] ) ? sanitize_text_field( wp_unslash( $_POST['exmage-nonce-settings'] ) ) : '';
		$is_save_setting = isset( $_POST['exmage_save_settings'] ) && ! empty( $_POST['exmage_save_settings'] ) ? true : false;

		if ( $s_nonce && wp_verify_nonce( $s_nonce, 'exmage-nonce-settings' ) ) {
			try {
				if ( $is_save_setting ) {
					$d_setting = EXMAGESettings::instance();
					$tabs      = $d_setting->define_tabs();
					$options   = [];
					foreach ( $tabs as $slug => $text ) {
						$method = $slug . '_options';
						if ( method_exists( $d_setting, $method ) ) {
							$options = array_merge( $options, $d_setting->$method() );
						} else {
							$options = array_merge( $options, apply_filters( 'exmage_save_setting_option', [], $slug ) );
						}
					}

					array_push( $options, [ 'id' => 'language_lang', 'type' => 'multiselect' ] );
					array_push( $options, [ 'id' => 'language_cty', 'type' => 'multiselect' ] );

					$options = apply_filters( 'exmage_settings_before_save', $options );

					/*flush end point*/
					flush_rewrite_rules();

					EXMAGESettings_Helper::save_fields( $options );
					EXMAGEDATA::instance()->init_params();

					if ( isset( $_POST['exmage_save_check'], $_POST['update_key'] ) ) {
						delete_transient( 'update_plugins' );
						delete_transient( 'villatheme_item_111106' );
						delete_option( 'exmage-wordpress-image-links_messages' );
						do_action( 'villatheme_save_and_check_key_exmage-wordpress-image-links', sanitize_text_field( wp_unslash( $_POST['update_key'] ) ) );
					}
				}

			} catch ( \Exception $e ) {
				echo esc_html( $e->getMessage() );
			}
		}
	}

	/**
	 * Filter exmage in page upload.php
	 *
	 * @param $query
	 */
	public function filter_exmage_in_library_page( $query ) {
		if ( function_exists( 'get_current_screen' ) ) {
			$screen = get_current_screen();
			if ( is_admin() && $screen && $screen->base === 'upload' ) {
				if ( isset( $_REQUEST['exmage_filter'] ) ) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
					$exmage_filter = sanitize_text_field( wp_unslash( $_REQUEST['exmage_filter'] ) );// phpcs:ignore WordPress.Security.NonceVerification.Recommended
					$meta_query    = [];
					switch ( $exmage_filter ) {
						case 'only_downloaded':
							$meta_query = [
								'relation' => 'AND',
								array(
									'key'     => '_exmage_external_url',
									'compare' => 'EXISTS',
								),
								array(
									'key'     => '_exmage_imported',
									'compare' => 'EXISTS',
								)
							];
							break;
						case 'only_undownloaded':
							$meta_query = [
								'relation' => 'AND',
								array(
									'key'     => '_exmage_external_url',
									'compare' => 'EXISTS',
								),
								array(
									'key'     => '_exmage_imported',
									'compare' => 'NOT EXISTS',
								)
							];
							break;
						default:
							$meta_query = [
								'relation' => 'or',
								array(
									'key'     => '_exmage_external_url',
									'compare' => 'EXISTS',
								),
								array(
									'key'     => '_exmage_imported',
									'compare' => 'EXISTS',
								)
							];
							break;
					}
					$query->set( 'meta_query', $meta_query );
				}
			}
		}
	}

	/**
	 * Add needed post meta when an external image is cloned by WPML
	 *
	 * @param $attachment_id
	 * @param $duplicated_attachment_id
	 */
	public function wpml_after_duplicate_attachment( $attachment_id, $duplicated_attachment_id ) {
		$_exmage_external_url = get_post_meta( $attachment_id, '_exmage_external_url', true );
		if ( $_exmage_external_url && ! get_post_meta( $attachment_id, '_exmage_imported', true ) ) {
			update_post_meta( $duplicated_attachment_id, '_exmage_external_url', $_exmage_external_url );
		}
	}

	/**
	 * Skip if the image src is external
	 *
	 * @param $skip_image
	 * @param $src
	 * @param $tag
	 *
	 * @return mixed
	 */
	public function jetpack_photon_skip_image( $skip_image, $src, $tag ) {
		if ( ! $skip_image ) {
			if ( strpos( $src, get_site_url() ) !== 0 ) {
				$skip_image = true;
			}
		}

		return $skip_image;
	}

	/**
	 * Do not allow to edit external images
	 *
	 * @param $filepath
	 * @param $attachment_id
	 * @param $size
	 *
	 * @return bool
	 */
	public function load_image_to_edit_path( $filepath, $attachment_id, $size ) {
		if ( get_post_meta( $attachment_id, '_exmage_external_url', true ) && ! get_post_meta( $attachment_id, '_exmage_imported', true ) ) {
			return false;
		}

		return $filepath;
	}

	/**
	 * @param $links
	 *
	 * @return mixed
	 */
	public function settings_link( $links ) {
		/* translators: %s: admin url */
		$links[] = sprintf( wp_kses_post( '<a href="%s">Add images from URLs</a>' ), esc_url( admin_url( 'media-new.php' ) ) );

		return $links;
	}

	/**
	 *
	 */
	public function post_upload_ui() {
		global $pagenow;
		exmage_get_template( 'exmage-form.php', [ 'pagenow' => $pagenow ], EXMAGEEnv::get( 'templates_dir' ) );

	}

	/**
	 * @param $response
	 *
	 * @return mixed
	 */
	public function wp_prepare_attachment_for_js( $response ) {
		$_exmage_external_url        = '';
		$_exmage_external_oembed_src = '';
		if ( ! get_post_meta( $response['id'], '_exmage_imported', true ) ) {
			$_exmage_external_url        = get_post_meta( $response['id'], '_exmage_external_url', true );
			$_exmage_external_oembed_src = get_post_meta( $response['id'], '_exmage_external_oembed_src', true );

		}
		$response['_exmage_external_url']        = $_exmage_external_url;
		$response['_exmage_external_oembed_src'] = $_exmage_external_oembed_src;

		return $response;
	}

	/**
	 * Override templates
	 */
	public function override_media_template_attachment_detail() {
		$class = 'media-modal wp-core-ui';
		$link_text1 = esc_html__('Learn how to describe the purpose of the image','exmage-wordpress-image-links');
		$link_text2 = esc_html__('Leave empty if the image is purely decorative.','exmage-wordpress-image-links');
		$alt_text_description = sprintf(
		/* translators: 1: Link to tutorial, 2: Additional link attributes, 3: Accessibility text. */
			 '<a href="%1$s" %2$s>%3$s %4$s</a>. %5$s',
			/* translators: Localized tutorial, if one exists. W3C Web Accessibility Initiative link has list of existing translations. */
			esc_url( 'https://www.w3.org/WAI/tutorials/images/decision-tree/' ),
			'target="_blank"',
			$link_text1,
			sprintf(
				'<span class="screen-reader-text"> %s</span>',
				/* translators: Hidden accessibility text. */
				esc_html__( '(opens in a new tab)', 'exmage-wordpress-image-links' )
			),
			$link_text2
		);
		?>
        <script type="text/html" id="tmpl-exmage-attachment" xmlns="http://www.w3.org/1999/html">
            <div class="attachment-preview js--select-attachment type-{{ data.type }} subtype-{{ data.subtype }} {{ data.orientation }}">
                <div class="thumbnail">
                    <# if ( data.uploading ) { #>
                    <div class="media-progress-bar">
                        <div style="width: {{ data.percent }}%"></div>
                    </div>
                    <# } else if ( 'image' === data.type && data.size && data.size.url ) { #>
                    <div class="centered">
                        <img src="{{ data.size.url }}" draggable="false" alt=""/>
                    </div>
                    <# } else { #>
                    <div class="centered">
                        <# if ( data.image && data.image.src && data.image.src !== data.icon ) { #>
                        <img src="{{ data.image.src }}" class="thumbnail" draggable="false" alt=""/>
                        <# } else if ( data.sizes && data.sizes.medium ) { #>
                        <img src="{{ data.sizes.medium.url }}" class="thumbnail" draggable="false" alt=""/>
                        <# } else { #>
                        <img src="{{ data.icon }}" class="icon" draggable="false" alt=""/>
                        <# } #>
                    </div>
                    <div class="filename">
                        <div>{{ data.filename }}</div>
                    </div>
                    <# } #>
                </div>
                <# if ( data.buttons.close ) { #>
                <button type="button" class="button-link attachment-close media-modal-icon"><span class="screen-reader-text"><?php esc_html_e( 'Remove', 'exmage-wordpress-image-links' ); ?></span></button>
                <# } #>
            </div>
            <# if ( data.buttons.check ) { #>
            <button type="button" class="check" tabindex="-1"><span class="media-modal-icon"></span><span class="screen-reader-text"><?php esc_html_e( 'Deselect', 'exmage-wordpress-image-links' ); ?></span></button>
            <# } #>
            <# if ( data.hasOwnProperty('_exmage_external_url')&&data._exmage_external_url ) { #>
            <span class="exmage-is-external-link" title="<?php esc_html_e( 'This is an external media file', 'exmage-wordpress-image-links' ); ?>"><span class="dashicons dashicons-external"></span></span>
            <# } #>
            <#
            var maybeReadOnly = data.can.save || data.allowLocalEdits ? '' : 'readonly';
            if ( data.describe ) {
            if ( 'image' === data.type ) { #>
            <input type="text" value="{{ data.caption }}" class="describe" data-setting="caption" aria-label="<?php echo esc_attr( 'Caption' ); ?>" placeholder="<?php echo esc_attr( 'Caption&hellip;' ); ?>" {{ maybeReadOnly }}/>
            <# } else { #>
            <input type="text" value="{{ data.title }}" class="describe" data-setting="title"
            <# if ( 'video' === data.type ) { #>
            aria-label="<?php echo esc_attr( 'Video title' ); ?>"
            placeholder="<?php echo esc_attr( 'Video title&hellip;' ); ?>"
            <# } else if ( 'audio' === data.type ) { #>
            aria-label="<?php echo esc_attr( 'Audio title' ); ?>"
            placeholder="<?php echo esc_attr( 'Audio title&hellip;' ); ?>"
            <# } else { #>
            aria-label="<?php echo esc_attr( 'Media title' ); ?>"
            placeholder="<?php echo esc_attr( 'Media title&hellip;' ); ?>"
            <# } #> {{ maybeReadOnly }} />
            <# }
            } #>
        </script>
        <script type="text/html" id="tmpl-exmage-attachment-details-two-column">
			<?php // Template for the Attachment Details two columns layout. ?>
            <div class="attachment-media-view {{ data.orientation }}">
				<?php
				if ( isset( $_GET['error'] ) && 'deprecated' === $_GET['error'] ) {
					wp_admin_notice(
						esc_html__( 'The Edit Media screen is deprecated as of WordPress 6.3. Please use the Media Library instead.', 'exmage-wordpress-image-links' ),
						array(
							'id'                 => 'message',
							'additional_classes' => array( 'error' ),
						)
					);
				}
				?>
                <h2 class="screen-reader-text"><?php /* translators: Hidden accessibility text. */
	                esc_html_e( 'Attachment Preview', 'exmage-wordpress-image-links' ); ?></h2>
                <div class="thumbnail thumbnail-{{ data.type }}">
                    <# if ( data.uploading ) { #>
                    <div class="media-progress-bar">
                        <div></div>
                    </div>
                    <# } else if ( data.sizes && data.sizes.full ) { #>
                    <img class="details-image" src="{{ data.sizes.full.url }}" draggable="false" alt=""/>
                    <# } else if ( data.sizes && data.sizes.large ) { #>
                    <img class="details-image" src="{{ data.sizes.large.url }}" draggable="false" alt=""/>
                    <# } else if ( -1 === jQuery.inArray( data.type, [ 'audio', 'video' ] ) ) { #>
                    <img class="details-image icon" src="{{ data.icon }}" draggable="false" alt=""/>
                    <# } #>

                    <# if ( 'audio' === data.type ) { #>
                    <div class="wp-media-wrapper wp-audio">
                        <audio style="visibility: hidden" controls class="wp-audio-shortcode" width="100%" preload="none">
                            <source type="{{ data.mime }}" src="{{ data.url }}"/>
                        </audio>
                    </div>
                    <# } else if ( 'video' === data.type ) {
                    var w_rule = '';
                    if ( data.width ) {
                    w_rule = 'width: ' + data.width + 'px;';
                    } else if ( wp.media.view.settings.contentWidth ) {
                    w_rule = 'width: ' + wp.media.view.settings.contentWidth + 'px;';
                    }
                    if(typeof data._exmage_external_oembed_src == 'undefined' || data._exmage_external_oembed_src == '' ){ #>
                    <div style="{{ w_rule }}" class="wp-media-wrapper wp-video">
                        <video controls="controls" class="wp-video-shortcode" preload="metadata"
                        <# if ( data.width ) { #>width="{{ data.width }}"<# } #>
                        <# if ( data.height ) { #>height="{{ data.height }}"<# } #>
                        <# if ( data.image && data.image.src !== data.icon ) { #>poster="{{ data.image.src }}"<# } #>>
                        <source type="{{ data.mime }}" src="{{ data.url }}"/>
                        </video>
                    </div>
                    <#
                    }else{
                    #>
                    <div style="{{ w_rule }}" class="wp-media-wrapper wp-video">
                        <iframe controls="controls" class="wp-video-shortcode" preload="metadata" src="{{ data._exmage_external_oembed_src }}"
                        <# if ( data.width ) { #>width="{{ data.width }}"<# } #>
                        <# if ( data.height ) { #>height="{{ data.height }}"<# } #>
                        <# if ( data.image && data.image.src !== data.icon ) { #>poster="{{ data.image.src }}"<# } #>>
                        </iframe>
                    </div>
                    <# } #>
                    <# } #>

                    <div class="attachment-actions">
                        <# if ( 'image' === data.type && ! data.uploading && data.sizes && data.can.save ) { #>
                        <button type="button" class="button edit-attachment"><?php esc_html_e( 'Edit Image', 'exmage-wordpress-image-links' ); ?></button>
                        <# } else if ( 'pdf' === data.subtype && data.sizes ) { #>
                        <p><?php esc_html_e( 'Document Preview', 'exmage-wordpress-image-links' ); ?></p>
                        <# } #>
                    </div>
                </div>
            </div>
            <div class="attachment-info">
			<span class="settings-save-status" role="status">
				<span class="spinner"></span>
				<span class="saved"><?php esc_html_e( 'Saved.' ); ?></span>
			</span>
                <div class="details">
                    <h2 class="screen-reader-text">
						<?php
						/* translators: Hidden accessibility text. */
						esc_html_e( 'Details', 'exmage-wordpress-image-links' );
						?>
                    </h2>
                    <div class="uploaded"><strong><?php esc_html_e( 'Uploaded on:', 'exmage-wordpress-image-links' ); ?></strong> {{ data.dateFormatted }}</div>
                    <div class="uploaded-by">
                        <strong><?php esc_html_e( 'Uploaded by:', 'exmage-wordpress-image-links' ); ?></strong>
                        <# if ( data.authorLink ) { #>
                        <a href="{{ data.authorLink }}">{{ data.authorName }}</a>
                        <# } else { #>
                        {{ data.authorName }}
                        <# } #>
                    </div>
                    <# if ( data.uploadedToTitle ) { #>
                    <div class="uploaded-to">
                        <strong><?php esc_html_e( 'Uploaded to:', 'exmage-wordpress-image-links' ); ?></strong>
                        <# if ( data.uploadedToLink ) { #>
                        <a href="{{ data.uploadedToLink }}">{{ data.uploadedToTitle }}</a>
                        <# } else { #>
                        {{ data.uploadedToTitle }}
                        <# } #>
                    </div>
                    <# } #>
                    <div class="filename"><strong><?php esc_html_e( 'File name:', 'exmage-wordpress-image-links' ); ?></strong> {{ data.filename }}</div>
                    <div class="file-type"><strong><?php esc_html_e( 'File type:' , 'exmage-wordpress-image-links'); ?></strong> {{ data.mime }}</div>
                    <div class="file-size"><strong><?php esc_html_e( 'File size:' , 'exmage-wordpress-image-links'); ?></strong> {{ data.filesizeHumanReadable }}</div>
                    <# if ( 'image' === data.type && ! data.uploading ) { #>
                    <# if ( data.width && data.height ) { #>
                    <div class="dimensions"><strong><?php esc_html_e( 'Dimensions:', 'exmage-wordpress-image-links' ); ?></strong>
						<?php
						/* translators: 1: A number of pixels wide, 2: A number of pixels tall. */
						printf( esc_html__( '%1$s by %2$s pixels', 'exmage-wordpress-image-links' ), '{{ data.width }}', '{{ data.height }}' );
						?>
                    </div>
                    <# } #>

                    <# if ( data.originalImageURL && data.originalImageName ) { #>
                    <div class="word-wrap-break-word">
                        <strong><?php esc_html_e( 'Original image:', 'exmage-wordpress-image-links' ); ?></strong>
                        <a href="{{ data.originalImageURL }}">{{data.originalImageName}}</a>
                    </div>
                    <# } #>
                    <# } #>

                    <# if ( data.fileLength && data.fileLengthHumanReadable ) { #>
                    <div class="file-length"><strong><?php esc_html_e( 'Length:', 'exmage-wordpress-image-links' ); ?></strong>
                        <span aria-hidden="true">{{ data.fileLengthHumanReadable }}</span>
                        <span class="screen-reader-text">{{ data.fileLengthHumanReadable }}</span>
                    </div>
                    <# } #>

                    <# if ( 'audio' === data.type && data.meta.bitrate ) { #>
                    <div class="bitrate">
                        <strong><?php esc_html_e( 'Bitrate:', 'exmage-wordpress-image-links' ); ?></strong> {{ Math.round( data.meta.bitrate / 1000 ) }}kb/s
                        <# if ( data.meta.bitrate_mode ) { #>
                        {{ ' ' + data.meta.bitrate_mode.toUpperCase() }}
                        <# } #>
                    </div>
                    <# } #>

                    <# if ( data.mediaStates ) { #>
                    <div class="media-states"><strong><?php esc_html_e( 'Used as:', 'exmage-wordpress-image-links' ); ?></strong> {{ data.mediaStates }}</div>
                    <# } #>

                    <div class="compat-meta">
                        <# if ( data.compat && data.compat.meta ) { #>
                        {{{ data.compat.meta }}}
                        <# } #>
                    </div>
                </div>

                <div class="settings">
                    <# var maybeReadOnly = data.can.save || data.allowLocalEdits ? '' : 'readonly'; #>
                    <# if ( 'image' === data.type ) { #>
                    <span class="setting alt-text has-description" data-setting="alt">
						<label for="attachment-details-two-column-alt-text" class="name"><?php esc_html_e( 'Alternative Text' , 'exmage-wordpress-image-links'); ?></label>
						<textarea id="attachment-details-two-column-alt-text" aria-describedby="alt-text-description" {{ maybeReadOnly }}>{{ data.alt }}</textarea>
                        <# if (exmage_admin_params.enable_ai_engine != 'disabled') { #>
                            <div class="exmage-wrap-button-render" style="margin-top: 15px;"><button class="exmage-generator-alt-button button button-primary">AI generator</button><div class="exmage-generator-alt-message"></div></div><div class="exmage-use-url-input-overlay exmage-hidden"></div>
                        <# } #>
					</span>
                    <p class="description" id="alt-text-description"><?php echo esc_html( $alt_text_description ); ?></p>
                    <# } #>
					<?php if ( post_type_supports( 'attachment', 'title' ) ) : ?>
                        <span class="setting" data-setting="title">
					<label for="attachment-details-two-column-title" class="name"><?php esc_html_e( 'Title', 'exmage-wordpress-image-links' ); ?></label>
					<input type="text" id="attachment-details-two-column-title" value="{{ data.title }}" {{ maybeReadOnly }}/>
				</span>
					<?php endif; ?>
                    <# if ( 'audio' === data.type ) { #>
					<?php
					foreach (
						array(
							'artist' => esc_html__( 'Artist', 'exmage-wordpress-image-links' ),
							'album'  => esc_html__( 'Album', 'exmage-wordpress-image-links' ),
						) as $key => $label
					) :
						?>
                        <span class="setting" data-setting="<?php echo esc_attr( $key ); ?>">
					<label for="attachment-details-two-column-<?php echo esc_attr( $key ); ?>" class="name"><?php echo esc_html( $label ); ?></label>
					<input type="text" id="attachment-details-two-column-<?php echo esc_attr( $key ); ?>" value="{{ data.<?php echo esc_attr( $key ); ?> || data.meta.<?php echo esc_attr( $key ); ?> || '' }}"/>
				</span>
					<?php endforeach; ?>
                    <# } #>
                    <span class="setting" data-setting="caption">
					<label for="attachment-details-two-column-caption" class="name"><?php esc_html_e( 'Caption', 'exmage-wordpress-image-links' ); ?></label>
					<textarea id="attachment-details-two-column-caption" {{ maybeReadOnly }}>{{ data.caption }}</textarea>
				</span>
                    <span class="setting" data-setting="description">
					<label for="attachment-details-two-column-description" class="name"><?php esc_html_e( 'Description', 'exmage-wordpress-image-links' ); ?></label>
					<textarea id="attachment-details-two-column-description" {{ maybeReadOnly }}>{{ data.description }}</textarea>
				</span>
                    <span class="setting" data-setting="url">
					<label for="attachment-details-two-column-copy-link" class="name"><?php esc_html_e( 'File URL:' , 'exmage-wordpress-image-links'); ?></label>
					<input type="text" class="attachment-details-copy-link" id="attachment-details-two-column-copy-link" value="{{ data.url }}" readonly/>
					<span class="copy-to-clipboard-container">
						<button type="button" class="button button-small copy-attachment-url" data-clipboard-target="#attachment-details-two-column-copy-link"><?php esc_html_e( 'Copy URL to clipboard' , 'exmage-wordpress-image-links'); ?></button>
						<span class="success hidden" aria-hidden="true"><?php esc_html_e( 'Copied!', 'exmage-wordpress-image-links' ); ?></span>
					</span>
				</span>
                    <div class="attachment-compat"></div>
                </div>

                <div class="actions">
                    <# if ( data.link ) { #>
					<?php
					$view_media_text = ( '1' === get_option( 'wp_attachment_pages_enabled' ) ) ? esc_html__( 'View attachment page', 'exmage-wordpress-image-links' ) : esc_html__( 'View media file', 'exmage-wordpress-image-links' );
					?>
                    <a class="view-attachment" href="{{ data.link }}"><?php echo esc_html( $view_media_text ); ?></a>
                    <# } #>
                    <# if ( data.can.save ) { #>
                    <# if ( data.link ) { #>
                    <span class="links-separator">|</span>
                    <# } #>
                    <a href="{{ data.editLink }}"><?php esc_html_e( 'Edit more details', 'exmage-wordpress-image-links' ); ?></a>
                    <# } #>
                    <# if ( data.can.save && data.link ) { #>
                    <span class="links-separator">|</span>
                    <a href="{{ data.url }}" download><?php esc_html_e( 'Download file', 'exmage-wordpress-image-links' ); ?></a>
                    <# } #>
                    <# if ( ! data.uploading && data.can.remove ) { #>
                    <# if ( data.link || data.can.save ) { #>
                    <span class="links-separator">|</span>
                    <# } #>
					<?php if ( MEDIA_TRASH ) : ?>
                        <# if ( 'trash' === data.status ) { #>
                        <button type="button" class="button-link untrash-attachment"><?php esc_html_e( 'Restore from Trash', 'exmage-wordpress-image-links' ); ?></button>
                        <# } else { #>
                        <button type="button" class="button-link trash-attachment"><?php esc_html_e( 'Move to Trash', 'exmage-wordpress-image-links' ); ?></button>
                        <# } #>
					<?php else : ?>
                        <button type="button" class="button-link delete-attachment"><?php esc_html_e( 'Delete permanently', 'exmage-wordpress-image-links' ); ?></button>
					<?php endif; ?>
                    <# } #>
                </div>
            </div>
        </script>
		<?php // Template for the Attachment details, used for example in the sidebar. ?>
        <script type="text/html" id="tmpl-exmage-attachment-details">
            <h2>
				<?php esc_html_e( 'Attachment Details', 'exmage-wordpress-image-links' ); ?>
                <span class="settings-save-status" role="status">
				<span class="spinner"></span>
				<span class="saved"><?php esc_html_e( 'Saved.' ); ?></span>
			</span>
            </h2>
            <div class="attachment-info">

                <# if ( 'audio' === data.type ) { #>
                <div class="wp-media-wrapper wp-audio">
                    <audio style="visibility: hidden" controls class="wp-audio-shortcode" width="100%" preload="none">
                        <source type="{{ data.mime }}" src="{{ data.url }}"/>
                    </audio>
                </div>
                <# } else if ( 'video' === data.type ) {
                var w_rule = '';
                if ( data.width ) {
                w_rule = 'width: ' + data.width + 'px;';
                } else if ( wp.media.view.settings.contentWidth ) {
                w_rule = 'width: ' + wp.media.view.settings.contentWidth + 'px;';
                }
                if(typeof data._exmage_external_oembed_src == 'undefined' || data._exmage_external_oembed_src == '' ){ #>
                <div style="{{ w_rule }}" class="wp-media-wrapper wp-video">
                    <video controls="controls" class="wp-video-shortcode" preload="metadata"
                    <# if ( data.width ) { #>width="{{ data.width }}"<# } #>
                    <# if ( data.height ) { #>height="{{ data.height }}"<# } #>
                    <# if ( data.image && data.image.src !== data.icon ) { #>poster="{{ data.image.src }}"<# } #>>
                    <source type="{{ data.mime }}" src="{{ data.url }}"/>
                    </video>
                </div>
                <#
                }else{
                #>
                <div style="{{ w_rule }}" class="wp-media-wrapper wp-video">
                    <iframe controls="controls" class="wp-video-shortcode" preload="metadata" src="{{ data._exmage_external_oembed_src }}"
                    <# if ( data.width ) { #>width="{{ data.width }}"<# } #>
                    <# if ( data.height ) { #>height="{{ data.height }}"<# } #>
                    <# if ( data.image && data.image.src !== data.icon ) { #>poster="{{ data.image.src }}"<# } #>>
                    </iframe>
                </div>
                <# } ``
                } else { #>
                <div class="thumbnail thumbnail-{{ data.type }}">
                    <# if ( data.uploading ) { #>
                    <div class="media-progress-bar">
                        <div></div>
                    </div>
                    <# } else if ( 'image' === data.type && data.size && data.size.url ) { #>
                    <img src="{{ data.size.url }}" draggable="false" alt=""/>
                    <# } else { #>
                    <img src="{{ data.icon }}" class="icon" draggable="false" alt=""/>
                    <# } #>
                </div>
                <# } #>

                <div class="details">
                    <div class="filename">{{ data.filename }}</div>
                    <div class="uploaded">{{ data.dateFormatted }}</div>

                    <div class="file-size">{{ data.filesizeHumanReadable }}</div>
                    <# if ( 'image' === data.type && ! data.uploading ) { #>
                    <# if ( data.width && data.height ) { #>
                    <div class="dimensions">
						<?php
						/* translators: 1: A number of pixels wide, 2: A number of pixels tall. */
						printf( esc_html__( '%1$s by %2$s pixels', 'exmage-wordpress-image-links' ), '{{ data.width }}', '{{ data.height }}' );
						?>
                    </div>
                    <# } #>

                    <# if ( data.originalImageURL && data.originalImageName ) { #>
                    <div class="word-wrap-break-word">
						<?php esc_html_e( 'Original image:', 'exmage-wordpress-image-links' ); ?>
                        <a href="{{ data.originalImageURL }}">{{data.originalImageName}}</a>
                    </div>
                    <# } #>

                    <# if ( data.can.save && data.sizes ) { #>
                    <a class="edit-attachment" href="{{ data.editLink }}&amp;image-editor" target="_blank"><?php esc_html_e( 'Edit Image', 'exmage-wordpress-image-links' ); ?></a>
                    <# } #>
                    <# } #>

                    <# if ( data.fileLength && data.fileLengthHumanReadable ) { #>
                    <div class="file-length"><?php esc_html_e( 'Length:' , 'exmage-wordpress-image-links'); ?>
                        <span aria-hidden="true">{{ data.fileLengthHumanReadable }}</span>
                        <span class="screen-reader-text">{{ data.fileLengthHumanReadable }}</span>
                    </div>
                    <# } #>

                    <# if ( data.mediaStates ) { #>
                    <div class="media-states"><strong><?php esc_html_e( 'Used as:', 'exmage-wordpress-image-links' ); ?></strong> {{ data.mediaStates }}</div>
                    <# } #>

                    <# if ( ! data.uploading && data.can.remove ) { #>
					<?php if ( MEDIA_TRASH ) : ?>
                        <# if ( 'trash' === data.status ) { #>
                        <button type="button" class="button-link untrash-attachment"><?php esc_html_e( 'Restore from Trash', 'exmage-wordpress-image-links' ); ?></button>
                        <# } else { #>
                        <button type="button" class="button-link trash-attachment"><?php esc_html_e( 'Move to Trash', 'exmage-wordpress-image-links' ); ?></button>
                        <# } #>
					<?php else : ?>
                        <button type="button" class="button-link delete-attachment"><?php esc_html_e( 'Delete permanently', 'exmage-wordpress-image-links' ); ?></button>
					<?php endif; ?>
                    <# } #>

                    <div class="compat-meta">
                        <# if ( data.compat && data.compat.meta ) { #>
                        {{{ data.compat.meta }}}
                        <# } #>
                    </div>
                </div>
            </div>
            <# var maybeReadOnly = data.can.save || data.allowLocalEdits ? '' : 'readonly'; #>
            <# if ( 'image' === data.type ) { #>
            <span class="setting alt-text has-description" data-setting="alt">
				<label for="attachment-details-alt-text" class="name"><?php esc_html_e( 'Alt Text', 'exmage-wordpress-image-links' ); ?></label>
				<textarea id="attachment-details-alt-text" aria-describedby="alt-text-description" {{ maybeReadOnly }}>{{ data.alt }}</textarea>
			</span>
            <p class="description" id="alt-text-description"><?php echo esc_html( $alt_text_description ); ?></p>
            <# } #>
			<?php if ( post_type_supports( 'attachment', 'title' ) ) : ?>
                <span class="setting" data-setting="title">
			<label for="attachment-details-title" class="name"><?php esc_html_e( 'Title', 'exmage-wordpress-image-links' ); ?></label>
			<input type="text" id="attachment-details-title" value="{{ data.title }}" {{ maybeReadOnly }}/>
		</span>
			<?php endif; ?>
            <# if ( 'audio' === data.type ) { #>
			<?php
			foreach (
				array(
					'artist' => esc_html__( 'Artist' ),
					'album'  => esc_html__( 'Album' ),
				) as $key => $label
			) :
				?>
                <span class="setting" data-setting="<?php echo esc_attr( $key ); ?>">
			<label for="attachment-details-<?php echo esc_attr( $key ); ?>" class="name"><?php echo esc_html( $label ); ?></label>
			<input type="text" id="attachment-details-<?php echo esc_attr( $key ); ?>" value="{{ data.<?php echo esc_attr( $key ); ?> || data.meta.<?php echo esc_attr( $key ); ?> || '' }}"/>
		</span>
			<?php endforeach; ?>
            <# } #>
            <span class="setting" data-setting="caption">
			<label for="attachment-details-caption" class="name"><?php esc_html_e( 'Caption', 'exmage-wordpress-image-links' ); ?></label>
			<textarea id="attachment-details-caption" {{ maybeReadOnly }}>{{ data.caption }}</textarea>
		</span>
            <span class="setting" data-setting="description">
			<label for="attachment-details-description" class="name"><?php esc_html_e( 'Description' , 'exmage-wordpress-image-links'); ?></label>
			<textarea id="attachment-details-description" {{ maybeReadOnly }}>{{ data.description }}</textarea>
		</span>
            <span class="setting" data-setting="url">
			<label for="attachment-details-copy-link" class="name"><?php esc_html_e( 'File URL:', 'exmage-wordpress-image-links' ); ?></label>
			<input type="text" class="attachment-details-copy-link" id="attachment-details-copy-link" value="{{ data.url }}" readonly/>
			<div class="copy-to-clipboard-container">
				<button type="button" class="button button-small copy-attachment-url" data-clipboard-target="#attachment-details-copy-link"><?php esc_html_e( 'Copy URL to clipboard' ); ?></button>
				<span class="success hidden" aria-hidden="true"><?php esc_html_e( 'Copied!', 'exmage-wordpress-image-links' ); ?></span>
			</div>
		</span>
        </script>
		<?php

	}

	/**
	 * Add External URL column to media list view
	 *
	 * @param $cols
	 *
	 * @return mixed
	 */
	public function is_external( $cols ) {
		$cols['exmage_is_external'] = '<span>' . esc_html__( 'External URL', 'exmage-wordpress-image-links' ) . '</span>';
		if ( $this->settings->get_param( 'ai_model' ) !== 'disable' ) {
			$cols['exmage_generator_alt'] = '<span>' . esc_html__( 'Generator Alt', 'exmage-wordpress-image-links' ) . '</span>';
		}

		return $cols;
	}

	/**
	 * @param $col
	 */
	public function column_callback_media( $col ) {
		global $post;
		if ( ! $post ) {
			return;
		}
		switch ( $col ) {
			case 'exmage_is_external':
				$post_mime_type = get_post_mime_type( $post->ID );
				if ( strpos( $post_mime_type, 'video' ) !== false ) {
					?>
                    <div class="exmage-external-url-video-shortcode">
                        <span class="exmage-shortcode-label"><?php echo esc_html__( 'Shortcode:', 'exmage-wordpress-image-links' ); ?></span>
                        <div class="exmage-wrap-shortcode">
                            <span class="exmage-shortcode">[exmage_video id="<?php echo esc_attr( $post->ID ) ?>"]</span>
                            <span class="exmage-shortcode-icon-copy dashicons dashicons-admin-page "></span>
                        </div>

                    </div>
					<?php
				}
				?>
                <div class="exmage-external-url-container">
                    <div class="exmage-external-url-content">
						<?php
						$_exmage_imported = get_post_meta( $post->ID, '_exmage_imported', true );
						$external_link    = get_post_meta( $post->ID, '_exmage_external_url', true );
						if ( ! $_exmage_imported && $external_link ) {
							self::html_for_external_image( $external_link, $post->ID );
						} elseif ( $_exmage_imported || get_post_meta( $post->ID, '_vi_wad_image_id', true ) ) {

						}
						?>
                    </div>
                    <p class="exmage-migrate-message"></p>
                </div>

				<?php
				break;
			case 'exmage_generator_alt':
				if ( $this->settings->get_param( 'ai_model' ) !== 'disable' ) {
					$post_mime_type = get_post_mime_type( $post->ID );
					if ( strpos( $post_mime_type, 'image' ) !== false ) {
						?>
                        <div class="exmage-wrap-button-render">
                            <button class="exmage-generator-alt-button button button-primary exmage-button" data-attachment_id="<?php echo esc_attr( $post->ID ); ?>"><?php echo esc_html__( 'AI generator', 'exmage-wordpress-image-links' ); ?></button>
                            <div class="exmage-generator-alt-message"></div>
                        </div>
						<?php
					}
				}
				break;
			default:
				break;
		}

	}

	/**
	 * @param $attachment_id
	 */
	private static function html_for_convertable_external_image( $attachment_id ) {
		?>
        <div class="exmage-action-buttons-container">
                <span class="button exmage-convert-external-button"
                      data-attachment_id="<?php echo esc_attr( $attachment_id ) ?>"
                      title="<?php esc_attr_e( 'Change this image to use external link. The existing image file stored on your server will be deleted.', 'exmage-wordpress-image-links' ) ?>">
                    <span class="dashicons dashicons-cloud-upload"></span>
                    <span class="exmage-migrate-button-overlay"></span>
                </span>
        </div>
		<?php
	}

	/**
	 * @param $external_link
	 * @param $attachment_id
	 */
	private static function html_for_external_image( $external_link, $attachment_id ) {
		$exmage_external_oembed_src = get_post_meta( $attachment_id, '_exmage_external_oembed_src', true );
		?>
        <div class="exmage-col-wrap-external-url">
            <div class="exmage-wrap-edit-field-external-url">
                <input type="text" class="exmage-edit-external-url-field" value="<?php echo esc_html( $external_link ) ?>">
                <span class="exmage-external-url"><?php echo esc_html( $external_link ) ?></span>
                <a href="#" class="exmage-edit-url dashicons dashicons-edit-large"></a>
                <a href="#" class="exmage-save-edit-url dashicons dashicons-saved"></a>
            </div>
            <a target="_blank" href="<?php echo esc_url( $external_link ) ?>" title="View Original Image"><span class="dashicons dashicons-external"></span></a>
        </div>
		<?php
		if ( ! $exmage_external_oembed_src ) {
			?>
            <div class="exmage-action-buttons-container">
                <span class="button exmage-migrate-button"
                      data-attachment_id="<?php echo esc_attr( $attachment_id ) ?>"
                      title="<?php esc_attr_e( 'Save this image to your WordPress server like normal images so that it will be editable', 'exmage-wordpress-image-links' ) ?>">
                    <span class="dashicons dashicons-cloud-saved"></span>
                    <span class="exmage-migrate-button-overlay"></span>
                </span>
            </div>
			<?php
		}

	}

	/**
	 * Check if an url is a valid image
	 *
	 * @param $url
	 * @param $width
	 * @param $height
	 *
	 * @return bool
	 */
	private static function is_image_url_valid( $url, &$width, &$height ) {
		$is_valid_image_url = false;
		$request            = wp_safe_remote_get( $url );
		if ( ! is_wp_error( $request ) && wp_remote_retrieve_response_code( $request ) === 200 && in_array( wp_remote_retrieve_header( $request, 'content-type' ), self::get_supported_mime_types(), true ) ) {
			$is_valid_image_url = true;
		}
		if ( $is_valid_image_url ) {
			$image_size = function_exists( 'wp_getimagesize' ) ? wp_getimagesize( $url ) : getimagesize( $url );
			if ( $image_size !== false ) {
				$width  = $image_size[0];
				$height = $image_size[1];
			}
		}

		return $is_valid_image_url;
	}

	/**
	 * Save external images
	 */
	public function convert_external_image() {
		global $wpdb;
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Sorry, you do not have permission.' );
		}
		check_ajax_referer( 'exmage_ajax_handle_url', '_exmage_ajax_nonce' );
		$response      = array(
			'status'  => 'error',
			'message' => '',
		);
		$attachment_id = isset( $_POST['attachment_id'] ) ? sanitize_text_field( wp_unslash( $_POST['attachment_id'] ) ) : '';
		$to_external   = isset( $_POST['to_external'] ) ? sanitize_text_field( wp_unslash( $_POST['to_external'] ) ) : '';

		if ( $attachment_id ) {
			$attachment = get_post( $attachment_id );
			if ( $attachment && $attachment->post_type === 'attachment' ) {
				$url              = get_post_meta( $attachment_id, '_exmage_external_url', true );
				$_exmage_imported = get_post_meta( $attachment_id, '_exmage_imported', true );
				if ( $to_external ) {
					$to_url = '';
					if ( $_exmage_imported ) {
						if ( $url ) {
							$to_url = $url;
						}
					} else {
						$ali_image_id = get_post_meta( $attachment_id, '_vi_wad_image_id', true );
						if ( $ali_image_id ) {
							$to_url = $ali_image_id;
							if ( 'https' !== substr( $to_url, 0, 5 ) ) {
								$to_url = set_url_scheme( '//' . $to_url, 'https' );
							}
						}
					}

					if ( $to_url ) {
						$width              = $height = 800;
						$is_valid_image_url = self::is_image_url_valid( $to_url, $width, $height );

						if ( $is_valid_image_url ) {
							$file = get_attached_file( $attachment_id, true );
							if ( is_multisite() ) {
								clean_dirsize_cache( $file );
							}
							if ( wp_delete_attachment_files( $attachment_id, wp_get_attachment_metadata( $attachment_id ), get_post_meta( $attachment_id, '_wp_attachment_backup_sizes', true ), $file ) ) {
								$to_url = self::process_image_url( $to_url, $image_id, $is_ali_cdn );
								update_post_meta( $attachment_id, '_wp_attached_file', $to_url );
								if ( $_exmage_imported ) {
									delete_post_meta( $attachment_id, '_exmage_imported' );
								}
								self::update_attachment_metadata( $attachment_id, $to_url, 'image', $is_ali_cdn, $width, $height );
								/*guid cannot be changed with wp_update_post function*/
								$wpdb->update( $wpdb->posts, array(// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
									'guid'       => strlen( $to_url ) > 255 ? '' : $to_url,//guid is varchar(255)
									'post_title' => apply_filters( 'exmage_insert_attachment_image_name', basename( $image_id ), $image_id, $to_url, $attachment->post_parent ),
								), array( 'ID' => $attachment_id ) );
								$response['status'] = 'success';
								ob_start();
								self::html_for_external_image( $to_url, $attachment_id );
								$response['message'] = ob_get_clean();

							} else {
								$response['message'] = esc_html__( 'Cannot delete file', 'exmage-wordpress-image-links' );
							}
						} else {
							$response['message'] = esc_html__( 'Invalid or not supported image URL', 'exmage-wordpress-image-links' );
						}
					} else {
						$response['message'] = esc_html__( 'Cannot find external URL', 'exmage-wordpress-image-links' );
					}
				} else {
					if ( ! $_exmage_imported ) {
						if ( $url ) {
							$tmp                    = download_url( $url );
							$file_array['name']     = $attachment->post_title ? $attachment->post_title : basename( $url );
							$file_array['tmp_name'] = $tmp;
							if ( ! is_wp_error( $tmp ) ) {
								$file = wp_handle_sideload( $file_array, array( 'test_form' => false ) );
								if ( ! isset( $file['error'] ) ) {
									$file_url = $file['url'];
									$type     = $file['type'];
									$file     = $file['file'];
									$title    = preg_replace( '/\.[^.]+$/', '', wp_basename( $file ) );
									$content  = '';
									// Use image exif/iptc data for title and caption defaults if possible.
									$image_meta = wp_read_image_metadata( $file );

									if ( $image_meta ) {
										if ( trim( $image_meta['title'] ) && ! is_numeric( sanitize_title( $image_meta['title'] ) ) ) {
											$title = $image_meta['title'];
										}

										if ( trim( $image_meta['caption'] ) ) {
											$content = $image_meta['caption'];
										}
									}
									$update_data = array(
										'ID'             => $attachment_id,
										'post_mime_type' => $type,
										'post_content'   => $content,
									);
									if ( ! $attachment->post_title ) {
										$update_data['post_title'] = $title;
									}
									// Save the attachment metadata.
									$update_post = wp_update_post( $update_data, true );
									if ( ! is_wp_error( $update_post ) ) {
										/*guid cannot be changed with wp_update_post function*/
										$wpdb->update( $wpdb->posts, array(// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
											'guid' => strlen( $file_url ) > 255 ? '' : $file_url,
											//guid is varchar(255)
										), array( 'ID' => $attachment_id ) );
										$response['status'] = 'success';
										ob_start();
										self::html_for_convertable_external_image( $attachment_id );
										$response['message'] = ob_get_clean();
										$upload_dir          = wp_get_upload_dir();
										$image_baseurl       = trailingslashit( $upload_dir['baseurl'] );
										update_post_meta( $attachment_id, '_wp_attached_file', str_replace( $image_baseurl, '', $file_url ) );
										update_post_meta( $attachment_id, '_exmage_imported', time() );
										wp_update_attachment_metadata( $attachment_id, wp_generate_attachment_metadata( $attachment_id, $file ) );
									} else {
										$response['message'] = $update_post->get_error_message();
									}
								} else {
									$response['message'] = $file['error'];
								}
							} else {
								@wp_delete_file( $file_array['tmp_name'] );
								$response['message'] = $tmp->get_error_message();
							}
						} else {
							$response['message'] = esc_html__( 'Cannot find external URL', 'exmage-wordpress-image-links' );
						}
					} else {
						$response['message'] = esc_html__( 'Saved already, please reload the page', 'exmage-wordpress-image-links' );
					}
				}
			}
		}

		wp_send_json( $response );
	}

	/**
	 * Edit external url
	 */
	public function exmage_edit_url() {
		global $wpdb;
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Sorry, you do not have permission.' );
		}
		check_ajax_referer( 'exmage_ajax_handle_url', '_exmage_ajax_nonce' );
		$response      = array(
			'status'  => 'error',
			'message' => '',
		);
		$attachment_id = isset( $_POST['attachment_id'] ) ? sanitize_text_field( wp_unslash( $_POST['attachment_id'] ) ) : '';
		$new_url       = isset( $_POST['url_val'] ) ? sanitize_text_field( wp_unslash( $_POST['url_val'] ) ) : '';
		$width         = $height = 800;
		if ( $attachment_id ) {
			/*Check type external url same current attachment*/
			$check_mine_type = false;

			$type_current_attachment = get_post_mime_type( $attachment_id );
			$get_type_current        = explode( '/', $type_current_attachment )[0];/*return image or video*/

			$mime_type_external = wp_check_filetype( $new_url );
			$external_type      = $mime_type_external['type'] ?? '';
			$get_external_type  = explode( '/', $external_type )[0];
			if ( empty( $get_external_type ) ) {
				$get_external_type = $this->video->is_video( $new_url ) ? 'video' : '';
			}
			if ( $get_type_current == $get_external_type ) {
				$check_mine_type = true;
			}

			if ( $check_mine_type ) {
				$attachment = get_post( $attachment_id );
				if ( $attachment && $attachment->post_type === 'attachment' ) {
					$new_url = self::process_image_url( $new_url, $image_id, $is_ali_cdn );
					update_post_meta( $attachment_id, '_wp_attached_file', $new_url );
					update_post_meta( $attachment_id, '_exmage_external_url', $new_url );
					wp_update_post( [
						'ID'   => (int) $attachment_id,
						'guid' => $new_url,
					] );
					if ( $this->video->is_video( $new_url ) ) {
						$data_video = $this->video->get_data_external_video( $new_url );
						if ( ! get_post_meta( $attachment_id, '_exmage_external_metadata', true ) ) {
							update_post_meta( $attachment_id, '_exmage_external_metadata', $data_video[0]['metadata'] );
						}
						if ( ! get_post_meta( $attachment_id, '_exmage_external_oembed_src', true ) ) {
							update_post_meta( $attachment_id, '_exmage_external_oembed_src', $data_video[0]['oembed_src'] ?? '' );
						}

						self::update_attachment_metadata( $attachment_id, $new_url, $data_video['post_mime_type'], $is_ali_cdn, $width, $height, $data_video );
					} else {
						self::update_attachment_metadata( $attachment_id, $new_url, 'image', $is_ali_cdn, $width, $height );
					}
					$response['message'] = esc_html__( 'Attachment updated', 'exmage-wordpress-image-links' );
					$response['status']  = esc_html__( 'success', 'exmage-wordpress-image-links' );


				} else {
					$response['message'] = esc_html__( 'Attachment not found', 'exmage-wordpress-image-links' );
				}
			} else {
				$response['message'] = esc_html__( 'Url is not the same type as this attachment or not support', 'exmage-wordpress-image-links' );
			}
		}

		wp_send_json( $response );
	}

	public function exmage_test_api_key() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Sorry, you do not have permission.' );
		}
		check_ajax_referer( 'exmage_ajax_handle_url', '_exmage_ajax_nonce' );

		$ai_model       = isset( $_POST['ai_model'] ) ? sanitize_text_field( wp_unslash( $_POST['ai_model'] ) ) : '';
		$api_key_gpt    = isset( $_POST['api_key_gpt'] ) ? sanitize_text_field( wp_unslash( $_POST['api_key_gpt'] ) ) : '';
		$api_key_gemini = isset( $_POST['api_key_gemini'] ) ? sanitize_text_field( wp_unslash( $_POST['api_key_gemini'] ) ) : '';

		if ( $ai_model == 'disabled' ) {
			wp_send_json_error( esc_html__( 'Please select AI model', 'exmage-wordpress-image-links' ) );
		}
		if ( ! $api_key_gpt && ! $api_key_gemini ) {
			wp_send_json_error( esc_html__( 'Unexpected error', 'exmage-wordpress-image-links' ) );
		}

		$r_result      = '';
		$ai_model_type = $this->settings->ai_model_type( $ai_model );
		if ( $ai_model_type == 'gpt' && $api_key_gpt ) {
			$r_result = esc_html__( 'Chat GPT: ', 'exmage-wordpress-image-links' ) . EXMAGEOpenAi::check_api_key_validity( $api_key_gpt );
		}

		if ( $ai_model_type == 'gemini' && $api_key_gemini ) {

			$r_result = esc_html__( 'Gemini: ', 'exmage-wordpress-image-links' ) . EXMAGEGemini::check_api_key_validity( $api_key_gemini );
		}

		wp_send_json( $r_result );
	}

	/**
	 * Generator alt text
	 */
	public function exmage_generator_alt_image() {

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Sorry, you do not have permission.' );
		}
		check_ajax_referer( 'exmage_ajax_handle_url', '_exmage_ajax_nonce' );
		$response = array(
			'status'  => 'error',
			'message' => '',
		);
		$ai_model = $this->settings->get_param( 'ai_model' );
		if ( $ai_model == 'disabled' ) {
			$response['message'] = esc_html__( 'This feature is disabled, please enable it in EXMAGE plugin settings.', 'exmage-wordpress-image-links' );
			wp_send_json( $response );
		}
		$attachment_id = isset( $_POST['attachment_id'] ) ? sanitize_text_field( wp_unslash( $_POST['attachment_id'] ) ) : '';

		if ( $attachment_id ) {
			/*Check type external url same current attachment*/

			$attachment = get_post( $attachment_id );
			if ( $attachment && $attachment->post_type === 'attachment' ) {
				/**/
				if ( $this->settings->get_param( 'ai_alt_exclude_image_exist_alt' ) ) {
					$current_alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
					if ( ! empty( $current_alt ) ) {
						$response['message'] = esc_html__( 'Alt image exist', 'exmage-wordpress-image-links' );
						$response['status']  = esc_html__( 'success', 'exmage-wordpress-image-links' );
						$response['content'] = esc_html( '' );
						wp_send_json( $response );
					}
				}
				$ai_model_type  = $this->settings->ai_model_type( $ai_model );
				$mess_generator = '';
				if ( $ai_model_type == 'gemini' ) {
					if ( empty( $this->settings->get_param( 'ai_gemini_api_key' ) ) ) {
						wp_send_json_error( esc_html__( 'Empty Google API key', 'exmage-wordpress-image-links' ) );
					}
					$mess_generator = EXMAGEGemini::instance()->generator( $attachment_id );


				} elseif ( $ai_model_type == 'gpt' ) {
					if ( empty( $this->settings->get_param( 'ai_openai_api_key' ) ) ) {
						wp_send_json_error( esc_html__( 'Empty OpenAI API key', 'exmage-wordpress-image-links' ) );
					}
					$mess_generator = EXMAGEOpenAi::instance()->generator( $attachment_id );
				}


				if ( is_array( $mess_generator ) ) {
					$response['message'] = $mess_generator;
				} else {
					if ( ! empty( $mess_generator ) ) {
						update_post_meta( $attachment_id, '_wp_attachment_image_alt', $mess_generator );
						$response['message'] = esc_html__( 'Alt image updated', 'exmage-wordpress-image-links' );
						$response['status']  = esc_html__( 'success', 'exmage-wordpress-image-links' );
						$response['content'] = esc_html( $mess_generator );

					} else {
						$response['message'] = esc_html__( 'There was an error during the generator process, please reload and generate again.', 'exmage-wordpress-image-links' );
					}
				}

			} else {
				$response['message'] = esc_html__( 'Attachment not found', 'exmage-wordpress-image-links' );
			}

		} else {
			$response['message'] = esc_html__( 'Attachment not found', 'exmage-wordpress-image-links' );
		}

		wp_send_json( $response );
	}

	/**
	 * @param $url
	 * @param $image_id
	 * @param $is_ali_cdn
	 *
	 * @return string|string[]|null
	 */
	public static function process_image_url( $url, &$image_id, &$is_ali_cdn ) {
		$new_url = $url;

		$parse_url  = wp_parse_url( $new_url );
		$scheme     = empty( $parse_url['scheme'] ) ? 'http' : $parse_url['scheme'];
		$image_id   = "{$parse_url['host']}{$parse_url['path']}";
		$new_url    = "{$scheme}://{$image_id}";
		$is_ali_cdn = in_array( $parse_url['host'], array(
			'ae01.alicdn.com',
			'ae02.alicdn.com',
			'ae03.alicdn.com',
			'ae04.alicdn.com',
			'ae05.alicdn.com',
		), true );
		preg_match( '/[^?]+\.(jpg|JPG|jpeg|JPEG|jpe|JPE|gif|GIF|png|PNG)/', $new_url, $matches );
		if ( ! is_array( $matches ) || ! count( $matches ) ) {
			preg_match( '/[^?]+\.(jpg|JPG|jpeg|JPEG|jpe|JPE|gif|GIF|png|PNG)/', $url, $matches );
			if ( is_array( $matches ) && count( $matches ) ) {
				$new_url  .= "?{$matches[0]}";
				$image_id .= "?{$matches[0]}";
			} elseif ( ! empty( $parse_url['query'] ) ) {
				$new_url .= '?' . $parse_url['query'];
			}
		} elseif ( ! empty( $parse_url['query'] ) ) {
			$new_url .= '?' . $parse_url['query'];
		}

		return $new_url;
	}

	/**
	 * @param $url
	 * @param $is_ali_cdn
	 *
	 * @return string|string[]|null
	 */
	public static function process_video_url( $url, &$is_ali_cdn ) {
		$new_url = $url;

		$parse_url  = wp_parse_url( $new_url );
		$scheme     = empty( $parse_url['scheme'] ) ? 'http' : $parse_url['scheme'];
		$video_id   = "{$parse_url['host']}{$parse_url['path']}";
		$new_url    = "{$scheme}://{$video_id}";
		$is_ali_cdn = in_array( $parse_url['host'], array(
			'video.aliexpress-media.com',
		), true );
		preg_match( '/[^?]+\.(mp4|mov|webm|MP4|MOV|WEBM)/', $new_url, $matches );
		if ( ! is_array( $matches ) || ! count( $matches ) ) {
			preg_match( '/[^?]+\.(mp4|mov|webm|MP4|MOV|WEBM)/', $url, $matches );
			if ( is_array( $matches ) && count( $matches ) ) {
				$new_url .= "?{$matches[0]}";

			} elseif ( ! empty( $parse_url['query'] ) ) {
				$new_url .= '?' . $parse_url['query'];
			}
		} elseif ( ! empty( $parse_url['query'] ) ) {
			$new_url .= '?' . $parse_url['query'];
		}

		return $new_url;
	}

	/**
	 *
	 */
	public function exmage_preload_video_data() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Sorry, you do not have permission.' );
		}
		check_ajax_referer( 'exmage_ajax_handle_url', '_exmage_ajax_nonce' );
		$response = array(
			'status'  => 'error',
			'message' => '',
			'id'      => '',
			'details' => array(),
		);
		$url      = isset( $_POST['url_val'] ) ? sanitize_trackback_urls( wp_unslash( $_POST['url_val'] ) ) : '';
		$url      = sanitize_trackback_urls( $url );
		$url      = wp_http_validate_url( $url );

		if ( ! $url ) {
			$response['message'] = esc_html__( 'Invalid Media URL', 'exmage-wordpress-image-links' );

			wp_send_json( $response );
		}
		if ( $this->video->is_video( $url ) ) {
			$data_video          = $this->video->get_data_external_video( $url );
			$response['details'] = $data_video;
		} else {
			$response['message'] = esc_html__( 'No valid image URLs found', 'exmage-wordpress-image-links' );
		}
		if ( ! empty( $response['details'] ) ) {
			$response['status'] = 'success';
		} elseif ( $response['status'] !== 'queue' ) {
			$response['message'] = esc_html__( 'No valid video URLs found', 'exmage-wordpress-image-links' );
		}

		wp_send_json( $response );
	}

	public function handle_url() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Sorry, you do not have permission.' );
		}
		check_ajax_referer( 'exmage_ajax_handle_url', '_exmage_ajax_nonce' );
		$response = array(
			'status'  => 'error',
			'message' => '',
			'id'      => '',
			'details' => array(),
		);

		$post_id    = isset( $_POST['post_id'] ) ? sanitize_text_field( wp_unslash( $_POST['post_id'] ) ) : '';
		$is_single  = isset( $_POST['is_single'] ) ? sanitize_text_field( wp_unslash( $_POST['is_single'] ) ) : '';
		$urls       = isset( $_POST['urls'] ) ? sanitize_trackback_urls( wp_unslash( $_POST['urls'] ) ) : '';
		$urls_thumb = isset( $_POST['urls_thumb'] ) ? sanitize_text_field( wp_unslash( $_POST['urls_thumb'] ) ) : '';
		if ( ! empty( $urls ) ) {
			$urls_array = explode( ",", $urls );
			$urls_array = array_filter( $urls_array );
			$urls_array = ( array_unique( $urls_array ) );/*Don't reset key array*/

			$urls_thumb_array = explode( ",", $urls_thumb );
			$urls_thumb_array = array_filter( $urls_thumb_array );
			if ( $is_single ) {
				$urls_array = array_slice( $urls_array, 0, 1 );
			}
			$urls_count     = count( $urls_array );
			$urls_threshold = apply_filters( 'exmage_ajax_handle_url_threshold', 20 );
			if ( $urls_count <= $urls_threshold ) {
				foreach ( $urls_array as $key => $url ) {
					$response['details'][] = self::add_media( $url, $urls_thumb_array[ $key ] ?? '', $image_id, $post_id );
				}
			}
		}
		if ( count( $response['details'] ) ) {
			$response['status'] = 'success';
		} elseif ( $response['status'] !== 'queue' ) {
			$response['message'] = esc_html__( 'No valid image URLs found', 'exmage-wordpress-image-links' );
		}

		wp_send_json( $response );
	}

	/**
	 * Add an external image
	 *
	 * @param $url
	 * @param $id_thumb
	 * @param $image_id
	 * @param string $parent_id
	 *
	 * @return array
	 */
	public function add_media( $url, $id_thumb, &$image_id, $parent_id = '' ) {
		$result = array(
			'url'       => $url,
			'message'   => '',
			'status'    => 'error',
			'id'        => '',
			'edit_link' => '',
		);

		$url = sanitize_trackback_urls( $url );
		$url = wp_http_validate_url( $url );

		if ( ! $url ) {
			$result['message'] = esc_html__( 'Invalid Media URL', 'exmage-wordpress-image-links' );

			return $result;
		}

		$width              = $height = 800;
		$is_valid_image_url = self::is_image_url_valid( $url, $width, $height );

		if ( $is_valid_image_url ) {
			$url   = self::process_image_url( $url, $image_id, $is_ali_cdn );
			$exist = attachment_url_to_postid( $url );
			if ( ! $exist ) {
				$check_filetype   = wp_check_filetype( basename( $url ), null );
				$attachment_media = array(
					'post_title'     => apply_filters( 'exmage_insert_attachment_image_name', basename( $image_id ), $image_id, $url, $parent_id ),
					'post_mime_type' => empty( $check_filetype['type'] ) ? 'image/url' : $check_filetype['type'],
					'guid'           => strlen( $url ) > 255 ? '' : $url,//guid is varchar(255)
					'post_status'    => 'inherit'
				);
				if ( class_exists( 'WPML_Media_Attachments_Duplication' ) ) {
					/*Prevent WPML from duplicating this external image*/
					exmage_remove_filter( 'add_attachment', 'WPML_Media_Attachments_Duplication', 'save_attachment_actions' );
					exmage_remove_filter( 'add_attachment', 'WPML_Media_Attachments_Duplication', 'save_translated_attachments' );
				}
				$attachment_id = wp_insert_attachment( $attachment_media, $url, $parent_id, true );
				if ( $attachment_id && ! is_wp_error( $attachment_id ) ) {
					self::update_attachment_metadata( $attachment_id, $url, 'image', $is_ali_cdn, $width, $height );
					$result['id']        = $attachment_id;
					$result['status']    = 'success';
					$result['message']   = esc_html__( 'Successful', 'exmage-wordpress-image-links' );
					$result['edit_link'] = esc_url( add_query_arg( array(
						'post'   => $attachment_id,
						'action' => 'edit'
					), admin_url( 'post.php' ) ) );
					$result['type']      = 'image';
				} else {
					$result['message'] = $attachment_id->get_error_message();
				}
			} else {
				$edit_link           = add_query_arg( array(
					'post'   => $exist,
					'action' => 'edit'
				), admin_url( 'post.php' ) );
				$result['id']        = $exist;
				$result['message']   = esc_html__( 'Image exists', 'exmage-wordpress-image-links' );
				$result['edit_link'] = esc_url( $edit_link );
				$result['type']      = 'image';
			}
		} else {
			$url = self::process_video_url( $url, $is_ali_cdn );

			if ( $this->video->is_video( $url ) ) {
				$exist = attachment_url_to_postid( $url );
				if ( ! $exist ) {

					$data_video = $this->video->get_data_external_video( $url );
					if ( ! empty( $data_video ) ) {

						$attachment_video = array(
							'post_title'     => apply_filters( 'exmage_insert_attachment_image_name', $data_video['post_title'] ?? '', $url ),
							'post_mime_type' => empty( $data_video['post_mime_type'] ) ? 'video/exmage' : $data_video['post_mime_type'],
							'guid'           => strlen( $data_video['guid'] ) > 255 ? '' : $data_video['guid'],//guid is varchar(255)
							'post_status'    => 'inherit'
						);
						if ( class_exists( 'WPML_Media_Attachments_Duplication' ) ) {
							/*Prevent WPML from duplicating this external image*/
							exmage_remove_filter( 'add_attachment', 'WPML_Media_Attachments_Duplication', 'save_attachment_actions' );
							exmage_remove_filter( 'add_attachment', 'WPML_Media_Attachments_Duplication', 'save_translated_attachments' );
						}
						$attachment_id = wp_insert_attachment( $attachment_video, $url, $parent_id, true );

						$width  = $data_video['width'] ?? $width;
						$height = $data_video['height'] ?? $height;

						/*Add feature image for video*/
						if ( $this->settings->get_param( 'enable_thumbnail_video' ) ) {

							if ( ! empty( $id_thumb ) ) {
								$id_thumb_video = $id_thumb;
								if ( ! is_numeric( $id_thumb ) ) {
									$attachment_thumb = self::add_media( esc_url_raw( $id_thumb ), '', $image_id, '' );
									$id_thumb_video   = $attachment_thumb['id'] ?? '';
								}
								$check_attachment = get_post( (int) $id_thumb_video );
								if ( $check_attachment && $check_attachment->post_type === 'attachment' ) {
									set_post_thumbnail( $attachment_id, $id_thumb_video );
								}
							}
						}

						if ( $attachment_id && ! is_wp_error( $attachment_id ) ) {
							self::update_attachment_metadata( $attachment_id, $url, $data_video['post_mime_type'], $is_ali_cdn, $width, $height, $data_video );
							$result['id']        = $attachment_id;
							$result['status']    = 'success';
							$result['message']   = esc_html__( 'Successful', 'exmage-wordpress-image-links' );
							$result['edit_link'] = esc_url( add_query_arg( array(
								'post'   => $attachment_id,
								'action' => 'edit'
							), admin_url( 'post.php' ) ) );
							$result['type']      = 'video';
						} else {
							$result['message'] = $attachment_id->get_error_message();
						}
					} else {
						$result['message'] = esc_html__( 'Error url video', 'exmage-wordpress-image-links' );
					}

				} else {
					$edit_link           = add_query_arg( array(
						'post'   => $exist,
						'action' => 'edit'
					), admin_url( 'post.php' ) );
					$result['id']        = $exist;
					$result['message']   = esc_html__( 'Image exists', 'exmage-wordpress-image-links' );
					$result['edit_link'] = esc_url( $edit_link );
				}
				$result['status']  = 'success';
				$result['message'] = esc_html__( 'Successful', 'exmage-wordpress-image-links' );
			} else {
				$result['message'] = esc_html__( 'Invalid or not supported video URL', 'exmage-wordpress-image-links' );
			}

		}

		return $result;
	}

	/**
	 * Update metadata
	 *
	 * @param $attachment_id
	 * @param $url
	 * @param $type
	 * @param $is_ali_cdn
	 * @param $width
	 * @param $height
	 * @param $data
	 */
	private static function update_attachment_metadata( $attachment_id, $url, $type, $is_ali_cdn, $width, $height, ...$data ) {
		if ( ! get_post_meta( $attachment_id, '_exmage_external_url', true ) ) {
			update_post_meta( $attachment_id, '_exmage_external_url', $url );
		}
		if ( $type !== 'image' ) {
			if ( ! get_post_meta( $attachment_id, '_exmage_external_metadata', true ) ) {
				update_post_meta( $attachment_id, '_exmage_external_metadata', $data[0]['metadata'] );
			}
			if ( ! get_post_meta( $attachment_id, '_exmage_external_oembed_src', true ) ) {
				update_post_meta( $attachment_id, '_exmage_external_oembed_src', $data[0]['oembed_src'] ?? '' );
			}
		}
		/*Build attachment metadata*/
		$attach_data = array(
			'file'   => $url,
			'width'  => $width,
			'height' => $height,
			'sizes'  => array()
		);
		if ( $type == 'image' ) {
			$wp_sizes    = self::get_sizes();
			$image_sizes = array();
			$pathinfo    = pathinfo( $url );
			if ( ! empty( $pathinfo['extension'] ) ) {
				$common_sizes = $is_ali_cdn ? array(
					'thumbnail'    => 50,
					'small1'       => 100,
					'small2'       => 200,
					'medium'       => 350,
					'medium_large' => 640
				) : apply_filters( 'exmage_get_supported_image_sizes', array(
					'thumbnail'    => 150,
					'medium'       => 300,
					'medium_large' => 768,
					'large'        => 1024
				), $url );
				foreach ( $common_sizes as $size_name => $size_width ) {
					if ( $is_ali_cdn ) {
						/*Ali cdn image size format: original-image-name.jpg_100x100.jpg*/
						$size_url = $url . "_{$size_width}x{$size_width}.{$pathinfo['extension']}";
					} else {
						/*WordPress image size format: original-image-name-100x100.jpg*/
						$size_url = apply_filters( 'exmage_image_size_url', substr( $url, 0, strlen( $url ) - strlen( $pathinfo['extension'] ) - 1 ) . "-{$size_width}x{$size_width}.{$pathinfo['extension']}", $url, $size_width );
					}
					$is_valid_image_url = self::is_image_url_valid( $size_url, $_width, $_height );
					if ( ! $is_valid_image_url ) {
						/*Use original url if the image size url is invalid*/
						$size_url = $url;
					}
					$image_sizes[ $size_name ] = array(
						'url'    => $size_url,
						'width'  => $size_width,
						'height' => $size_width
					);
				}
			}
			if ( ! isset( $image_sizes['large'] ) ) {
				$image_sizes['large'] = array(
					'url'    => $url,
					'width'  => $width,
					'height' => $height
				);
			} else {
				$image_sizes['full'] = array(
					'url'    => $url,
					'width'  => $width,
					'height' => $height
				);
			}
			/*Build attachment metadata*/
			$attach_data ['image_meta'] = array(
				'aperture'          => '0',
				'credit'            => '',
				'camera'            => '',
				'caption'           => '',
				'created_timestamp' => '0',
				'copyright'         => '',
				'focal_length'      => '0',
				'iso'               => '0',
				'shutter_speed'     => '0',
				'title'             => '',
				'orientation'       => '0',
				'keywords'          => array(),
			);
			foreach ( $wp_sizes as $size => $props ) {
				$select_size = self::select_size( $props, $image_sizes );
				if ( ! empty( $select_size ) ) {
					$check_filetype                  = wp_check_filetype( basename( $select_size['url'] ), null );
					$attach_data['sizes']["{$size}"] = array(
						'file'      => basename( $select_size['url'] ),
						'width'     => $select_size['width'],
						'height'    => $select_size['height'],
						'mime-type' => $check_filetype['type'],
					);
				}
			}
			if ( isset( $attach_data['sizes']['full'] ) ) {
				unset( $attach_data['sizes']['full'] );
			}
		} else if ( strpos( $type, "video" ) ) {
			$attach_data ['mime_type'] = $type;/*Maybe is video/youtube video/vimeo*/
		}


		wp_update_attachment_metadata( $attachment_id, $attach_data );
	}

	/**
	 * Generate sizes if any
	 *
	 * @return array
	 */
	private static function get_sizes() {
		global $_wp_additional_image_sizes;

		$sizes = array();

		foreach ( get_intermediate_image_sizes() as $_size ) {
			if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
				$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
				$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
				$sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
			} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
				$sizes[ $_size ] = array(
					'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
					'height' => $_wp_additional_image_sizes[ $_size ]['height'],
					'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
				);
			}
		}

		return $sizes;
	}

	/**
	 * @param $size
	 * @param array $image_sizes
	 *
	 * @return bool|mixed
	 */
	private static function select_size( $size, $image_sizes = array() ) {
		if ( empty( $image_sizes ) ) {
			return $size;
		}

		$min_size = $max_size = false;
		foreach ( $image_sizes as $props ) {
			if ( (int) $size['width'] == (int) $props['width'] ) {
				return $props;
			}

			if ( intval( $size['width'] ) < intval( $props['width'] ) && ( ! $min_size || intval( $min_size['width'] ) > intval( $props['width'] ) ) ) {
				$min_size = $props;
			}

			if ( ! $max_size || ( intval( $max_size['width'] ) < intval( $props['width'] ) ) ) {
				$max_size = $props;
			}
		}

		return ! $min_size ? $max_size : $min_size;
	}

	/**
	 * Enqueue script wherever media is used
	 */
	public function wp_enqueue_media() {
		if ( is_admin() ) {
			if ( ! did_action( 'wp_enqueue_media' ) ) {
				wp_enqueue_media();
			}
			wp_enqueue_script( 'exmage-media', EXMAGE_WP_IMAGE_PREMIUM_LINKS_JS . 'media.js', array( 'jquery' ), EXMAGEEnv::get( 'version' ), false );
			wp_enqueue_style( 'exmage-media', EXMAGE_WP_IMAGE_PREMIUM_LINKS_CSS . 'media.css', [], EXMAGEEnv::get( 'version' ) );
			wp_enqueue_script( 'exmage-script', EXMAGE_WP_IMAGE_PREMIUM_LINKS_JS . 'exmage.js', array( 'jquery' ), EXMAGEEnv::get( 'version' ), false );

			$exmage_admin_params = array(
				'ajaxurl'                    => admin_url( 'admin-ajax.php' ),
				'uploadurl'                  => admin_url( 'async-upload.php' ),
				'post_id'                    => get_the_ID(),
				'enable_ai_engine'           => $this->settings->get_param( 'ai_model' ),
				'_exmage_ajax_nonce'         => wp_create_nonce( 'exmage_ajax_handle_url' ),
				'i18n_select_existing_image' => esc_html__( 'Click here to select this exmage', 'exmage-wordpress-image-links' ),
				'wp_max_upload_size'         => wp_max_upload_size(),
				'cdn_type'                   => $this->settings->get_param( 'cdn_type' ),
			);

			switch ( $this->settings->get_param( 'cdn_type' ) ) {
				case 'cloudinary':
					$exmage_admin_params['cloudinaryCloudName']    = $this->settings->get_param( 'cloudinary_cloud_name' );
					$exmage_admin_params['cloudinaryUploadPreset'] = $this->settings->get_param( 'cloudinary_upload_preset' );

					wp_enqueue_script( 'exmage-cloudinary-widget', 'https://widget.cloudinary.com/v2.0/global/all.js' );
					wp_enqueue_script( 'exmage-cloudinary-upload-script', EXMAGE_WP_IMAGE_PREMIUM_LINKS_JS . 'exmage-upload.js', [ 'jquery', 'exmage-cloudinary-widget' ], EXMAGEEnv::get( 'version' ), false );
					break;
				case 'cloudflare':
				case 'aws':
					wp_enqueue_script( 'exmage-cloudinary-upload-script', EXMAGE_WP_IMAGE_PREMIUM_LINKS_JS . 'exmage-upload.js', [ 'jquery' ], EXMAGEEnv::get( 'version' ), false );
					break;
				default:
					break;
			}


			wp_localize_script( 'exmage-script', 'exmage_admin_params', $exmage_admin_params );
		}
	}

	/**
	 * @param $url
	 * @param $id
	 *
	 * @return mixed
	 */
	public function wp_get_attachment_url( $url, $id ) {
		if ( get_post_meta( $id, '_exmage_imported', true ) ) {
			return $url;
		}
		if ( ! get_post_meta( $id, '_exmage_external_url', true ) ) {
			return $url;
		}
		$post = get_post( $id );
		if ( $post && 'attachment' === $post->post_type ) {
			$_wp_attached_file = get_post_meta( $id, '_wp_attached_file', true );
			if ( $_wp_attached_file ) {
				if ( substr( $_wp_attached_file, 0, 7 ) === "http://" || substr( $_wp_attached_file, 0, 8 ) === "https://" ) {
					$url = $_wp_attached_file;
				}
			}
		}

		return $url;
	}

	/**
	 * @param $sources
	 * @param $size_array
	 * @param $image_src
	 * @param $image_meta
	 * @param $attachment_id
	 *
	 * @return mixed
	 */
	public function wp_calculate_image_srcset( $sources, $size_array, $image_src, $image_meta, $attachment_id ) {
		if ( get_post_meta( $attachment_id, '_exmage_imported', true ) ) {
			return $sources;
		}
		if ( ! get_post_meta( $attachment_id, '_exmage_external_url', true ) ) {
			return $sources;
		}
		if ( $sources ) {
			$upload_dir    = wp_get_upload_dir();
			$image_baseurl = trailingslashit( $upload_dir['baseurl'] );
			if ( is_ssl() && 'https' !== substr( $image_baseurl, 0, 5 ) && ! empty( $_SERVER['HTTP_HOST'] ) && wp_parse_url( $image_baseurl, PHP_URL_HOST ) === $_SERVER['HTTP_HOST'] ) {
				$image_baseurl = set_url_scheme( $image_baseurl, 'https' );
			}
			$_wp_attached_file = get_post_meta( $attachment_id, '_wp_attached_file', true );
			foreach ( $sources as &$src ) {
				$pos = strpos( $_wp_attached_file, 'wp-content/uploads/' );
				if ( false !== $pos ) {
					$src['url'] = str_replace( $image_baseurl, substr( $_wp_attached_file, 0, $pos - 1 ) . '/wp-content/uploads/', $src['url'] );
				} else {
					$src['url'] = str_replace( $image_baseurl, '', $src['url'] );
				}
			}
		}

		return $sources;
	}

	/**
	 * @return mixed|void
	 */
	private static function get_supported_mime_types() {
		return apply_filters( 'exmage_get_supported_mime_types', array(
			'image/png',
			'image/jpeg',
			'image/jpg',
			'image/gif',
			'image/webp',
		) );
	}

	public function search_exmage_url_when_import_product( &$q ) {
		if ( ! empty( $q->query_vars['meta_query'] ) ) {
			$file = '';
			foreach ( $q->query_vars['meta_query'] as $key => &$mt_qr ) {
				if ( ! empty( $mt_qr['key'] ) && $mt_qr['key'] == '_wc_attachment_source' ) {
					$file = $mt_qr['value'];
					break;
				}
			}
			if ( $file ) {
				$q->query_vars['meta_query'][] = [
					'key'     => '_exmage_external_url',
					'value'   => $file,
					'compare' => 'LIKE',
				];

				$q->query_vars['meta_query']['relation'] = 'OR';
			}
		}

	}

	public function ajax_cloudinary_save_attachment() {
		if ( empty( $_POST['url'] ) ) {
			wp_send_json_error( 'Empty URL' );
		}

		$url = esc_url_raw( $_POST['url'] );

		// Create attachment to Media Library
		$attachment = self::add_media( esc_url_raw( $url ), '', $image_id, '' );


		if ( empty( $attachment['id'] ) ) {
			wp_send_json_error( 'Cannot create attachment.' );
		}
		update_post_meta( $attachment['id'], '_exmage_cdn_type', 'cloudinary' );
		wp_send_json_success( [
			'attachment' => $attachment,
			'url'        => $url
		] );
	}

	public function ajax_upload_to_s3_or_r2() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Sorry, you do not have permission.' );
		}
		check_ajax_referer( 'exmage_ajax_handle_url', '_exmage_ajax_nonce' );

		$file_path = $_FILES['file']['tmp_name'];
		$file_name = basename( $_FILES['file']['name'] );
		$mime_type = mime_content_type( $file_path );

		// Allow only specific image and video mime types
		$allowed_types = [
			'image/jpeg',
			'image/png',
			'image/gif',
			'image/webp',
			'image/svg+xml',
			'video/mp4',
			'video/webm',
			'video/ogg',
			'video/quicktime'
		];

		if ( ! in_array( $mime_type, $allowed_types ) ) {
			wp_send_json_error( 'Invalid file type.' );
		}

		// (Optional) Size limit, e.g. 10MB
		$max_size = 10 * 1024 * 1024; // 100MB
		if ( $_FILES['file']['size'] > $max_size ) {
			wp_send_json_error( 'File size exceeds 10MB limit.' );
		}
		$service_type = '';
		if ( $this->settings->get_param( 'cdn_type' ) == 'cloudflare' ) {
			$service_type = 'cloudflare';
		} elseif ( $this->settings->get_param( 'cdn_type' ) == 'aws' ) {
			$service_type = 'aws';
		}
		$result = $this->upload_to_s3_or_r2( $file_path, $file_name, $mime_type, $service_type );
		// Check upload result and return public R2.dev URL if successful
		if ( $result['success'] ) {
			$public_url = $result['url'];
			$attachment = self::add_media( esc_url_raw( $public_url ), '', $image_id, '' );

			if ( empty( $attachment['id'] ) ) {
				wp_send_json_error( $attachment['message'] );
			} else {
				update_post_meta( $attachment['id'], '_exmage_cdn_type', $service_type );
				update_post_meta( $attachment['id'], '_exmage_cdn_file_name', $file_name );
				wp_send_json_success( [
					'attachment' => $attachment,
					'url'        => $public_url
				] );
			}
		} else {
			wp_send_json_error( $result['message'] );
		}
	}

	function upload_to_s3_or_r2( $file_path, $file_name, $mime_type, $service_type = 'aws' ) {

		// Check file exists
		if ( ! file_exists( $file_path ) ) {
			return [ 'success' => false, 'message' => 'File not found' ];
		}
		$region = 'auto';
		// Build endpoint and host according to service_type
		if ( $service_type === 'aws' ) {
			// Your Cloudflare R2 credentials
			$access_key = $this->settings->get_param( 'aws_access_key' );
			$secret_key = $this->settings->get_param( 'aws_secret_key' );
			$bucket     = $this->settings->get_param( 'aws_bucket_name' );
			$region     = $this->settings->get_param( 'aws_region_name' );
			// Validate required configuration variables
			if ( empty( $access_key ) ) {
				return [ 'success' => false, 'message' => 'Missing AWS Amazon Access Key . ' ];
			}
			if ( empty( $secret_key ) ) {
				return [ 'success' => false, 'message' => 'Missing AWS Amazon Secret Key . ' ];
			}
			if ( empty( $bucket ) ) {
				return [ 'success' => false, 'message' => 'Missing AWS Amazon R2 Bucket Name . ' ];
			}
			$host            = "{$bucket}.s3.{$region}.amazonaws.com";
			$object_key      = "exmage_uploads/{$file_name}";
			$object_key_safe = str_replace( '%2F', '/', rawurlencode( $object_key ) );
			$endpoint        = "https://{$host}/{$object_key_safe}";
			$public_url      = $endpoint;
		} elseif ( $service_type === 'cloudflare' ) {
			// Your Cloudflare R2 credentials
			$access_key = $this->settings->get_param( 'cloudflare_access_key' );
			$secret_key = $this->settings->get_param( 'cloudflare_secret_key' );
			$account_id = $this->settings->get_param( 'cloudflare_account_id' );
			$bucket     = $this->settings->get_param( 'cloudflare_bucket_name' );
			$r2_dev_url = $this->settings->get_param( 'cloudflare_public_development_url' );
			// Validate required configuration variables
			if ( empty( $access_key ) ) {
				return [ 'success' => false, 'message' => 'Missing Cloudflare Access Key . ' ];
			}
			if ( empty( $secret_key ) ) {
				return [ 'success' => false, 'message' => 'Missing Cloudflare Secret Key . ' ];
			}
			if ( empty( $account_id ) ) {
				return [ 'success' => false, 'message' => 'Missing Cloudflare Account ID . ' ];
			}
			if ( empty( $bucket ) ) {
				return [ 'success' => false, 'message' => 'Missing Cloudflare R2 Bucket Name . ' ];
			}
			if ( empty( $r2_dev_url ) ) {
				return [ 'success' => false, 'message' => 'Missing R2 . dev public URL . ' ];
			}
			$host = "{$account_id}.r2.cloudflarestorage.com";

			$object_key      = "{$bucket}/exmage_uploads/{$file_name}";
			$object_key_safe = str_replace( '%2F', '/', rawurlencode( $object_key ) );
			$endpoint        = "https://{$host}/{$object_key_safe}";
			$public_url      = "{$r2_dev_url}/exmage_uploads/{$file_name}";
		} else {
			return [ 'success' => false, 'message' => 'Invalid service type' ];
		}

		// Tính Signature V4
		date_default_timezone_set( 'UTC' );
		$amz_date       = gmdate( 'Ymd\THis\Z' );
		$date_stamp     = gmdate( 'Ymd' );
		$service        = 's3';
		$signed_headers = 'host;x-amz-content-sha256;x-amz-date';
		$payload_hash   = trim( hash( 'sha256', file_get_contents( $file_path ) ) );

		$canonical_request = "PUT\n/{$object_key_safe}\n\n"
		                     . "host:{$host}\n"
		                     . "x-amz-content-sha256:{$payload_hash}\n"
		                     . "x-amz-date:{$amz_date}\n\n"
		                     . "{$signed_headers}\n{$payload_hash}";

		$credential_scope = "{$date_stamp}/{$region}/{$service}/aws4_request";
		$string_to_sign   = "AWS4-HMAC-SHA256\n{$amz_date}\n{$credential_scope}\n" . hash( 'sha256', $canonical_request );

		$signing_key = $this->getSignatureKey( $secret_key, $date_stamp, $region, $service );
		$signature   = hash_hmac( 'sha256', $string_to_sign, $signing_key );

		$authorization_header = "AWS4-HMAC-SHA256 Credential={$access_key}/{$credential_scope}, SignedHeaders={$signed_headers}, Signature={$signature}";

		// Headers
		$headers = [
			"Authorization: {$authorization_header}",
			"x-amz-content-sha256: {$payload_hash}",
			"x-amz-date: {$amz_date}",
			"Content-Type: {$mime_type}"
		];

		// Upload qua cURL
		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $endpoint );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'PUT' );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, file_get_contents( $file_path ) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );

		$response  = curl_exec( $ch );
		$http_code = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		curl_close( $ch );
		if ( in_array( $http_code, [ 200, 201 ] ) ) {
			return [ 'success' => true, 'url' => $public_url ];
		} else {
			return [ 'success' => false, 'message' => "Upload failed (HTTP: {$http_code})" ];
		}
	}

	public function delete_from_s3_or_r2( $file_name, $service_type = 'aws' ) {
		$region = 'auto';

		if ( $service_type === 'aws' ) {
			$access_key = $this->settings->get_param( 'aws_access_key' );
			$secret_key = $this->settings->get_param( 'aws_secret_key' );
			$bucket     = $this->settings->get_param( 'aws_bucket_name' );
			$region     = $this->settings->get_param( 'aws_region_name' );

			if ( empty( $access_key ) || empty( $secret_key ) || empty( $bucket ) ) {
				return [ 'success' => false, 'message' => 'Missing AWS credentials' ];
			}

			$host          = "{$bucket}.s3.{$region}.amazonaws.com";
			$file_name_raw = rawurldecode( $file_name );
			$object_key    = "exmage_uploads/{$file_name_raw}";
			$object_key    = implode( '/', array_map( 'rawurlencode', explode( '/', $object_key ) ) );
			$endpoint      = "https://{$host}/{$object_key}";

		} elseif ( $service_type === 'cloudflare' ) {
			$access_key = $this->settings->get_param( 'cloudflare_access_key' );
			$secret_key = $this->settings->get_param( 'cloudflare_secret_key' );
			$account_id = $this->settings->get_param( 'cloudflare_account_id' );
			$bucket     = $this->settings->get_param( 'cloudflare_bucket_name' );

			if ( empty( $access_key ) || empty( $secret_key ) || empty( $account_id ) || empty( $bucket ) ) {
				return [ 'success' => false, 'message' => 'Missing Cloudflare credentials' ];
			}

			$host = "{$account_id}.r2.cloudflarestorage.com";

			$file_name_raw = rawurldecode( $file_name );
			$object_key    = "{$bucket}/exmage_uploads/{$file_name_raw}";
			$object_key    = implode( '/', array_map( 'rawurlencode', explode( '/', $object_key ) ) );
			$endpoint      = "https://{$host}/{$object_key}";
		} else {
			return [ 'success' => false, 'message' => 'Invalid service type' ];
		}

		date_default_timezone_set( 'UTC' );
		$amz_date       = gmdate( 'Ymd\THis\Z' );
		$date_stamp     = gmdate( 'Ymd' );
		$service        = 's3';
		$signed_headers = 'host;x-amz-date';
		$payload_hash   = hash( 'sha256', '' );

		$canonical_request = "DELETE\n/{$object_key}\n\n"
		                     . "host:{$host}\n"
		                     . "x-amz-date:{$amz_date}\n\n"
		                     . "{$signed_headers}\n{$payload_hash}";

		$credential_scope = "{$date_stamp}/{$region}/{$service}/aws4_request";
		$string_to_sign   = "AWS4-HMAC-SHA256\n{$amz_date}\n{$credential_scope}\n" . hash( 'sha256', $canonical_request );

		$signing_key = $this->getSignatureKey( $secret_key, $date_stamp, $region, $service );
		$signature   = hash_hmac( 'sha256', $string_to_sign, $signing_key );

		$authorization_header = "AWS4-HMAC-SHA256 Credential={$access_key}/{$credential_scope}, SignedHeaders={$signed_headers}, Signature={$signature}";

		// Headers
		$headers = [
			"Authorization: {$authorization_header}",
			"x-amz-content-sha256: {$payload_hash}",
			"x-amz-date: {$amz_date}",
		];

		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $endpoint );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'DELETE' );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );

		$response  = curl_exec( $ch );
		$http_code = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		curl_close( $ch );

		if ( $http_code === 204 ) {
			return [ 'success' => true, 'message' => 'File deleted successfully' ];
		} else {
			return [ 'success' => false, 'message' => "Delete failed (HTTP: {$http_code})" ];
		}
	}

	public function delete_from_cloudinary( $file_name, $resource_type = 'image' ) {
		$cloud_name = $this->settings->get_param( 'cloudinary_cloud_name' );
		$api_key    = $this->settings->get_param( 'cloudinary_api_key' );
		$api_secret = $this->settings->get_param( 'cloudinary_api_secret' );

		if ( empty( $cloud_name ) || empty( $api_key ) || empty( $api_secret ) ) {
			return [ 'success' => false, 'message' => 'Missing Cloudinary credentials' ];
		}

		$timestamp = time();

		// Remove external file if exist (Because Cloudinary need only public_id don't have extension)
		$file_name_raw = pathinfo( $file_name, PATHINFO_FILENAME );

		// If on folder, keep folder
		$file_name_raw = rawurldecode( $file_name_raw );
		$public_id     = preg_replace( '/\.[^.]+$/', '', $file_name_raw ); // Remove external .jpg/.png/.webp/.mp4,.....

		// Tính signature
		$params_to_sign = "public_id={$public_id}&timestamp={$timestamp}{$api_secret}";
		$signature      = sha1( $params_to_sign );

		// Request URL
		$endpoint = "https://api.cloudinary.com/v1_1/{$cloud_name}/{$resource_type}/destroy";
		// POST fields
		$post_fields = [
			'public_id' => $public_id,
			'api_key'   => $api_key,
			'timestamp' => $timestamp,
			'signature' => $signature
		];

		// Send request delete file
		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $endpoint );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $ch, CURLOPT_POST, 1 );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $post_fields );

		$response  = curl_exec( $ch );
		$http_code = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		curl_close( $ch );

		$response_data = json_decode( $response, true );
		if ( $http_code === 200 && isset( $response_data['result'] ) && $response_data['result'] === 'ok' ) {
			return [ 'success' => true, 'message' => 'File deleted successfully from Cloudinary' ];
		} else {
			return [
				'success'  => false,
				'message'  => "Delete failed (HTTP: {$http_code})",
				'response' => $response_data
			];
		}
	}

	public function delete_file_and_cdn_resource( $post_id ) {
		$post   = get_post( $post_id );
		$result = [ 'success' => false ];

		if ( $post && $post->post_type === 'attachment' ) {
			$cdn_type = get_post_meta( $post_id, '_exmage_cdn_type', true );

			if ( ! empty( $cdn_type ) ) {
				$file_url  = $post->guid;
				$file_name = basename( parse_url( $file_url, PHP_URL_PATH ) );

				switch ( $cdn_type ) {
					case 'cloudinary':
						$file_mime_type = $post->post_mime_type;
						$resource_type  = 'image'; // default

						if ( strpos( $file_mime_type, 'video/' ) === 0 ) {
							$resource_type = 'video';
						}
						$result = $this->delete_from_cloudinary( $file_url, $resource_type );
						break;
					case 'cloudflare':
					case 'aws':
						// Only delete file on folder exmage_uploads/
						if ( strpos( $file_url, 'exmage_uploads/' ) === false ) {
							return;
						}
						$result = $this->delete_from_s3_or_r2( $file_name, $cdn_type );

						break;
				}

				if ( $result['success'] ) {
					error_log( print_r( "Deleted {$file_name} from S3 successfully", true ) );
				} else {
					error_log( print_r( "Failed to delete {$file_name} from S3: " . $result['message'], true ) );
				}
			}
		}
	}

	/**
	 * AWS Signature V4 signing key generator
	 *
	 * @param $key
	 * @param $dateStamp
	 * @param $regionName
	 * @param $serviceName
	 *
	 * @return string
	 */
	public function getSignatureKey( $key, $dateStamp, $regionName, $serviceName ) {
		$kDate    = hash_hmac( 'sha256', $dateStamp, 'AWS4' . $key, true );
		$kRegion  = hash_hmac( 'sha256', $regionName, $kDate, true );
		$kService = hash_hmac( 'sha256', $serviceName, $kRegion, true );
		$kSigning = hash_hmac( 'sha256', 'aws4_request', $kService, true );

		return $kSigning;
	}

	public function exmage_test_upload_cdn() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Sorry, you do not have permission . ' );
		}
		check_ajax_referer( 'exmage_ajax_handle_url', '_exmage_ajax_nonce' );
		$response      = array(
			'status'  => 'error',
			'message' => '',
		);
		$cloud_name    = isset( $_POST['cloudinaryName'] ) ? sanitize_text_field( $_POST['cloudinaryName'] ) : '';
		$upload_preset = isset( $_POST['cloudinaryUploadPreset'] ) ? sanitize_text_field( $_POST['cloudinaryUploadPreset'] ) : '';
		// Create endpoint
		$url = "https://api.cloudinary.com/v1_1/{$cloud_name}/image/upload";

		// Dummy Image base64 (1x1 px transparent GIF)
		$dummy_image = 'data:image / gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==';

		// Prepare POST fields
		$postfields = [
			'file'          => $dummy_image,
			'upload_preset' => $upload_preset
		];

		$ch = curl_init( $url );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_TIMEOUT, 10 );
		curl_setopt( $ch, CURLOPT_POST, true );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $postfields );

		$response   = curl_exec( $ch );
		$http_code  = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		$curl_error = curl_error( $ch );
		curl_close( $ch );

		if ( $curl_error ) {
			wp_send_json_error( $response );
		}

		if ( $http_code == 200 ) {
			wp_send_json_success( 'Connected' );

		} else {
			wp_send_json_error( "Connection error or wrong Cloudname / Upload Preset (HTTP {$http_code}). Responsive: {$response}" );
		}
	}
}