<?php
/**
 * Template for displaying course audience
 *
 * @package Tutor\Templates
 * @subpackage Single\Course
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

do_action( 'tutor_course/single/before/audience' );

$target_audience = tutor_course_target_audience();

if ( empty( $target_audience ) ) {
	return;
}
?>

<?php if ( is_array( $target_audience ) && count( $target_audience ) ) : ?>
	<div class="tutor-course-details-widget">
		<h5 class="tutor-course-details-widget-title tutor-mb-16">
			<?php esc_html_e( 'Audience', 'eduvalt' ); ?>
		</h5>
		<ul class="tutor-course-details-widget-list">
			<?php foreach ( $target_audience as $audience ) : ?>
				<li class="tutor-d-flex tutor-mb-12">
					<span><?php echo esc_html( $audience ); ?></span>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>

<?php do_action( 'tutor_course/single/after/audience' ); ?>
