<?php
/**
 * Template for displaying course requirements
 *
 * @package Tutor\Templates
 * @subpackage Single\Course
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

do_action( 'tutor_course/single/before/requirements' );

$course_requirements = tutor_course_requirements();

if ( empty( $course_requirements ) ) {
	return;
}

if ( is_array( $course_requirements ) && count( $course_requirements ) ) {
	?>

	<div class="tutor-course-details-widget">
		<h5 class="tutor-course-details-widget-title tutor-mb-16">
			<?php esc_html_e( 'Requirements', 'eduvalt' ); ?>
		</h5>
		<ul class="tutor-course-details-widget-list">
			<?php
			foreach ( $course_requirements as $requirement ) {
				echo '<li class="tutor-d-flex tutor-mb-12"><span>' . esc_html( $requirement ) . '</span></li>';
			}
			?>
		</ul>
	</div>

<?php } ?>

<?php do_action( 'tutor_course/single/after/requirements' ); ?>
