<?php

/**
 * Template for displaying course benefits
 *
 * @package Tutor\Templates
 * @subpackage Single\Course
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

do_action('tutor_course/single/before/benefits');

$course_benefits = tutor_course_benefits();
if (empty($course_benefits)) {
    return;
}
?>

<?php if (is_array($course_benefits) && count($course_benefits)) : ?>
    <div class="courses__details-inner">
        <h4 class="title">
            <?php echo esc_html(apply_filters('tutor_course_benefit_title', __('What Will You Learn?', 'eduvalt'))); ?>
        </h4>
        <div class="event-details-list">
            <ul class="list-wrap">
                <?php foreach ($course_benefits as $benefit) : ?>
                    <li>
                        <i class="fas fa-check-circle"></i>
                        <span><?php echo esc_html($benefit); ?></span>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php endif; ?>
<?php do_action('tutor_course/single/after/benefits'); ?>