<?php

/**
 * Template for displaying single course
 *
 * @package Tutor\Templates
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

global $post, $authordata;
$course_id       = get_the_ID();
$course_rating   = tutor_utils()->get_course_rating($course_id);
$is_enrolled     = tutor_utils()->is_enrolled($course_id, get_current_user_id());

// Prepare the nav items.
$course_nav_item = apply_filters('tutor_course/single/nav_items', array(
    'info'          => array(
        'title'  => __('Course Info', 'eduvalt'),
        'method' => 'tutor_course_info_custom',
    ),
    'curriculam'          => array(
        'title'  => __('Curriculam', 'eduvalt'),
        'method' => 'tutor_course_topics',
    ),
    'reviews'       => array(
        'title'  => __('Reviews', 'eduvalt'),
        'method' => 'tutor_course_target_reviews_html',
    ),
    'announcements' => array(
        'title'             => __('Announcements', 'eduvalt'),
        'method'            => 'tutor_course_announcements'
    ),
), $course_id);
$is_public       = \TUTOR\Course_List::is_public($course_id);
$is_mobile       = wp_is_mobile();

$enrollment_box_position = tutor_utils()->get_option('enrollment_box_position_in_mobile', 'bottom');
if ('-1' === $enrollment_box_position) {
    $enrollment_box_position = 'bottom';
}
$student_must_login_to_view_course = tutor_utils()->get_option('student_must_login_to_view_course');
$course_duration   = get_tutor_course_duration_context($course_id, true);
$total_students_in_course = tutor_utils()->count_enrolled_users_by_course($course_id);
$course_categories     = get_tutor_course_categories($course_id);
$profile_url       = tutor_utils()->profile_url($authordata->ID, true);
tutor_utils()->tutor_custom_header();

if (!is_user_logged_in() && !$is_public && $student_must_login_to_view_course) {
    tutor_load_template('login');
    tutor_utils()->tutor_custom_footer();
    return;
}

$topics_ids = get_posts(array(
    'post_parent'    => $course_id,
    'post_type'        => 'topics',
    'fields'         => 'ids'
));
$lessons_count = 0;
foreach ($topics_ids as $topic) {
    $lessons_ids = get_posts(array(
        'post_type'        => 'lesson',
        'post_parent'    => $topic,
        'fields'         => 'ids'
    ));

    $lessons_count += count($lessons_ids);
}

?>

<!-- breadcrumb-area -->
<section class="courses__breadcrumb-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="courses__breadcrumb-content">
                    <?php
                        $course_categories = get_tutor_course_categories();
                        if(is_array($course_categories) && count($course_categories)){
                            foreach ($course_categories as $course_category){
                                $category_name = $course_category->name;
                                $category_link = get_term_link($course_category->term_id);
                                echo "<a class='category' href='$category_link'>$category_name</a>";
                            }
                        }
                    ?>
                    <h3 class="title"><?php the_title(); ?></h3>
                    <p><?php echo wp_trim_words(get_the_excerpt(), 17); ?></p>
                    <ul class="courses__item-meta list-wrap">
                        <li>
                            <?php
                               $disable_course_author = get_tutor_option('disable_course_author');
                               if ( !$disable_course_author){
                                    global $post, $authordata;
                                     $profile_url = tutor_utils()->profile_url($authordata->ID, true);
                                    ?>
                                    <div class="author">
                                        <a href="<?php echo esc_url($profile_url); ?>">
                                           <?php echo get_avatar( get_the_author_meta( 'ID' ), 60 ); ?>
                                        </a>
                                        <a href="<?php echo esc_url($profile_url); ?>"><?php echo get_the_author(); ?></a>
                                    </div>
                            <?php } ?>
                        </li>                        
                        <li><i class="flaticon-file"></i> <?php echo esc_html($lessons_count); ?></li>
                        <li><i class="flaticon-timer"></i> <?php echo tutor_utils()->clean_html_content($course_duration); ?></li>
                        <li><i class="flaticon-user-1"></i> <?php echo esc_html($total_students_in_course); ?></li>
                        <?php
                          $disable = get_tutor_option('disable_course_review');
                          if ( ! $disable){
                            ?>
                            <li>
                                <div class="rating">
                                        <?php
                                        $course_rating = tutor_utils()->get_course_rating();
                                        tutor_utils()->star_rating_generator($course_rating->rating_avg);
                                        ?>
                                        <span class="rating-count">
                                            <?php echo '('.esc_attr( $course_rating->rating_avg ).')'; ?>
                                        </span>
                                </div>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- breadcrumb-area-end -->

<?php do_action('tutor_course/single/before/wrap'); ?>
<div <?php tutor_post_class('tutor-full-width-course-top tutor-course-top-info tutor-page-wrap tutor-wrap-parent'); ?>>
    <div class="courses-details-area section-pb-120">
        <div class="tutor-course-details-page container">
            <div class="row">
                <div class="col-xl-9 col-lg-8">
                    <div class="courses__details-wrapper">
                        <?php tutor_utils()->has_video_in_single() ? tutor_course_video() : get_tutor_course_thumbnail(); ?>
                        <?php do_action('tutor_course/single/before/inner-wrap'); ?>

                        <?php if ($is_mobile && 'top' === $enrollment_box_position) : ?>
                            <div class="tutor-mt-32">
                                <?php tutor_load_template('single.course.course-entry-box'); ?>
                            </div>
                        <?php endif; ?>

                        <div class="tutor-course-details-tab tutor-mt-32">
                            <?php if (is_array($course_nav_item) && count($course_nav_item) > 1) : ?>
                                <div class="tutor-is-sticky">
                                    <?php tutor_load_template('single.course.enrolled.nav', array('course_nav_item' => $course_nav_item)); ?>
                                </div>
                            <?php endif; ?>
                            <div class="tutor-tab tutor-pt-24">
                                <?php foreach ($course_nav_item as $key => $subpage) : ?>
                                    <div id="tutor-course-details-tab-<?php echo esc_attr($key); ?>" class="tutor-tab-item<?php echo 'info' == $key ? ' is-active' : ''; ?>">
                                        <?php
                                        do_action('tutor_course/single/tab/' . $key . '/before');

                                        $method = $subpage['method'];

                                        if (is_string($method)) {
                                            $method();
                                        } else {
                                            $_object = $method[0];
                                            $_method = $method[1];
                                            $_object->$_method(get_the_ID());
                                        }

                                        do_action('tutor_course/single/tab/' . $key . '/after');
                                        ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php do_action('tutor_course/single/after/inner-wrap'); ?>
                    </div>
                </div>

                <div class="col-xl-3 col-lg-4">
                    <aside class="courses__details-sidebar">
                        <div class="tutor-single-course-sidebar">
                            <?php do_action('tutor_course/single/before/sidebar'); ?>

                            <?php if (($is_mobile && 'bottom' === $enrollment_box_position) || !$is_mobile) : ?>
                                <?php tutor_load_template('single.course.course-entry-box'); ?>
                            <?php endif ?>

                            <div class="tutor-single-course-sidebar-more tutor-mt-24">
                                <?php tutor_course_instructors_html(); ?>
                                <?php tutor_course_target_audience_html(); ?>
                                <?php tutor_course_requirements_html(); ?>
                                <?php tutor_course_tags_html(); ?>
                            </div>

                            <?php do_action('tutor_course/single/after/sidebar'); ?>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
$randID = wp_rand();
$author_id = get_post_field('post_author', $course_id);
$related_courses_loop = olc_tutor_utils()->get_courses_by_instructor((int) $author_id, (int) $course_id);
if ($related_courses_loop->have_posts()) :
?>
    <div class="eduvalt-related-course courses__grid-wrap section-pb-90">
        <div class="container">
            <div class="section__title-wrap mb-40">
                <div class="row align-items-end">
                    <div class="col-lg-8">
                        <div class="section__title text-center text-lg-start">
                            <span class="sub-title"><?php echo esc_html__('Top Course', 'eduvalt'); ?></span>
                            <h2 class="title tg-svg"><?php echo esc_html__('More Courses By', 'eduvalt'); ?> <span class="position-relative"><span class="svg-icon" id="svg-<?php echo esc_attr($randID); ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo esc_html(ucwords(get_the_author())); ?></span></h2>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="tg-button-wrap justify-content-center justify-content-lg-end">
                            <a class="btn tg-svg" href="<?php echo esc_url($profile_url); ?>">
                                <span class="text"><?php esc_html_e('View All Course', 'eduvalt'); ?></span>
                                <span class="svg-icon" id="blog-btn<?php echo esc_attr($randID); ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row row-cols-1 row-cols-xl-3 row-cols-lg-2 row-cols-md-2 row-cols-sm-1">
                <?php while ($related_courses_loop->have_posts()) : $related_courses_loop->the_post(); ?>
                    <!-- Start Single Card  -->
                    <div class="col">
                        <?php
                        /**
                         * Usage Idea, you may keep a loop within a wrap, such as bootstrap col
                         *
                         * @hook tutor_course/archive/before_loop_course
                         * @type action
                         */
                        do_action('tutor_course/archive/before_loop_course');

                        tutor_load_template('loop.course');

                        /**
                         * Usage Idea, If you start any div before course loop, you can end it here, such as </div>
                         *
                         * @hook tutor_course/archive/after_loop_course
                         * @type action
                         */
                        do_action('tutor_course/archive/after_loop_course');
                        ?>
                    </div>
                    <!-- End Single Card  -->
                <?php endwhile;
                wp_reset_postdata(); ?>
            </div>
        </div>
    <?php endif; ?>
    <?php do_action('tutor_course/single/after/wrap'); ?>

    <?php
    tutor_utils()->tutor_custom_footer();
