<?php

/**
 * Display loop thumbnail
 *
 * @package Tutor\Templates
 * @subpackage CourseLoopPart
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.4.3
 */
global $post, $authordata;
$tutor_course_img = get_tutor_course_thumbnail_src();
$placeholder_img  = tutor()->url . 'assets/images/placeholder.svg';
$profile_url       = tutor_utils()->profile_url($authordata->ID, true);
?>
<div class="courses__item-two-thumb">
    <a href="<?php the_permalink(); ?>" class="shine__animate-link">
        <img src="<?php echo empty($tutor_course_img) ? esc_url($placeholder_img) : esc_url($tutor_course_img); ?>" alt="<?php the_title(); ?>">
    </a>
    <div class="author hide-list-view">
        <a href="<?php echo esc_url($profile_url); ?>">
            <?php echo get_avatar( get_the_author_meta( 'ID' ), 32 ); ?>
        </a>
    </div>
</div>