<?php

/**
 * Course meta template
 *
 * Meta template contains author avatar & categories
 *
 * @package Tutor\Templates
 * @subpackage CourseLoopPart
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.5.8
 */

global $post, $authordata;
$course_id         = $post->ID;
$profile_url       = tutor_utils()->profile_url($authordata->ID, true);
$course_categories = get_tutor_course_categories($course_id);
$course_duration   = get_tutor_course_duration_context($course_id, true);
$course_students   = tutor_utils()->count_enrolled_users_by_course($course_id);
$topics_ids = get_posts(array(
    'post_parent'    => $course_id,
    'post_type'        => 'topics',
    'fields'         => 'ids'
));

$lessons_count = 0;
foreach ($topics_ids as $topic) {
    $lessons_ids = get_posts(array(
        'post_type'        => 'lesson',
        'post_parent'    => $topic,
        'fields'         => 'ids'
    ));

    $lessons_count += count($lessons_ids);
}

?>

<?php if (tutor_utils()->get_option('enable_course_total_enrolled') || !empty($course_duration)) : ?>
    <ul class="courses__item-meta list-wrap">
        <li><i class="flaticon-file"></i><?php echo esc_html($lessons_count); ?></li>
        <?php if (!empty($course_duration)) : ?>
            <li><i class="flaticon-timer"></i> <?php echo tutor_utils()->clean_html_content($course_duration); ?></li>
        <?php endif; ?>
        <li><i class="flaticon-user-1"></i><?php echo esc_html($course_students); ?></li>
        <li class="hide-grid-view">
            <div class="courses__item-rating">
                <i class="fas fa-star"></i>
                <?php $course_rating = tutor_utils()->get_course_rating(); ?>
                <span class="rating-count">(<?php echo esc_html($course_rating->rating_avg); ?>)</span>
            </div>
        </li>
    </ul>
<?php endif; ?>
<p class="hide-grid-view"><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
<div class="courses__item-bottom">
    <div class="author hide-grid-view">
        <a href="<?php echo esc_url($profile_url); ?>" style="line-height: 0;">
            <?php echo wp_kses(tutor_utils()->get_tutor_avatar($post->post_author), tutor_utils()->allowed_avatar_tags()); ?>
        </a>
        <a href="<?php echo esc_url($profile_url); ?>"><?php echo esc_html(ucwords(get_the_author())); ?></a>
    </div>
    <?php tutor_course_loop_price(); ?>
</div>