<?php
/**
 * Course loop show view cart if in added to.
 *
 * @package Tutor\Templates
 * @subpackage CourseLoopPart
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.7.5
 */

?>
<?php
$course_id     = get_the_ID();
$cart_url      = function_exists( 'wc_get_cart_url' ) ? wc_get_cart_url() : '#';
$enroll_btn    = '<a href="' . $cart_url . '" class="btn">
		<i class="feather-shopping-cart"></i>
		<span>' . __( 'View Cart', 'eduvalt' ) . '</span>
	</a>';
$default_price = apply_filters( 'tutor-loop-default-price', __( 'Free', 'eduvalt' ) );
$price_html    = '<div class="price"> ' . $default_price . $enroll_btn . '</div>';
if ( tutor_utils()->is_course_purchasable() ) {

	$product_id = tutor_utils()->get_course_product_id( $course_id );
	$product    = wc_get_product( $product_id );

	if ( $product ) {
	ob_start();
	$sale_price    = $product->get_sale_price();
	$regular_price = $product->get_regular_price();
	?>
	<div class="price">
		<span class="current-price"><?php echo wc_price( $sale_price ? $sale_price : $regular_price ); //phpcs:ignore?></span>
		<?php if ( $regular_price && $sale_price && $sale_price != $regular_price ) : ?>
		<span class="off-price"><?php echo wc_price( $regular_price ); //phpcs:ignore?></span>
		<?php endif; ?>
	</div>
	<?php

	$price_html = ob_get_clean();
	$cart_html  = apply_filters( 'tutor_course_restrict_new_entry', $enroll_btn );
	}
}
echo wp_kses_post( $price_html );
echo wp_kses_post( $cart_html );
?>
