<?php

/**
 * Template for course filter
 *
 * @package Tutor\Templates
 * @subpackage Course_Filter
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

$filter_object = new \TUTOR\Course_Filter();

$filter_prices = array(
    'free' => __('Free', 'eduvalt'),
    'paid' => __('Paid', 'eduvalt'),
);

$course_levels     = tutor_utils()->course_levels();
$supported_filters = tutor_utils()->get_option('supported_course_filters', array());
$supported_filters = array_keys($supported_filters);
$reset_link        = remove_query_arg($supported_filters, get_pagenum_link());
?>

<form class="tutor-course-filter-form tutor-form">
    <aside class="courses__sidebar">
        <div class="tutor-mb-16 tutor-d-block tutor-d-lg-none tutor-text-right">
            <a href="#" class="tutor-iconic-btn tutor-mr-n8" tutor-hide-course-filter><span class="tutor-icon-times" area-hidden="true"></span></a>
        </div>

        <?php do_action('tutor_course_filter/before'); ?>

        <?php if (in_array('search', $supported_filters)) : ?>
            <div class="tutor-widget tutor-widget-search mb-30">
                <div class="tutor-form-wrap">
                    <span class="tutor-icon-search tutor-form-icon" area-hidden="true"></span>
                    <input type="Search" class="tutor-form-control" name="keyword" placeholder="<?php esc_attr_e('Search', 'eduvalt'); ?>" />
                </div>
            </div>
        <?php endif; ?>

        <?php if (in_array('category', $supported_filters)) : ?>
            <!-- Start Widget Area  -->
            <div class="shop-widget has-show-more">
                <div class="inner">
                    <h4 class="widget-title"><?php echo esc_html__('Faculties', 'eduvalt'); ?></h4>
                    <ul class="list-wrap categories-list-check has-show-more-inner-content">
                        <?php
                        $children_cats = array();
                        $categories = get_terms(array(
                            'taxonomy'         => 'course-category',
                            'hide_empty'    => false,
                            'parent'        => 0
                        ));

                        if (!empty($categories)) :
                            foreach ($categories as $term) :
                                $child_terms = get_term_children($term->term_id, 'course-category');

                                if (!empty($child_terms)) {
                                    foreach ($child_terms as $child_term_id) {
                                        $child_term = get_term_by('id', $child_term_id, 'course-category');
                                        $children_cats[] = $child_term;
                                    }
                                }
                                $post_in_term = new \WP_Query(array('course-category' => $term->slug));
                        ?>
                                <li>
                                    <div class="form-check">
                                        <input class="form-check-input" id="<?php echo esc_attr($term->slug); ?>" type="checkbox" name="tutor-course-filter-category" value="<?php echo esc_html($term->term_id); ?>">
                                        <label class="form-check-label" for="<?php echo esc_attr($term->slug); ?>"><?php echo esc_html($term->name); ?> <span class="cat-label count">(<?php echo esc_html($post_in_term->found_posts); ?>)</span></label>
                                    </div>
                                </li>
                        <?php wp_reset_query();
                            endforeach;
                        endif; ?>
                    </ul>
                </div>
                <div class="edu-show-more-btn"><?php echo esc_html__('Show More', 'eduvalt'); ?></div>
            </div>

            <div class="shop-widget has-show-more">
                <div class="inner">
                    <h4 class="widget-title"><?php echo esc_html__('Departments', 'eduvalt'); ?></h4>
                    <ul class="list-wrap categories-list-check has-show-more-inner-content">
                        <?php
                        if (!empty($children_cats)) :
                            foreach ($children_cats as $term) :
                                $post_in_term = new \WP_Query(array('course-category' => $term->slug));
                        ?>
                                <li>
                                    <div class="form-check">
                                        <input class="form-check-input" id="<?php echo esc_attr($term->slug); ?>" type="checkbox" name="tutor-course-filter-category" value="<?php echo esc_html($term->term_id); ?>">
                                        <label class="form-check-label" for="<?php echo esc_attr($term->slug); ?>"><?php echo esc_html($term->name); ?> <span class="cat-label count">(<?php echo esc_html($post_in_term->found_posts); ?>)</span></label>
                                    </div>
                                </li>
                        <?php wp_reset_query();
                            endforeach;
                        endif; ?>
                    </ul>
                </div>
                <div class="edu-show-more-btn"><?php echo esc_html__('Show More', 'eduvalt'); ?></div>
            </div>
            <!-- End Widget Area  -->
        <?php endif; ?>

        <!-- Start Widget Area  -->
        <div class="shop-widget d-none">
            <div class="inner">
                <h4 class="widget-title"><?php echo esc_html__('Ratings', 'eduvalt'); ?></h4>
                <ul class="list-wrap rating-list-check">
                    <li>
                        <div class="form-check">
                            <input class="form-check-input" id="cat-radio-1" type="radio" name="ratings">
                            <label class="form-check-label" for="cat-radio-1">
                                <span class="rating">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </span>
                                <span class="cat-label count">(5)</span>
                            </label>
                        </div>
                    </li>
                    <li>
                        <input class="form-check-input" id="cat-radio-2" type="radio" name="ratings">
                        <label class="form-check-label" for="cat-radio-2">
                            <span class="rating">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                            </span>
                            <span class="cat-label count">(4)</span>
                        </label>
                    </li>
                    <li>
                        <input class="form-check-input" id="cat-radio-3" type="radio" name="ratings">
                        <label class="form-check-label" for="cat-radio-3">
                            <span class="rating">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                            </span>
                            <span class="cat-label count">(3)</span>
                        </label>
                    </li>
                    <li>
                        <input class="form-check-input" id="cat-radio-4" type="radio" name="ratings">
                        <label class="form-check-label" for="cat-radio-4">
                            <span class="rating">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                            </span>
                            <span class="cat-label count">(2)</span>
                        </label>
                    </li>

                    <li>
                        <input class="form-check-input" id="cat-radio-5" type="radio" name="ratings">
                        <label class="form-check-label" for="cat-radio-5">
                            <span class="rating">
                                <i class="fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                                <i class="off fas fa-star"></i>
                            </span>
                            <span class="cat-label count">(1)</span>
                        </label>
                    </li>
                </ul>
            </div>
        </div>
        <!-- End Widget Area  -->

        <!-- Start Widget Area  -->
        <?php
        $is_membership = get_tutor_option('monetize_by') == 'pmpro' && tutor_utils()->has_pmpro();
        if (!$is_membership && in_array('price_type', $supported_filters)) :
        ?>
            <div class="shop-widget">
                <div class="inner">
                    <h4 class="widget-title"><?php echo esc_html__('Prices', 'eduvalt'); ?></h4>
                    <ul class="list-wrap prices-list-check">
                        <?php foreach ($filter_prices as $value => $course_title) : ?>
                            <li>
                                <div class="form-check">
                                    <input class="form-check-input" id="<?php echo esc_html($value); ?>" type="checkbox" name="tutor-course-filter-price" value="<?php echo esc_html($value); ?>">
                                    <label class="form-check-label" for="<?php echo esc_html($value); ?>"><?php echo esc_html($course_title); ?></label>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <!-- End Widget Area  -->

        <!-- Start Widget Area  -->
        <?php if (in_array('difficulty_level', $supported_filters)) : ?>
            <div class="shop-widget">
                <div class="inner">
                    <h4 class="widget-title"><?php echo esc_html__('Levels', 'eduvalt'); ?></h4>
                    <ul class="list-wrap lavels-list-check">
                        <?php
                        $key = '';
                        foreach ($course_levels as  $value => $course_title) :
                            if ('all_levels' == $key) {
                                continue;
                            }
                        ?>
                            <li>
                                <div class="form-check">
                                    <input class="form-check-input" id="<?php echo esc_html($value); ?>" type="checkbox" name="tutor-course-filter-level" value="<?php echo esc_html($value); ?>">
                                    <label class="form-check-label" for="<?php echo esc_html($value); ?>"><?php echo esc_html($course_title); ?></label>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <!-- End Widget Area  -->
        <div class="tutor-widget tutor-widget-course-filter text-center">
            <div class="tutor-widget-content">
                <a href="#" class="btn btn-border" onclick="window.location.replace('<?php echo esc_url($reset_link); ?>')" action-tutor-clear-filter>
                    <i class="tutor-icon-times tutor-mr-8"></i> <?php esc_html_e('Clear All Filters', 'eduvalt'); ?>
                </a>
            </div>
        </div>
    </aside>
    <?php do_action('tutor_course_filter/after'); ?>
</form>