<?php

/**
 * Template for course archive filter
 *
 * @package Tutor\Templates
 * @subpackage Course_Filter
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.4.3
 */

if (!tutor_utils()->get_option('course_archive_filter_sorting', true, true, true)) {
    return;
}

$sort_by = \TUTOR\Input::get('course_order', '');
?>

<!--
	Note: Do not remove tutor-course-filter attr. It required by _archive.js for filter function.
!-->
<div class="filter-select tutor-course-filter" tutor-course-filter>
    <form>
        <select class="tutor-form-select" name="course_order">
            <option value="newest_first" <?php selected('newest_first', $sort_by); ?>>
                <?php esc_html_e('Newest', 'eduvalt'); ?>
            </option>
            <option value="oldest_first" <?php selected('oldest_first', $sort_by); ?>>
                <?php esc_html_e('Oldest', 'eduvalt'); ?>
            </option>
            <option value="price_asc" <?php selected('price_asc', $sort_by); ?>>
                <?php esc_html_e('Price High To Low', 'eduvalt'); ?>
            </option>
            <option value="price_desc" <?php selected('price_desc', $sort_by); ?>>
                <?php esc_html_e('Price Low To High', 'eduvalt'); ?>
            </option>
            <option value="course_title_az" <?php selected('course_title_az', $sort_by); ?>>
                <?php esc_html_e('Course Title (a-z)', 'eduvalt'); ?>
            </option>
            <option value="course_title_za" <?php selected('course_title_za', $sort_by); ?>>
                <?php esc_html_e('Course Title (z-a)', 'eduvalt'); ?>
            </option>
        </select>
    </form>
</div>