<?php

/**
 * Template for course archive init
 *
 * @package Tutor\Templates
 * @subpackage CourseArchive
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

use TUTOR\Input;

!isset($course_filter) ? $course_filter         = false : 0;
!isset($supported_filters) ? $supported_filters = tutor_utils()->get_option('supported_course_filters', array()) : 0;
!isset($loop_content_only) ? $loop_content_only = false : 0;
!isset($column_per_row) ? $column_per_row       = tutor_utils()->get_option('courses_col_per_row', 3) : 0;
!isset($course_per_page) ? $course_per_page     = tutor_utils()->get_option('courses_per_page', 12) : 0;
!isset($show_pagination) ? $show_pagination     = true : 0;
!isset($current_page) ? $current_page           = 1 : 0;

// Hide pagination is there is no page after first one.
$pages_count = 0;
if (isset($the_query)) {
    $pages_count = $the_query->max_num_pages;
} else {
    global $wp_query;
    $pages_count = $wp_query->max_num_pages;
}
$pages_count < 2 ? $show_pagination = false : 0;

// Set in global variable to avoid too many stack to pass to other templates.
$GLOBALS['tutor_course_archive_arg'] = compact(
    'course_filter',
    'supported_filters',
    'loop_content_only',
    'column_per_row',
    'course_per_page',
    'show_pagination'
);

// Render the loop.
ob_start();
do_action('tutor_course/archive/before_loop');

if ((isset($the_query) && $the_query->have_posts()) || have_posts()) {
    /* Start the Loop */

    tutor_course_loop_start();

    while (isset($the_query) ? $the_query->have_posts() : have_posts()) {
        isset($the_query) ? $the_query->the_post() : the_post();

        /**
         * Usage Idea, you may keep a loop within a wrap, such as bootstrap col
         *
         * @hook tutor_course/archive/before_loop_course
         * @type action
         */
        do_action('tutor_course/archive/before_loop_course');

        tutor_load_template('loop.course');

        /**
         * Usage Idea, If you start any div before course loop, you can end it here, such as </div>
         *
         * @hook tutor_course/archive/after_loop_course
         * @type action
         */
        do_action('tutor_course/archive/after_loop_course');
    }

    tutor_course_loop_end();
} else {

    /**
     * No course found
     */
    tutor_utils()->tutor_empty_state(tutor_utils()->not_found_text());
}

do_action('tutor_course/archive/after_loop');

$course_loop = ob_get_clean();

if (isset($loop_content_only) && true == $loop_content_only) {
    echo wp_kses_post($course_loop); //phpcs:ignore --$course_loop contain sanitized data
    return;
}

$course_archive_arg = isset($GLOBALS['tutor_course_archive_arg']) ? $GLOBALS['tutor_course_archive_arg']['column_per_row'] : null;
$columns            = null === $course_archive_arg ? tutor_utils()->get_option('courses_col_per_row', 3) : $course_archive_arg;
$has_course_filters = $course_filter && count($supported_filters);

$supported_filters_keys = array_keys($supported_filters);
$courses_count = 0;
if (isset($the_query)) {
    $courses_count = $the_query->post_count;
} else {
    global $wp_query;
    $courses_count = $wp_query->post_count;
}
?>



<!-- all-courses -->
<section class="all-courses-area section-py-120" data-tutor_courses_meta="<?php echo esc_attr(json_encode($GLOBALS['tutor_course_archive_arg'])); ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-3 col-lg-4 order-2 order-lg-0">
                <div class="tutor-course-filter-container">
                    <div class="tutor-course-filter" tutor-course-filter>
                        <?php tutor_load_template('course-filter.filters'); ?>
                    </div>
                </div>
            </div>
            <div class="col-xl-9 col-lg-8">
                <div class="shop-top-wrap courses-top-wrap">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="shop-top-left">
                                <p>
                                    <?php
                                    // phpcs:disable WordPress.Security
                                    if (1 === intval($courses_count)) {
                                        _e('Showing the single result', 'eduvalt');
                                    } elseif ($courses_count <= $course_per_page || -1 === $course_per_page) {
                                        /* translators: %d: cour$courses_count results */
                                        // printf(_n('Showing all %d result', 'Showing all %d results', $courses_count, 'eduvalt'), $courses_count);

                                        printf(__('Showing all %d results', 'eduvalt'), $courses_count);
                                    } else {
                                        $first = ($course_per_page * $current_page) - $course_per_page + 1;
                                        $last  = min($courses_count, $course_per_page * $current_page);
                                        /* translators: 1: first result 2: last result 3: cour$courses_count results */
                                        printf(_nx('Showing %1$d&ndash;%2$d of %3$d result', 'Showing %1$d&ndash;%2$d of %3$d results', $courses_count, 'with first and last result', 'eduvalt'), $first, $last, $courses_count);
                                    }
                                    // phpcs:enable WordPress.Security
                                    ?>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex justify-content-center justify-content-md-end align-items-center">
                                <div class="shop-top-right m-0 ms-md-auto">
                                    <?php tutor_load_template('course-filter.course-archive-filter-bar'); ?>
                                </div>
                                <ul class="nav nav-tabs courses__nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="grid-tab" data-bs-toggle="tab" data-bs-target="#grid" type="button" role="tab" aria-controls="grid" aria-selected="true">
                                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M6 1H2C1.44772 1 1 1.44772 1 2V6C1 6.55228 1.44772 7 2 7H6C6.55228 7 7 6.55228 7 6V2C7 1.44772 6.55228 1 6 1Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M16 1H12C11.4477 1 11 1.44772 11 2V6C11 6.55228 11.4477 7 12 7H16C16.5523 7 17 6.55228 17 6V2C17 1.44772 16.5523 1 16 1Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M6 11H2C1.44772 11 1 11.4477 1 12V16C1 16.5523 1.44772 17 2 17H6C6.55228 17 7 16.5523 7 16V12C7 11.4477 6.55228 11 6 11Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M16 11H12C11.4477 11 11 11.4477 11 12V16C11 16.5523 11.4477 17 12 17H16C16.5523 17 17 16.5523 17 16V12C17 11.4477 16.5523 11 16 11Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="list-tab" data-bs-toggle="tab" data-bs-target="#list" type="button" role="tab" aria-controls="list" aria-selected="false">
                                            <svg width="19" height="15" viewBox="0 0 19 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M1.5 6C0.67 6 0 6.67 0 7.5C0 8.33 0.67 9 1.5 9C2.33 9 3 8.33 3 7.5C3 6.67 2.33 6 1.5 6ZM1.5 0C0.67 0 0 0.67 0 1.5C0 2.33 0.67 3 1.5 3C2.33 3 3 2.33 3 1.5C3 0.67 2.33 0 1.5 0ZM1.5 12C0.67 12 0 12.68 0 13.5C0 14.32 0.68 15 1.5 15C2.32 15 3 14.32 3 13.5C3 12.68 2.33 12 1.5 12ZM5.5 14.5H17.5C18.05 14.5 18.5 14.05 18.5 13.5C18.5 12.95 18.05 12.5 17.5 12.5H5.5C4.95 12.5 4.5 12.95 4.5 13.5C4.5 14.05 4.95 14.5 5.5 14.5ZM5.5 8.5H17.5C18.05 8.5 18.5 8.05 18.5 7.5C18.5 6.95 18.05 6.5 17.5 6.5H5.5C4.95 6.5 4.5 6.95 4.5 7.5C4.5 8.05 4.95 8.5 5.5 8.5ZM4.5 1.5C4.5 2.05 4.95 2.5 5.5 2.5H17.5C18.05 2.5 18.5 2.05 18.5 1.5C18.5 0.95 18.05 0.5 17.5 0.5H5.5C4.95 0.5 4.5 0.95 4.5 1.5Z" fill="currentColor" />
                                            </svg>
                                        </button>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if ($has_course_filters && in_array('search', $supported_filters_keys)) : ?>
                    <div class="tutor-d-block tutor-d-lg-none tutor-mb-32">
                        <div class="tutor-d-flex tutor-align-center tutor-justify-between">
                            <span class="tutor-fw-medium"><?php esc_html_e('Courses', 'eduvalt'); ?></span>
                            <a href="#" class="tutor-iconic-btn tutor-iconic-btn-secondary tutor-iconic-btn-md" tutor-toggle-course-filter><span class="tutor-icon-slider-vertical"></span></a>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="tab-content eduvalt-courses-wrapper" id="myTabContent">
                    <div class="tab-pane fade show active" id="grid" role="tabpanel" aria-labelledby="grid-tab">
                        <div class="row courses__grid-wrap row-cols-1 row-cols-xl-3 row-cols-lg-2 row-cols-md-2 row-cols-sm-1" tutor-course-list-container>

                            <?php echo wp_kses_post($course_loop); //phpcs:ignore --$course_loop contain sanitized data
                            ?>

                        </div>
                        <?php
                        // Load the pagination now.
                        global $wp_query;

                        $current_url = wp_doing_ajax() ? sanitize_text_field(wp_unslash($_SERVER['HTTP_REFERER'] ?? '')) : tutor()->current_url;
                        //phpcs:disable WordPress.Security.NonceVerification.Missing
                        $push_link = add_query_arg(array_merge($_POST, $GLOBALS['tutor_course_archive_arg']), $current_url);

                        $data            = wp_doing_ajax() ? Input::sanitize_array($_POST) : Input::sanitize_array($_GET);
                        $pagination_data = array(
                            'total_page' => isset($the_query) ? $the_query->max_num_pages : $wp_query->max_num_pages,
                            'per_page'   => $course_per_page,
                            'paged'      => $current_page,
                            'data_set'   => array('push_state_link' => $push_link),
                            'ajax'       => array_merge(
                                $data,
                                array(
                                    'loading_container' => '.tutor-course-filter-loop-container',
                                    'action'            => 'tutor_course_filter_ajax',
                                )
                            ),
                        );

                        tutor_load_template_from_custom_path(
                            get_parent_theme_file_path() . '/tutor/dashboard/elements/pagination.php',
                            $pagination_data
                        );
                        ?>
                    </div>
                    <div class="tab-pane fade" id="list" role="tabpanel" aria-labelledby="list-tab">
                        <div class="row courses__list-wrap row-cols-1" tutor-course-list-container>

                            <?php echo wp_kses_post($course_loop); //phpcs:ignore --$course_loop contain sanitized data
                            ?>

                        </div>
                        <?php
                        // Load the pagination now.
                        global $wp_query;

                        $current_url = wp_doing_ajax() ? sanitize_text_field(wp_unslash($_SERVER['HTTP_REFERER'] ?? '')) : tutor()->current_url;
                        //phpcs:disable WordPress.Security.NonceVerification.Missing
                        $push_link = add_query_arg(array_merge($_POST, $GLOBALS['tutor_course_archive_arg']), $current_url);

                        $data            = wp_doing_ajax() ? Input::sanitize_array($_POST) : Input::sanitize_array($_GET);
                        $pagination_data = array(
                            'total_page' => isset($the_query) ? $the_query->max_num_pages : $wp_query->max_num_pages,
                            'per_page'   => $course_per_page,
                            'paged'      => $current_page,
                            'data_set'   => array('push_state_link' => $push_link),
                            'ajax'       => array_merge(
                                $data,
                                array(
                                    'loading_container' => '.tutor-course-filter-loop-container',
                                    'action'            => 'tutor_course_filter_ajax',
                                )
                            ),
                        );

                        tutor_load_template_from_custom_path(
                            get_parent_theme_file_path() . '/tutor/dashboard/elements/pagination.php',
                            $pagination_data
                        );
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- all-courses-end -->
<?php
if (!is_user_logged_in()) {
    tutor_load_template_from_custom_path(tutor()->path . '/views/modal/login.php');
}
?>