<?php

/**
 * Template part for displaying header layout two
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package eduvalt
 */

// Header Settings
$eduvalt_show_sticky_header = get_theme_mod('eduvalt_show_sticky_header', false);
$sticky_header = $eduvalt_show_sticky_header ? 'sticky-header' : 'sticky-default';

// Header Search
$eduvalt_show_header_search = get_theme_mod('eduvalt_show_header_search', false);

// Header Right
$eduvalt_show_header_right = get_theme_mod('eduvalt_show_header_right', false);

// Header Button
$eduvalt_show_header_button = get_theme_mod('eduvalt_show_header_button', false);
$eduvalt_header_btn_text = get_theme_mod('eduvalt_header_btn_text', __('Log in', 'eduvalt'));
$eduvalt_header_btn_url = get_theme_mod('eduvalt_header_btn_url', __('#', 'eduvalt'));

$eduvalt_show_header_button2 = get_theme_mod('eduvalt_show_header_button2', false);
$eduvalt_header_btn_text2 = get_theme_mod('eduvalt_header_btn_text2', __('Try For Free', 'eduvalt'));
$eduvalt_header_btn_url2 = get_theme_mod('eduvalt_header_btn_url2', __('#', 'eduvalt'));

// Mobile Menu
$eduvalt_show_mobile_search = get_theme_mod('eduvalt_show_mobile_search', false);
$eduvalt_show_mobile_btn = get_theme_mod('eduvalt_show_mobile_btn', false);
$mobile_btn_text01 = get_theme_mod('mobile_btn_text01', __('Log in', 'eduvalt'));
$mobile_btn_url01 = get_theme_mod('mobile_btn_url01', __('#', 'eduvalt'));
$mobile_btn_text02 = get_theme_mod('mobile_btn_text02', __('Try For Free', 'eduvalt'));
$mobile_btn_url02 = get_theme_mod('mobile_btn_url02', __('#', 'eduvalt'));

$eduvalt_show_mobile_social = get_theme_mod('eduvalt_show_mobile_social', false);

$is_show_breadcrumb = function_exists('get_field') ? get_field('is_it_invisible_breadcrumb') : '';

$change_class = $is_show_breadcrumb ? "transparent-header" : "header-normal";

?>


<!-- header-area -->
<header>
    <div id="<?php echo esc_attr($sticky_header); ?>" class="tg-header__area <?php echo esc_attr($change_class); ?>">
        <div class="container custom-container">
            <div class="row">
                <div class="col-12">
                    <?php if (has_nav_menu('main-menu')) { ?>
                        <div class="mobile-nav-toggler"><i class="tg-flaticon-menu-1"></i></div>
                    <?php } ?>
                    <div class="tgmenu__wrap">
                        <nav class="tgmenu__nav">
                            <div class="logo">
                                <?php eduvalt_header_logo(); ?>
                            </div>
                            <div class="tgmenu__navbar-wrap tgmenu__main-menu d-none d-xl-flex">
                                <?php eduvalt_header_menu(); ?>
                            </div>

                            <?php if (!empty($eduvalt_show_header_search)) : ?>
                                <div class="tgmenu__search d-none d-md-block">
                                    <form action="<?php echo home_url('/'); ?>" method="get" class="tgmenu__search-form">
                                        <?php if (function_exists('tutor')) { ?>
                                            <div class="select-grp">
                                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M12 12H6.85714V6.85714H12V12ZM5.14286 12H0V6.85714H5.14286V12ZM12 5.14286H6.85714V0H12V5.14286ZM5.14286 5.14286H0V0H5.14286V5.14286Z" fill="currentcolor" />
                                                </svg>
                                                <?php eduvalt_course_select(); ?>
                                            </div>
                                        <?php } ?>

                                        <div class="input-grp">
                                            <input type="text" name="s" id="s"  value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php esc_attr__('Search For Course . . .', 'eduvalt'); ?>">
                                            <button type="submit"><i class="flaticon-searching"></i></button>
                                        </div>
                                    </form>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($eduvalt_show_header_right)) : ?>
                                <div class="tgmenu__action">
                                    <ul class="list-wrap">
                                        <?php if (class_exists('WooCommerce')) : ?>
                                            <li class="mini-cart-icon">
                                                <a href="<?php echo wc_get_cart_url(); ?>" class="cart-count">
                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M18 6C18 4.4087 17.3679 2.88258 16.2426 1.75736C15.1174 0.632141 13.5913 0 12 0C10.4087 0 8.88258 0.632141 7.75736 1.75736C6.63214 2.88258 6 4.4087 6 6H0V21C0 21.7956 0.31607 22.5587 0.87868 23.1213C1.44129 23.6839 2.20435 24 3 24H21C21.7956 24 22.5587 23.6839 23.1213 23.1213C23.6839 22.5587 24 21.7956 24 21V6H18ZM12 2C13.0609 2 14.0783 2.42143 14.8284 3.17157C15.5786 3.92172 16 4.93913 16 6H8C8 4.93913 8.42143 3.92172 9.17157 3.17157C9.92172 2.42143 10.9391 2 12 2ZM22 21C22 21.2652 21.8946 21.5196 21.7071 21.7071C21.5196 21.8946 21.2652 22 21 22H3C2.73478 22 2.48043 21.8946 2.29289 21.7071C2.10536 21.5196 2 21.2652 2 21V8H6V10H8V8H16V10H18V8H22V21Z" fill="#5A7093" />
                                                    </svg>
                                                    <span id="tg-cart-item" class="mini-cart-count"><?php echo esc_html(WC()->cart->cart_contents_count); ?></span>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if (!is_user_logged_in()) : ?>
                                            <?php if (!empty($eduvalt_show_header_button)) : ?>
                                                <li class="header-btn login-btn">
                                                    <a href="<?php echo esc_url($eduvalt_header_btn_url); ?>" class="btn"><?php echo esc_html($eduvalt_header_btn_text); ?></a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if (!empty($eduvalt_show_header_button2)) : ?>
                                                <li class="header-btn free-btn">
                                                    <a href="<?php echo esc_url($eduvalt_header_btn_url2); ?>" class="btn"><?php echo esc_html($eduvalt_header_btn_text2); ?></a>
                                                </li>
                                            <?php endif; ?>

                                        <?php else : ?>
                                            <?php if (!empty($eduvalt_show_header_button)) : ?>
                                                <li class="header-btn login-btn">
                                                    <a href="<?php echo esc_url($eduvalt_header_btn_url); ?>" class="btn"><?php echo __('Profile', 'eduvalt'); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if (!empty($eduvalt_show_header_button2)) : ?>
                                                <li class="header-btn free-btn">
                                                    <a href="<?php echo esc_url(wp_logout_url(apply_filters('eduvalt_default_logout_redirect', (!empty($_SERVER['HTTPS']) ? "https" : "http") . '://' . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]))); ?>" class="btn"><?php echo __('Logout', 'eduvalt'); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                    </ul>
                                </div>
                            <?php endif; ?>
                        </nav>
                    </div>
                    <!-- Mobile Menu  -->
                    <div class="tgmobile__menu">
                        <nav class="tgmobile__menu-box">
                            <div class="close-btn"><i class="tg-flaticon-close-1"></i></div>
                            <div class="nav-logo">
                                <?php eduvalt_mobile_logo(); ?>
                            </div>

                            <?php if (!empty($eduvalt_show_mobile_search)) : ?>
                                <div class="tgmobile__search">
                                    <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                                        <input type="text" name="s" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php print esc_attr__('Search here...', 'eduvalt'); ?>">
                                        <button type="submit"><i class="fas fa-search"></i></button>
                                    </form>
                                </div>
                            <?php endif; ?>

                            <div class="tgmobile__menu-outer">
                                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                            </div>
                            <?php if (!empty($eduvalt_show_mobile_btn)) : ?>
                                <div class="tgmenu__action">
                                    <ul class="list-wrap">

                                        <?php if (!is_user_logged_in()) : ?>
                                            <?php if (!empty($eduvalt_show_header_button)) : ?>
                                                <li class="header-btn login-btn">
                                                    <a href="<?php echo esc_url($eduvalt_header_btn_url); ?>" class="btn"><?php echo esc_html($eduvalt_header_btn_text); ?></a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if (!empty($eduvalt_show_header_button2)) : ?>
                                                <li class="header-btn">
                                                    <a href="<?php echo esc_url($eduvalt_header_btn_url2); ?>" class="btn"><?php echo esc_html($eduvalt_header_btn_text2); ?></a>
                                                </li>
                                            <?php endif; ?>

                                        <?php else : ?>
                                            <?php if (!empty($eduvalt_show_header_button)) : ?>
                                                <li class="header-btn login-btn">
                                                    <a href="<?php echo esc_url($eduvalt_header_btn_url); ?>" class="btn"><?php echo __('Profile', 'eduvalt'); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if (!empty($eduvalt_show_header_button2)) : ?>
                                                <li class="header-btn">
                                                    <a href="<?php echo esc_url(wp_logout_url(apply_filters('eduvalt_default_logout_redirect', (!empty($_SERVER['HTTPS']) ? "https" : "http") . '://' . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]))); ?>" class="btn"><?php echo __('Logout', 'eduvalt'); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($eduvalt_show_mobile_social)) : ?>
                                <div class="social-links">
                                    <?php eduvalt_mobile_social_profiles(); ?>
                                </div>
                            <?php endif; ?>

                        </nav>
                    </div>
                    <div class="tgmobile__menu-backdrop"></div>
                    <!-- End Mobile Menu -->
                </div>
            </div>
        </div>
    </div>
</header>
<!-- header-area-end -->