<?php

/**
 * Template part for displaying footer layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package eduvalt
 */


// Bg color
$footer_bg_color = get_theme_mod('eduvalt_footer_bg_color');
$copyright_bg_color = get_theme_mod('eduvalt_copyright_bg_color');

// Payment Card
$footer_payment_method_img = get_theme_mod('footer_payment_method_img');
$eduvalt_copyright_center = $footer_payment_method_img ? 'col-md-6 text-end' : 'col-lg-12 text-center';


// BG Color
$bg_color = !empty($eduvalt_footer_bg_color) ? $eduvalt_footer_bg_color : $footer_bg_color;


// Copyright menu
$show_copyright_menu = get_theme_mod('show_copyright_menu', false);
$defaults_menu = [
    [
        'link_text' => esc_html__('Privacy Policy', 'eduvalt'),
        'link_url'  => '#',
    ],
    [
        'link_text' => esc_html__('Terms & Conditions', 'eduvalt'),
        'link_url'  => '#',
    ],
];
$copyright_menu_repeater = get_theme_mod('copyright_menu_repeater', $defaults_menu);
$eduvalt_copyright_center = $show_copyright_menu ? 'col-lg-7' : 'col-12 text-center';


// Footer Columns
$footer_columns = 0;
$footer_widgets = get_theme_mod('footer_widget_number', 4);

for ($num = 1; $num <= $footer_widgets; $num++) {
    if (is_active_sidebar('footer-' . $num)) {
        $footer_columns++;
    }
}

switch ($footer_columns) {
    case '1':
        $footer_class[1] = 'col-lg-12';
        break;
    case '2':
        $footer_class[1] = 'col-sm-6';
        $footer_class[2] = 'col-sm-6';
        break;
    case '3':
        $footer_class[1] = 'col-lg-4 col-sm-6';
        $footer_class[2] = 'col-lg-4 col-sm-6';
        $footer_class[3] = 'col-lg-4 col-sm-6';
        break;
    case '4':
        $footer_class[1] = 'col-xl-3 col-lg-4 col-sm-6';
        $footer_class[2] = 'col-xl-3 col-lg-4 col-sm-6';
        $footer_class[3] = 'col-xl-3 col-lg-4 col-sm-6';
        $footer_class[4] = 'col-xl-3 col-lg-4 col-sm-6';
        break;
    default:
        $footer_class = 'col-xl-3 col-lg-4 col-sm-6';
        break;
}

?>


<!-- footer-area -->
<footer class="footer-bg" data-bg-color="<?php print esc_attr($bg_color); ?>">
    <?php if (is_active_sidebar('footer-1') or is_active_sidebar('footer-2') or is_active_sidebar('footer-3') or is_active_sidebar('footer-4')) : ?>
        <div class="footer__top-wrap">
            <div class="container">
                <div class="row">
                    <?php
                    if ($footer_columns < 4) {
                        print '<div class="col-xl-3 col-lg-4 col-sm-6">';
                        dynamic_sidebar('footer-1');
                        print '</div>';

                        print '<div class="col-xl-3 col-lg-4 col-sm-6">';
                        dynamic_sidebar('footer-2');
                        print '</div>';

                        print '<div class="col-xl-3 col-lg-4 col-sm-6">';
                        dynamic_sidebar('footer-3');
                        print '</div>';

                        print '<div class="col-xl-3 col-lg-4 col-sm-6">';
                        dynamic_sidebar('footer-4');
                        print '</div>';
                    } else {
                        for ($num = 1; $num <= $footer_columns; $num++) {
                            if (!is_active_sidebar('footer-' . $num)) {
                                continue;
                            }
                            print '<div class="' . esc_attr($footer_class[$num]) . '">';
                            dynamic_sidebar('footer-' . $num);
                            print '</div>';
                        }
                    }
                    ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="copyright__wrapper" data-bg-color="<?php print esc_attr($copyright_bg_color); ?>">
        <div class="container">
            <div class="row">
                <div class="<?php echo esc_attr($eduvalt_copyright_center); ?>">
                    <div class="copyright__text">
                        <p><?php print eduvalt_copyright_text(); ?></p>
                    </div>
                </div>

                <?php if (!empty($show_copyright_menu)) : ?>
                    <div class="col-lg-5">
                        <div class="copyright__menu">
                            <ul class="list-wrap d-flex flex-wrap justify-content-center justify-content-lg-end">
                                <?php foreach ($copyright_menu_repeater as $item) : ?>
                                    <li><a href="<?php echo esc_url($item['link_url']); ?>"><?php echo esc_html($item['link_text']); ?></a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</footer>
<!-- footer-area-end -->