<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package eduvalt
 */

$eduvalt_show_blog_share = get_theme_mod('eduvalt_show_blog_share', false);
$eduvalt_post_tags_width = $eduvalt_show_blog_share ? 'col-md-7' : 'col-12';

?>
<?php if (is_single()) : ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('blog__standard-post blog__details-wrapper format-image'); ?>>

        <?php if (has_post_thumbnail()) : ?>
            <div class="blog__standard-thumb">
                <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
            </div>
        <?php endif; ?>

        <div class="blog__standard-content blog-details-content">

            <!-- blog meta -->
            <?php get_template_part('template-parts/blog/blog-meta'); ?>

            <div class="post-text">
                <?php the_content(); ?>
                <?php
                wp_link_pages([
                    'before'      => '<div class="page-links">' . esc_html__('Pages:', 'eduvalt'),
                    'after'       => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after'  => '</span>',
                ]);
                ?>
            </div>

            <?php if (!empty(get_the_tags())) : ?>
                <div class="blog-details-bottom">

                    <div class="row">
                        <div class="<?php echo esc_attr($eduvalt_post_tags_width); ?>">
                            <?php print eduvalt_get_tag(); ?>
                        </div>
                        <?php if (!empty($eduvalt_show_blog_share)) : ?>
                            <div class="col-md-5">
                                <div class="tg-post-social justify-content-start justify-content-md-end">
                                    <h5 class="social-title"><?php echo esc_html__('Social Share :', 'eduvalt') ?></h5>
                                    <?php eduvalt_social_share(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            <?php endif; ?>

        </div>
    </article>

<?php else : ?>


    <article id="post-<?php the_ID(); ?>" <?php post_class('blog__standard-post format-image'); ?>>

        <?php if (has_post_thumbnail()) : ?>
            <div class="blog__standard-thumb">
                <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                </a>
            </div>
        <?php endif; ?>

        <div class="blog__standard-content">

            <?php $categories = get_the_category();
            if (!empty($categories)) {
                echo '<a href="' . esc_url(get_category_link($categories[0]->term_id)) . '" class="cat">' . esc_html($categories[0]->name) . '</a>';
            } ?>

            <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

            <!-- blog meta -->
            <?php get_template_part('template-parts/blog/blog-meta'); ?>

            <div class="post-text">
                <?php the_excerpt(); ?>
            </div>

            <!-- blog btn -->
            <?php get_template_part('template-parts/blog/blog-btn'); ?>

        </div>

    </article>

<?php endif; ?>