<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package eduvalt
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function eduvalt_body_classes( $classes ) {
    // Adds a class of hfeed to non-singular pages.
    if ( !is_singular() ) {
        $classes[] = 'hfeed';
    }
    // Adds a class of no-sidebar when there is no sidebar present.
    if ( !is_active_sidebar( 'sidebar-1' ) ) {
        $classes[] = 'no-sidebar';
    }
    if (  function_exists('tutor') ) {
        $user_name = sanitize_text_field(get_query_var('tutor_student_username'));
        $get_user = tutor_utils()->get_user_by_login($user_name);
    }

    if ( !empty($get_user) ) {
        $classes[] = 'profile-breadcrumb';
    }

    return $classes;
}
add_filter( 'body_class', 'eduvalt_body_classes' );

/**
 * Get tags.
 */
function eduvalt_get_tag() {
    $html = '';
    if ( has_tag() ) {
        $html .= '<div class="tg-post-tag"><h5 class="tag-title">' . esc_html__( 'Tags :', 'eduvalt' ) . '</h5>';
        $html .= get_the_tag_list( '<ul class="list-wrap p-0 mb-0"><li>', '</li><li>', '</li></ul>' );
        $html .= '</div>';
    }
    return $html;
}

/**
 * Get Social.
 */
function eduvalt_social_share() {?>
    <ul class="list-wrap p-0 mb-0">
        <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink() ?>"><i class="fab fa-facebook-f"></i></a></li>
        <li><a href="https://twitter.com/home?status=<?php the_permalink() ?>"><i class="fab fa-twitter"></i></a></li>
        <li><a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink() ?>"><i class="fab fa-linkedin-in"></i></a></li>
        <li><a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink() ?>"><i class="fab fa-pinterest-p"></i></a></li>
    </ul>
<?php
}

/**
 * Get categories.
 */
function eduvalt_get_category() {

    $categories = get_the_category( get_the_ID() );
    $x = 0;
    foreach ( $categories as $category ) {

        if ( $x == 2 ) {
            break;
        }
        $x++;
        print '<a class="news-tag" href="' . get_category_link( $category->term_id ) . '">' . $category->cat_name . '</a>';

    }
}

/** img alt-text **/
function eduvalt_img_alt_text( $img_er_id = null ) {
    $image_id = $img_er_id;
    $image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', false );
    $image_title = get_the_title( $image_id );

    if ( !empty( $image_id ) ) {
        if ( $image_alt ) {
            $alt_text = get_post_meta( $image_id, '_wp_attachment_image_alt', false );
        } else {
            $alt_text = get_the_title( $image_id );
        }
    } else {
        $alt_text = esc_html__( 'Image Alt Text', 'eduvalt' );
    }

    return $alt_text;
}

// eduvalt_offer_sidebar_func
function eduvalt_offer_sidebar_func() {
    if ( is_active_sidebar( 'offer-sidebar' ) ) {

        dynamic_sidebar( 'offer-sidebar' );
    }
}
add_action( 'eduvalt_offer_sidebar', 'eduvalt_offer_sidebar_func', 20 );

// eduvalt_service_sidebar
function eduvalt_service_sidebar_func() {
    if ( is_active_sidebar( 'services-sidebar' ) ) {

        dynamic_sidebar( 'services-sidebar' );
    }
}
add_action( 'eduvalt_service_sidebar', 'eduvalt_service_sidebar_func', 20 );

// eduvalt_portfolio_sidebar
function eduvalt_portfolio_sidebar_func() {
    if ( is_active_sidebar( 'portfolio-sidebar' ) ) {

        dynamic_sidebar( 'portfolio-sidebar' );
    }
}
add_action( 'eduvalt_portfolio_sidebar', 'eduvalt_portfolio_sidebar_func', 20 );

// eduvalt_faq_sidebar
function eduvalt_faq_sidebar_func() {
    if ( is_active_sidebar( 'faq-sidebar' ) ) {

        dynamic_sidebar( 'faq-sidebar' );
    }
}
add_action( 'eduvalt_faq_sidebar', 'eduvalt_faq_sidebar_func', 20 );


if ( class_exists( 'LearnPress' ) ) {

    /**
     * Enable override template
     */
    add_filter( 'learn-press/override-templates', '__return_true' );

    /**
     * Add removed action
     */
    // remove_action( 'learn-press/before-courses-loop', LP()->template( 'course' )->func( 'courses_top_bar' ), 10 );
    // remove_action( 'learn-press/course-summary-sidebar', LP()->template( 'course' )->func( 'course_featured_review' ), 20 );

    remove_action( 'learn_press_before_main_content', 'learn_press_breadcrumb' );

    // Remove LearnPress breadcrumb action
    function remove_learnpress_breadcrumb() {
        LP()->template( 'general' )->remove( 'learn-press/before-main-content', 'breadcrumb' );
    }
    add_action( 'wp', 'remove_learnpress_breadcrumb' );


    function eduvalt_learnpress_course_meata(){  ?>
        <ul class="list-wraper">
            <li><i class="flaticon-timer"></i><?php echo esc_html( 'Duration', 'eduvalt' ); ?> 
                <span>
                    <?php echo learn_press_get_post_translated_duration( get_the_ID(), esc_html__( 'Lifetime', 'eduvalt' ) ); ?>
                    </span>
                </li>
            <li><i class="flaticon-file"></i><?php echo esc_html( 'Estimated Seat', 'eduvalt' ); ?> 
                <span>
                <?php
                    $max_students = get_post_meta( get_the_ID(), '_lp_max_students', true );
                    // Check if the max students value is found and not empty
                    if ($max_students !== '') {
                        // Return the value as an integer if it's not "Unlimited"
                        if ($max_students !== '0') {
                            echo intval($max_students);
                        } else {
                            // Return "Unlimited" if the value is "unlimited" (case insensitive)
                            echo 'Unlimited';
                        }
                    }
                ?>
                </span>
            </li>
            <?php $level = learn_press_get_post_level( get_the_ID() ); ?>
            <li><i class="flaticon-bars"></i><?php echo esc_html( 'Level', 'eduvalt' ); ?> 
                <span>
                    <?php echo esc_html( $level ); ?>
                </span>
            </li>
            <li><i class="flaticon-user-1"></i><?php echo esc_html( 'Enrolled', 'eduvalt' ); ?>
                <span>
                    <?php
                        $students = (int)learn_press_get_course()->count_students();
                        $students_text = ('1' == $students) ? esc_html__(' Student', 'eduvalt') : esc_html__(' Students', 'eduvalt');
                        echo esc_attr( $students );
                     ?>
                </span>
            </li>
            <li><i class="flaticon-flash"></i><?php echo esc_html( 'Category', 'eduvalt' ); ?>
                <span>
                <?php
                    if ( ! get_the_terms( get_the_ID(), 'course_category' ) ) {
                        esc_html_e( 'Uncategorized', 'eduvalt' );
                    } else {
                        echo get_the_term_list( get_the_ID(), 'course_category', '', '<span>|</span>' );
                    }
                ?>
                </span>
            </li>
        </ul>
        <?php
    }
    add_action('learn-press/after-course-summary-sidebar', 'eduvalt_learnpress_course_meata', 1);
}