<?php
/**
 * eduvalt customizer
 *
 * @package eduvalt
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function eduvalt_customizer_panels_sections( $wp_customize ) {

    //Add panel
    $wp_customize->add_panel( 'eduvalt_customizer', [
        'priority' => 10,
        'title'    => esc_html__( 'Eduvalt Customizer', 'eduvalt' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'eduvalt_default_setting', [
        'title'       => esc_html__( 'Eduvalt Default Setting', 'eduvalt' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section('section_header_logo', [
        'title'       => esc_html__('Header Setting', 'eduvalt'),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ]);

    $wp_customize->add_section( 'header_topbar_setting', [
        'title'       => esc_html__( 'Header Topbar Setting', 'eduvalt' ),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( 'header_info_setting', [
        'title'       => esc_html__( 'Header Info Setting', 'eduvalt' ),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( 'mobile_menu_setting', [
        'title'       => esc_html__( 'Mobile Menu Setting', 'eduvalt' ),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( 'breadcrumb_setting', [
        'title'       => esc_html__( 'Breadcrumb Setting', 'eduvalt' ),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'eduvalt' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( 'footer_setting', [
        'title'       => esc_html__( 'Footer Settings', 'eduvalt' ),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( 'color_setting', [
        'title'       => esc_html__( 'Color Setting', 'eduvalt' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'eduvalt' ),
        'description' => '',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( 'typo_setting', [
        'title'       => esc_html__( 'Typography Setting', 'eduvalt' ),
        'description' => '',
        'priority'    => 20,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );

    $wp_customize->add_section( 'slug_setting', [
        'title'       => esc_html__( 'Slug Settings', 'eduvalt' ),
        'description' => '',
        'priority'    => 21,
        'capability'  => 'edit_theme_options',
        'panel'       => 'eduvalt_customizer',
    ] );
}

add_action( 'customize_register', 'eduvalt_customizer_panels_sections' );


/*
Theme Default Settings
*/
function _eduvalt_default_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_preloader',
        'label'    => esc_html__( 'Preloader ON/OFF', 'eduvalt' ),
        'section'  => 'eduvalt_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_backtotop',
        'label'    => esc_html__( 'Back to Top ON/OFF', 'eduvalt' ),
        'section'  => 'eduvalt_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_cursor_mode',
        'label'    => esc_html__( 'Cursor Effect ON/OFF', 'eduvalt' ),
        'section'  => 'eduvalt_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_eduvalt_default_fields' );


/*
Header Settings
 */
function _header_header_fields( $fields ) {

    // Sticky Header
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_sticky_header',
        'label'    => esc_html__( 'Show Sticky Header', 'eduvalt' ),
        'section'  => 'section_header_logo',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_header',
        'label'       => esc_html__( 'Select Header Style', 'eduvalt' ),
        'section'     => 'section_header_logo',
        'placeholder' => esc_html__( 'Select an option...', 'eduvalt' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'header-style-1' => get_template_directory_uri() . '/inc/img/header/header-1.png',
            'header-style-2' => get_template_directory_uri() . '/inc/img/header/header-2.png',
            'header-style-3' => get_template_directory_uri() . '/inc/img/header/header-3.png',
        ],
        'default'     => 'header-style-1',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__( 'Header Logo', 'eduvalt' ),
        'description' => esc_html__( 'Upload Your Logo', 'eduvalt' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'secondary_logo',
        'label'       => esc_html__( 'Header Secondary Logo', 'eduvalt' ),
        'description' => esc_html__( 'Upload Your Logo', 'eduvalt' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/secondary_logo.png',
    ];

    $fields[] = [
        'type'        => 'dimension',
        'settings'    => 'logo_size_adjust',
        'label'       => esc_html__( 'Logo Size', 'eduvalt' ),
        'description' => esc_html__( 'Adjust your logo size with px', 'eduvalt' ),
        'section'     => 'section_header_logo',
        'default'     => '150px',
        'choices'     => [
            'accept_unitless' => true,
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_header_fields' );

/*
Header TopBar Settings
*/
function _header_topbar_fields($fields)
{

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_header_top',
        'label'    => esc_html__('Show Header Top', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'eduvalt_header_location',
        'label'    => esc_html__('Enter Location Text', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('463 7th Ave, NY 10018, USA', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_mail',
        'label'    => esc_html__('Enter your Email', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('info@gmail.com', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_header_social',
        'label'    => esc_html__('Show Header Social', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_social_title',
        'label'    => esc_html__('Enter Social Title', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('Follow Us On :', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_fb_url',
        'label'    => esc_html__('Enter Facebook URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_insta_url',
        'label'    => esc_html__('Enter Instagram URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_twitter_url',
        'label'    => esc_html__('Enter Twitter URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_whatsapp_url',
        'label'    => esc_html__('Enter Whatsapp URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_whatsapp_url',
        'label'    => esc_html__('Enter Whatsapp URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_linkedin_url',
        'label'    => esc_html__('Enter Linkedin URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_youtube_url',
        'label'    => esc_html__('Enter Youtube URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_tiktok_url',
        'label'    => esc_html__('Enter TikTok URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_dribbb_url',
        'label'    => esc_html__('Enter Dribbble URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_behance_url',
        'label'    => esc_html__('Enter Behance URL', 'eduvalt'),
        'section'  => 'header_topbar_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'choose_default_header',
                'operator' => '===',
                'value'    => 'header-style-1',
            ],
        ],
        'default'  => esc_html__('', 'eduvalt'),
    ];

    return $fields;
}
add_filter('kirki/fields', '_header_topbar_fields');


/*
Header Info Settings
*/
function _header_right_fields($fields)
{

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_header_categories',
        'label'    => esc_html__('Show Header Categories', 'eduvalt'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'choose_default_header',
                'operator' => '!==',
                'value'    => 'header-style-2',
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_header_search',
        'label'    => esc_html__('Show Header Search', 'eduvalt'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_header_right',
        'label'    => esc_html__('Show Header Right', 'eduvalt'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_header_phone',
        'label'    => esc_html__('Show Header Phone', 'eduvalt'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_number',
        'label'    => esc_html__('Enter Phone Number', 'eduvalt'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_phone',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('993-00-67777', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_header_button',
        'label'    => esc_html__('Show Header Button', 'eduvalt'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_btn_text',
        'label'    => esc_html__('Enter Button Text', 'eduvalt'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('Sign Up', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_btn_url',
        'label'    => esc_html__('Enter Button URL', 'eduvalt'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_header_button2',
        'label'    => esc_html__('Show Header Button Two', 'eduvalt'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_btn_text2',
        'label'    => esc_html__('Enter Button Text', 'eduvalt'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_button2',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('Try For Free', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_header_btn_url2',
        'label'    => esc_html__('Enter Button URL', 'eduvalt'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_header_button2',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'eduvalt_show_header_right',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    return $fields;
}
add_filter('kirki/fields', '_header_right_fields');


/*
Mobile Menu Settings
*/
function _mobile_menu_fields($fields)
{

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'mobile_logo',
        'label'       => esc_html__('Mobile Menu Logo Dark', 'eduvalt'),
        'description' => esc_html__('Upload Your Logo.', 'eduvalt'),
        'section'     => 'mobile_menu_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_mobile_search',
        'label'    => esc_html__('Show Mobile Menu Search', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_mobile_btn',
        'label'    => esc_html__('Show Mobile Menu Buttons', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mobile_btn_text01',
        'label'    => esc_html__('Enter Button Text', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_btn',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('Log in', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mobile_btn_url01',
        'label'    => esc_html__('Enter Button URL', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_btn',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mobile_btn_text02',
        'label'    => esc_html__('Enter Button Text 02', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_btn',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('Try For Free', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'mobile_btn_url02',
        'label'    => esc_html__('Enter Button URL 02', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_btn',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'eduvalt'),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_mobile_social',
        'label'    => esc_html__('Show Mobile Menu Social', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 12,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
    ];

    // Mobile section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_mobile_fb_url',
        'label'    => esc_html__('Facebook URL', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__('#', 'eduvalt'),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_mobile_twitter_url',
        'label'    => esc_html__('Twitter URL', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__('#', 'eduvalt'),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_mobile_instagram_url',
        'label'    => esc_html__('Instagram URL', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__('#', 'eduvalt'),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_mobile_linkedin_url',
        'label'    => esc_html__('Linkedin URL', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__('#', 'eduvalt'),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_mobile_telegram_url',
        'label'    => esc_html__('Telegram URL', 'eduvalt'),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__('#', 'eduvalt'),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'eduvalt_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter('kirki/fields', '_mobile_menu_fields');


/*
_header_page_title_fields
 */
function _header_page_title_fields( $fields ) {

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_bg_img',
        'label'       => esc_html__('Breadcrumb Background Image', 'eduvalt'),
        'description' => esc_html__('Upload Image', 'eduvalt'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/bg/breadcrumb_bg.jpg',
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_hide_default',
        'label'    => esc_html__( 'Breadcrumb Hide by Default', 'eduvalt' ),
        'section'  => 'breadcrumb_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_info_switch',
        'label'    => esc_html__( 'Breadcrumb Nav Hide', 'eduvalt' ),
        'section'  => 'breadcrumb_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_page_title_fields' );

/*
Header Social
 */
function _header_blog_fields( $fields ) {
// Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_blog_btn_switch',
        'label'    => esc_html__( 'Blog Button ON/OFF', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_blog_cat',
        'label'    => esc_html__( 'Blog Category Meta ON/OFF', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_blog_author',
        'label'    => esc_html__( 'Blog Author Meta ON/OFF', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_blog_date',
        'label'    => esc_html__( 'Blog Date Meta ON/OFF', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_blog_comments',
        'label'    => esc_html__( 'Blog Comments Meta ON/OFF', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'eduvalt_show_blog_share',
        'label'    => esc_html__( 'Show Blog Share', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'eduvalt' ),
            'off' => esc_html__( 'Disable', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_blog_btn',
        'label'    => esc_html__( 'Blog Button text', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__('Continue Reading', 'eduvalt' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title',
        'label'    => esc_html__( 'Blog Title', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog', 'eduvalt' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title_details',
        'label'    => esc_html__( 'Blog Details Title', 'eduvalt' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog Details', 'eduvalt' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_blog_fields' );

/*
Footer
 */
function _header_footer_fields( $fields ) {
    // Footer Setting
    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__( 'Choose Footer Style', 'eduvalt' ),
        'section'     => 'footer_setting',
        'default'     => '5',
        'placeholder' => esc_html__( 'Select an option...', 'eduvalt' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1'   => get_template_directory_uri() . '/inc/img/footer/footer-1.png',
        ],
        'default'     => 'footer-style-1',
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'eduvalt_footer_bg_color',
        'label'       => __( 'Footer BG Color', 'eduvalt' ),
        'description' => esc_html__( 'This is a Footer bg color control.', 'eduvalt' ),
        'section'     => 'footer_setting',
        'default'     => '#061E43',
        'priority'    => 11,
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__( 'Widget Number', 'eduvalt' ),
        'section'     => 'footer_setting',
        'default'     => '4',
        'placeholder' => esc_html__( 'Select an option...', 'eduvalt' ),
        'priority'    => 12,
        'multiple'    => 1,
        'choices'     => [
            '4' => esc_html__( 'Widget Number 4', 'eduvalt' ),
            '3' => esc_html__( 'Widget Number 3', 'eduvalt' ),
            '2' => esc_html__( 'Widget Number 2', 'eduvalt' ),
            '1' => esc_html__( 'Widget Number 1', 'eduvalt' ),
        ],
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'eduvalt_copyright_bg_color',
        'label'       => __( 'Copyright BG Color', 'eduvalt' ),
        'description' => esc_html__( 'Copyright bg color control.', 'eduvalt' ),
        'section'     => 'footer_setting',
        'default'     => '#061E43',
        'priority'    => 14,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_copyright',
        'label'    => esc_html__( 'CopyRight', 'eduvalt' ),
        'section'  => 'footer_setting',
        'default'  => wp_kses_post('Copyright © 2024 eduvalt. All rights reserved.', 'eduvalt' ),
        'priority' => 15,
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'show_copyright_menu',
        'label'    => esc_html__('Show Copyright Menu', 'eduvalt'),
        'section'  => 'footer_setting',
        'default'  => '0',
        'priority' => 16,
        'choices'  => [
            'on'  => esc_html__('Enable', 'eduvalt'),
            'off' => esc_html__('Disable', 'eduvalt'),
        ],
    ];

    $fields[] = [
        'type'     => 'repeater',
        'settings' => 'copyright_menu_repeater',
        'label'    => esc_html__(
            'Copyright Menu',
            'eduvalt'
        ),
        'section'  => 'footer_setting',
        'priority' => 17,
        'active_callback'  => [
            [
                'setting'  => 'show_copyright_menu',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => [
            [
                'link_text'   => esc_html__('Privacy Policy', 'eduvalt'),
                'link_url'    => '#',
            ],
            [
                'link_text'   => esc_html__('Terms & Conditions', 'eduvalt'),
                'link_url'    => '#',
            ],
        ],
        'fields'   => [
            'link_text'   => [
                'type'        => 'text',
                'label'       => esc_html__('Item Name', 'eduvalt'),
                'description' => esc_html__('Enter your menu item name', 'eduvalt'),
                'default'     => '',
            ],
            'link_url'    => [
                'type'        => 'text',
                'label'       => esc_html__('Link URL', 'eduvalt'),
                'description' => esc_html__('Enter your menu item link', 'eduvalt'),
                'default'     => '',
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_footer_fields' );

// color
function eduvalt_color_fields( $fields ) {

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'eduvalt_color_option',
        'label'       => __( 'Primary Color', 'eduvalt' ),
        'description' => esc_html__('This is a Primary color control.', 'eduvalt' ),
        'section'     => 'color_setting',
        'default'     => '#1363DF',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'eduvalt_color_option2',
        'label'       => __('Secondary Color', 'eduvalt' ),
        'description' => esc_html__('This is a Secondary color control.', 'eduvalt' ),
        'section'     => 'color_setting',
        'default'     => '#082A5E',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'eduvalt_color_option3',
        'label'       => __('Title Border Color', 'eduvalt' ),
        'description' => esc_html__('This is a Yellow color control.', 'eduvalt' ),
        'section'     => 'color_setting',
        'default'     => '#FAB123',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'eduvalt_color_option4',
        'label'       => __('Sub Title Background Color', 'eduvalt' ),
        'description' => esc_html__('This is a gray color control.', 'eduvalt' ),
        'section'     => 'color_setting',
        'default'     => '#E7EFFC',
        'priority'    => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', 'eduvalt_color_fields' );

// 404
function eduvalt_404_fields( $fields ) {

    // 404 settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_error_text',
        'label'    => esc_html__('404 Text', 'eduvalt'),
        'section'  => '404_page',
        'default'  => esc_html__('404', 'eduvalt'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'eduvalt_error_title',
        'label'    => esc_html__( 'Not Found Title', 'eduvalt' ),
        'section'  => '404_page',
        'default'  => esc_html__('Sorry, the page you are looking for could not be found', 'eduvalt' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'eduvalt' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Back To Home', 'eduvalt' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', 'eduvalt_404_fields' );


/**
 * Added Fields
 */
function eduvalt_typo_fields( $fields ) {
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__( 'Body Font', 'eduvalt' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => ['body', 'p'],
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h_setting',
        'label'       => esc_html__( 'Heading Fonts', 'eduvalt' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => [
                    'h1',
                    'h2',
                    'h3',
                    'h4',
                    'h5',
                    'h6',
                    '.tgmenu__navbar-wrap ul li a',
                    '.tgmenu__search-form .form-select',
                    '.categories__item a .name',
                    '.courses__nav-active button',
                    '.categories__item-two a .name',
                    '.categories__item-three .info .name',
                    '.categories__item-three .info .courses',
                    '.fact__content p',
                    '.courses__item-bottom .price',
                    '.tg-header__style-three .tgmenu__categories .dropdown-toggle',
                    '.tgmenu__search-bar form input',
                    '.slider__content .list-wrap li',
                    '.courses__details-wrapper .nav-tabs .nav-link',
                    '.wp-block-group__inner-container h2, .wp-block-search__button-outside.wp-block-search__text-button.wp-block-search .wp-block-search__label',
                ],
            ],
        ],
    ];

    return $fields;
}

add_filter( 'kirki/fields', 'eduvalt_typo_fields' );


/**
 * Added Fields
 */
function eduvalt_slug_setting( $fields ) {
    // slug settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_ev_slug',
        'label'    => esc_html__( 'Event Slug', 'eduvalt' ),
        'section'  => 'slug_setting',
        'default'  => esc_html__( 'ourevent', 'eduvalt' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'eduvalt_port_slug',
        'label'    => esc_html__( 'Portfolio Slug', 'eduvalt' ),
        'section'  => 'slug_setting',
        'default'  => esc_html__( 'ourportfolio', 'eduvalt' ),
        'priority' => 10,
    ];

    return $fields;
}

add_filter( 'kirki/fields', 'eduvalt_slug_setting' );


/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function EDUVALT_THEME_OPTION( $name ) {
    $value = '';
    if ( class_exists( 'eduvalt' ) ) {
        $value = Kirki::get_option( eduvalt_get_theme(), $name );
    }

    return apply_filters('EDUVALT_THEME_OPTION', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function eduvalt_get_theme() {
    return 'eduvalt';
}