<?php
/**
 * Extends the tutor lms Utils Class
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class OLC_Tutor_Utils{
    public function count_total_courses_by_instructor( int $instructor_id ){
        global $wpdb;
        $results = $wpdb->get_results( 
            $wpdb->prepare( "SELECT count( ID ) as total FROM {$wpdb->prefix}posts WHERE post_author=%d AND post_type = 'courses'", $instructor_id ) 
        );

        return $results;
    }

    public function get_courses_by_instructor( int $instructor_id, int $exclude ){
        $loop = new WP_Query(array(
            'post_status'       => 'publish',
            'post_type'         => 'courses',
            'author'            => $instructor_id,
            'posts_per_page'    => 3,
            'post__not_in'      => array($exclude) 
        ));

        return $loop;
    }
}