<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Register post type testimonial
 *
 * @return void
 */
function eduvalt_register_testimonial_init() {

    $labels = array(
        'name'               => _x( 'Testimonial', 'post type general name', 'eduvalt' ),
        'singular_name'      => _x( 'Testimonial', 'post type singular name', 'eduvalt' ),
        'menu_name'          => __( 'Testimonial', 'eduvalt' ),
        'name_admin_bar'     => __( 'Testimonial', 'eduvalt' ),
        'add_new'            => __( 'Add New', 'eduvalt' ),
        'add_new_item'       => __( 'Add New Testimonial', 'eduvalt' ),
        'new_item'           => __( 'New Testimonial', 'eduvalt' ),
        'edit_item'          => __( 'Edit Testimonial', 'eduvalt' ),
        'view_item'          => __( 'View Testimonial', 'eduvalt' ),
        'all_items'          => __( 'All Testimonials', 'eduvalt' ),
        'search_items'       => __( 'Search Testimonial', 'eduvalt' ),
        'parent_item_colon'  => __( 'Parent Testimonial:', 'eduvalt' ),
        'not_found'          => __( 'No Testimonial found.', 'eduvalt' ),
        'not_found_in_trash' => __( 'No Testimonial found in Trash.', 'eduvalt' )
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => true,
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => true,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-admin-post',
        'supports'           => array( 'title', 'editor', 'thumbnail' ),
    );

    register_post_type( 'testimonial', $args );
}
add_action( 'init', 'eduvalt_register_testimonial_init' );

/**
 * Register post type testimonial taxonomoy
 *
 * @return void
 */
function eduvalt_register_testimonial_categories() {
    register_taxonomy(
        'testimonial-category',
        'testimonial',
        array(
            'label' => esc_html__( 'Testimonial Categories','eduvalt' ),
            'hierarchical' => true,
            'show_admin_column' => true,
        )
    );
}
add_action( 'init', 'eduvalt_register_testimonial_categories' );