<?php
/*
Plugin Name: Eduvalt Master
Plugin URI: https://ifingerstudio.com/eduvalt
Description: After install the Eduvalt Theme, you must need to install "Eduvalt Master" plugin first to get all features.
Author: Johanspond
Author URI: https://themeforest.net/user/johanspond
Version: 2.0.2
Text Domain: Eduvalt
Domain Path: /languages
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

//define
define( 'EDUVALT', '2.0.2' );
define( 'EDUVALT_PLG_URL', plugin_dir_url( __FILE__ ) );
define( 'EDUVALT_PLG_DIR', dirname( __FILE__ ) );
define( 'EDUVALT_PLG_DEMO_PATH', dirname( __FILE__ ) . '/demo-importer/' );
define( 'EDUVALT_PLG_DEMO_URL', plugin_dir_url( __FILE__ ) . 'demo-importer/' );

function eduvalt_plugin_loaded(){
	/*------------------------------------------------------------------------------------------------------------------*/
	/*  Plugin required file include.
	/*------------------------------------------------------------------------------------------------------------------*/
	require_once EDUVALT_PLG_DIR . '/inc/enqueue.php';
	require_once EDUVALT_PLG_DIR . '/inc/custom-widgets.php';
	require_once EDUVALT_PLG_DIR . '/inc/custom-posttype.php';
	require_once EDUVALT_PLG_DIR . '/inc/class-ocdi-importer.php';
}
add_action( 'plugins_loaded','eduvalt_plugin_loaded' );


/*------------------------------------------------------------------------------------------------------------------*/
/*  Elementor Widget Elements.
/*------------------------------------------------------------------------------------------------------------------*/
require_once EDUVALT_PLG_DIR . '/eduvalt-elements/eduvalt-elements.php';


// Allow SVG
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

  global $wp_version;
  if ( $wp_version !== '4.7.1' ) {
     return $data;
  }

  $filetype = wp_check_filetype( $filename, $mimes );

  return [
      'ext'             => $filetype['ext'],
      'type'            => $filetype['type'],
      'proper_filename' => $data['proper_filename']
  ];

}, 10, 4 );

function tg_mime_types( $mimes ){
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter( 'upload_mimes', 'tg_mime_types' );