<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class SliderStyleTwo extends Widget_Base {

	public function get_name() {
		return 'slider-two-area';
	}

	public function get_title() {
		return 'Slider';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-address-card'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Slider Title First', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Find The Best Suitable' , 'eduvalt' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_title_middle', [
				'label' => __( 'Slider Title Middle', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Courses' , 'eduvalt' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_title_last', [
				'label' => __( 'Slider Title Last', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'From Here' , 'eduvalt' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_title_two', [
				'label' => __( 'Slider Sub Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Any Time, Any Where To Do Discover Courses' , 'eduvalt' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_title_three', [
				'label' => __( 'Slider Check List', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'You can access 7,900+ different courses' , 'eduvalt' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_title_four', [
				'label' => __( 'Slider Check List', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Lifetime Access For All' , 'eduvalt' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_item_image', [
				'label' => __( 'Slider Background Image', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_item_shape_1', [
				'label' => __( 'Slider Shape Image', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_item_shape_2', [
				'label' => __( 'Slider Shape Image', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_btn_one_text', [
				'label' => __( 'Button Text', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Explore Courses' , 'eduvalt' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_btn_one_link', [
				'label' => __( 'Button Link', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '#' , 'eduvalt' ),
				'label_block' => true,
			]
		);

        $repeater->add_control(
            'list_btn_icon_type', [
                'label' => __( 'Icon Type', 'eduvalt' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
			    'default' => '1',
			    'options' => [
			     	'1'   => __( 'Type Icon', 'eduvalt' ),
			     	'2'   => __( 'Type Image', 'eduvalt' ),
			    ],
            ]
        );

        $repeater->add_control(
            'buttons_icons', [
                'label' => __( 'Select Icon', 'eduvalt' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
				'condition' => [
					'list_btn_icon_type' => '1',
				],
            ]
        );

        $repeater->add_control(
            'buttons_image', [
                'label' => __( 'Select Image', 'eduvalt' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
				'condition' => [
					'list_btn_icon_type' => '2',
				],
            ]
        );

		$this->add_control(
			'list',
			[
				'label' => __( 'Slider Item List', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Find The Best Suitable', 'eduvalt' ),
						'list_title_middle' => __( 'Courses', 'eduvalt' ),
						'list_title_last' => __( 'From Here', 'eduvalt' ),
						'list_title_two' => __( 'Any Time, Any Where To Do Discover Courses', 'eduvalt' ),
					],
					[
						'list_title' => __( 'Find The Best Suitable', 'eduvalt' ),
						'list_title_middle' => __( 'Courses', 'eduvalt' ),
						'list_title_last' => __( 'From Here', 'eduvalt' ),
						'list_title_two' => __( 'Any Time, Any Where To Do Discover Courses', 'eduvalt' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_three_options',
			[
				'label' => __( 'Slider Options', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			  'slider_autoplay',
			  [
			     'label'   => __( 'Slider Autoplay', 'eduvalt' ),
			     'type'    => Controls_Manager::SELECT,
			     'default' => 'false',
			     'options' => [
			     	'false'   => __( 'No', 'eduvalt' ),
			     	'true'    => __( 'Yes', 'eduvalt' ),
			     ],
			  ]
		);

		$this->add_control(
			  'slider_autoplay_speed',
			  [
			     'label'   => __( 'Slider Autoplay Speed', 'eduvalt' ),
			     'type'    => Controls_Manager::TEXT,
			     'default' => '10000',
			  ]
		);

		$this->add_control(
			  'slider_animation',
			  [
			     'label'   => __( 'Slider Animation', 'eduvalt' ),
			     'type'    => Controls_Manager::SELECT,
			     'default' => 'true',
			     'options' => [
			     	'false'   => __( 'No', 'eduvalt' ),
			     	'true'    => __( 'Yes', 'eduvalt' ),
			     ],
			  ]
		);

		$this->add_control(
			  'slider_arrows',
			  [
			     'label'   => __( 'Slider Arrows', 'eduvalt' ),
			     'type'    => Controls_Manager::SELECT,
			     'default' => 'true',
			     'options' => [
			     	'false'   => __( 'No', 'eduvalt' ),
			     	'true'    => __( 'Yes', 'eduvalt' ),
			     ],
			  ]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'slider_style_section',
			[
				'label' => __( 'Slider Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'slider_title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider__content h2.title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .slider__content h2.title',
			]
		);

		$this->add_control(
			'slider_sub_title_color',
			[
				'label' => __( 'Sub Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider__content .list-wrap li' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Sub Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .slider__content .list-wrap li',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$eduvalt_rtl_check = is_rtl() ?  'true' : 'false';
		$randID = wp_rand();
		?>
		<script type="text/javascript">
		    jQuery(document).ready(function(){
			    jQuery('.slider__active_two').slick({
			        dots: false,
			        infinite: true,
			        speed: 1000,
			        autoplay: true,
			        rtl: <?php echo $eduvalt_rtl_check; ?>,
			        autoplaySpeed: 5000,
			        arrows: false,
			        slidesToShow: 1,
			        slidesToScroll: 1,
			        fade: true,
			    }).slickAnimation();
		    });
		</script>

		<?php if ( $settings['list'] ) { ?>
	        <section class="slider-area">
	            <div class="slider__active_two">
	            	<?php foreach (  $settings['list'] as $index => $item ) { ?>
		                <div class="slider__item d-flex" style="background-image:url(<?php echo $item['list_item_image']['url'];?>)">
		                    <div class="container">
		                        <div class="row">
		                            <div class="col-xl-6 col-lg-8">
		                                <div class="slider__content">
		                                    <span class="sub-title" data-animation-in="slideInLeft" data-delay-in=".2" data-duration-in="1.5"><?php echo $item['list_title_two']; ?></span>
		                                    <h2 class="title tg-svg" data-animation-in="slideInLeft" data-delay-in=".4" data-duration-in="1.5"><?php echo $item['list_title']; ?> <span class="position-relative"><span class="svg-icon" id="slider-<?php echo $index; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo $item['list_title_middle']; ?></span> <?php echo $item['list_title_last']; ?></h2>
		                                    <ul class="list-wrap" data-animation-in="slideInLeft" data-delay-in=".6" data-duration-in="1.5">
		                                        <li><i class="fas fa-check-circle"></i><?php echo $item['list_title_three']; ?></li>
		                                        <li><i class="fas fa-check-circle"></i><?php echo $item['list_title_four']; ?></li>
		                                    </ul>
		                                    <div class="tg-button-wrap" data-animation-in="slideInLeft" data-delay-in=".8" data-duration-in="1.5">
		                                        <a href="<?php echo $item['list_btn_one_link']; ?>" class="btn tg-svg"><span class="text"><?php echo $item['list_btn_one_text']; ?></span> <span class="svg-icon" id="slider-btn01-<?php echo $index; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
		                                    </div>
		                                </div>
		                            </div>
		                        </div>
		                    </div>
		                    <?php if (!empty($item['list_item_shape_2']['url'])): ?>
		                    	<img src="<?php echo $item['list_item_shape_2']['url'];?>" alt="shape" width="108" class="top-shape" data-animation-in="slideInDown" data-delay-in="1.2" data-duration-in="1.5">
		                    <?php endif; ?>
		                    <?php if (!empty($item['list_item_shape_1']['url'])): ?>
		                    	<img src="<?php echo $item['list_item_shape_1']['url'];?>" alt="shape" class="bottom-shape" data-animation-in="slideInLeft" data-delay-in="1.2" data-duration-in="1.5">
		                    <?php endif; ?>
		                </div>
	            	<?php } ?>
	            </div>
	        </section>
		<?php
		}
	}
}