<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Single_Team extends Widget_Base {
	// widgets unique ID
	public function get_name() {
		return 'section_single_team';
	}

	// widgets title
	public function get_title() {
		return 'Team Member Item';
	}

	// widgets Icon
	public function get_icon() {
		return 'eicon-info-box';
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Team Member Item', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'teammember_styles',
			[
			    'label'       => __( 'Select Style', 'eduvalt' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => 'one',
			    'options' => [
			     	'one'   => __( 'Style 1', 'eduvalt' ),
			     	'two'   => __( 'Style 2', 'eduvalt' ),
			    ],
			]
		);

		$this->add_control(
			'teammember_columns',
			[
			    'label'       => __( 'Select columns', 'eduvalt' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'6'   => __( '2', 'eduvalt' ),
			     	'4'   => __( '3', 'eduvalt' ),
			     	'3'   => __( '4', 'eduvalt' ),
			    ],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'single_team_name',
			[
				'label' => esc_html__( 'Team Member Name', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Jon Doe', 'eduvalt' ),
			]
		);
		$repeater->add_control(
			'single_team_designation',
			[
				'label' => esc_html__( 'Team Member Designation', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Developer', 'eduvalt' ),
			]
		);
		$repeater->add_control(
			'single_team_total',
			[
				'label' => esc_html__( 'Total Students', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( '1335 Students', 'eduvalt' ),
			]
		);
		$repeater->add_control(
			'single_team_total_rating',
			[
				'label' => esc_html__( 'Total Rating', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( '(5.0)', 'eduvalt' ),
			]
		);
		$repeater->add_control(
			'single_team_image',
			[
				'label' => esc_html__( 'Team Member Image', 'eduvalt' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'single_social_1',
			[
				'label' => esc_html__( 'Facebook', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'single_social_2',
			[
				'label' => esc_html__( 'Twitter', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'single_social_3',
			[
				'label' => esc_html__( 'Instagram', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'single_social_4',
			[
				'label' => esc_html__( 'Linkedin', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'single_social_5',
			[
				'label' => esc_html__( 'Youtube', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'single_social_6',
			[
				'label' => esc_html__( 'Dribbble', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'single_member_link',
			[
				'label' => __( 'Add Profile Link', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$repeater->add_control(
			'single_member_bg',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#E2FAFF',
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'single_member_active',
			[
				'label' => __( 'Border Radius Style', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
			    'default' => 'one',
			    'options' => [
			     	'one'   => __( 'Border Radius Style One', 'eduvalt' ),
			     	'two'   => __( 'Border Radius Style Two', 'eduvalt' ),
			     	'three'   => __( 'Border Radius Style Three', 'eduvalt' ),
			     	'four'   => __( 'Border Radius Style Four', 'eduvalt' ),
			    ],
			    'label_block' => true,
			]
		);

		$this->add_control(
			'team_items_list',
			[
				'label' => __( 'Repeater List', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'single_team_name'  => __( 'Jon Doe', 'eduvalt' ),
						'single_team_designation'  => __( 'Developer', 'eduvalt' ),
					],
				],
				'title_field' => '{{{ single_team_name }}}',
			]
		);


		$this->end_controls_section();
		//End  of a control box

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/* = Item Styling
		========================================*/
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'Title Style', 'eduvalt' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'title_color',
			[
				'label' => __( 'Title text color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .team-item.single-one .team-content .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .team-item.single-one .team-content .title',
			]
		);

		$this->add_responsive_control(
			'designation_color',
			[
				'label' => __( 'Designation Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .team-item.single-one .team-content span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography',
				'label' => __( 'Content Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .team-item.single-one .team-content span',
			]
		);

		$this->add_responsive_control(
			'item_border_color',
			[
				'label' => __( 'Border Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .team-item.single-one .team-thumb::before' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'item_hover_bg_color',
			[
				'label' => __( 'Item Hover Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .team-item.single-one:hover .team-thumb::before' => 'background-color: {{VALUE}};',
				],
			]
		);

	}
	//end of control box 

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
			<?php if ( $settings['teammember_styles'] == 'one') { ?>
				<?php if ( $settings['team_items_list'] ) { ?>
	                <div class="row justify-content-center">
	                	<?php foreach ( $settings['team_items_list'] as $value ) { ?>
	                        <div class="col-lg-<?php echo $settings['teammember_columns']; ?> col-md-6 col-sm-10">
		                        <div class="instructor__item">
		                            <div class="instructor__img">
		                                <div class="instructor__shape" style="background-color: <?php echo $value['single_member_bg']; ?>; border-radius: <?php if( $value['single_member_active'] == 'one'){echo '135px 0 0 0'; }elseif($value['single_member_active'] == 'two'){echo '135px 115px 115px 0';}elseif($value['single_member_active'] == 'three'){echo '0 135px 0 0';}else{ echo '115px 135px 0 115px'; } ?>;"></div>
			                                <?php if (!empty($value['single_team_image']['url'])): ?>
			                                	<a href="<?php echo esc_url( $value['single_member_link']['url'] ); ?>"><img src="<?php echo esc_attr( $value['single_team_image']['url'] ); ?>" alt="instructor"></a>
			                            	<?php endif; ?>
		                            </div>
		                            <div class="instructor__content">
		                                <div class="left">
		                                    <span class="designation"><?php echo $value['single_team_designation']; ?></span>
		                                    <h4 class="name"><a href="<?php echo esc_url( $value['single_member_link']['url'] ); ?>"><?php echo $value['single_team_name']; ?></a></h4>
		                                </div>
		                                <div class="right">
		                                    <span class="share"><i class="flaticon-share"></i></span>
											<ul class="social-list list-wrap">
											    <?php if (!empty($value['single_social_1']['url'])): ?>
											        <li>
											            <a href="<?php echo esc_url($value['single_social_1']['url']); ?>">
											                <i class="fab fa-facebook-f"></i>
											            </a>
											        </li>
											    <?php endif; ?>

											    <?php if (!empty($value['single_social_2']['url'])): ?>
											        <li>
											            <a href="<?php echo esc_url($value['single_social_2']['url']); ?>">
											                <i class="fab fa-twitter"></i>
											            </a>
											        </li>
											    <?php endif; ?>

											    <?php if (!empty($value['single_social_3']['url'])): ?>
											        <li>
											            <a href="<?php echo esc_url($value['single_social_3']['url']); ?>">
											                <i class="fab fa-instagram"></i>
											            </a>
											        </li>
											    <?php endif; ?>

											    <?php if (!empty($value['single_social_4']['url'])): ?>
											        <li>
											            <a href="<?php echo esc_url($value['single_social_4']['url']); ?>">
											                <i class="fab fa-linkedin-in"></i>
											            </a>
											        </li>
											    <?php endif; ?>
											</ul>
		                                </div>
		                            </div>
		                        </div>
	                        </div>
	                    <?php } ?>
	                </div>
		        <?php } ?>
	        <?php }else{ ?> 
				<?php if ( $settings['team_items_list'] ) { ?>
	                <div class="row justify-content-center">
	                	<?php foreach ( $settings['team_items_list'] as $value ) { ?>
	                        <div class="col-lg-<?php echo $settings['teammember_columns']; ?> col-md-6 col-sm-6">
		                        <div class="mentors__item">
		                            <div class="mentors__img">
		                            	<?php if (!empty($value['single_team_image']['url'])): ?>
			                                <a href="<?php echo esc_url( $value['single_member_link']['url'] ); ?>">
			                                    <img src="<?php echo esc_attr( $value['single_team_image']['url'] ); ?>" alt="instructor">
			                                </a>
		                            	<?php endif; ?>
		                                <div class="mentors__social">
		                                    <span class="share"><i class="flaticon-share"></i></span>
											<ul class="social-list list-wrap">
											    <?php if (!empty($value['single_social_1']['url'])): ?>
											        <li>
											            <a href="<?php echo esc_url($value['single_social_1']['url']); ?>">
											                <i class="fab fa-facebook-f"></i>
											            </a>
											        </li>
											    <?php endif; ?>

											    <?php if (!empty($value['single_social_2']['url'])): ?>
											        <li>
											            <a href="<?php echo esc_url($value['single_social_2']['url']); ?>">
											                <i class="fab fa-twitter"></i>
											            </a>
											        </li>
											    <?php endif; ?>

											    <?php if (!empty($value['single_social_3']['url'])): ?>
											        <li>
											            <a href="<?php echo esc_url($value['single_social_3']['url']); ?>">
											                <i class="fab fa-instagram"></i>
											            </a>
											        </li>
											    <?php endif; ?>

											    <?php if (!empty($value['single_social_4']['url'])): ?>
											        <li>
											            <a href="<?php echo esc_url($value['single_social_4']['url']); ?>">
											                <i class="fab fa-linkedin-in"></i>
											            </a>
											        </li>
											    <?php endif; ?>
											</ul>

		                                </div>
		                            </div>
		                            <div class="mentors__content">
		                                <div class="mentors__content-top">
		                                    <h4 class="name"><a href="<?php echo esc_url( $value['single_member_link']['url'] ); ?>"><?php echo $value['single_team_name']; ?></a></h4>
		                                    <span class="designation"><?php echo $value['single_team_designation']; ?></span>
		                                </div>
		                                <div class="mentors__content-bottom">
		                                    <ul class="list-wrap">
		                                        <li class="students"><i class="flaticon-user-1"></i><?php echo $value['single_team_total']; ?></li>
		                                        <li class="rating">
		                                            <i class="fas fa-star"></i>
		                                            <span class="rating-count"><?php echo $value['single_team_total_rating']; ?></span>
		                                        </li>
		                                    </ul>
		                                </div>
		                            </div>
		                        </div>
	                        </div>
	                    <?php } ?>
	                </div>
		        <?php } ?>
	        <?php } ?>
		<?php
	}
}