<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

/**
 * Elementor gcounter widget.
 *
 * Elementor widget that displays stats and numbers in an escalating manner.
 *
 * @since 1.0.0
 */
class Single_Counter extends Widget_Base {

	public function get_name() {
		return 'single-counter';
	}

	// title to show on elementor
	public function get_title() {
		return 'Counter Number'; 
	}

	// Icon for elelmentor widgets
	public function get_icon() {
		return 'fal fa-sort-numeric-up'; 
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	// Elementor script depends
  	public function get_script_depends() {
		return [ 'eduvalt-elementor-editor' ];
	}

	/**
	 * Register counter widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_counter',
			[
				'label' => __( 'Counter Number', 'eduvalt' ),
			]
		);

		$this->add_control(
			'counter_number',
			[
				'label' => __( 'Number', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => 100,
				'label_block' => true,
			]
		);

		$this->add_control(
			'counter_title',
			[
				'label' => __( 'Counter Description', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( 'Counter Description', 'eduvalt' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'delay',
			[
				'label' => __( 'Counter Delay (milliseconds)', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( '10', 'eduvalt' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Counter Animation Time', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( '2000', 'eduvalt' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'size',
			[
				'label' => __( 'Size', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => __( 'Default', 'eduvalt' ),
					'small'   => __( 'Small', 'eduvalt' ),
					'medium'  => __( 'Medium', 'eduvalt' ),
					'large'   => __( 'Large', 'eduvalt' ),
					'xl'      => __( 'XL', 'eduvalt' ),
					'xxl'     => __( 'XXL', 'eduvalt' ),
				],
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'eduvalt' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'eduvalt' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'eduvalt' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-left',
				'toggle' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_number',
			[
				'label' => __( 'Number', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'number_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#074DF3',
				'selectors' => [
					'{{WRAPPER}} .counter-item .count' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography_number',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .counter-item h2',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_description',
			[
				'label' => __( 'Description', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .counter-item p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography_description',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .counter-item p',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render counter widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'counter_title', 'none' );
		$this->add_inline_editing_attributes( 'counter_description', 'none' );

		$this->add_render_attribute(
			'counter_number_animate',
			[
				'id' 			=> 'countter-' . $this->get_id(),
				'data-delay' 	=> $settings['delay'], 
				'data-time' 	=> $settings['time'],
			]
		);
		$id = uniqid();

		?>
	        <div class="counter-item <?php echo esc_attr( $settings['text_align'] ); ?>">
	            <h2 class="count">
	            	<span class="countter" <?php echo $this->get_render_attribute_string( 'counter_number_animate' ); ?>>
	            		<?php echo $settings['counter_number']; ?>
	            	</span>
	            </h2>
	            <p><?php echo $settings['counter_title']; ?></p>
	        </div>
		<?php
	}
}