<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Mission extends Widget_Base {

	public function get_name() {
		return 'section-mission';
	}

	// title to show on eduvalt
	public function get_title() {
		return 'Section Mission';
	}

	public function get_icon() {
		return 'fal fa-play-circle'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Section Mission', 'eduvalt' ),   //section name for controler view
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' => esc_html__( 'Section Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Title', 'eduvalt' ),
				'default' => 'Section Title',
			]
		);
		$this->add_control(
			'section_signature',
			[
				'label' => esc_html__( 'Choose Image', 'eduvalt' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'section_name',
			[
				'label' => esc_html__( 'Name', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Sandra Jones', 'eduvalt' ),
				'default' => 'Sandra Jones',
			]
		);

		$repeater = new Repeater();
        $repeater->add_control(
            'mission_thumb', [
                'label' => __( 'Mission Thumbnail', 'eduvalt' ),
                'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
            ]
        );
        $repeater->add_control(
            'mission_title', [
                'label' => __( 'Mission Title', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Our Mission' , 'eduvalt' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'mission_content', [
                'label' => __( 'Content', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'mission_items',
            [
                'label' => __( 'Add Mission', 'eduvalt' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

		$this->end_controls_section();


		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_responsive_control(
            'mission_area_title_color',
            [
                'label' => __( 'Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mission-content .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'mission_area_name_color',
            [
                'label' => __( 'Name Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mission-content .sign span' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'section_style_margin',
            [
                'label' => esc_html__('Section Margin', 'eduvalt'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem'],
                'default' => [
                    'top' => 75,
                    'right' => 0,
                    'bottom' => 80,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

        /* = Progress Bar Styling
        ========================================*/
        $this->start_controls_section(
            'section_mission_item_style',
            [
                'label' => esc_html__( 'Mission Item Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

       $this->add_responsive_control(
            'mission_item_title_color',
            [
                'label' => __( 'Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mission-item .content .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'mission_item_content_color',
            [
                'label' => __( 'Content Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mission-item .content p' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();


	}
	//end of control box 

	//to show on the fontend
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
            <section class="mission-area">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="mission-content wow fadeInUp" data-wow-delay=".2s">
                                <h2 class="title"><?php echo $settings['section_title']; ?></h2>
                                <div class="sign">
                                    <img src="<?php echo $settings['section_signature']['url']; ?>">
                                    <span><?php echo $settings['section_name']; ?></span>
                                </div>
                            </div>
                        </div>
                        <?php if ( $settings['mission_items'] ) { ?>
                        	<?php foreach ( $settings['mission_items'] as $value ) { ?>
		                        <div class="col-lg-4 col-md-6">
		                            <div class="mission-item wow fadeInUp" data-wow-delay=".4s">
                                        <?php if (!empty($value['mission_thumb']['url'])): ?>
    		                                <div class="mission-thumb">
    		                                    <img src="<?php echo esc_attr( $value['mission_thumb']['url'] ); ?>" alt="">
    		                                </div>
                                        <?php endif; ?>
		                                <div class="content">
		                                    <h2 class="title"><?php echo $value['mission_title']; ?></h2>
		                                    <p><?php echo $value['mission_content']; ?></p>
		                                </div>
		                            </div>
		                        </div>
							<?php } ?>
						<?php } ?>
                    </div>
                </div>
            </section>
		<?php
	}
}