<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Events extends Widget_Base {   //this name is added to plugin.php of the root folder

    public function get_name() {
        return 'section-events';
    }

    public function get_title() {
        return 'Event Grid';   // title to show on elementor
    }

    public function get_icon() {
        return 'fal fa-users-medical';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
    }

    public function get_categories() {
        return [ 'eduvalt-elements' ];    // category of the widget
    }

     public function get_script_depends() {
        return [ 'eduvalt-elementor-editor' ];
    }

    /**
     * A list of scripts that the widgets is depended in
     * @since 1.3.0
     **/
    protected function register_controls() {
        
    //start of a control box
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__( 'Event Grid', 'eduvalt' ),   //section name for controler view
            ]
        );

        $this->add_control(
         'categories_events',
         [
             'label' => __( 'Select Categories', 'eduvalt' ),
             'type' => Controls_Manager::SELECT2,
             'multiple' => true,
             'options' => eduvalt_get_terms_dropdown_array([
                 'taxonomy' => 'tribe_events_cat',
                 'hide_empty' => true
             ]),
             'label_block' => true,
         ]
        );

        $this->add_control(
            'post_number',
            [
                'label' => esc_html__( 'Number of Event', 'eduvalt' ),
                'description' => esc_html__( 'Give -1 for all post', 'eduvalt' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
            ]
        );

        $this->add_control(
            'events_orderby',
            [
                'label' => __( 'Order by', 'eduvalt' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' =>ifinger_post_orderby_options(),
            ]
        );

        $this->add_control(
            'events_order',
            [
                'label' => __( 'Order', 'eduvalt' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => __( 'Ascending Order', 'eduvalt' ),
                    'DESC' => __( 'Descending', 'eduvalt' ),
                ],
            ]
        );

        $this->add_control(
            'event_columns',
            [
                'label' => __( 'Columns', 'eduvalt' ),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '6' => __( '2', 'eduvalt' ),
                    '4' => __( '3', 'eduvalt' ),
                    '3' => __( '4', 'eduvalt' ),
                    '2' => __( '6', 'eduvalt' ),
                ],
            ]
        );

        $this->add_control(
            'thumbnail_size',
            [
                'label' => __( 'Thumbnail Size', 'eduvalt' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'thumbnail' => __( 'Thumbnail', 'eduvalt' ),
                    'medium' => __( 'Medium', 'eduvalt' ),
                    'large' => __( 'Large', 'eduvalt' ),
                    'full' => __( 'Full', 'eduvalt' ),
                ],
                'default' => 'thumbnail',
            ]
        );

        $this->end_controls_section();

        /* = Title Styling
        ========================================*/
        $this->start_controls_section(
            'events_style',
            [
                'label' => esc_html__( 'Event Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'event_item_background',
            [
                'label' => __( 'Background Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .events__item' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'event_item_border_color',
            [
                'label' => __( 'Border Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .events__item-content' => 'border:1px solid {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'event_title_color',
            [
                'label' => __( 'Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .events__item-content .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'event_title_typography',
                'label' => __( 'Title Typography', 'eduvalt' ),
                'selector' => '{{WRAPPER}} .events__item-content .title',
            ]
        );

        $this->add_responsive_control(
            'event_title_hover_color',
            [
                'label' => __( 'Title Hover Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .events__item-content .title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {               //to show on the fontend 
        $settings = $this->get_settings_for_display();

        if ( !empty( $settings['categories_events'] ) ) {
            $args = array(
            'post_type'      => 'tribe_events',
            'post_status'    => 'publish',
            'posts_per_page' => $settings['post_number'],
            'order'          => $settings['events_order'],
            'orderby'        => $settings['events_orderby'],
                'tax_query' => array(
                    array(
                        'taxonomy' => 'tribe_events_cat',
                        'field' => 'id',
                        'terms' => $settings['categories_events']
                    )
                ),
            );
        } else {
            $args = array(
                'post_type'      => 'tribe_events',
                'post_status'    => 'publish',
                'posts_per_page' => $settings['post_number'],
                'order'          => $settings['events_order'],
                'orderby'        => $settings['events_orderby'],
                'taxonomy'       => 'tribe_events_cat',
            );
        }

        $events_query= null;
        $events_query = new \WP_Query( $args );

        if ( $events_query->have_posts() ) : ?>
            <div class="event-calendar-grid">
                <div class="row justify-content-center">
                    <?php while ($events_query->have_posts()) : $events_query->the_post(); 
                        $event_venue = tribe_get_venue();
                        ?>
                        <div class="col-lg-4 col-md-6 col-sm-10">
                            <div class="events__item shine__animate-item">
                                <div class="events__item-thumb">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <a href="<?php the_permalink(); ?>" class="shine__animate-link">
                                            <?php the_post_thumbnail(); ?>
                                        </a>
                                    <?php endif; ?>
                                    <span class="events__date"><i class="flaticon-calendar-date"></i> <?php echo tribe_get_start_date(null, false, 'M d, Y'); ?></span>
                                </div>
                                <div class="events__item-content">
                                    <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <?php if ( !empty( $event_venue ) ) { ?>
                                            <span class="location"><i class="flaticon-pin-1"></i><?php echo $event_venue ; ?>
                                        <?php } else { ?>
                                            <span class="location"><i class="flaticon-pin-1"></i><?php echo 'N/A'; ?>
                                        <?php } ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        <?php endif; wp_reset_postdata(); ?>
        <?php
    }
}