<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Counter_List extends Widget_Base {
	// widgets unique ID
	public function get_name() {
		return 'section-counter-list';
	}

	// widgets title
	public function get_title() {
		return 'Counter List';
	}

	// widgets Icon
	public function get_icon() {
		return 'eicon-info-box';
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Counter List', 'eduvalt' ),   //section name for controler view
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
            'counter_icons_type',
            [
                'label' => esc_html__('Select Icon Type', 'eduvalt'),
                'type' => Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'eduvalt'),
                    'icon' => esc_html__('Icon', 'eduvalt'),
                ],
            ]
        );

        $repeater->add_control(
            'counter_icons', [
                'label' => __( 'Upload Icon', 'eduvalt' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition' => [
                    'counter_icons_type' => 'image'
                ]
            ]
        );

        $repeater->add_control(
            'counter_icon2',
            [
                'show_label' => false,
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'label_block' => true,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'counter_icons_type' => 'icon'
                ]
            ]
        );

		$repeater->add_control(
			'counter_title',
			[
				'label' => esc_html__( 'Counter Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Students Enrolled', 'eduvalt' ),
			]
		);

		$repeater->add_control(
			'counter_numbers',
			[
				'label' => esc_html__( 'Counter Number', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( '590', 'eduvalt' ),
			]
		);

		$this->add_control(
			'counter_lists',
			[
				'label' => __( 'Repeater List', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'counter_title'  => __( 'Students Enrolled', 'eduvalt' ),
						'fun_facts_subtitle'  => __( '325,200', 'eduvalt' ),
					],
					[
						'counter_title'  => __( 'Top Class Courses', 'eduvalt' ),
						'fun_facts_subtitle'  => __( '11,399', 'eduvalt' ),
					],
					[
						'counter_title'  => __( 'World Countries', 'eduvalt' ),
						'fun_facts_subtitle'  => __( '312', 'eduvalt' ),
					],
					[
						'counter_title'  => __( 'Award We Received', 'eduvalt' ),
						'fun_facts_subtitle'  => __( '590', 'eduvalt' ),
					],
				],
				'title_field' => '{{{ counter_title }}}',
			]
		);


		$this->end_controls_section();
		//End  of a control box

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Counter Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_responsive_control(
			'item_bg_color',
			[
				'label' => __( 'Item Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .fact__item-two' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_responsive_control(
			'title_color',
			[
				'label' => __( 'Title text color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#39557e',
				'selectors' => [
					'{{WRAPPER}} .fact__content-two p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .fact__content-two p',
			]
		);

		$this->add_responsive_control(
			'content_color',
			[
				'label' => __( 'Number Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#082a5e',
				'selectors' => [
					'{{WRAPPER}} .fact__content-two .count' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Content Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .fact__content-two .count',
			]
		);
	}
	//end of control box 

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

        <script>
            jQuery(document).ready(function($) {
                $('.odometer').appear(function(e) {
                    var odo = $(".odometer");
                    odo.each(function() {
                        var countNumber = $(this).attr("data-count");
                        $(this).html(countNumber);
                    });
                });

            });
        </script>

		<?php if ( $settings['counter_lists'] ) { ?>
            <div class="row justify-content-center">
            	<?php foreach ($settings['counter_lists'] as $item ) : ?>
	                <div class="col-lg-3 col-md-4 col-sm-6">
	                    <div class="fact__item-two text-center">
	                        <div class="fact__icon-two">
                                <?php if ($item['counter_icons_type'] == 'image') : ?>
                                    <?php if (!empty($item['counter_icons']) ): ?>
                                        <img src="<?php echo esc_url($item['counter_icons']['url']); ?>" alt="">
                                    <?php endif; ?>
                                <?php else : ?>
                                    <?php if(!empty($item['counter_icon2']['value'])) : ?>
                                    	<i class="<?php echo $item['counter_icon2']['value']; ?>"></i>
                                    <?php endif; ?>
                                <?php endif; ?>
	                        </div>
	                        <div class="fact__content-two">
	                            <h3 class="count"><span class="odometer" data-count="<?php echo esc_attr($item['counter_numbers']); ?>"></span></h3>
	                            <p><?php echo esc_html__($item['counter_title']); ?></p>
	                        </div>
	                    </div>
	                </div>
    			<?php endforeach; ?>
            </div>
    	<?php } ?>
		<?php
	}
}