<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Checkbox_Lists extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'checkbox-lists';
	}

	public function get_title() {
		return 'Checkbox List';   // title to show on elementor
	}

	public function get_icon() {
		return 'eicon-bullet-list';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}
	
    public function get_script_depends() {
		return [ 'eduvalt-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
	//start of a control box
		$this->start_controls_section(
			'section_content_checkbo',
			[
				'label' => esc_html__( 'Checkbox List Settings', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			  'checklist_styles',
			  [
			     'label'   => __( 'Check List Style', 'eduvalt' ),
			     'type'    => Controls_Manager::SELECT,
			     'default' => 'style1',
			     'options' => [
					'style1' => __( 'Check List 1', 'eduvalt' ),
					'style2' => __( 'Check List 2', 'eduvalt' ),
			     ],
			  ]
		);


		$repeater = new Repeater();

		$repeater->add_control(
			'checkbox_item_title', [
				'label' => __( 'Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Expert Tutors' , 'eduvalt' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'checkbox_item_number', [
				'label' => __( 'Icon', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '2000' , 'eduvalt' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'checkbox_item_icon', [
				'label' => __( 'Icon', 'eduvalt' ),
				'type' => Controls_Manager::ICON,
				'default' => 'fas fa-check-square',
				'label_block' => true,
			]
		);

		$this->add_control(
			'checkbox_list_items',
			[
				'label' => __( 'Check List', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'checkbox_item_title' => __( 'Expert Tutors', 'eduvalt' ),
						'checkbox_item_number' => __( '20000', 'eduvalt' ),
						'checkbox_item_icon' => __( 'flaticon-support', 'eduvalt' ),
					],
					[
						'checkbox_item_title' => __( 'Top Lessons', 'eduvalt' ),
						'checkbox_item_number' => __( '1500', 'eduvalt' ),
						'checkbox_item_icon' => __( 'flaticon-file', 'eduvalt' ),
					],
					[
						'checkbox_item_title' => __( 'Over Students', 'eduvalt' ),
						'checkbox_item_number' => __( '18000', 'eduvalt' ),
						'checkbox_item_icon' => __( 'flaticon-graduation-cap', 'eduvalt' ),
					],
					[
						'checkbox_item_title' => __( 'Pro Videos', 'eduvalt' ),
						'checkbox_item_number' => __( '3200', 'eduvalt' ),
						'checkbox_item_icon' => __( 'flaticon-video-player', 'eduvalt' ),
					],
				],
				'title_field' => '{{{ checkbox_item_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'checkbox_style',
			[
				'label' => esc_html__( 'Checkbox Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'checkbox_title_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-check-area .about-list li' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'checkbox_icon_color',
			[
				'label' => __( 'Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-check-area .about-list li i' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'checkbox_title2_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .support-list .list-wrap li' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'checkbox_icon2_color',
			[
				'label' => __( 'Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .support-list .list-wrap li i' => 'color: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();
	}

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();

	?>

		<?php if ( $settings['checkbox_list_items'] ) { ?>
			<?php if ( $settings['checklist_styles'] == 'style2' ) { ?>
		        <div class="support-list">
		            <ul class="list-wrap">
				   		<?php foreach ( $settings['checkbox_list_items'] as $key => $value ) { ?>
			                <li>
			                    <i class="<?php echo esc_attr( $value['checkbox_item_icon'] );?>"></i> 
			                    <?php echo esc_attr( $value['checkbox_item_title'] );?>
			                </li>
				   		<?php } ?>
	           		</ul>
	        	</div>
			<?php }else{ ?>
                <ul class="about__info-list list-wrap p-0">
                	<?php foreach ( $settings['checkbox_list_items'] as $key => $value ) { ?>
	                    <li class="about__info-list-item">
	                    	<?php if ( !empty( $value['checkbox_item_icon'] ) ) { ?>
	                        	<div class="icon"><i class="<?php echo esc_attr( $value['checkbox_item_icon'] );?>"></i></div>
	                        <?php } ?>
	                        <p class="content"><?php echo esc_attr( $value['checkbox_item_number'] );?> <br> <?php echo esc_attr( $value['checkbox_item_title'] );?></p>
	                    </li>
				   	<?php } ?>
                </ul>
			<?php } ?>
		<?php } ?>
	<?php
	}
}