<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Blog extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-blog';
	}

	public function get_title() {
		return 'Blog Grid';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-edit';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}
     public function get_script_depends() {
		return [ 'eduvalt-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
	//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Blog Grid', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'select_styles',
			[
				'label' => __( 'Select Style', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' 	=> __( 'Style One', 'eduvalt' ),
					'style2' 	=> __( 'Style Two', 'eduvalt' ),
					'style3' 	=> __( 'Style Three', 'eduvalt' ),
					'style4' 	=> __( 'Style Four', 'eduvalt' ),
				]
			]
		);

		$this->add_control(
			'query_type',
			[
				'label' => __( 'Get Posts by cats or title', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'cats'   => __( 'Posts by Cats', 'eduvalt' ),
					'titles' => __( 'Posts by Titles', 'eduvalt' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'postbycats',
			[
				'label' => __( 'Post By Categories', 'eduvalt' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => eduvalt_get_terms_dropdown_array([
					'taxonomy' => 'category',
					'hide_empty' => true
				]),
				'label_block' => true,
				'condition'   => array( 'query_type' => array( 'cats' ) ),
			]
		);

		$this->add_control(
			'postbytitle',
			[
				'label' => __( 'Post By Title', 'eduvalt' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => blog_posts_title([
					'taxonomy' => 'category',
					'hide_empty' => true
				]),
				'label_block' => true,
				'condition'   => array( 'query_type' => array( 'titles' ) ),
			]
		);
		
		$this->add_control(
			'blog_columns',
			[
			    'label'       => __( 'Blog columns', 'eduvalt' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'12'   => __( '1', 'eduvalt' ),
			     	'6'   => __( '2', 'eduvalt' ),
			     	'4'   => __( '3', 'eduvalt' ),
			     	'3'   => __( '4', 'eduvalt' ),
			    ],
			]
		);

		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Number of Item', 'eduvalt' ),
				'description' => esc_html__( 'Give -1 for all posts', 'eduvalt' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 3,
			]
		);

		$this->add_control(
			'post_excerpt',
			[
				'label' => esc_html__( 'Post Excerpt', 'eduvalt' ),
				'description' => esc_html__( 'Post content excerpt', 'eduvalt' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 20,
			]
		);

		$this->add_control(
			'post_orderby',
			[
				'label' => __( 'Order by', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' =>ifinger_post_orderby_options(),
			]
		);

		$this->add_control(
			'post_order',
			[
				'label' => __( 'Order', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __( 'Ascending Order', 'eduvalt' ),
					'DESC' => __( 'Descending', 'eduvalt' ),
				],
			]
		);

		$this->add_control(
			'hide_post_summery',
			[
				'label' => __( 'Hide Post Summery', 'eduvalt' ),
				'type'  => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'eduvalt' ),
				'label_off' => __( 'Hide', 'eduvalt' ),
				'return_value' => 'no',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'hide_post_cat',
			[
				'label' => __( 'Hide Post Category', 'eduvalt' ),
				'type'  => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'eduvalt' ),
				'label_off' => __( 'Hide', 'eduvalt' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'hide_post_date',
			[
				'label' => __( 'Hide Post Date', 'eduvalt' ),
				'type'  => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'eduvalt' ),
				'label_off' => __( 'Hide', 'eduvalt' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'hide_post_admin',
			[
				'label' => __( 'Hide Post Author', 'eduvalt' ),
				'type'  => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'eduvalt' ),
				'label_off' => __( 'Hide', 'eduvalt' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'hide_post_comments',
			[
				'label' => __( 'Hide Post Comments', 'eduvalt' ),
				'type'  => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'eduvalt' ),
				'label_off' => __( 'Hide', 'eduvalt' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'blog_general_settings',
			[
				'label' => esc_html__( 'Blog General Settings', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'blog_items',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style1',
                ],
			]
		);

		$this->add_control(
			'blog_items_two',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-two' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style2',
                ],
			]
		);

		$this->add_control(
			'blog_items_three',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-item-three' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style3',
                ],
			]
		);

		$this->add_control(
			'blog_items_rounded',
			[
				'label' => __( 'Border Radius', 'eduvalt' ),
				'type' => Controls_Manager::DIMENSIONS,
				'default' =>[
					'top'=> '0',
					'right' => '0',
					'bottom' => '0',
					'left' => '0'
				],
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'blog_post_cat_style',
			[
				'label' => esc_html__( 'Category Settings', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'categories_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-thumb .tag' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style1',
                ],
			]
		);

		$this->add_control(
			'categories_text_color',
			[
				'label' => __( 'Categories Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-thumb .tag a' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style1',
                ],
			]
		);

		$this->add_control(
			'categories1_hover_bg_color',
			[
				'label' => __( 'Hover Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-thumb .tag:hover' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style1',
                ],
			]
		);

		$this->add_control(
			'categories1_hover_text_color',
			[
				'label' => __( 'Categories Hover Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-thumb .tag:hover a' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style1',
                ],
			]
		);

		// Style Two
		$this->add_control(
			'categories2_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-thumb-two .list-wrap li a' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style2',
                ],
			]
		);

		$this->add_control(
			'categories2_text_color',
			[
				'label' => __( 'Categories Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-thumb-two .list-wrap li a' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style2',
                ],
			]
		);

		$this->add_control(
			'categories2_hover_bg_color',
			[
				'label' => __( 'Hover Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-thumb-two .list-wrap li a:hover' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style2',
                ],
			]
		);

		$this->add_control(
			'categories2_hover_text_color',
			[
				'label' => __( 'Categories Hover Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-thumb-two .list-wrap li a:hover' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style2',
                ],
			]
		);

		// Style Three
		$this->add_control(
			'categories3_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-three .tag' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style3',
                ],
			]
		);

		$this->add_control(
			'categories3_text_color',
			[
				'label' => __( 'Categories Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-three .tag' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style3',
                ],
			]
		);

		$this->add_control(
			'categories3_hover_bg_color',
			[
				'label' => __( 'Hover Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-three .tag:hover' => 'background-color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style3',
                ],
			]
		);

		$this->add_control(
			'categories3_hover_text_color',
			[
				'label' => __( 'Categories Hover Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-three .tag:hover' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style3',
                ],
			]
		);		

		$this->end_controls_section();


		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'blog_post_dates_style',
			[
				'label' => esc_html__( 'Date Settings', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'dates_text_color',
			[
				'label' => __( 'Date Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content .post-date span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'blog_post_title_style',
			[
				'label' => esc_html__( 'Title Settings', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/* = Title Styling
		========================================*/
		$this->add_control(
			'title_font_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content .title a' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style1',
                ],
			]
		);

		$this->add_control(
			'title_font_color_hover',
			[
				'label' => __( 'Title Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content .title a:hover' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style1',
                ],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .blog-post-content .title a',
                'condition' => [
                    'select_styles' => 'style1',
                ],
			]
		);

		// Two
		$this->add_control(
			'title2_font_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-two .title' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style2',
                ],
			]
		);

		$this->add_control(
			'title2_font_color_hover',
			[
				'label' => __( 'Title Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-two .title a:hover' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style2',
                ],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title2_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .blog-post-content-two .title',
                'condition' => [
                    'select_styles' => 'style2',
                ],
			]
		);

		// Three
		$this->add_control(
			'title3_font_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-three .title' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style3',
                ],
			]
		);

		$this->add_control(
			'title3_font_color_hover',
			[
				'label' => __( 'Title Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-post-content-three .title a:hover' => 'color: {{VALUE}};',
				],
                'condition' => [
                    'select_styles' => 'style3',
                ],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title3_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .blog-post-content-three .title',
                'condition' => [
                    'select_styles' => 'style3',
                ],
			]
		);

		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'blog_post_content_style',
			[
				'label' => esc_html__( 'Content Settings', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'blog_post_content_color',
			[
				'label' => __( 'Content Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .blog-content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography(Content)', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .blog-content p',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'blog_post_meta_style',
			[
				'label' => esc_html__( 'Meta Info Settings', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'blog_meta_icon_color',
			[
				'label' => __( 'Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-meta .list-wrap li i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'blog_meta_text_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-meta .list-wrap li' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'blog_meta_link_color',
			[
				'label' => __( 'Link Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-meta .list-wrap li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'blog_meta_link_hover_color',
			[
				'label' => __( 'Link Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .blog-meta .list-wrap li a:hover' => 'color: {{VALUE}};',
				],
			]
		);


		$this->end_controls_section();

	}

	protected function render() {				//to show on the fontend 
		$settings = $this->get_settings_for_display();

		$content_excerpt    = $settings['post_excerpt'];

		if ($settings['blog_columns'] == '6') {
		  $crop_img = 'eduvalt-770-460';
		} elseif ($settings['blog_columns'] == '4') {
		  $crop_img = 'eduvalt-770-460';
		} elseif ($settings['blog_columns'] == '3') {
		  $crop_img = 'eduvalt-770-460';
		} else {
		  $crop_img = 'full';
		}

		if ( $settings['query_type'] == 'cats' && !empty( $settings['postbycats'] ) ) {
		    $args = array(
		        'post_type'      => 'post',
		        'post_status'    => 'publish',
		        'posts_per_page' => $settings['post_number'],
		        'orderby'        => $settings['post_orderby'],
		        'order'          => $settings['post_order'],
		        'tax_query' => array(
		            array(
		                'taxonomy' => 'category',
		                'field' => 'id',
		                'terms' => $settings['postbycats']
		            )
		        ),
		    );
		} elseif ( $settings['query_type'] == 'titles' && !empty( $settings['postbytitle'] ) ) {
		    $args = array(
		        'post_type'      => 'post',
		        'post_status'    => 'publish',
		        'posts_per_page' => $settings['post_number'],
		        'orderby'        => $settings['post_orderby'],
		        'order'          => $settings['post_order'],
		        'taxonomy'       => 'category',
		        'post__in'       => $settings['postbytitle']
		    );
		} else {
		    $args = array(
		        'post_type'      => 'post',
		        'post_status'    => 'publish',
		        'posts_per_page' => $settings['post_number'],
		        'orderby'        => $settings['post_orderby'],
		        'order'          => $settings['post_order'],
		        'taxonomy'       => 'category'
		    );
		}

		 
		$grid_query = new \WP_Query( $args );

		if ( $grid_query->have_posts() ) :
		?>
			<div class="row justify-content-center">


				<?php if($settings['select_styles'] == 'style4'){ ?>
					<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; ?>
	                    <div class="col-lg-<?php echo esc_attr( $settings['blog_columns'] ); ?> col-md-6 blog-shortcode">
	                        <div class="blog__post-item-four shine__animate-item">
	                        	<?php if(has_post_thumbnail()) { ?>
		                            <div class="blog__post-thumb-two">
		                                <a href="<?php the_permalink(); ?>" class="shine__animate-link">
		                                    <?php the_post_thumbnail( ); ?>
		                                </a>
		                            </div>
	                            <?php } ?>
	                            <div class="blog__post-content-two">
					            	<?php if( 'yes' == $settings['hide_post_cat'] ) { ?>
										<?php
										global $post;
										$categories = get_the_category($post->ID);
										if ( !empty( $categories[0]->name ) ) : ?>
											<a href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>" class="cat"><?php echo esc_html($categories[0]->name); ?></a>
										<?php endif; ?>
						            <?php } ?>
	                                <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
									<?php if ( !empty( $settings[ 'hide_post_admin' ] ) || !empty( $settings[ 'hide_post_comments' ] ) ) { ?>
										<ul class="list-wrap blog__post-meta">
											<?php if( 'yes' == $settings[ 'hide_post_admin' ] ) { ?>
												<li><i class="flaticon-account"></i><?php esc_html_e('By ', 'eduvalt'); ?><?php the_author_posts_link(); ?></li>
											<?php } ?>
											<?php if( 'yes' == $settings['hide_post_date'] ) { ?>
												<li><i class="flaticon-calendar-date"></i><?php echo get_the_date(); ?></li>
											<?php } ?>
										</ul>
									<?php } ?>
	                            </div>
	                        </div>
	                    </div>
				   <?php endwhile; wp_reset_postdata(); ?>
				<?php }elseif($settings['select_styles'] == 'style3'){ ?>
					<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; ?>
						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	                        <div class="blog__post-item-three shine__animate-item">
	                        	<?php if(has_post_thumbnail()) { ?>
		                            <div class="blog__post-thumb-three">
		                                <a class="shine__animate-link" href="<?php the_permalink(); ?>"><?php the_post_thumbnail( ); ?></a>
		                            </div>
	                            <?php } ?>
	                            <div class="blog__post-content-three">
					            	<?php if( 'yes' == $settings['hide_post_cat'] ) { ?>
										<?php
										global $post;
										$categories = get_the_category($post->ID);
										if ( !empty( $categories[0]->name ) ) : ?>
											<a href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>" class="cat"><?php echo esc_html($categories[0]->name); ?></a>
										<?php endif; ?>
						            <?php } ?>
	                                <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
									<?php if ( !empty( $settings[ 'hide_post_admin' ] ) || !empty( $settings[ 'hide_post_comments' ] ) ) { ?>
										<ul class="list-wrap blog__post-meta">
											<?php if( 'yes' == $settings[ 'hide_post_admin' ] ) { ?>
												<li><i class="flaticon-account"></i><?php esc_html_e('By ', 'eduvalt'); ?><?php the_author_posts_link(); ?></li>
											<?php } ?>
											<?php if( 'yes' == $settings['hide_post_date'] ) { ?>
												<li><i class="flaticon-calendar-date"></i><?php echo get_the_date(); ?></li>
											<?php } ?>
										</ul>
									<?php } ?>
	                            </div>
	                        </div>
						</article>
				   <?php endwhile; wp_reset_postdata(); ?>
				<?php }elseif($settings['select_styles'] == 'style2'){ ?>
					<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; ?>
	                    <div class="col-lg-<?php echo esc_attr( $settings['blog_columns'] ); ?> col-md-6 blog-shortcode">
	                        <div class="blog__post-item-two shine__animate-item">
	                        	<?php if(has_post_thumbnail()) { ?>
		                            <div class="blog__post-thumb-two">
		                                <a href="<?php the_permalink(); ?>" class="shine__animate-link">
		                                    <?php the_post_thumbnail( ); ?>
		                                </a>
		                            </div>
	                            <?php } ?>
	                            <div class="blog__post-content-two">
					            	<?php if( 'yes' == $settings['hide_post_cat'] ) { ?>
										<?php
										global $post;
										$categories = get_the_category($post->ID);
										if ( !empty( $categories[0]->name ) ) : ?>
											<a href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>" class="cat"><?php echo esc_html($categories[0]->name); ?></a>
										<?php endif; ?>
						            <?php } ?>
	                                <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
									<?php if ( !empty( $settings[ 'hide_post_admin' ] ) || !empty( $settings[ 'hide_post_comments' ] ) ) { ?>
										<ul class="list-wrap blog__post-meta">
											<?php if( 'yes' == $settings[ 'hide_post_admin' ] ) { ?>
												<li><i class="flaticon-account"></i><?php esc_html_e('By ', 'eduvalt'); ?><?php the_author_posts_link(); ?></li>
											<?php } ?>
											<?php if( 'yes' == $settings['hide_post_date'] ) { ?>
												<li><i class="flaticon-calendar-date"></i><?php echo get_the_date(); ?></li>
											<?php } ?>
										</ul>
									<?php } ?>
	                            </div>
	                        </div>
	                    </div>
				   <?php endwhile; wp_reset_postdata(); ?>
				<?php }else{ ?>
					<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; ?>
						<div class="col-lg-<?php echo esc_attr( $settings['blog_columns'] ); ?> col-md-6 blog-shortcode">
							<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							   <div class="blog__post-item shine__animate-item">
							      	<?php if(has_post_thumbnail()) { ?>
							         	<div class="blog__post-thumb">
							            	<a class="shine__animate-link" href="<?php the_permalink(); ?>"><?php the_post_thumbnail( ); ?></a>
							        	</div>
						         	<?php } ?>
							        <div class="blog__post-content">
						            	<?php if( 'yes' == $settings['hide_post_cat'] ) { ?>
							            	<span class="cat tag categories-info"><?php the_category(' '); ?></span>
							            <?php } ?>
										<h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
										<?php if ( !empty( $settings[ 'hide_post_admin' ] ) || !empty( $settings[ 'hide_post_comments' ] ) ) { ?>
											<ul class="list-wrap blog__post-meta">
												<?php if( 'yes' == $settings[ 'hide_post_admin' ] ) { ?>
													<li><i class="flaticon-account"></i><?php esc_html_e('By ', 'eduvalt'); ?><?php the_author_posts_link(); ?></li>
												<?php } ?>
												<?php if( 'yes' == $settings['hide_post_date'] ) { ?>
													<li><i class="flaticon-calendar-date"></i><?php echo get_the_date(); ?></li>
												<?php } ?>
											</ul>
										<?php } ?>
							        </div>
								</div>
							</article>
						</div>
				   <?php endwhile; wp_reset_postdata(); ?>
				<?php } ?>
			</div>
		<?php
		endif;   //main if end
	}
}