<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class AnimatedAbout_Image extends Widget_Base {

	public function get_name() {
		return 'animated_about_image';
	}

	public function get_title() {
		return 'About Animate Section';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-file-image';    // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//section name for controler view
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'About Animate', 'eduvalt' ),
			]
		);

        $this->add_control(
            'section_about_title',
            [
                'label' => esc_html__( 'Section Title First', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'The Leading Global', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_title_middle',
            [
                'label' => esc_html__( 'Section Title Middle', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Marketplace', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_title_last',
            [
                'label' => esc_html__( 'Section Title Last', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'For Learning And Instruction', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_sub_title',
            [
                'label' => esc_html__( 'Section Sub Title', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Borem ipsum dolor sit amet, consectetur adipiscing eliawe ellus luctus nec ullamcorper mattisBorem', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_sub_title2',
            [
                'label' => esc_html__( 'Banner Description', 'eduvalt' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Bipsum dolor awtnse awctetur adipis we followelit. Borem.Borem ipsum dolamet consectetur adipiscing eliawe awUt elit ellutnse awcon sectetur adipiscing ectetur.', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_btn1_text',
            [
                'label' => esc_html__( 'Button One Text', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Explore Courses', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_btn1_link',
            [
                'label' => __( 'Link', 'eduvalt' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

		$this->add_control(
			'anim_one_img',
			[
				'label' => esc_html__( 'Image One', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_two_img',
			[
				'label' => esc_html__( 'Image Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_three_img',
			[
				'label' => esc_html__( 'Image Three', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img',
			[
				'label' => esc_html__( 'Image Shape', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img_two',
			[
				'label' => esc_html__( 'Image Shape Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img_three',
			[
				'label' => esc_html__( 'Image Shape Three', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'full_imgstyle',
			[
				'label' => esc_html__( 'Counter style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'delay',
			[
				'label' => __( 'Counter Delay (milliseconds)', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( '10', 'eduvalt' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'time',
			[
				'label' => __( 'Counter Animation Time', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( '2000', 'eduvalt' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'img_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .expertise-img-wrap .exp-content' => 'background: {{VALUE}};',
					'{{WRAPPER}} .expertise-img-wrap .exp-box' => 'border:10px solid {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'img_text_color',
			[
				'label' => __( 'Test Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .expertise-img-wrap .exp-content h2, .expertise-img-wrap .exp-content p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .expertise-img-wrap .exp-content .icon i:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 
		$settings = $this->get_settings_for_display();
		$randID = wp_rand();
		?>
        <div class="row justify-content-center">
            <div class="col-xl-5 col-lg-6">
                <div class="about__title-wrap">
                    <div class="section__title">
                        <span class="sub-title">Who we are</span>
                        <h2 class="title tg-svg"><?php echo esc_html( $settings['section_about_title'] ); ?> <span class="position-relative"><span class="svg-icon" id="about-svg-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo esc_html( $settings['section_about_title_middle'] ); ?></span><?php echo esc_html( $settings['section_about_title_last'] ); ?></h2>
                    </div>
                    <p class="fw-medium"><?php echo esc_html( $settings['section_about_sub_title'] ); ?></p>
                    <p><?php echo esc_html( $settings['section_about_sub_title2'] ); ?></p>
                    <div class="tg-button-wrap">
                        <a href="<?php echo esc_url( $settings['section_about_btn1_link']['url'] ); ?>" class="btn tg-svg"><span class="text"><?php echo esc_html( $settings['section_about_btn1_text'] ); ?></span> <span class="svg-icon" id="about-btn" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
                    </div>
                </div>
            </div>
            <div class="col-xl-7 col-lg-6 col-md-11">
		        <div class="about__images-wrap">
		        	<?php if( !empty ( $settings['anim_one_img']['url'] ) ) : ?>
			            <div class="column">
			                <img src="<?php echo esc_url( $settings['anim_one_img']['url'] );?>" alt="img">
			            </div>
		        	<?php endif; ?>
		            <div class="column">
		            	<?php if( !empty ( $settings['anim_two_img']['url'] ) ) : ?>
		                	<img src="<?php echo esc_url( $settings['anim_two_img']['url'] );?>" alt="img">
		                <?php endif; ?>
		                <?php if( !empty ( $settings['anim_three_img']['url'] ) ) : ?>
		                	<img src="<?php echo esc_url( $settings['anim_three_img']['url'] );?>" alt="img">
		                <?php endif; ?>
		            </div>
		            <div class="about__shapes">
		            	<?php if( !empty ( $settings['anim_shape_img']['url'] ) ) : ?>
		                	<img src="<?php echo esc_url( $settings['anim_shape_img']['url'] );?>" alt="img" class="about-shape-01" data-aos="fade-down-left">
		                <?php endif; ?>
		                <?php if( !empty ( $settings['anim_shape_img_two']['url'] ) ) : ?>
		                	<img src="<?php echo esc_url( $settings['anim_shape_img_two']['url'] );?>" alt="img" class="about-shape-02" data-aos="fade-up-right">
		                <?php endif; ?>
		                <?php if( !empty ( $settings['anim_shape_img_three']['url'] ) ) : ?>
		                	<img src="<?php echo esc_url( $settings['anim_shape_img_three']['url'] );?>" alt="img" class="about-shape-03 rotateme">
		                <?php endif; ?>
		            </div>
		        </div>
            </div>
        </div>
	<?php
	}
}