<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Accordion extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-accordion';
	}

	public function get_title() {
		return 'Asked Question';   // title to show on elementor
	}

	public function get_icon() {
		return 'eicon-accordion';    //   eicon-posts-ticker-> eicon ow asche icon to show on
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}
	
   	public function get_script_depends() {
		return [ 'eduvalt-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Asked Question', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'accordion_version',
			[
				'label' => __( 'Accordion Style', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => __( 'Style 1', 'eduvalt' ),
					'2'  => __( 'Style 2', 'eduvalt' ),
				],
			]
		);


		$repeater = new Repeater();

		$repeater->add_control(
			'accordion_title', [
				'label' => __( 'Faq Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Faq Title Here..' , 'eduvalt' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'accordion_text', [
				'label' => __( 'Faq Description', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.' , 'eduvalt' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'accordion_activate', [
				'label' => __( 'Active Faq', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'deactivate',
				'options' => [
					'active'  => __( 'Yes', 'eduvalt' ),
					'deactivate'  => __( 'No', 'eduvalt' ),
				],
			]
		);


		$this->add_control(
			'accordion_items',
			[
				'label' => __( 'Accordion Items', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'accordion_title' => __( 'Faq Title Here..', 'eduvalt' ),
						'accordion_text' => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat', 'eduvalt' ),
					]
				],
				'title_field' => '{{{ accordion_title }}}',
			]
		);

		$this->end_controls_section();

		/* = Item Title Styling
		========================================*/
		$this->start_controls_section(
			'accordion_title_style',
			[
				'label' => esc_html__( 'Accordion Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#082a5e',
				'selectors' => [
					'{{WRAPPER}} .faq-wrap .accordion-item .accordion-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_icon_color',
			[
				'label' => __( 'Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#1363DF',
				'selectors' => [
					'{{WRAPPER}} .faq-wrap .accordion-button::after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_active_color',
			[
				'label' => __( 'Title Active Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .faq-wrap .accordion-button:not(.collapsed)' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_icon_active_color',
			[
				'label' => __( 'Icon Active Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0554F2',
				'selectors' => [
					'{{WRAPPER}} .faq-wrap .accordion-button:not(.collapsed)::after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .faq-wrap .accordion-item .accordion-button',
			]
		);
		
		$this->end_controls_section();

		/* = Item Icon Styling
		========================================*/
		$this->start_controls_section(
			'accordion_icon_style',
			[
				'label' => esc_html__( 'Accordion Description Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'right_icon_bg_color',
			[
				'label' => __( 'Description Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .faq-wrap .accordion-body' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .faq-wrap .accordion-body',
			]
		);
		
		$this->end_controls_section();
	}

	protected function render() { // to show on the fontend 
		$settings = $this->get_settings_for_display();
		$i = 0;

		if ( $settings['accordion_items'] ) {
		?>
			<div class="faq-wrap">
	            <div class="tab-content" id="myTabContent">
	            	<?php foreach ( $settings['accordion_items'] as $key => $value ) {
	            		$i++;
	            		$active = 'collapsed';
	            		$show = '';
	            		if ( 'active' === $value['accordion_activate'] ) {
	            			$active = '';
	            			$show = 'show';
	            		}
	            		?>
		                <div class="accordion-item">
		                    <h2 class="accordion-header" id="heading<?php echo $i; ?>">
		                        <button  class="accordion-button <?php echo esc_attr( $active ); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse<?php echo $i; ?>">
		                            <?php echo $value['accordion_title']; ?>
		                        </button>
		                    </h2>
		                    <div id="collapse<?php echo $i; ?>" class="collapse <?php echo esc_attr( $show ); ?>" aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#myTabContent">
		                        <div class="accordion-body">
		                            <p><?php echo $value['accordion_text']; ?></p>
		                        </div>
		                    </div>
		                </div>
	                <?php } ?>
	            </div>
	        </div>
    	<?php 
    	}
	}
}