<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_About_Section extends Widget_Base {

	public function get_name() {
		return 'section_about_section';
	}

	public function get_title() {
		return 'About Section';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-file-image';    // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//section name for controler view
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'About Section', 'eduvalt' ),
			]
		);

		$this->add_control(
			'section_about_title',
			[
				'label' => esc_html__( 'Section Title', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '',
			]
		);

		$this->add_control(
			'section_about_sub_title',
			[
				'label' => esc_html__( 'Section Sub Title', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '',
			]
		);

		$this->add_control(
			'section_about_description',
			[
				'label' => esc_html__( 'Section Description', 'eduvalt' ),
				'type'  => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => '',
			]
		);

		$repeater = new Repeater();
        $repeater->add_control(
            'checkbox_item_title', [
                'label' => __( 'Checkbox Description', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Checkbox Description' , 'eduvalt' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'checkbox_item_sub_icon', [
                'label' => __( 'Checkbox Icon', 'eduvalt' ),
                'type' => Controls_Manager::ICON,
                'default' => 'fas fa-check-square',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_checkbox_items',
            [
                'label' => __( 'Add Checkbox List', 'eduvalt' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

		$this->add_control(
			'anim_counter_title',
			[
				'label' => esc_html__( 'Counter Number', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '32',
			]
		);

		$this->add_control(
			'anim_countersub_title',
			[
				'label' => esc_html__( 'Counter Title', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'years Of Experience',
			]
		);

		$this->add_control(
			'anim_countersub_number',
			[
				'label' => esc_html__( 'Phone Number', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'anim_one_img',
			[
				'label' => esc_html__( 'Image One', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'img_one_animation',
			[
				'label' => __( 'Image One Animation', 'eduvalt' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'img_one_animation_delay',
			[
				'label' => __( 'Image One Animation Delay', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'anim_two_img',
			[
				'label' => esc_html__( 'Image Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'img_two_animation',
			[
				'label' => __( 'Image Two Animation', 'eduvalt' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'img_two_animation_delay',
			[
				'label' => __( 'Image Two Animation Delay', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'anim_three_img',
			[
				'label' => esc_html__( 'Image Three', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'img_three_animation',
			[
				'label' => __( 'Image Three Animation', 'eduvalt' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'img_three_animation_delay',
			[
				'label' => __( 'Image Three Animation Delay', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'anim_four_img',
			[
				'label' => esc_html__( 'Image Four', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'img_four_animation',
			[
				'label' => __( 'Image Four Animation', 'eduvalt' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'img_four_animation_delay',
			[
				'label' => __( 'Image Four Animation Delay', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'anim_shape_img',
			[
				'label' => esc_html__( 'Image Shape', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->end_controls_section();


		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_main_style',
			[
				'label' => esc_html__( 'Section Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_responsive_control(
            'section_title_color',
            [
                'label' => __( 'Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .support-area .support-content .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_sub_title_color',
            [
                'label' => __( 'Sub Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .support-area .support-content .section-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_sub_title_line_color',
            [
                'label' => __( 'Sub Title Line Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .support-area .support-content .section-title span:before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_contents_color',
            [
                'label' => __( 'Content Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .support-area .support-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_check_icon_text_color',
            [
                'label' => __( 'Check List Text Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .support-list .list-wrap li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_check_icon_bg_color',
            [
                'label' => __( 'Check List Icon Bg Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .support-list .list-wrap li i' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();


		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_experience_style',
			[
				'label' => esc_html__( 'Experience Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_responsive_control(
            'section_experience_bg_color',
            [
                'label' => __( 'Experience Background Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .work-experience' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_experience_number_color',
            [
                'label' => __( 'Experience Number Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .work-experience .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_experience_title_color',
            [
                'label' => __( 'Experience Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .work-experience span' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 

		$settings = $this->get_settings_for_display();

		// one image animation
		if (!empty( $settings['img_one_animation'] )) {
			$img_one_anim = 'data-wow-delay="'.esc_attr( $settings['img_one_animation_delay'] ).'"';
		} else {
			$img_one_anim = '';	
		}

		if ( ! empty( $settings['img_one_animation'] ) ) {
			$this->add_render_attribute( 'img-one', 'class', 'wow ' . $settings['img_one_animation'] );
		}

		// two image animation
		if (!empty( $settings['img_two_animation'] )) {
			$img_two_anim = 'data-wow-delay="'.esc_attr( $settings['img_two_animation_delay'] ).'"';
		} else {
			$img_two_anim = '';	
		}

		if ( ! empty( $settings['img_two_animation'] ) ) {
			$this->add_render_attribute( 'img-two', 'class', 'wow ' . $settings['img_two_animation'] );
		}

		// Three image animation
		if (!empty( $settings['img_three_animation'] )) {
			$img_three_anim = 'data-wow-delay="'.esc_attr( $settings['img_three_animation_delay'] ).'"';
		} else {
			$img_three_anim = '';	
		}

		if ( ! empty( $settings['img_three_animation'] ) ) {
			$this->add_render_attribute( 'img-three', 'class', 'wow ' . $settings['img_three_animation'] );
		}

		?>

        <section class="support-area">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-6 order-0 order-lg-2">
                        <div class="support-img-wrap">
                        	<?php if( !empty ( $settings['anim_one_img']['url'] ) ) : ?>
								<img src="<?php echo esc_attr( $settings['anim_one_img']['url'] );?>" alt="Animate Image" class="wow fadeInDown" data-wow-delay=".2s">
							<?php endif; ?>
							<?php if( !empty ( $settings['anim_two_img']['url'] ) ) : ?>
								<img src="<?php echo esc_attr( $settings['anim_two_img']['url'] );?>" alt="Animate Image" class="wow fadeInRight" data-wow-delay=".3s">
							<?php endif; ?>
							<?php if( !empty ( $settings['anim_three_img']['url'] ) ) : ?>
								<img src="<?php echo esc_attr( $settings['anim_three_img']['url'] );?>" alt="Animate Image" class="wow fadeInLeft" data-wow-delay=".4s">
							<?php endif; ?>
							<?php if( !empty ( $settings['anim_four_img']['url'] ) ) : ?>
								<img src="<?php echo esc_attr( $settings['anim_four_img']['url'] );?>" alt="Animate Image" class="wow fadeInUp" data-wow-delay=".5s">
							<?php endif; ?>
				            <div class="work-experience wow zoomIn" data-wow-delay=".6s">
				                <h2 class="title"><?php echo esc_html( $settings['anim_counter_title'] ); ?></h2>
				                <span><?php echo esc_html( $settings['anim_countersub_title'] ); ?></span>
				            </div>
				            <?php if( !empty ( $settings['anim_shape_img']['url'] ) ) : ?>
					            <div class="support-shape">
					            	<img src="<?php echo esc_attr( $settings['anim_shape_img']['url'] );?>">
					            </div>
				            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="support-content wow fadeInLeft" data-wow-delay=".2s">
                            <div class="section-title mb-25 tg-heading-subheading animation-style2">
                                <span class="sub-title tg-element-title"><?php echo esc_html( $settings['section_about_sub_title'] ); ?></span>
                                <h2 class="title tg-element-title"><?php echo esc_html( $settings['section_about_title'] ); ?></h2>
                            </div>
                            <p><?php echo esc_html( $settings['section_about_description'] ); ?></p>
                            <?php if ( $settings['section_about_checkbox_items'] ) : ?>
                                <div class="support-list">
                                    <ul class="list-wrap">
                                    	<?php foreach ( $settings['section_about_checkbox_items'] as $key => $value ) : ?>
                                        	<li><i class="<?php echo esc_attr( $value['checkbox_item_sub_icon'] );?>"></i><?php echo esc_attr( $value['checkbox_item_title'] );?></li>
                                    	<?php endforeach; ?>
                                    </ul>
                                </div>
                        	<?php endif; ?>
                            <div class="support-contact">
                                <div class="icon pulse">
                                    <i class="flaticon-phone-call"></i>
                                </div>
                                <a href="tel:<?php echo esc_attr( str_replace(" ","",( $settings['anim_countersub_number'] )) ); ?>"><?php echo esc_html( $settings['anim_countersub_number'] ); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
	<?php 
	}
}