<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Contact_Box extends Widget_Base {

	public function get_name() {
		return 'contact-box';
	}

	public function get_title() {
		return 'Contact Box';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-address-card'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Contact Box Info', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'item_title',
			[
				'label' => esc_html__( 'Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'item_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
		   'item_icon',
		   [
	      'label' => esc_html__( 'Contact Icon', 'eduvalt' ),
	      'type' => Controls_Manager::ICON,
			'label_block' => true,
		   ]
		);

		$repeater->add_control(
		   'item_title',
		   [
		   'label' => esc_html__( 'Contact Info One', 'eduvalt' ),
		   'type' => Controls_Manager::TEXT,
			'label_block' => true,
		   ]
		);

		$repeater->add_control(
		   'sub_title',
		   [
		   'label' => esc_html__( 'Contact Info Two', 'eduvalt' ),
		   'type' => Controls_Manager::TEXT,
			'label_block' => true,
		   ]
		);

		$this->add_control(
		   'contact_list_items',
		   [
		       'label' => esc_html__( 'Add Item List', 'eduvalt' ),
		       'type' => Controls_Manager::REPEATER,
		       'fields' => $repeater->get_controls(),
		   ]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'eduvalt' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'eduvalt' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'eduvalt' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'eduvalt' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-left',
				'toggle' => true,
			]
		);

		$this->end_controls_section();
		//End of a control box

		/* = Item Styling
		========================================*/
		$this->start_controls_section(
			'full_item_style',
			[
				'label' => esc_html__( 'Item Title Settings', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'title_color',
			[
				'label' => __( 'Item Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .contact-info-wrap .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_line_color',
			[
				'label' => __( 'Item Title Line Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .contact-info-wrap .title::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .contact-info-wrap .title',
			]
		);

		$this->add_responsive_control(
			'title_text_color',
			[
				'label' => __( 'Sub Title Text color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .contact-info-wrap > p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tabs();
		$this->end_controls_section();

		/* = Item Styling
		========================================*/
		$this->start_controls_section(
			'contact_list_item_style',
			[
				'label' => esc_html__( 'List Item Style Settings', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'contact_icon_bg_color',
			[
				'label' => __( 'Icon Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .contact-info-wrap .list-wrap li .icon' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'contact_icon_color',
			[
				'label' => __( 'Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .contact-info-wrap .list-wrap li .icon i.ficon:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'contact_icon_text_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .contact-info-wrap .list-wrap li .content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();		

	}
	//end of control box 

	//to show on the fontend
	protected function render() {
		$settings = $this->get_settings_for_display();
	?>
        <div class="contact-info-wrap">
			<?php if ( !empty( $settings['item_title'] ) ) : ?>
				<h2 class="title"><?php echo esc_html( $settings['item_title'] ); ?></h2>
			<?php endif; ?>
			<?php if ( !empty( $settings['item_sub_title'] ) ) : ?>
				<p><?php echo esc_html( $settings['item_sub_title'] ); ?></p>
			<?php endif; ?>
            <?php if ( $settings['contact_list_items'] ) : ?>
                <ul class="list-wrap">
                	<?php foreach( $settings['contact_list_items'] as $contact_list ) : ?>
                        <li>
                            <div class="icon">
                                <i class="<?php echo esc_html( $contact_list['item_icon'] );?>"></i>
                            </div>
                            <div class="content">
                                <p><?php echo esc_html( $contact_list['item_title'] );?> <br> <?php echo esc_html( $contact_list['sub_title'] );?></p>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>
	<?php
	}
}