<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class CallAction_Button extends Widget_Base {

	public function get_name() {
		return 'callaction-button';
	}

	public function get_title() {
		return 'Call to Action'; // title to show on eduvalt
	}

	public function get_icon() {
		return 'eicon-image-rollover'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ]; // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Call to Action Content', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'item_title',
			[
				'label' => esc_html__( 'Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '50% Offer For Very First 50', 'eduvalt'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'item_title_two',
			[
				'label' => esc_html__( 'Title Two', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Student’s & Mentors', 'eduvalt'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'item_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'ARE YOU READY FOR THIS OFFER', 'eduvalt'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'item_btn1_title',
			[
				'label' => esc_html__( 'Button Text', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Become A Student', 'eduvalt'),
				'label_block' => true,			
			]
		);

		$this->add_control(
			'item_btn1_link',
			[
				'label' => esc_html__( 'Button link', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '',
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'eduvalt' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'eduvalt' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'eduvalt' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'eduvalt' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);
		
		$this->end_controls_section();
		//End  of a control box
		
		//start of a control box
		$this->start_controls_section(
			'section_bgtab',
			[
				'label' => esc_html__( 'Call to Action Background', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'item_bg_images',
			[
				'label' => esc_html__( 'Upload Background Image', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'item_bg_one',
			[
				'label' => esc_html__( 'Upload Shape Image One', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'item_bg_two',
			[
				'label' => esc_html__( 'Upload Shape Image Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'item_bg_three',
			[
				'label' => esc_html__( 'Upload Shape Image Three', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();
		//End  of a control box

		/* = Item Styling
		========================================*/
		$this->start_controls_section(
			'item_title_style',
			[
				'label' => esc_html__( 'Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_title_style' );

		$this->add_responsive_control(
			'title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .cta__content h2.title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_two_color',
			[
				'label' => __( 'Title Two Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .cta__content .sub-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .cta__content h2.title',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		/* = Item Styling
		========================================*/
		$this->start_controls_section(
			'item_subtitle_style',
			[
				'label' => esc_html__( 'Sub Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_subtitle_style' );

		$this->add_responsive_control(
			'subtitle_color',
			[
				'label' => __( 'Sub Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .cta__content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'subtitle_two_color',
			[
				'label' => __( 'Sub Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0a174c',
				'selectors' => [
					'{{WRAPPER}} .advice-call-area .free-quote-content h6' => 'color: {{VALUE}};',
				],
				'condition' => [
					'calltoaction_version' => '2',
				],	
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .cta-inner-wrap .section-title h6.sub-title',
				'condition' => [
					'calltoaction_version' => '1',
				],	
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_two_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .advice-call-area .free-quote-content h6',
				'condition' => [
					'calltoaction_version' => '2',
				],	
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 
		$settings = $this->get_settings_for_display();
		$randID = wp_rand();
		?>

        <section class="cta-area-two position-relative">
        	<?php if( !empty ( $settings['item_bg_images']['url'] ) ) : ?>
            	<div class="cta__bg" style="background-image:url(<?php echo $settings['item_bg_images']['url']; ?>)"></div>
        	<?php endif; ?>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-8 col-lg-10">
                        <div class="cta__content">
                            <p><?php echo $settings['item_sub_title']; ?></p>
                            <h2 class="title"><?php echo $settings['item_title']; ?></h2>
                            <h5 class="sub-title"><?php echo $settings['item_title_two']; ?></h5>
                            <div class="tg-button-wrap justify-content-center">
                                <a href="contact.html" class="btn tg-svg"><span class="text"><?php echo $settings['item_btn1_title']; ?></span> <span class="svg-icon" id="cta-btn-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="cta__shapes">
            	<?php if( !empty ( $settings['item_bg_one']['url'] ) ) : ?>
                	<img src="<?php echo esc_attr( $settings['item_bg_one']['url'] ); ?>" alt="img" class="position-absolute" data-aos="fade-down-right" data-aos-delay="300">
                <?php endif; ?>
                <?php if( !empty ( $settings['item_bg_two']['url'] ) ) : ?>
                	<img src="<?php echo esc_attr( $settings['item_bg_two']['url'] ); ?>" alt="img" class="position-absolute">
                <?php endif; ?>
                <?php if( !empty ( $settings['item_bg_three']['url'] ) ) : ?>
                	<img src="<?php echo esc_attr( $settings['item_bg_three']['url'] ); ?>" alt="img" class="position-absolute" data-aos="fade-up-left" data-aos-delay="300">
                <?php endif; ?>
            </div>
        </section>

	<?php
	}
}