<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Eduvalt_Button extends Widget_Base {

	public function get_name() {
		return 'eduvalt-button';
	}

	public function get_title() {
		return 'Eduvalt Button';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-link';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor

	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Eduvalt Button', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			  'button_styles',
			  [
			     'label'   => __( 'Button Style', 'eduvalt' ),
			     'type'    => Controls_Manager::SELECT,
			     'default' => 'style1',
			     'options' => [
					'style1' => __( 'Button Style 1', 'eduvalt' ),
					'style2' => __( 'Button Style 2', 'eduvalt' ),
					'style3' => __( 'Button Style 3', 'eduvalt' ),
			     ],
			  ]
		);

		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Button text', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Apply Here',
			]
		);

		$this->add_control(
			'button_link',
			[
				'label' => __( 'Link', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_responsive_control(
			'btn_align',
			[
				'label' => __( 'Alignment', 'eduvalt' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => __( 'Left', 'eduvalt' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'eduvalt' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'eduvalt' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => __( 'Justified', 'eduvalt' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'default' => '',
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Eduvalt Button Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'eduvalt' ),
			]
		);

		$this->add_responsive_control(
			'btn_font_color',
			[
				'label' => __( 'Font color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .tg-button-wraps .btn.btn-border' => 'color: {{VALUE}};',
					'{{WRAPPER}} .eduvalt-button-wrappers a.btn.btn-two' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_line_color',
			[
				'label' => __( 'Icon color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .btn.btn-borders svg path' => 'stroke: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'service_title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} a.eduvalt.btn',
			]
		);

		$this->add_responsive_control(
			'btn_bg_color',
			[
				'label' => __( 'Background color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#1363df',
				'selectors' => [
					'{{WRAPPER}} .tg-button-wraps .btn.btn-border' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .eduvalt-button-wrappers a.btn.btn-two' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_border_color',
			[
				'label' => __( 'Border color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#1363df',
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .tg-button-wraps .btn.btn-border' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_border_radius',
			[
				'label' => __( 'Border radius', 'eduvalt' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' 		=> '25',
					'right' 	=> '25',
					'bottom' 	=> '25',
					'left' 		=> '25',
				],
				'selectors' => [
					'{{WRAPPER}} a.eduvalt.btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		/* = Button Hover Styling
		========================================*/
		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'eduvalt' ),
			]
		);

		$this->add_control(
			'hover_heading',
			[
				'label' => __( 'Hover State', 'eduvalt' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'btn_h_font_color',
			[
				'label' => __( 'Font color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .eduvalt-button-wrapper a.btn:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .eduvalt-button-wrapper a.btn.btn-two:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_line_h_color',
			[
				'label' => __( 'Line color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .eduvalt-button-wrapper a.btn.btn-two:hover span::after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'btn_h_bg_color',
			[
				'label' => __( 'Background color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .eduvalt-button-wrapper a.btn::after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .eduvalt-button-wrapper a.btn.btn-two::after' => 'background-color: {{VALUE}};',
				],
			]
		);
		
	}
	//end of control box 

	//to show on the fontend
	protected function render() {  
		
		$settings = $this->get_settings_for_display();
		$target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : '';
		$randID = wp_rand();
		?>

		<?php if ( $settings['button_styles'] == 'style3' ) { ?>
            <div class="tg-button-wrap mt-4 mt-lg-0 justify-content-center justify-content-lg-end">
                <a href="<?php echo $settings['button_link']['url']; ?>" <?php echo $target; ?> <?php echo $nofollow; ?> class="btn tg-svg"><span class="text"><?php echo $settings['button_text']; ?></span> <span class="svg-icon" id="svg-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
            </div>

		<?php }elseif ( $settings['button_styles'] == 'style2' ) { ?>
            <div class="tg-button-wrap mt-4 mt-lg-0">
                <a href="<?php echo $settings['button_link']['url']; ?>" <?php echo $target; ?> <?php echo $nofollow; ?> class="btn tg-svg"><span class="text"><?php echo $settings['button_text']; ?></span> <span class="svg-icon" id="svg-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
            </div>
		<?php }else{ ?>
            <div class="tg-button-wrap mt-4 mt-lg-0 justify-content-center justify-content-lg-end <?php echo esc_attr( $settings['btn_align'] ); ?>">
                <a href="<?php echo $settings['button_link']['url']; ?>" <?php echo $target; ?> <?php echo $nofollow; ?> class="btn btn-border tg-svg"><span class="text"><?php echo $settings['button_text']; ?></span> <span class="svg-icon" id="svg-1<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
            </div>
		<?php } ?>
		<?php
	}
}

