<?php
namespace Eduvalt;  //main namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $void_widgets;
$void_widgets= array_map('basename', glob(dirname( __FILE__ ) . '/widgets/*.php'));

/* - Path define same as class name of the widget
====================================================================================================*/
use Eduvalt\Widgets\Section_Head_Two;
use Eduvalt\Widgets\Slider_Banner;
use Eduvalt\Widgets\Slider_Banner_Three;
use Eduvalt\Widgets\SliderStyleTwo;
use Eduvalt\Widgets\Section_About_Section;
use Eduvalt\Widgets\Section_About_Two;
use Eduvalt\Widgets\Working_Steps;
use Eduvalt\Widgets\Working_Process;
use Eduvalt\Widgets\Fun_Facts;
use Eduvalt\Widgets\Video_Area_Section;
use Eduvalt\Widgets\Section_Testimonial;
use Eduvalt\Widgets\Section_Mission;
use Eduvalt\Widgets\Eduvalt_Button;
use Eduvalt\Widgets\Single_Counter;
use Eduvalt\Widgets\Section_Single_Team;
use Eduvalt\Widgets\Section_Accordion;
use Eduvalt\Widgets\Animated_Image;
use Eduvalt\Widgets\AnimatedAbout_Image;
use Eduvalt\Widgets\Animated_Home_Image;
use Eduvalt\Widgets\Contact_Box;
use Eduvalt\Widgets\Section_Quote;
use Eduvalt\Widgets\CallAction_Button;
use Eduvalt\Widgets\Section_Newsletter;
use Eduvalt\Widgets\Checkbox_Lists;
use Eduvalt\Widgets\Brand_Slider;
use Eduvalt\Widgets\Lp_Course_Grid;
use Eduvalt\Widgets\Tutor_Course_Grid;
use Eduvalt\Widgets\Tutor_Course_Categoreis;
use Eduvalt\Widgets\Eduvalt_Shape;
use Eduvalt\Widgets\Section_Counter_List;
use Eduvalt\Widgets\Section_Promotion;
use Eduvalt\Widgets\Section_Events;
use Eduvalt\Widgets\Contact_Cf7;
use Eduvalt\Widgets\Section_Blog;

/* - End Of path define same as class name of the widget
====================================================================================================*/

/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class Plugin {
	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	
	public function __construct() {
		$this->add_actions();
		add_action('elementor/controls/controls_registered', array( $this, 'pickelements_icon_pack' ), 11 );
		add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
	}

	/**
     * Enqueue editor styles
     *
     * @return void
     */

   public function editor_enqueue_styles() {
      wp_enqueue_style( 'eduvalt-elements-editor', EDUVALT_PLG_URL.'assets/css/eduvalt-admin-style.css',null, EDUVALT );
      wp_enqueue_style( 'eduvalt-icon-elementor', EDUVALT_PLG_URL.'assets/css/fontawesome-all.min.css',null, EDUVALT );
   }


	/**
     * Extend Icon pack core controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
     */

   public function pickelements_icon_pack( $controls_manager ) {
   	require_once EDUVALT_PLG_DIR. '/eduvalt-elements/controls/pickelements-icon.php';
      $controls = array(
      	$controls_manager::ICON => 'Eduvalt_Icon_Controler',
      );
      foreach ( $controls as $control_id => $class_name ) {
      	$controls_manager->unregister_control( $control_id );
      	$controls_manager->register_control( $control_id, new $class_name() );
      }
   }

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function add_actions() {
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'on_widgets_registered' ] );
		add_action( 'elementor/frontend/after_register_scripts', function() {
			wp_register_script( 'eduvalt-elementor-editor', plugins_url( '../assets/js/eduvalt-elementor-editor.js', __FILE__), [ 'jquery' ], true, true );
		} );
	}

	/**
	 * On Widgets Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function on_widgets_registered() {
		$this->includes();
		$this->register_widget();
	}

	/**
	 * Includes
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function includes() {
		global $void_widgets;              //include the widgets here
		foreach($void_widgets as $key => $value){
   		require __DIR__ . '/widgets/'.$value;
		}
	}

	/* - Register all elements widget
	====================================================================================================*/

	/**
	 * Register Widget
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function register_widget() {   
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Head_Two() );
      \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Slider_Banner() );
      \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Slider_Banner_Three() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SliderStyleTwo() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_About_Section() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_About_Two() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Working_Steps() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Working_Process() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Fun_Facts() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Video_Area_Section() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Testimonial() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Mission() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Eduvalt_Button() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Single_Counter() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Single_Team() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Accordion() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Animated_Image() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new AnimatedAbout_Image() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Animated_Home_Image() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Contact_Box() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Quote() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new CallAction_Button() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Newsletter() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Checkbox_Lists() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Brand_Slider() );
		if ( class_exists( 'LearnPress' ) ) {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Lp_Course_Grid() );
		}
		if ( function_exists('tutor')) {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Tutor_Course_Grid() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Tutor_Course_Categoreis() );
		}
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Eduvalt_Shape() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Counter_List() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Promotion() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Events() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Contact_Cf7() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Blog() );
	}
}
new Plugin();