<?php 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
/* - For Custom Icon Loading
==========================================================*/
function custom_get_flat_icons() {
  return [
    /* - Flat Icons*/
    'eduvalt-flaticon flaticon-briefcase'=>'flaticon-briefcase',
    'eduvalt-flaticon flaticon-check'=>'flaticon-check',
    'eduvalt-flaticon flaticon-dslr-camera'=>'flaticon-dslr-camera',
    'eduvalt-flaticon flaticon-earth-globe'=>'flaticon-earth-globe',
    'eduvalt-flaticon flaticon-email'=>'flaticon-email',
    'eduvalt-flaticon flaticon-family-insurance'=>'flaticon-family-insurance',
    'eduvalt-flaticon flaticon-file'=>'flaticon-file',
    'eduvalt-flaticon flaticon-heart'=>'flaticon-heart',
    'eduvalt-flaticon flaticon-home-insurance'=>'flaticon-home-insurance',
    'eduvalt-flaticon flaticon-idea'=>'flaticon-idea',
    'eduvalt-flaticon flaticon-insurance'=>'flaticon-insurance',
    'eduvalt-flaticon flaticon-left-arrow'=>'flaticon-left-arrow',
    'eduvalt-flaticon flaticon-life-guard'=>'flaticon-life-guard',
    'eduvalt-flaticon flaticon-location'=>'flaticon-location',
    'eduvalt-flaticon flaticon-loupe'=>'flaticon-loupe',
    'eduvalt-flaticon flaticon-maps-and-location'=>'flaticon-maps-and-location',
    'eduvalt-flaticon flaticon-marketing'=>'flaticon-marketing',
    'eduvalt-flaticon flaticon-message'=>'flaticon-message',
    'eduvalt-flaticon flaticon-open-email'=>'flaticon-open-email',
    'eduvalt-flaticon flaticon-phone-call'=>'flaticon-phone-call',
    'eduvalt-flaticon flaticon-pie-chart-1'=>'flaticon-pie-chart-1',
    'eduvalt-flaticon flaticon-pie-chart'=>'flaticon-pie-chart',
    'eduvalt-flaticon flaticon-placeholder'=>'flaticon-placeholder',
    'eduvalt-flaticon flaticon-play-1'=>'flaticon-play-1',
    'eduvalt-flaticon flaticon-play'=>'flaticon-play',
    'eduvalt-flaticon flaticon-protection'=>'flaticon-protection',
    'eduvalt-flaticon flaticon-quotation'=>'flaticon-quotation',
    'eduvalt-flaticon flaticon-renewable'=>'flaticon-renewable',
    'eduvalt-flaticon flaticon-right-arrow'=>'flaticon-right-arrow',
    'eduvalt-flaticon flaticon-right-down'=>'flaticon-right-down',
    'eduvalt-flaticon flaticon-right-up'=>'flaticon-right-up',
    'eduvalt-flaticon flaticon-rocket'=>'flaticon-rocket',
    'eduvalt-flaticon flaticon-send'=>'flaticon-send',
    'eduvalt-flaticon flaticon-trophy'=>'flaticon-trophy',
    'eduvalt-flaticon flaticon-user'=>'flaticon-user',
    'eduvalt-flaticon flaticon-view'=>'flaticon-view',
  ];
}

function custom_get_flat_icons_includes() {
  return [
    /* - Flat Icons*/
    'eduvalt-flaticon flaticon-briefcase',
    'eduvalt-flaticon flaticon-check',
    'eduvalt-flaticon flaticon-dslr-camera',
    'eduvalt-flaticon flaticon-earth-globe',
    'eduvalt-flaticon flaticon-email',
    'eduvalt-flaticon flaticon-family-insurance',
    'eduvalt-flaticon flaticon-file',
    'eduvalt-flaticon flaticon-heart',
    'eduvalt-flaticon flaticon-home-insurance',
    'eduvalt-flaticon flaticon-idea',
    'eduvalt-flaticon flaticon-insurance',
    'eduvalt-flaticon flaticon-left-arrow',
    'eduvalt-flaticon flaticon-life-guard',
    'eduvalt-flaticon flaticon-location',
    'eduvalt-flaticon flaticon-loupe',
    'eduvalt-flaticon flaticon-maps-and-location',
    'eduvalt-flaticon flaticon-marketing',
    'eduvalt-flaticon flaticon-message',
    'eduvalt-flaticon flaticon-open-email',
    'eduvalt-flaticon flaticon-phone-call',
    'eduvalt-flaticon flaticon-pie-chart-1',
    'eduvalt-flaticon flaticon-pie-chart',
    'eduvalt-flaticon flaticon-placeholder',
    'eduvalt-flaticon flaticon-play-1',
    'eduvalt-flaticon flaticon-play',
    'eduvalt-flaticon flaticon-protection',
    'eduvalt-flaticon flaticon-quotation',
    'eduvalt-flaticon flaticon-renewable',
    'eduvalt-flaticon flaticon-right-arrow',
    'eduvalt-flaticon flaticon-right-down',
    'eduvalt-flaticon flaticon-right-up',
    'eduvalt-flaticon flaticon-rocket',
    'eduvalt-flaticon flaticon-send',
    'eduvalt-flaticon flaticon-trophy',
    'eduvalt-flaticon flaticon-user',
    'eduvalt-flaticon flaticon-view',
  ];
}
function font_weight() {
  return [
    '100' => __( '100', 'eduvalt' ),
    '200' => __( '200', 'eduvalt' ),
    '300' => __( '300', 'eduvalt' ),
    '400' => __( '400', 'eduvalt' ),
    '500' => __( '500', 'eduvalt' ),
    '600' => __( '600', 'eduvalt' ),
    '700' => __( '700', 'eduvalt' ),
    '800' => __( '800', 'eduvalt' ),
    '900' => __( '900', 'eduvalt' ),
  ];
}

function ifinger_post_orderby_options(){
    $orderby = array(
        'ID' => 'Post Id',
        'author' => 'Post Author',
        'title' => 'Title',
        'date' => 'Date',
        'modified' => 'Last Modified Date',
        'parent' => 'Parent Id',
        'rand' => 'Random',
        'comment_count' => 'Comment Count',
        'menu_order' => 'Menu Order',
    );
    return $orderby;
}

/**  Shortcodes | Image compatibility.
--------------------------------------------------------------------------------------------------- */
function ifinger_grid_columns() {
  return [
    '6'=>'Columns 2',
    '4'=>'Columns 3',
    '3'=>'Columns 4',
  ];
}

/**  Shortcodes | Image compatibility.
--------------------------------------------------------------------------------------------------- */
function ifinger_anim_delay() {
  return [
    '0.2s'=>'0.2s',
    '0.3s'=>'0.3s',
    '0.4s'=>'0.4s',
    '0.5s'=>'0.5s',
    '0.6s'=>'0.6s',
    '0.7s'=>'0.7s',
    '0.8s'=>'0.8s',
    '1s'=>'1s',
    '1.2s'=>'1.2s',
    '1.4s'=>'1.4s',
    '1.6s'=>'1.6s',
    '1.8s'=>'1.8s',
    '2s'=>'2s',
    '2.2s'=>'2.2s',
    '2.4s'=>'2.4s',
    '2.6s'=>'2.6s',
    '2.8s'=>'2.8s',
    '3s'=>'3s',
    '3.2s'=>'3.2s',
    '3.4s'=>'3.4s',
    '3.6s'=>'3.6s',
    '3.8s'=>'3.8s'
  ];
}

if ( ! function_exists( 'eduvalt_get_terms_dropdown_array' ) ) :

  // get terms dropdown
  function eduvalt_get_terms_dropdown_array($args = [], $key = 'term_id', $value = 'name') {
    $options = [];
    $terms = get_terms($args);

    if (is_wp_error($terms)) {
      return [];
    }

    foreach ((array) $terms as $term) {
      $options[$term->{$key}] = $term->{$value};
    }
    return $options;
  }
  
endif;

if ( ! function_exists( 'blog_posts_title' ) ) :
  // get terms dropdown
  function blog_posts_title() {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'taxonomy'       => 'category'
    );
    $post_title = array();
    $grid_query = new \WP_Query( $args );
    if ( $grid_query->have_posts() ) : 
        while ( $grid_query->have_posts() ) : $grid_query->the_post();
        $post_title[get_the_ID()] = get_the_title();
        endwhile; wp_reset_postdata();
    endif;
    return $post_title;
  }
  
endif;

if ( ! function_exists( 'eduvalt_get_cf7_forms' ) ) {
    /**
     * Get a list of all CF7 forms
     *
     * @return array
     */
    function eduvalt_get_cf7_forms() {
        $forms = get_posts( [
            'post_type'      => 'wpcf7_contact_form',
            'post_status'    => 'publish',
            'posts_per_page' => -1,
            'orderby'        => 'title',
            'order'          => 'ASC',
        ] );

        if ( ! empty( $forms ) ) {
            return wp_list_pluck( $forms, 'post_title', 'ID' );
        }
        return [];
    }
}