<?php

add_action( 'cmb2_admin_init', 'dexon_metabox' );
/*
**	Setting up custom fields for custom post types belongs to fantasic child theme for dexon
*/ 

if ( !function_exists('dexon_metabox') ) {
	function dexon_metabox() {
		$prefix = '_dexon_';

	//header metabox
 	$page_heading_style = new_cmb2_box( array(
	'id'            => $prefix . 'em_header_style_option',
	'title'         => esc_html__( 'Header Style Option', 'dexon' ),
	'object_types'  => array( 'page' ), // Post type
	'priority'   => 'high',
	) );
	

	
		$page_heading_style->add_field( array(
			'name'    => esc_html__('Top Menu Style ','dexon'),
			'id'      => $prefix . 'dexon_header_topa',
			'type'    => 'radio_inline',
			'options' => array(
			'1' => esc_html__( 'Show Top Menu This Page', 'dexon' ),
			'2'   => esc_html__( 'Hide Top Menu This Page', 'dexon' ),
			),
			'default' =>'2',
		) );
		$page_heading_style->add_field( array(
			'name'    => esc_html__('Header Style','dexon'),
			'id'      => $prefix . 'dexon_header_style',
			'show_option_none' => true,
			'desc'   => esc_html__( 'Note: When you select 1-1,3,4,6 style menu, that time you need to set top bar menu, otherwise you can not find our real menu style.', 'dexon' ), 			
			'type'    => 'select',
			'options' => array(
				'1' => esc_html__( 'Default Header Menu', 'dexon' ),				
				'2' => esc_html__( 'Header Menu Transparent', 'dexon' ),					
				'3' => esc_html__( 'Header Style Two', 'dexon' ),			
				'4' => esc_html__( 'Header OnePage Menu', 'dexon' ),			
			),
			'default' =>'1',
		) );	
		
		  //page metabox
		  $page_breadcrumb = new_cmb2_box( array(
		   'id'            => $prefix . 'pageid1',
		   'title'         => esc_html__( 'Breadcumb Option', 'dexon' ),
		   'object_types'  => array( 'post','page','em_event','em_portfolio' ), // Post type
		   'priority'   => 'high',
		  ) );
		  
		  $page_breadcrumb->add_field( array(
		   'name'    => esc_html__('Page Title','dexon'),
		   'id'      => $prefix . 'ptitle',
		   'type'    => 'radio_inline',
		   'options' => array(
			'ptitles' => esc_html__( 'Hide Title', 'dexon' ),
			'ptitleh'   => esc_html__( 'Show Title', 'dexon' ),
		   ),
		   'default' =>'ptitleh',
		  ) );   
		  
		  
		$page_breadcrumb->add_field( array(
			'name'    => esc_html__('Breadcrumb','dexon'),
			'id'      => $prefix . 'breadcrumbs',
			'type'    => 'radio_inline',
			'options' => array(
			'0' => esc_html__( 'Show breadcrumb', 'dexon' ),
			'1'   => esc_html__( 'Hide breadcrumb', 'dexon' ),
			),
			'default' =>0,
		) );
		$page_breadcrumb->add_field( array(
			'name'    => esc_html__('Breadcrumb Title','dexon'),
			'id'      => $prefix . 'btitle',
			'type'    => 'radio_inline',
			'options' => array(
			'btitles' => esc_html__( 'Show Title', 'dexon' ),
			'btitleh'   => esc_html__( 'Hide Title', 'dexon' ),
			),
			'default' =>'btitleh',
		) );    
		$page_breadcrumb->add_field(array(
			'name' => esc_html__( 'Page Breadcrumb Image', 'dexon' ),
			'id'   => $prefix .'pageimagess',
			'desc'       => esc_html__( 'insert image here', 'dexon' ),  
			'type' => 'file',
		) );  
		$page_breadcrumb->add_field( array(
			'name'             => esc_html__('Text Align','dexon'),
			'desc'             => esc_html__('Select an option','dexon'),
			'id'   => $prefix .'page_text_align',
			'type'             => 'select',
			'show_option_none' => true,
			'default'          => 'text-center',
			'options'          => array(
			'text-left' => esc_html__( 'Align Left', 'dexon' ),
			'text-center'   => esc_html__( 'Align Middle', 'dexon' ),
			'text-right'     => esc_html__( 'Alige Right', 'dexon' ),
			),
		) );
		$page_breadcrumb->add_field( array(
			'name'             => esc_html__('Text Transform','dexon'),
			'desc'             => esc_html__('Select an option','dexon'),
			'id'   => $prefix .'page_text_transform',
			'type'             => 'select',
			'show_option_none' => true,
			'default'          => 'ccase',
			'options'          => array(
			'lcase' => esc_html__( 'Transform lowercase', 'dexon' ),
			'ucase'   => esc_html__( 'Transform uppercase', 'dexon' ),
			'ccase'     => esc_html__( 'Transform capitalize', 'dexon' ),
			),
		) );	
		

		//Testimonial
		$testimonial = new_cmb2_box( array(
			'id'            => $prefix . 'em_testimonial',
			'title'         => esc_html__( 'Testimonial Option', 'dexon' ),
			'object_types'  => array( 'em_testimonial' ), // Post type
			'priority'   => 'high',
		) );
			$testimonial->add_field( array(
				'name'       => esc_html__( 'Degignation', 'dexon' ),
				'desc'       => esc_html__( 'insert Degignation here', 'dexon' ),
				'id'         => $prefix . 'testi_deg',
				'type'       => 'text',
			) );	
			
							
	//Case Study
		$casestudy = new_cmb2_box( array(
			'id'            => $prefix . 'em_case_study',
			'title'         => esc_html__( 'Case Study Option', 'dexon' ),
			'object_types'  => array( 'em_case_study' ), // Post type
			'priority'   => 'high',
		) );
			$casestudy->add_field( array(
				'name'       => esc_html__( 'Case Study Description', 'dexon' ),
				'desc'       => esc_html__( 'Description', 'dexon' ),
				'id'         => $prefix . 'casedesc',
				'type'       => 'wysiwyg',
			) );

		$casestudy->add_field( array(
				'name' => 'oEmbed',
				'id'   => 'embed',
				'type' => 'oembed',
			) );
		$casestudy->add_field( array(
			'name'    => 'Icon Field',
			'desc'    => 'Upload an image or enter an URL.',
			'id'      => 'icon_field',
			'type'    => 'file',
		) );
			
							
				
				
			//===================================
			//Portfolio Metaboxes
			//===================================  

			$portfolio = new_cmb2_box( array(
				'id'            => $prefix . 'portfolio',
				'title'         => esc_html__( 'Portfolio Option', 'dexon' ),
				'object_types'  => array( 'em_portfolio', ), // Post type
				'priority'   => 'high',
			) );
			$portfolio->add_field( array(
				'name'       => esc_html__( 'Portfolio Description', 'dexon' ),
				'desc'       => esc_html__( 'Description', 'dexon' ),
				'id'         => $prefix . 'portdesc',
				'type'       => 'wysiwyg',
			) );				
			
			  $portfolio->add_field( array(
			   'name'    => esc_html__('Show/Hide All Option','dexon'),			  
			   'id'      => $prefix . 'saloption',
			   'type'    => 'radio_inline',
			   'options' => array(
				'm_alshow' => esc_html__( 'Show', 'dexon' ),
				'm_alhide'   => esc_html__( 'Hide', 'dexon' ),
			   ),
			   'default' =>'m_alhide',
			  ) );			
			  $portfolio->add_field( array(
			   'name'    => esc_html__('Show/Hide Popup Image','dexon'),			  
			   'id'      => $prefix . 'siimagepop',
			   'type'    => 'radio_inline',
			   'options' => array(
				'm_ishow' => esc_html__( 'Show', 'dexon' ),
				'm_ihide'   => esc_html__( 'Hide', 'dexon' ),
			   ),
			   'default' =>'m_ishow',
			  ) );
			  $portfolio->add_field( array(
			   'name'    => esc_html__('Show/Hide Link Page','dexon'),			  
			   'id'      => $prefix . 'sllink',
			   'type'    => 'radio_inline',
			   'options' => array(
				'm_lshow' => esc_html__( 'Show', 'dexon' ),
				'm_lhide'   => esc_html__( 'Hide', 'dexon' ),
			   ),
			   'default' =>'m_lshow',
			  ) );				  
			  $portfolio->add_field( array(
			   'name'    => esc_html__('Show/Hide Popup Youtube','dexon'),			  
			   'id'      => $prefix . 'shyoutub',
			   'type'    => 'radio_inline',
			   'options' => array(
				'm_yshow' => esc_html__( 'Show', 'dexon' ),
				'm_yhide'   => esc_html__( 'Hide', 'dexon' ),
			   ),
			   'default' =>'m_yhide',
			  ) );				
			   $portfolio->add_field( array(
				'name'       => esc_html__( 'Youtube Video', 'dexon' ),
				'desc'       => esc_html__( 'insert video link. ex-https://youtu.be/OJ9ejTy4J98', 'dexon' ),
				'id'         => $prefix . 'pyoutube',
				'type'       => 'text_url',
			   ) );
			  $portfolio->add_field( array(
			   'name'    => esc_html__('Show/Hide Popup Vimeo','dexon'),			  
			   'id'      => $prefix . 'svvimeo',
			   'type'    => 'radio_inline',
			   'options' => array(
				'm_vshow' => esc_html__( 'Show', 'dexon' ),
				'm_vhide'   => esc_html__( 'Hide', 'dexon' ),
			   ),
			   'default' =>'m_vhide',
			  ) );				   
			   $portfolio->add_field( array(
				'name'       => esc_html__( 'Vimeo Video', 'dexon' ),
				'desc'       => esc_html__( 'insert video link. ex-https://youtu.be/OJ9ejTy4J98', 'dexon' ),
				'id'         => $prefix . 'pvimeo',
				'type'       => 'text_url',
			   ) );		   

			  $portfolio->add_field( array(
			   'name'    => esc_html__('Select Multi Gellary','dexon'),			  
			   'id'      => $prefix . 'm_g_image_pop',
			   'type'    => 'radio_inline',
			   'options' => array(
				'm_gshow' => esc_html__( 'Show', 'dexon' ),
				'm_ghide'   => esc_html__( 'Hide', 'dexon' ),
			   ),
			   'default' =>'m_ghide',
			  ) );				   
				$portfolio->add_field( array(
					'name'       => esc_html__( 'Multiple Gellary Image', 'dexon' ),
					'desc'       => esc_html__( 'insert multiple gellary image here for single page', 'dexon' ),
					'id'         => $prefix . 'pgellaryu',
					'type'       => 'file_list',
				) );
			  $portfolio->add_field( array(
			   'name'    => esc_html__('Show/Hide Title','dexon'),			  
			   'id'      => $prefix . 'pshow_title',
			   'type'    => 'radio_inline',
			   'options' => array(
				'ptitle_show' => esc_html__( 'Show', 'dexon' ),
				'ptitle_hide'   => esc_html__( 'Hide', 'dexon' ),
			   ),
			   'default' =>'ptitle_show',
			  ) );					
			  $portfolio->add_field( array(
			   'name'    => esc_html__('Show/Hide Category','dexon'),			  
			   'id'      => $prefix . 'pshow_cat',
			   'type'    => 'radio_inline',
			   'options' => array(
				'pcat_show' => esc_html__( 'Show', 'dexon' ),
				'pcat_hide'   => esc_html__( 'Hide', 'dexon' ),
			   ),
			   'default' =>'pcat_show',
			  ) );	
//===================================
//Pricing table metabox
//===================================
		$pricing = new_cmb2_box( array(
			'id'            => $prefix . 'pricing',
			'title'         => esc_html__( 'Price Option', 'dexon' ),
			'object_types'  => array( 'em_pricing', ), // Post type
			'priority'   => 'high',
		) );
				$pricing->add_field( array(
					'name'       => esc_html__( 'Price Currency', 'dexon' ),
					'desc'       => esc_html__( 'insert Currency here e.g $', 'dexon' ),
					'id'         => $prefix . 'currency',
					'type'       => 'text',
				) );	
				$pricing->add_field( array(
					'name'       => esc_html__( 'Price Amount', 'dexon' ),
					'desc'       => esc_html__( 'insert Amount here', 'dexon' ),
					'id'         => $prefix . 'price_amount',
					'type'       => 'text',
				) );	
				$pricing->add_field( array(
					'name'       => esc_html__( 'Price Delay', 'dexon' ),
					'desc'       => esc_html__( 'insert Year, Month, Week or Day here', 'dexon' ),
					'id'         => $prefix . 'day',
					'type'       => 'text',
				) );						
				$pricing->add_field( array(
					'name'       => esc_html__( 'pricing content', 'dexon' ),
					'desc'       => esc_html__( 'insert pricing Item', 'dexon' ),
					'id'         => $prefix . 'pricing_item_loop',
					'type'       => 'text',
					'repeatable'      => true,
				) );
				$pricing->add_field( array(
					'name' => esc_html__( 'Button Text', 'dexon' ),
					'desc' => esc_html__( 'Insert Text Here', 'dexon' ),
					'id'   => $prefix . 'button_text',
					'type' => 'text',
				) );					
				$pricing->add_field( array(
					'name' => esc_html__( 'Button Link', 'dexon' ),
					'desc' => esc_html__( 'Insert register Link', 'dexon' ),
					'id'   => $prefix . 'button_link',
					'type' => 'text_url',
				) );
				$pricing->add_field( array(
					'name' => esc_html__( 'Active Class', 'dexon' ),
					'desc' => esc_html__( 'Add Active Class here "active"', 'dexon' ),
					'id'   => $prefix . 'active',
					'type' => 'text',
				) );

				
				
		//post tab metabox
			$emtab = new_cmb2_box( array(
				'id'            => $prefix . 'em_tab',
				'title'         => esc_html__( 'Tab Option', 'dexon' ),
				'object_types'  => array( 'em_tab' ), // Post type
				'priority'   => 'high',
			) );

				$emtab->add_field( array(
					'name'       => esc_html__( 'Tab Menu Name', 'dexon' ),
					'desc'       => esc_html__( 'insert tab menu here', 'dexon' ),
					'id'         => $prefix . 'em_tab_menu',
					'type'       => 'text',
				) );					
									
				$emtab->add_field(array(
					'name' => esc_html__( 'Tab Menu Image', 'dexon' ),
					'id'   => $prefix .'em_tab_image',
					'desc'       => esc_html__( 'insert image here', 'dexon' ),  
					'type' => 'file',
				) );
				$emtab->add_field( array(
					'name'       => esc_html__( 'Tab Menu Active', 'dexon' ),
					'desc'       => esc_html__( 'must be set "active in" class into one post from all post, for active tab item', 'dexon' ),
					'id'         => $prefix . 'em_tab_active',
					'type'       => 'text',
				) );
				$emtab->add_field( array(
					'name'       => esc_html__( 'Tab Icon Name', 'dexon' ),
					'desc'       => esc_html__( 'Type Your favorite Font awesome Icon name', 'dexon' ),
					'id'         => $prefix . 'em_tab_icon',
					'type'       => 'text',
				) );
				
					
				
				
								
//slider table metabox
	$slider = new_cmb2_box( array(
		'id'            => $prefix . 'dexon_slider',
		'title'         => esc_html__( 'Slider Option', 'dexon' ),
		'object_types'  => array( 'em_slider', ), // Post type
		'priority'   => 'high',
	) );
	
	
			$slider->add_field( array(
				'name'       => esc_html__( 'Title', 'dexon' ),
				'desc'       => esc_html__( 'insert title here. for highlight text use <span> ex-<span>Design</span>', 'dexon' ),
				'id'         => $prefix . 'em_slide_title',
				'type'       => 'textarea_small',
			) );

			$slider->add_field( array(
				'name'    => esc_html__('Title Animate','dexon'),
				'id'      => $prefix . 'em_aimate_title',
				'show_option_none' => true,					
				'type'    => 'select',
				'options' => array(
					'bounceIn' => esc_html__( 'bounceIn', 'dexon' ),				
					'bounceInDown' => esc_html__( 'bounceInDown', 'dexon' ),				
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'dexon' ),				
					'bounceInRight' => esc_html__( 'bounceInRight', 'dexon' ),				
					'bounceInUp' => esc_html__( 'bounceInUp', 'dexon' ),				
					'fadeIn' => esc_html__( 'fadeIn', 'dexon' ),				
					'fadeInDown' => esc_html__( 'fadeInDown', 'dexon' ),				
					'fadeInDownBig' => esc_html__( 'fadeInDownBig', 'dexon' ),				
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'dexon' ),				
					'fadeInLeftBig' => esc_html__( 'fadeInLeftBig', 'dexon' ),				
					'fadeInRight' => esc_html__( 'fadeInRight', 'dexon' ),				
					'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'dexon' ),				
					'fadeInUp' => esc_html__( 'fadeInUp', 'dexon' ),				
					'fadeInUpBig' => esc_html__( 'fadeInUpBig', 'dexon' ),				
					'rotateIn' => esc_html__( 'rotateIn', 'dexon' ),				
					'rotateInDownLeft' => esc_html__( 'rotateInDownLeft', 'dexon' ),				
					'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'dexon' ),				
					'rotateInUpLeft' => esc_html__( 'rotateInUpLeft', 'dexon' ),				
					'rotateInUpRight' => esc_html__( 'rotateInUpRight', 'dexon' ),				
					'rollIn' => esc_html__( 'rollIn', 'dexon' ),				
					'zoomIn' => esc_html__( 'zoomIn', 'dexon' ),				
					'zoomInDown' => esc_html__( 'zoomInDown', 'dexon' ),				
					'zoomInLeft' => esc_html__( 'zoomInLeft', 'dexon' ),				
					'zoomInRight' => esc_html__( 'zoomInRight', 'dexon' ),				
					'zoomInUp' => esc_html__( 'zoomInUp', 'dexon' ),				
					'slideInDown' => esc_html__( 'slideInDown', 'dexon' ),				
					'slideInLeft' => esc_html__( 'slideInLeft', 'dexon' ),				
					'slideInRight' => esc_html__( 'slideInRight', 'dexon' ),				
					'slideInUp' => esc_html__( 'slideInUp', 'dexon' ),				
				),
				'default' =>'slideInRight',
			) );
			

			$slider->add_field( array(
				'name'    => esc_html__('Title Animate Duration','dexon'),
				'id'      => $prefix . 'em_durations_title',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'2',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Title Animate Delay','dexon'),
				'id'      => $prefix . 'em_dealy_title',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0' => esc_html__( 'point 0s', 'dexon' ),							
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'0',
			) );		

		
		
		
			
			$slider->add_field( array(
				'name'       => esc_html__( 'Sub Title', 'dexon' ),
				'desc'       => esc_html__( 'insert sub-title here. for highlight text use <span> ex-<span>website</span>', 'dexon' ),
				'id'         => $prefix . 'em_slide_subtitle',
				'type'       => 'textarea_small',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Sub Title Animate','dexon'),
				'id'      => $prefix . 'em_aimate_subtitle',
				'show_option_none' => true,					
				'type'    => 'select',
				'options' => array(
					'bounceIn' => esc_html__( 'bounceIn', 'dexon' ),				
					'bounceInDown' => esc_html__( 'bounceInDown', 'dexon' ),				
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'dexon' ),				
					'bounceInRight' => esc_html__( 'bounceInRight', 'dexon' ),				
					'bounceInUp' => esc_html__( 'bounceInUp', 'dexon' ),				
					'fadeIn' => esc_html__( 'fadeIn', 'dexon' ),				
					'fadeInDown' => esc_html__( 'fadeInDown', 'dexon' ),				
					'fadeInDownBig' => esc_html__( 'fadeInDownBig', 'dexon' ),				
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'dexon' ),				
					'fadeInLeftBig' => esc_html__( 'fadeInLeftBig', 'dexon' ),				
					'fadeInRight' => esc_html__( 'fadeInRight', 'dexon' ),				
					'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'dexon' ),				
					'fadeInUp' => esc_html__( 'fadeInUp', 'dexon' ),				
					'fadeInUpBig' => esc_html__( 'fadeInUpBig', 'dexon' ),				
					'rotateIn' => esc_html__( 'rotateIn', 'dexon' ),				
					'rotateInDownLeft' => esc_html__( 'rotateInDownLeft', 'dexon' ),				
					'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'dexon' ),				
					'rotateInUpLeft' => esc_html__( 'rotateInUpLeft', 'dexon' ),				
					'rotateInUpRight' => esc_html__( 'rotateInUpRight', 'dexon' ),				
					'rollIn' => esc_html__( 'rollIn', 'dexon' ),				
					'zoomIn' => esc_html__( 'zoomIn', 'dexon' ),				
					'zoomInDown' => esc_html__( 'zoomInDown', 'dexon' ),				
					'zoomInLeft' => esc_html__( 'zoomInLeft', 'dexon' ),				
					'zoomInRight' => esc_html__( 'zoomInRight', 'dexon' ),				
					'zoomInUp' => esc_html__( 'zoomInUp', 'dexon' ),				
					'slideInDown' => esc_html__( 'slideInDown', 'dexon' ),				
					'slideInLeft' => esc_html__( 'slideInLeft', 'dexon' ),				
					'slideInRight' => esc_html__( 'slideInRight', 'dexon' ),				
					'slideInUp' => esc_html__( 'slideInUp', 'dexon' ),				
				),
				'default' =>'slideInRight',
			) );
			

			$slider->add_field( array(
				'name'    => esc_html__('Sub Title Animate Duration','dexon'),
				'id'      => $prefix . 'em_durations_subtitle',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'2',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Sub Title Animate Delay','dexon'),
				'id'      => $prefix . 'em_dealy_subtitle',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0' => esc_html__( 'point 0s', 'dexon' ),							
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'0',
			) );				
			$slider->add_field( array(
				'name'       => esc_html__( 'Content', 'dexon' ),
				'desc'       => esc_html__( 'insert content here', 'dexon' ),
				'id'         => $prefix . 'em_slide_textarea',
				'type'       => 'textarea',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Content Animate','dexon'),
				'id'      => $prefix . 'em_aimate_content',
				'show_option_none' => true,					
				'type'    => 'select',
				'options' => array(
					'bounceIn' => esc_html__( 'bounceIn', 'dexon' ),				
					'bounceInDown' => esc_html__( 'bounceInDown', 'dexon' ),				
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'dexon' ),				
					'bounceInRight' => esc_html__( 'bounceInRight', 'dexon' ),				
					'bounceInUp' => esc_html__( 'bounceInUp', 'dexon' ),				
					'fadeIn' => esc_html__( 'fadeIn', 'dexon' ),				
					'fadeInDown' => esc_html__( 'fadeInDown', 'dexon' ),				
					'fadeInDownBig' => esc_html__( 'fadeInDownBig', 'dexon' ),				
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'dexon' ),				
					'fadeInLeftBig' => esc_html__( 'fadeInLeftBig', 'dexon' ),				
					'fadeInRight' => esc_html__( 'fadeInRight', 'dexon' ),				
					'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'dexon' ),				
					'fadeInUp' => esc_html__( 'fadeInUp', 'dexon' ),				
					'fadeInUpBig' => esc_html__( 'fadeInUpBig', 'dexon' ),				
					'rotateIn' => esc_html__( 'rotateIn', 'dexon' ),				
					'rotateInDownLeft' => esc_html__( 'rotateInDownLeft', 'dexon' ),				
					'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'dexon' ),				
					'rotateInUpLeft' => esc_html__( 'rotateInUpLeft', 'dexon' ),				
					'rotateInUpRight' => esc_html__( 'rotateInUpRight', 'dexon' ),				
					'rollIn' => esc_html__( 'rollIn', 'dexon' ),				
					'zoomIn' => esc_html__( 'zoomIn', 'dexon' ),				
					'zoomInDown' => esc_html__( 'zoomInDown', 'dexon' ),				
					'zoomInLeft' => esc_html__( 'zoomInLeft', 'dexon' ),				
					'zoomInRight' => esc_html__( 'zoomInRight', 'dexon' ),				
					'zoomInUp' => esc_html__( 'zoomInUp', 'dexon' ),				
					'slideInDown' => esc_html__( 'slideInDown', 'dexon' ),				
					'slideInLeft' => esc_html__( 'slideInLeft', 'dexon' ),				
					'slideInRight' => esc_html__( 'slideInRight', 'dexon' ),				
					'slideInUp' => esc_html__( 'slideInUp', 'dexon' ),				
				),
				'default' =>'slideInRight',
			) );
			

			$slider->add_field( array(
				'name'    => esc_html__('Content Animate Duration','dexon'),
				'id'      => $prefix . 'em_durations_content',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'3',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Content Animate Delay','dexon'),
				'id'      => $prefix . 'em_dealy_content',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0' => esc_html__( 'point 0s', 'dexon' ),							
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'0',
			) );				
			
			$slider->add_field( array(
				'name'       => esc_html__( 'Button Text 1', 'dexon' ),
				'desc'       => esc_html__( 'insert button text here', 'dexon' ),
				'id'         => $prefix . 'em_slide_btn1',
				'type'       => 'text',
			) );
			$slider->add_field( array(
				'name'       => esc_html__( 'Slide Image', 'dexon' ),
				'desc'       => esc_html__( 'insert single slide image here', 'dexon' ),
				'id'         => $prefix . 'em_slide_img',
				'type'       => 'file',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Image Animate','dexon'),
				'id'      => $prefix . 'em_aimate_image',
				'show_option_none' => true,					
				'type'    => 'select',
				'options' => array(
					'bounceIn' => esc_html__( 'bounceIn', 'dexon' ),				
					'bounceInDown' => esc_html__( 'bounceInDown', 'dexon' ),				
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'dexon' ),				
					'bounceInRight' => esc_html__( 'bounceInRight', 'dexon' ),				
					'bounceInUp' => esc_html__( 'bounceInUp', 'dexon' ),				
					'fadeIn' => esc_html__( 'fadeIn', 'dexon' ),				
					'fadeInDown' => esc_html__( 'fadeInDown', 'dexon' ),				
					'fadeInDownBig' => esc_html__( 'fadeInDownBig', 'dexon' ),				
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'dexon' ),				
					'fadeInLeftBig' => esc_html__( 'fadeInLeftBig', 'dexon' ),				
					'fadeInRight' => esc_html__( 'fadeInRight', 'dexon' ),				
					'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'dexon' ),				
					'fadeInUp' => esc_html__( 'fadeInUp', 'dexon' ),				
					'fadeInUpBig' => esc_html__( 'fadeInUpBig', 'dexon' ),				
					'rotateIn' => esc_html__( 'rotateIn', 'dexon' ),				
					'rotateInDownLeft' => esc_html__( 'rotateInDownLeft', 'dexon' ),				
					'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'dexon' ),				
					'rotateInUpLeft' => esc_html__( 'rotateInUpLeft', 'dexon' ),				
					'rotateInUpRight' => esc_html__( 'rotateInUpRight', 'dexon' ),				
					'rollIn' => esc_html__( 'rollIn', 'dexon' ),				
					'zoomIn' => esc_html__( 'zoomIn', 'dexon' ),				
					'zoomInDown' => esc_html__( 'zoomInDown', 'dexon' ),				
					'zoomInLeft' => esc_html__( 'zoomInLeft', 'dexon' ),				
					'zoomInRight' => esc_html__( 'zoomInRight', 'dexon' ),				
					'zoomInUp' => esc_html__( 'zoomInUp', 'dexon' ),				
					'slideInDown' => esc_html__( 'slideInDown', 'dexon' ),				
					'slideInLeft' => esc_html__( 'slideInLeft', 'dexon' ),				
					'slideInRight' => esc_html__( 'slideInRight', 'dexon' ),				
					'slideInUp' => esc_html__( 'slideInUp', 'dexon' ),				
				),
				'default' =>'slideInRight',
			) );
			

			$slider->add_field( array(
				'name'    => esc_html__('Image Animate Duration','dexon'),
				'id'      => $prefix . 'em_durations_image',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'2',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Image Animate Delay','dexon'),
				'id'      => $prefix . 'em_dealy_image',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0' => esc_html__( 'point 0s', 'dexon' ),							
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'0',
			) );		

			
			
			$slider->add_field( array(
				'name'       => esc_html__( 'Button url 1', 'dexon' ),
				'desc'       => esc_html__( 'insert button text url here', 'dexon' ),
				'id'         => $prefix . 'em_slide_btn1utl',
				'type'       => 'text_url',
			) );			
			$slider->add_field( array(
				'name'       => esc_html__( 'Button Text 2', 'dexon' ),
				'desc'       => esc_html__( 'insert button text here', 'dexon' ),
				'id'         => $prefix . 'em_slide_btn2',
				'type'       => 'text',
			) );
			$slider->add_field( array(
				'name'       => esc_html__( 'Button url 2', 'dexon' ),
				'desc'       => esc_html__( 'insert button text url here', 'dexon' ),
				'id'         => $prefix . 'em_slide_btn2url',
				'type'       => 'text_url',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Button Animate','dexon'),
				'id'      => $prefix . 'em_aimate_btn',
				'show_option_none' => true,					
				'type'    => 'select',
				'options' => array(
					'bounceIn' => esc_html__( 'bounceIn', 'dexon' ),				
					'bounceInDown' => esc_html__( 'bounceInDown', 'dexon' ),				
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'dexon' ),				
					'bounceInRight' => esc_html__( 'bounceInRight', 'dexon' ),				
					'bounceInUp' => esc_html__( 'bounceInUp', 'dexon' ),				
					'fadeIn' => esc_html__( 'fadeIn', 'dexon' ),				
					'fadeInDown' => esc_html__( 'fadeInDown', 'dexon' ),				
					'fadeInDownBig' => esc_html__( 'fadeInDownBig', 'dexon' ),				
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'dexon' ),				
					'fadeInLeftBig' => esc_html__( 'fadeInLeftBig', 'dexon' ),				
					'fadeInRight' => esc_html__( 'fadeInRight', 'dexon' ),				
					'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'dexon' ),				
					'fadeInUp' => esc_html__( 'fadeInUp', 'dexon' ),				
					'fadeInUpBig' => esc_html__( 'fadeInUpBig', 'dexon' ),				
					'rotateIn' => esc_html__( 'rotateIn', 'dexon' ),				
					'rotateInDownLeft' => esc_html__( 'rotateInDownLeft', 'dexon' ),				
					'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'dexon' ),				
					'rotateInUpLeft' => esc_html__( 'rotateInUpLeft', 'dexon' ),				
					'rotateInUpRight' => esc_html__( 'rotateInUpRight', 'dexon' ),				
					'rollIn' => esc_html__( 'rollIn', 'dexon' ),				
					'zoomIn' => esc_html__( 'zoomIn', 'dexon' ),				
					'zoomInDown' => esc_html__( 'zoomInDown', 'dexon' ),				
					'zoomInLeft' => esc_html__( 'zoomInLeft', 'dexon' ),				
					'zoomInRight' => esc_html__( 'zoomInRight', 'dexon' ),				
					'zoomInUp' => esc_html__( 'zoomInUp', 'dexon' ),				
					'slideInDown' => esc_html__( 'slideInDown', 'dexon' ),				
					'slideInLeft' => esc_html__( 'slideInLeft', 'dexon' ),				
					'slideInRight' => esc_html__( 'slideInRight', 'dexon' ),				
					'slideInUp' => esc_html__( 'slideInUp', 'dexon' ),				
				),
				'default' =>'bounceInUp',
			) );
			

			$slider->add_field( array(
				'name'    => esc_html__('Button Animate Duration','dexon'),
				'id'      => $prefix . 'em_durations_btn',
				'show_option_none' => false,					
				'type'    => 'select',
				'options' => array(
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'3',
			) );
			$slider->add_field( array(
				'name'    => esc_html__('Button Animate Delay','dexon'),
				'id'      => $prefix . 'em_dealy_btn',
				'show_option_none' => true,					
				'type'    => 'select',
				'options' => array(
					'0' => esc_html__( 'point 0s', 'dexon' ),							
					'0.1' => esc_html__( 'point 1s', 'dexon' ),							
					'0.2' => esc_html__( 'point 2s', 'dexon' ),							
					'0.3' => esc_html__( 'point 3s', 'dexon' ),							
					'0.4' => esc_html__( 'point 4s', 'dexon' ),							
					'0.5' => esc_html__( 'point 5s', 'dexon' ),							
					'0.6' => esc_html__( 'point 6s', 'dexon' ),							
					'0.7' => esc_html__( 'point 7s', 'dexon' ),							
					'0.8' => esc_html__( 'point 8s', 'dexon' ),							
					'0.9' => esc_html__( 'point 9s', 'dexon' ),							
					'1.2' => esc_html__( '1 point 2s', 'dexon' ),							
					'1.3' => esc_html__( '1 point 3s', 'dexon' ),							
					'1.4' => esc_html__( '1 point 4s', 'dexon' ),							
					'1.5' => esc_html__( '1 point 5s', 'dexon' ),							
					'1.8' => esc_html__( '1 point 8s', 'dexon' ),							
					'2' => esc_html__( '2s', 'dexon' ),							
					'2.2' => esc_html__( '2 point 2s', 'dexon' ),							
					'2.3' => esc_html__( '2 point 5s', 'dexon' ),							
					'3' => esc_html__( '3s', 'dexon' ),							
				),
				'default' =>'1',
			) );				
			$slider->add_field( array(
				'name'    => esc_html__('Text Alignment Style','dexon'),
				'id'      => $prefix . 'em_slider_posi',
				'show_option_none' => true,					
				'type'    => 'select',
				'options' => array(
					'' => esc_html__( 'Select alignment', 'dexon' ),
					'text-left' => esc_html__( 'Left Alignment', 'dexon' ),
					'text-center' => esc_html__( 'Center Alignment', 'dexon' ),
					'text-right' => esc_html__( 'Right Alignment', 'dexon' ),
				),
				'default' =>'text-center',
			) );				
			$slider->add_field( array(
				'name'       => esc_html__( 'More Sliders Option, Please see slider widget area', 'dexon' ),
				'id'         => $prefix . 'title_heading_line',
				'type'       => 'title',
			) );				
	
			
	}
}


