<?php
/**
 * dexon functions and definitions
 *
 * @package dexon
 */

// Security check
if (!defined('ABSPATH')) {
    exit;
}

require_once get_template_directory() . '/inc/theme-setup.php';

// Theme version
define('DEXON_THEME_VERSION', '1.0.0');

/**
 * Theme Setup Class
 */
require_once get_template_directory() . '/inc/theme-setup.php';

/**
 * Sets up theme defaults and registers support for various WordPress features.
 */
function dexon_setup() {
    // Load text domain
    load_theme_textdomain('dexon', get_template_directory() . '/languages');

    // Add default posts and comments RSS feed links to head
    add_theme_support('automatic-feed-links');

    // Let WordPress manage the document title
    add_theme_support('title-tag');

    // Enable support for Post Thumbnails
    add_theme_support('post-thumbnails');

    // Register image sizes
    add_image_size('dexon-blog-default', 390, 250, true);
    add_image_size('dexon-blog-adn', 250, 300, true);
    add_image_size('dexon-blog-single', 850, 550, true);
    add_image_size('dexon-blog-both', 570, 350, true);
    add_image_size('dexon-team', 450, 450, true);
    add_image_size('dexon-testimonial', 106, 106, true);
    add_image_size('dexon-single-portfolio', 1170, 600, true);
    add_image_size('dexon-gallery-thumb', 560, 560, true);
    add_image_size('dexon-recent-image', 80, 80, true);
    add_image_size('dexon-case-thumb', 400, 250, true);

    // Post formats
    add_theme_support('post-formats', array('gallery', 'quote', 'video', 'audio'));

    // WooCommerce support
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');

    // Add editor style
    add_editor_style();

    // Register menus
    register_nav_menus(array(
        'menu-1' => esc_html__('Main Menu', 'dexon'),
        'one-pages' => esc_html__('OnePage Menu', 'dexon'),
        'menu-3' => esc_html__('Mobile Menu', 'dexon'),
        'menu-4' => esc_html__('Footer Menu', 'dexon'),
    ));

    // HTML5 support
    add_theme_support('html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ));

    // Custom background
    add_theme_support('custom-background', apply_filters('dexon_custom_background_args', array(
        'default-color' => 'ffffff',
        'default-image' => '',
    )));

    // Selective refresh for widgets
    add_theme_support('customize-selective-refresh-widgets');
}
add_action('after_setup_theme', 'dexon_setup');

/**
 * Set the content width in pixels.
 */
function dexon_content_width() {
    $GLOBALS['content_width'] = apply_filters('dexon_content_width', 1140);
}
add_action('after_setup_theme', 'dexon_content_width', 0);

/**
 * Register Google Fonts
 */
function dexon_fonts_url() {
    $font_families = array();
    $font_families[] = 'Clash Display:300,400,500,600,700,800';
    $font_families[] = 'Kumbh Sans:300,400,500,600,700,800';

    $fonts_url = add_query_arg(array(
        'family' => urlencode(implode('|', $font_families)),
        'subset' => urlencode('latin,latin-ext'),
    ), 'https://fonts.googleapis.com/css');

    return esc_url_raw($fonts_url);
}

/**
 * Enqueue scripts and styles.
 */
function dexon_scripts() {
    // Styles
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css');
    wp_enqueue_style('dexon-fonts', dexon_fonts_url());
    wp_enqueue_style('venobox', get_template_directory_uri() . '/venobox/venobox.css');
    wp_enqueue_style('animate', get_template_directory_uri() . '/assets/css/animate.css');
    wp_enqueue_style('slick', get_template_directory_uri() . '/assets/css/slick.css');
    wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.css');
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css');
    wp_enqueue_style('thmemify', get_template_directory_uri() . '/assets/css/themify-icons.css');
    wp_enqueue_style('meanmenu', get_template_directory_uri() . '/assets/css/meanmenu.min.css');
    wp_enqueue_style('dexon-main', get_template_directory_uri() . '/assets/css/theme-default.css');
    wp_enqueue_style('dexon-style', get_stylesheet_uri());
    wp_enqueue_style('dexon-responsive', get_template_directory_uri() . '/assets/css/responsive.css');
    wp_enqueue_style('clash-display', 'https://fonts.cdnfonts.com/css/clash-display');

    // Scripts
    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array('jquery'), '3.3.5', true);
    wp_enqueue_script('meanmenu', get_template_directory_uri() . '/assets/js/jquery.meanmenu.js', array('jquery'), '1.0.0', true);
    wp_enqueue_script('isotope', get_template_directory_uri() . '/assets/js/isotope.pkgd.min.js', array('jquery'), '1.0.0', true);
    wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array('jquery'), '', true);
    wp_enqueue_script('venobox', get_template_directory_uri() . '/venobox/venobox.min.js', array('jquery'), '3.2.4', true);
    wp_enqueue_script('dexon-main', get_template_directory_uri() . '/assets/js/theme.js', array('jquery'), DEXON_THEME_VERSION, true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'dexon_scripts');

/**
 * Register widget areas.
 */
function dexon_widgets_init() {
    // Main Sidebar
    register_sidebar(array(
        'name'          => esc_html__('Sidebar', 'dexon'),
        'id'            => 'sidebar-1',
        'description'   => esc_html__('Add widgets here.', 'dexon'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h5 class="widget-title mb-3">',
        'after_title'   => '</h5>',
    ));

    // Page Sidebar
    register_sidebar(array(
        'name'          => esc_html__('Page Sidebar', 'dexon'),
        'id'            => 'sidebar-2',
        'description'   => esc_html__('Add widgets here.', 'dexon'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h5 class="widget-title mb-3">',
        'after_title'   => '</h5>',
    ));

    // Footer Widgets
    for ($i = 1; $i <= 4; $i++) {
        register_sidebar(array(
            'name'          => sprintf(esc_html__('Footer %d', 'dexon'), $i),
            'id'            => 'dexon-footer-' . $i,
            'description'   => esc_html__('Add footer widgets here.', 'dexon'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h5 class="widget-title">',
            'after_title'   => '</h5>',
        ));
    }
}
add_action('widgets_init', 'dexon_widgets_init');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/includes/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/includes/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/includes/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/includes/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
    require get_template_directory() . '/includes/jetpack.php';
}

/**
 * Load Redux Framework config
 */
if (class_exists('ReduxFrameworkPlugin')) {
    require get_template_directory() . '/includes/dexon-option-framework.php';
}

/**
 * Load theme functions
 */
require get_template_directory() . '/includes/dexon-global-function.php';
require get_template_directory() . '/includes/dexon-breadcrumb.php';

/**
 * TGM Plugin Activation
 */
require get_template_directory() . '/includes/dexon-tgm-activation.php';

/**
 * Content word limiter
 */
function dexon_read_more($limit) {
    $content = explode(' ', get_the_content());
    $count = array_slice($content, 0, $limit);
    echo implode(' ', $count);
}

/**
 * Title word limiter
 */
function dexon_title($limit) {
    $title = explode(' ', get_the_title());
    $titles = array_slice($title, 0, $limit);
    echo implode(' ', $titles);
}

/**
 * Social sharing
 */
function dexon_blog_sharing() {
    global $post;
    
    $html = '<div class="dexon-single-icon-inner">';
    
    // Social sharing URLs
    $share_urls = array(
        'facebook' => 'https://www.facebook.com/sharer/sharer.php?u=' . get_the_permalink(),
        'twitter' => 'https://twitter.com/share?url=' . esc_url(get_permalink()) . '&text=' . get_the_title(),
        'linkedin' => 'https://www.linkedin.com/shareArticle?url=' . esc_url(get_permalink()) . '&title=' . get_the_title(),
        'pinterest' => 'https://pinterest.com/pin/create/bookmarklet/?url=' . esc_url(get_permalink()) . '&description=' . get_the_title() . '&media=' . esc_url(wp_get_attachment_url(get_post_thumbnail_id($post->ID)))
    );

    // Social icons
    $icons = array(
        'facebook' => 'fa-facebook',
        'twitter' => 'fa-twitter',
        'linkedin' => 'fa-linkedin',
        'pinterest' => 'fa-pinterest'
    );

    // Generate sharing links
    foreach ($share_urls as $network => $url) {
        $html .= '<a href="' . esc_url($url) . '" target="_blank"><i class="fa ' . $icons[$network] . '"></i></a>';
    }

    $html .= '</div>';

    echo $html;
}

/**
 * Login page customization
 */
function dexon_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/assets/images/main-logo.png);
            height: 32px;
            width: 157px;
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
        }
    </style>
<?php }
add_action('login_enqueue_scripts', 'dexon_login_logo');
