<?php

use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;

if(!defined('ABSPATH')) exit;


class SlickSlider extends \Elementor\Widget_Base{

	public function get_name(){
		return "slider";
	}
	
	public function get_title(){
		return "Slick Slider";
	}
	
	public function get_icon(){
		return "eicon-slider-push";
	}

	public function get_categories(){
		return ['dreamit-category'];
	}

	protected function register_controls() {
		
        $this->start_controls_section(
			'slider', [
				'label' => __( 'Slider', 'dreamit-elementor-extension' ),
			]
		);

        $repeater = new \Elementor\Repeater();
     

        $repeater->add_control(
			'content_position',
            [
                'label' => __( 'Select Text Position', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'text-left' => __( 'Text Left', 'dreamit-elementor-extension' ),
                    'text-center' => __( 'Text Center', 'dreamit-elementor-extension' ),
                    'text-right' => __( 'Text Right', 'dreamit-elementor-extension' ),
                ],
                'default' => 'text-left',
            ],
		); 

        $repeater->add_control(
			'slider_style',
            [
                'label' => __( 'Slider style', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_01' => esc_html__('Style one', 'dreamit-elementor-extension'),
                    'style_02' => esc_html__('Style two', 'dreamit-elementor-extension'),
                ],
                'default' => 'style_01'
            ],
		); 
        $repeater->add_control(
			'subtitle',
            [
                'label' => __( 'Subtitle', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Welcome to dreamhub'
            ],
		);        
        $repeater->add_control(
			'title',
            [
                'label' => __( 'Title', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'We are a creative <br>Design Agency',
            ],
		);        
        $repeater->add_control(
			'description',
            [
                'label' => __( 'Description', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Pellentesque at posuere tellus phasellus scelerisque porem.',
            ],
		);        
        $repeater->add_control(
			'btn1',
            [
                'label' => __( 'Button 1', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __( 'Enter Button Name', 'dreamit-elementor-extension' ),
                'default' => 'Get Started'
            ],	
		);        
        $repeater->add_control(
			'btn1_url',
            [
                'label' => __( 'Button URL', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#'
                ]
            ],	
		);        
        $repeater->add_control(
			'btn2',
            [
                'label' => __( 'Button 2', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __( 'Enter Button Name', 'dreamit-elementor-extension' ),
                'default' => ''
            ],	
		);        
        $repeater->add_control(
			'btn2_url',
            [
                'label' => __( 'Button URL', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#'
                ]
            ],	
		);        
        $repeater->add_control(
			'video_url',
            [
                'label' => __( 'Video URL', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#'
                ]
            ],	
		);        
        $repeater->add_control(
			'video_title',
            [
                'label' => __( 'Video Title', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ],	
		);        
        $repeater->add_control(
			'video_icon',
            [
                'label' => __( 'Video Icon', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-play',
                ],
            ],	
		);
        $repeater->add_control(
			'single_image',
            [
                'label' => __( 'Choose Single Image', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ],	
		);
        $repeater->add_control(
			'bg_image',
            [
                'label' => __( 'Background image', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ],	
		);
        $repeater->add_control(
            'title_two',
            [
                'label' => __( 'Title Two', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'We are a creative <br>Design Agency',
            ],
        );  
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Slide Items', 'dreamit-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();

        /**
         * Style Tab
         */

        $this->start_controls_section(
            'general_section', [
                'label' => __( 'General', 'dreamit-elementor-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'slider_height',
                [
                    'label' => __( 'Slider Height', 'dreamit-elementor-extension' ),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1500,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .dreamit-slick-slider .single-slick' => 'min-height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();

        //------------------------------ Style Title ------------------------------
        $this->start_controls_section(
            'style_title', [
                'label' => __( 'Title', 'dreamit-elementor-extension' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color_title', [
                'label' => __( 'Text Color', 'dreamit-elementor-extension' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-text h1' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .slider_two .hero-text h1' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .slider_five .new_hero_text .f_65' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_title',
                
                'selector' => '{{WRAPPER}} .hero-text h1, {{WRAPPER}} .slider_two .hero-text h1',
            ]
        );
        $this->end_controls_section();


        //------------------------------ Style subtitle ------------------------------
        $this->start_controls_section(
            'style_subtitle', [
                'label' => __( 'Subtitle', 'dreamit-elementor-extension' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color_subtitle', [
                'label' => __( 'Text Color', 'dreamit-elementor-extension' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-text h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .slider_two .hero-text h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_subtitle',
                'selector' => '{{WRAPPER}} .hero-text h4, {{WRAPPER}} .slider_two .hero-text h3',
            ]
        );
        $this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .hero-text h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //------------------------------ Style Description ------------------------------
        $this->start_controls_section(
            'style_description', [
                'label' => __( 'Description', 'dreamit-elementor-extension' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color_description', [
                'label' => __( 'Text Color', 'dreamit-elementor-extension' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-text p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_description',
                'selector' => '{{WRAPPER}} .hero-text p, {{WRAPPER}} .slider_two .hero-text h3',
            ]
        );
        $this->add_responsive_control(
            'description_margin',
            [
                'label' => __( 'Margin', 'dreamit-elementor-extension' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .hero-text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


        //------------------------------ Style Button ------------------------------
        $this->start_controls_section(
            'style_button', [
                'label' => __( 'Button 1', 'dreamit-elementor-extension' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->start_controls_tabs(
                'button_style_tabs'
            );
                $this->start_controls_tab(
                    'button_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'dreamit-elementor-extension' ),
                    ]
                );
                
                    $this->add_control(
                        'button_text_color',
                        [
                            'label' => __( 'Text Color', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'button_background_color',
                        [
                            'label' => __( 'Background Color', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn' => 'background-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        \Elementor\Group_Control_Border::get_type(),
                        [
                            'name' => 'button_border',
                            'label' => __( 'Border', 'dreamit-elementor-extension' ),
                            'selector' => '{{WRAPPER}} .single-slick .btn',
                        ]
                    );
                    $this->add_responsive_control(
                        'button_border_radius',
                        [
                            'label' => __( 'Border Radius', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', 'em', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                
                $this->start_controls_tab(
                    'button_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'dreamit-elementor-extension' ),
                    ]
                );

                    $this->add_control(
                        'hover_button_text_color',
                        [
                            'label' => __( 'Text Color', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'hover_button_background_color',
                        [
                            'label' => __( 'Background Color', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn:hover' => 'background-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        \Elementor\Group_Control_Border::get_type(),
                        [
                            'name' => 'hover_button_border',
                            'label' => __( 'Border', 'dreamit-elementor-extension' ),
                            'selector' => '{{WRAPPER}} .single-slick .btn:hover',
                        ]
                    );
                    $this->add_responsive_control(
                        'hover_button_border_radius',
                        [
                            'label' => __( 'Border Radius', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', 'em', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                
            $this->end_controls_tabs();

            $this->add_responsive_control(
                'button_margin',
                [
                    'label' => __( 'Margin', 'dreamit-elementor-extension' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .single-slick .btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'button_height',
                [
                    'label' => __( 'Height', 'dreamit-elementor-extension' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 5,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .single-slick .btn' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'button_width',
                [
                    'label' => __( 'Width', 'dreamit-elementor-extension' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 5,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .single-slick .btn' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .single-slick .btn',
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_button_two', [
                'label' => __( 'Button 2', 'dreamit-elementor-extension' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->start_controls_tabs(
                'button_two_style_tabs'
            );
                $this->start_controls_tab(
                    'button_two_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'dreamit-elementor-extension' ),
                    ]
                );
                
                    $this->add_control(
                        'button_two_text_color',
                        [
                            'label' => __( 'Text Color', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn.button-two' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'button_two_background_color',
                        [
                            'label' => __( 'Background Color', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn.button-two' => 'background-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        \Elementor\Group_Control_Border::get_type(),
                        [
                            'name' => 'button_two_border',
                            'label' => __( 'Border', 'dreamit-elementor-extension' ),
                            'selector' => '{{WRAPPER}} .single-slick .btn.button-two',
                        ]
                    );
                    $this->add_responsive_control(
                        'button_two_border_radius',
                        [
                            'label' => __( 'Border Radius', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', 'em', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn.button-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                
                $this->start_controls_tab(
                    'button_two_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'dreamit-elementor-extension' ),
                    ]
                );

                    $this->add_control(
                        'hover_button_two_text_color',
                        [
                            'label' => __( 'Text Color', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn.button-two:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'hover_button_two_background_color',
                        [
                            'label' => __( 'Background Color', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn.button-two:hover' => 'background-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        \Elementor\Group_Control_Border::get_type(),
                        [
                            'name' => 'hover_button_two_border',
                            'label' => __( 'Border', 'dreamit-elementor-extension' ),
                            'selector' => '{{WRAPPER}} .single-slick .btn.button-two:hover',
                        ]
                    );
                    $this->add_responsive_control(
                        'hover_button_two_border_radius',
                        [
                            'label' => __( 'Border Radius', 'dreamit-elementor-extension' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', 'em', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .single-slick .btn.button-two:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                
            $this->end_controls_tabs();

            $this->add_responsive_control(
                'button_two_margin',
                [
                    'label' => __( 'Margin', 'dreamit-elementor-extension' ),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .single-slick .btn.button-two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'button_two_height',
                [
                    'label' => __( 'Height', 'dreamit-elementor-extension' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 5,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .single-slick .btn.button-two' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'button_two_width',
                [
                    'label' => __( 'Width', 'dreamit-elementor-extension' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 5,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .single-slick .btn.button-two' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'button_two_typography',
                    'selector' => '{{WRAPPER}} .single-slick .btn.button-two',
                ]
            );

        $this->end_controls_section();
                //------------------------------ Style Title ------------------------------
        $this->start_controls_section(
            'style_title_two', [
                'label' => __( 'Title Two', 'dreamit-elementor-extension' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color_title_two', [
                'label' => __( 'Text Color', 'dreamit-elementor-extension' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-text h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .slider_two .hero-text h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .slider_five .new_hero_text .f_65' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_title_two',
                
                'selector' => '{{WRAPPER}} .hero-text h2, {{WRAPPER}} .slider_two .hero-text h2',
            ]
        );
        $this->end_controls_section();


	}


    protected function render() {

        $settings = $this->get_settings();

    ?>

        
            <section class="dreamit-slick-slider">
                <div class="default-slider slick">
                    
                <?php foreach ( $settings['list'] as $item  ) { ?>

                        <?php if($item['slider_style']=='style_01'){ ?>

						<div class="single-slick one align-items-center d-flex <?php echo $item['content_position'] ?>">
                            <div class="container">
                                <div class="slide-img parallax-effect"
                                    style="background:url(<?php echo esc_url($item['bg_image']['url']) ?>) center center / cover scroll no-repeat;">
                                </div>
                                <div class="white-color">
								<div class="hero-text-wrap">
                                    <div class="hero-text">
										<?php if(!empty($item['subtitle'])) : ?> <h4> <?php echo esc_html_e($item['subtitle']) ?> </h4> <?php endif; ?>
										<?php if(!empty($item['title'])) : ?> <h1 class="font-600"> <?php echo $item['title']; ?> </h1> <?php endif; ?>
                                      <!--   <div class="lines pt-20 pb-40">
                                            <div class="line"></div>
                                        </div> -->
                                        <div class="slick_content">
										<p><?php echo $item['description']; ?></p>
										<div class="slider-buttons">
											<?php if( !empty($item['btn1']) ){ ?>
											<a class="btn btn-gradient btn-md btn-animated-none" href="<?php echo esc_url($item['btn1_url']['url']); ?>" >
													<?php echo $item['btn1']; ?>
												<i aria-hidden="true" class="flaticon flaticon-right-arrow"></i>
											</a>
											<?php } ?>

											<?php if( !empty($item['btn2']) ){ ?>
											<div class="call-button d-flex align-items-center">
												<a class="call-icon" href="tel:+983217690326"><i aria-hidden="true" class="flaticon flaticon-phone-call"></i></a>
												<div class="call-number">
													<span> Call Everyday </span>
													<h3><a href="tel:+983217690326">+98 321 (7690) 326</a></h3>
												</div>
											 </div>
											<?php } ?>
										</div>
										</div>
                                    </div>
                                </div>
								
               <!--                  <div class="slider-single-image">
                                	<img src="<?php echo $item['single_image']['url']; ?>" alt="<?php esc_attr_e('dexon', 'dexon'); ?>">
									<?php if( !empty($item['video_url']['url']) ){ ?>
									<div class="slider-video-icon">
										<a href="<?php echo esc_url($item['video_url']['url']); ?>" class="video-vemo-icon venobox vbox-item" data-vbtype="youtube" data-autoplay="true">
											<?php \Elementor\Icons_Manager::render_icon( $item['video_icon'], [ 'aria-hidden' => 'true' ] ); ?>
										</a>
									</div>
									<?php } ?>
                                </div> -->
								</div>
							</div><!-- .container -->

                        <div class="slider_shape">
                            <img src="<?php echo get_stylesheet_directory_uri() . '/assets/image/sp1.png'; ?>" alt="<?php esc_attr_e('dexon', 'dexon'); ?>">
                        </div>
                        <div class="slider_shape2">
                            <img src="<?php echo get_stylesheet_directory_uri() . '/assets/image/sp2.png'; ?>" alt="<?php esc_attr_e('dexon', 'dexon'); ?>">
                            <div class="slider_shape3 rotateme">
                                <img src="<?php echo get_stylesheet_directory_uri() . '/assets/image/circle.png'; ?>" alt="<?php esc_attr_e('dexon', 'dexon'); ?>">
                            </div>
                        </div>
                        <div class="slick_shape5">
                            <img src="<?php echo get_stylesheet_directory_uri() . '/assets/image/shape3.png'; ?>" alt="<?php esc_attr_e('dexon', 'dexon'); ?>">
                        </div>
						</div><!-- .single-slick -->

                        <?php }elseif($item['slider_style']=='style_02'){ ?>

                            <div class="single-slick style-two align-items-center d-flex <?php echo $item['content_position'] ?>">
                                <div class="container">
                                    <div class="slide-img parallax-effect"
                                    style="background:url(<?php echo esc_url($item['bg_image']['url']) ?>) center center / cover scroll no-repeat;">
                                </div>
                                <div class="hero-text-wrap">
                                    <div class="hero-text">

                                        <div class="white-color">
                                            <?php if(!empty($item['subtitle'])) : ?> <h4> <?php echo esc_html_e($item['subtitle']) ?> </h4> <?php endif; ?>
                                            <?php if(!empty($item['title'])) : ?> <h1 class="font-600"> <?php echo $item['title']; ?> </h1> <?php endif; ?>

                                            <p><?php echo $item['description']; ?></p>

                                            <?php if( !empty($item['btn1']) ){ ?>
                                                <a class="btn btn-gradient btn-md btn-animated-none" href="<?php echo esc_url($item['btn1_url']['url']); ?>" >
                                                    <?php echo $item['btn1']; ?>
                                                    <i aria-hidden="true" class="flaticon flaticon-right-arrow"></i>
                                                </a>
                                            <?php } ?>

                                        </div>
                                        <div class="single_image">
                                            <?php if(!empty($item['title_two'])) : ?> <h2 class="font-600"> <?php echo $item['title_two']; ?> </h2> <?php endif; ?>
                                            <img src="<?php echo $item['single_image']['url']; ?>" alt="<?php esc_attr_e('dexon', 'dexon'); ?>">
                                            <div class="slick_shape5 rotateme">
                                                <img src="<?php echo get_stylesheet_directory_uri() . '/assets/image/circle2.png'; ?>" alt="<?php esc_attr_e('dexon', 'dexon'); ?>">
                                            </div>
                                        </div>                              
                                    </div>
                                </div>
                            </div><!-- .container -->
                         <div class="slick_shape4 bounce-animate2">
                            <img src="<?php echo get_stylesheet_directory_uri() . '/assets/image/circle3.png'; ?>" alt="<?php esc_attr_e('dexon', 'dexon'); ?>">
                        </div>
                        
                        </div><!-- .single-slick -->

                        <?php } ?>

                    <?php } ?>
                    
                </div>
            </section>
            <script>
                jQuery(document).ready(function() {
                    jQuery(".default-slider").slick({
                        <?php
                        if(is_rtl()) { ?>
                            dots: false,
                            infinite: true,
                            autoplay: false,
                            autoplaySpeed: 7000,
                            centerPadding: '0',
                            arrows: true,
                        <?php }else { ?>
                            dots: false,
                            infinite: true,
                            centerMode: true,
                            autoplay: true,
                            autoplaySpeed: 7000,
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            centerPadding: '0',
                            arrows: true
                        <?php } ?>
                    });
                });
            </script>

	<?php }

}