<?php 

/*******************************************************************
Register Post Type
********************************************************************/


function dexon_portfolio_post_type() 
{
	$labels = array(
		'name'               => _x( 'Portfolio', 'post type general name', 'dexon' ),
		'singular_name'      => _x( 'Portfolio', 'post type singular name', 'dexon' ),
		'menu_name'          => _x( 'Portfolio', 'admin menu', 'dexon' ),
		'name_admin_bar'     => _x( 'Portfolio', 'add new on admin bar', 'dexon' ),
		'add_new'            => _x( 'Add New', 'Portfolio', 'dexon' ),
		'add_new_item'       => __( 'Add New Portfolio', 'dexon' ),
		'new_item'           => __( 'New Portfolio', 'dexon' ),
		'edit_item'          => __( 'Edit Portfolio', 'dexon' ),
		'view_item'          => __( 'View Portfolio', 'dexon' ),
		'all_items'          => __( 'All Portfolio', 'dexon' ),
		'search_items'       => __( 'Search Portfolio', 'dexon' ),
		'parent_item_colon'  => __( 'Parent Portfolio:', 'dexon' ),
		'not_found'          => __( 'No Portfolio found.', 'dexon' ),
		'not_found_in_trash' => __( 'No Portfolio found in Trash.', 'dexon' )
	);
	
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-images-alt2',		
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'em_portfolios' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title','editor', 'thumbnail')
	);
	
	register_post_type( 'em_portfolio' , $args );
	
	$labels = array(
		'name'              => _x( 'Categories', 'taxonomy general name', 'dexon' ),
		'singular_name'     => _x( 'Category', 'taxonomy singular name', 'dexon' ),
		'search_items'      => __( 'Search Categories', 'dexon' ),
		'all_items'         => __( 'All Categories', 'dexon' ),
		'parent_item'       => __( 'Parent Category', 'dexon' ),
		'parent_item_colon' => __( 'Parent Category:', 'dexon' ),
		'edit_item'         => __( 'Edit Category', 'dexon' ),
		'update_item'       => __( 'Update Category', 'dexon' ),
		'add_new_item'      => __( 'Add New Category', 'dexon' ),
		'new_item_name'     => __( 'New Category Name', 'dexon' ),
		'menu_name'         => __( 'Categories', 'dexon' ),
	);

	$args = array(
		'public'            => false,
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'query_var'         => false,
		'rewrite'           => array( 'slug' => 'portfolio-category' ),
	);
	
	register_taxonomy( 'em_portfolio_cat', array( 'em_portfolio' ), $args );
}
add_action('init', 'dexon_portfolio_post_type');


// Case Study
function dexon_case_study_post_type() 
{
	$labels = array(
		'name'               => _x( 'Case Study', 'post type general name', 'dexon' ),
		'singular_name'      => _x( 'Case Study', 'post type singular name', 'dexon' ),
		'menu_name'          => _x( 'Case Study', 'admin menu', 'dexon' ),
		'name_admin_bar'     => _x( 'Case Study', 'add new on admin bar', 'dexon' ),
		'add_new'            => _x( 'Add New', 'Case Study', 'dexon' ),
		'add_new_item'       => __( 'Add New Case Study', 'dexon' ),
		'new_item'           => __( 'New Case Study', 'dexon' ),
		'edit_item'          => __( 'Edit Case Study', 'dexon' ),
		'view_item'          => __( 'View Case Study', 'dexon' ),
		'all_items'          => __( 'All Case Study', 'dexon' ),
		'search_items'       => __( 'Search Case Study', 'dexon' ),
		'parent_item_colon'  => __( 'Parent Case Study:', 'dexon' ),
		'not_found'          => __( 'No Case Study found.', 'dexon' ),
		'not_found_in_trash' => __( 'No Case Study found in Trash.', 'dexon' )
	);
	
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-format-status',		
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'em_case_study' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title','editor', 'thumbnail')
	);
	
	register_post_type( 'em_case_study' , $args );
	
	$labels = array(
		'name'              => _x( 'Categories', 'taxonomy general name', 'dexon' ),
		'singular_name'     => _x( 'Category', 'taxonomy singular name', 'dexon' ),
		'search_items'      => __( 'Search Categories', 'dexon' ),
		'all_items'         => __( 'All Categories', 'dexon' ),
		'parent_item'       => __( 'Parent Category', 'dexon' ),
		'parent_item_colon' => __( 'Parent Category:', 'dexon' ),
		'edit_item'         => __( 'Edit Category', 'dexon' ),
		'update_item'       => __( 'Update Category', 'dexon' ),
		'add_new_item'      => __( 'Add New Category', 'dexon' ),
		'new_item_name'     => __( 'New Category Name', 'dexon' ),
		'menu_name'         => __( 'Categories', 'dexon' ),
	);

	$args = array(
		'public'            => false,
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'query_var'         => false,
		'rewrite'           => array( 'slug' => 'casestudy-category' ),
	);
	
	register_taxonomy( 'em_case_study_cat', array( 'em_case_study' ), $args );
}
add_action('init', 'dexon_case_study_post_type');

