<?php
/**
 * Available filters for extending Merlin WP.
 *
 * @package   Merlin WP
 * @version   @@pkg.version
 * @link      https://merlinwp.com/
 * @author    Rich Tabor, from ThemeBeans.com & the team at ProteusThemes.com
 * @copyright Copyright (c) 2018, Merlin WP of Inventionn LLC
 * @license   Licensed GPLv3 for Open Source Use
 */


/**
 * Add your widget area to unset the default widgets from.
 * If your theme's first widget area is "sidebar-1", you don't need this.
 *
 * @see https://stackoverflow.com/questions/11757461/how-to-populate-widgets-on-sidebar-on-theme-activation
 *
 * @param array $widget_areas Arguments for the sidebars_widgets widget areas.
 *
 * @return array of arguments to update the sidebars_widgets option.
 */
function deeds_unset_default_widgets_args( $widget_areas ) {

	$widget_areas = array(
		'default-sidebar' => array(),
	);

	return $widget_areas;
}

add_filter( 'merlin_unset_default_widgets_args', 'deeds_unset_default_widgets_args' );

/**
 * Custom content for the generated child theme's functions.php file.
 *
 * @param string $output Generated content.
 * @param string $slug   Parent theme slug.
 */
function deeds_child_functions_php( $output, $slug ) {

	$slug_no_hyphens = strtolower( preg_replace( '#[^a-zA-Z]#', '', $slug ) );

	$output = "
		<?php
		/**
		 * Theme functions and definitions.
		 */
		function {$slug_no_hyphens}_child_enqueue_styles() {

		    if ( SCRIPT_DEBUG ) {
		        wp_enqueue_style( '{$slug}-style' , get_template_directory_uri() . '/style.css' );
		    }

		    wp_enqueue_style( '{$slug}-child-style',
		        get_stylesheet_directory_uri() . '/style.css',
		        array( '{$slug}-style' ),
		        wp_get_theme()->get('Version')
		    );
		}

		add_action(  'wp_enqueue_scripts', '{$slug_no_hyphens}_child_enqueue_styles' );\n
	";

	// Let's remove the tabs so that it displays nicely.
	$output = trim( preg_replace( '/\t+/', '', $output ) );

	// Filterable return.
	return $output;
}

add_filter( 'merlin_generate_child_functions_php', 'deeds_child_functions_php', 10, 2 );

/**
 * Define the demo import files (local files).
 * You have to use the same filter as in above example,
 * but with a slightly different array keys: local_*.
 * The values have to be absolute paths (not URLs) to your import files.
 * To use local import files, that reside in your theme folder,
 * please use the below code.
 * Note: make sure your import files are readable!
 */
function deeds_local_import_files() {
	return array(
		array(
			'import_file_name'           => esc_html__( 'Main Demo', 'deeds' ),
			'local_import_widget_file'   => trailingslashit( get_template_directory() ) . 'webinane_import/content/widgets.json',
			'import_rev_slider_file_url' => trailingslashit( get_template_directory_uri() ) . 'webinane_import/content/slider.zip',
			'local_import_redux'         => array(
				array(
					'file_path'   => trailingslashit( get_template_directory() ) . 'webinane_import/content/redux_options.json',
					'option_name' => 'deeds_options',
				),
			),
			'local_import_file'          => trailingslashit( get_template_directory() ) . 'webinane_import/content/content.xml',
			'import_preview_image_url'   => get_template_directory_uri() . '/screenshot.png',
			'import_notice'              => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'deeds' ),
			'preview_url'                => 'https://themes.webinane.com/wp/deeds/',
		),
	);
}

// add_filter( 'merlin_import_files', 'deeds_local_import_files' );

/**
 * Define the demo import files (remote files).
 * To define imports, you just have to add the following code structure,
 * with your own values to your theme (using the 'merlin_import_files' filter).
 */
function deeds_merlin_import_files() {
	return array(
		array(
			'import_file_name'         => esc_html__( 'Demo Import', 'deeds' ),
			'local_import_file'          => trailingslashit( get_template_directory() ) . 'webinane_import/content/content.xml',
			'import_file_url'            => 'https://webinane-themes-plugins.s3.amazonaws.com/deeds/import-data/elementor/content.xml',
			// 'local_import_file'        => trailingslashit( get_template_directory() ) . 'webinane_import/content/content.xml',
			// 'import_widget_file_url'   => 'https://webinane-themes-plugins.s3.amazonaws.com/deeds/import-data/widgets.json',
			'local_import_widget_file'   => trailingslashit( get_template_directory() ) . 'webinane_import/content/widgets.we',
			'import_redux'             => array(
				array(
					'file_url'    => 'https://webinane-themes-plugins.s3.amazonaws.com/deeds/import-data/elementor/redux_options.json',
					'option_name' => 'deeds_options',
				),
			),
			'import_preview_image_url' => 'https://webinane.s3.amazonaws.com/deeds/demo-content/preview.png',
			'import_notice'            => esc_html__( 'A special note for this import.', 'deeds' ),
			'preview_url'              => 'https://webinane.s3.amazonaws.com/deeds/demo-content/preview.png',
		),
	);
}

add_filter( 'merlin_import_files', 'deeds_merlin_import_files' );
/**
 * Execute custom code after the whole import has finished.
 */
function deeds_after_import_setup() {
	// Assign menus to their locations.
	$main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

	set_theme_mod(
		'nav_menu_locations', array(
			'main_menu' => $main_menu->term_id,
		)
	);

	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title( 'Home 1' );
	$blog_page_id  = get_page_by_title( 'Blog Grid' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );
	// New design for the event calendar disable 
	if ( function_exists( 'tribe_update_option' )  ) {
		tribe_update_option( 'views_v2_enabled', false );
	}

	$logo = get_page_by_title( 'logo', OBJECT, 'attachment' );

	if ( $logo ) {
		set_theme_mod( 'custom_logo', $logo->ID );
	}

	if ( class_exists( 'RevSliderSliderImport' ) ) {
		foreach ( array( 'slider', 'slider-1', 'slider-2', 'slider-3', 'slider-4', 'slider-5', 'slider-6' ) as $slider ) {
			$file    = 'https://webinane.s3.amazonaws.com/deeds/import-data/elementor/' . $slider . '.zip';
			$content = wp_remote_get( $file );
			$content = wp_remote_retrieve_body( $content );

			if ( $content ) {
				$upload_dir = wp_upload_dir();
				$file       = $upload_dir['path'] . '/' . $slider . '.zip';

				deeds_filesystem()->put_contents( $file, $content );

				if ( file_exists( $file ) ) {
					$importer = new RevSliderSliderImport();
					$response = $importer->import_slider( true, $file );
					if ( $response ) {
						unlink( $file );
					}
				}
			}
		}
	}

	$wp_commerce_file    = wp_remote_get(get_template_directory_uri().'/webinane_import/content/webinane-commerce-settings.json');
	if($body = wp_remote_retrieve_body( $wp_commerce_file )) {
		update_option('_wpcommerce_settings', json_decode($body, true));
	}

	update_option( 'elementor_load_fa4_shim', 'yes' );
	update_option( 'elementor_allow_svg', '1' );
	update_option( 'elementor_cpt_support', [ 'post', 'page', 'sermon', 'story', 'team' ] );
}

add_action( 'merlin_after_all_import', 'deeds_after_import_setup' );

/**
 * Deeds 2 mime types.
 *
 * @param  [type] $mimes [description]
 *
 * @return [type]        [description]
 */
function deeds_mime_types( $mimes ) {
	$mimes['svg'] = 'image/svg+xml';

	return $mimes;
}

add_filter( 'upload_mimes', 'deeds_mime_types' );