<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       1.0.0
 */
if ( ! function_exists( 'wpcm_get_settings' ) ) {
	return;
}

$donation_settings = wpcm_get_settings();

if ( ! $donation_settings->get( 'menu_donation_button' ) ) {
	return;
}

wp_enqueue_script( array( 'lifeline-donation-modal' ) );

$action      = $donation_settings->get( 'donation_general_type' );
$class       = 'theme-btn align-middle';
$id          = $donation_settings->get( 'donation_dummy_page_select' );
$template_id = $donation_settings->get( 'donation_shortcode_page' );
$link        = $donation_settings->get( 'donation_button_linkGeneral' );
$label       = $donation_settings->get( 'menu_donation_button_title' );
$style 		 = $donation_settings->get('donation_popup_style');

switch ( $action ) :
	case 'donation_popup_box':
		?>
		<div class="lifeline-donation-app">
			<lifeline-donation-button :id="<?php echo esc_attr( $id ); ?>" dstyle="<?php echo esc_attr($style) ?>">
				<a id="header_button_lifeline" class="<?php echo esc_attr( $class ); ?>" href="javascript:void(0);" title="<?php echo esc_attr( $label ); ?>">
					<?php echo esc_html( $label ); ?>
				</a>
			</lifeline-donation-button>
		</div>
		<?php
		break;
	case 'donation_page_template':
		?>
		<div class="urgent-popup-list">
			<a id="header_button_lifeline" class="<?php echo esc_attr( $class ); ?>" href="<?php echo esc_url( get_the_permalink( $template_id ) ); ?>" title="<?php echo esc_attr( $label ); ?>">
				<?php echo esc_html( $label ); ?>
			</a>
		</div>
		<?php
		break;
	case 'external_link':
		?>
		<div class="urgent-popup-list">
			<a id="header_button_lifeline" class="<?php echo esc_attr( $class ); ?>" href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_attr( $label ); ?>">
				<?php echo esc_html( $label ); ?>
			</a>
		</div>
		<?php
		break;
endswitch;

