<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage deeds
 * @author     Webinane
 * @version    1.0
 */

if ( class_exists( 'Deeds_Resizer' ) ) {
	$img_obj = new Deeds_Resizer();
} else {
	$img_obj = array();
}
?>
<div <?php post_class( 'blog-detail-page' ) ?>>
	<?php if ( has_post_thumbnail() ) : ?>
		<figure>
			<div class="single-avatar singlee">
				<?php the_post_thumbnail(array(1110, 664)) ?>
			</div>
		</figure>
	<?php endif; ?>
	<div class="blog-detail-meta">
		<div class="comments-area">
			<?php if ( $data->get( 'author', true ) ): ?>
				<span>
					<i class="fas fa-user"></i>
					<?php echo get_the_author_link(); ?>
				</span>
			<?php endif; ?>
			<?php if ( $data->get( 'date', true ) ): ?>
				<span>
					<a href="<?php echo get_day_link( get_the_time( 'Y' ), get_the_time( 'm' ), get_the_time( 'd' ) ); ?>"><i class="fas fa-calendar"></i> <?php echo get_the_date( 'F j,' ) . ' ' . get_the_date( ' Y' ); ?></a>
				</span>
			<?php endif; ?>
			<?php if ( $data->get( 'comments' ) ): ?>
				<span>
					<i class="fa fa-chat-o"></i>
					<a href="<?php the_permalink(); ?>#comments"><i class="fa fa-comments-o"></i><?php comments_number( '0 Comments', '01 Comment', '% Comments' ); ?></a>
				</span>
			<?php endif; ?>
		</div>
		<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		<?php the_excerpt(); ?>
		<a href="<?php the_permalink() ?>" class="btn btn-primary mt-2"><?php esc_html_e('Read more', 'deeds') ?></a>
	</div>
</div>