<?php
/**
 * Blog Post Main File.
 *
 * @package deeds
 * @author  Webinane
 * @version 1.0
 */

get_header();

$data    = \deeds\Includes\Classes\Common::instance()->data( 'single' )->get();

$layout = ( $data->get( 'layout' ) ) ? $data->get('layout') : 'right';

$class   = ( $layout != 'full' ) ? 'col-sm-12 col-md-8 col-lg-8' : 'col-md-12';
$options = deeds_WSH()->option();
do_action( 'deeds_banner', $data );

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
      
    }

} else {
	?>
	<section>
		<div class="gap">
			<div class="container">
				<div class="row">
					<?php
					if ( $data->get( 'layout' ) == 'left' ) {
						do_action( 'deeds_sidebar', $data );
					}
					?>
					<div class="<?php echo esc_attr( $class ); ?>">
						<?php
						while ( have_posts() ) :
							the_post();
							?>
							<div <?php post_class(); ?>>
								<?php deeds_template_load( 'templates/blog-single/single-content.php', compact( 'options', 'data' ) ); ?>
							</div>
						<?php endwhile; ?>
					</div><!-- page content -->
					<?php
					if ( $layout == 'right' ) {
						$data->set('sidebar', 'default-sidebar');
						do_action( 'deeds_sidebar', $data );
					}
					?>
				</div>
			</div>
		</div>
	</section><!-- content with sidebar -->
	<?php
}
get_footer();